/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.InstallerBase;
import com.izforge.izpack.installer.PanelAutomation;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.util.Housekeeper;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import net.n3.nanoxml.NonValidator;
import net.n3.nanoxml.StdXMLBuilder;
import net.n3.nanoxml.StdXMLParser;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLElement;

public class AutomatedInstaller
extends InstallerBase {
    private TreeMap panelInstanceCount;

    public AutomatedInstaller(String string) throws Exception {
        File file = new File(string);
        AutomatedInstallData automatedInstallData = new AutomatedInstallData();
        this.loadInstallData(automatedInstallData);
        automatedInstallData.xmlData = this.getXMLData(file);
        automatedInstallData.localeISO3 = automatedInstallData.xmlData.getAttribute("langpack", "eng");
        InputStream inputStream = this.getClass().getResourceAsStream("/langpacks/" + automatedInstallData.localeISO3 + ".xml");
        automatedInstallData.langpack = new LocaleDatabase(inputStream);
        automatedInstallData.setVariable("IS03_LANG", automatedInstallData.localeISO3);
        ResourceManager.create(automatedInstallData);
        this.panelInstanceCount = new TreeMap();
        this.doInstall(automatedInstallData);
    }

    private void doInstall(AutomatedInstallData automatedInstallData) throws Exception {
        System.out.println("[ Starting automated installation ]");
        Iterator iterator = automatedInstallData.panelsOrder.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = "com.izforge.izpack.panels." + string + "AutomationHelper";
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
            PanelAutomation panelAutomation = null;
            if (clazz != null) {
                try {
                    panelAutomation = (PanelAutomation)clazz.newInstance();
                }
                catch (Exception exception) {
                    System.err.println("ERROR: no default constructor for " + string2 + ", skipping...");
                    continue;
                }
            }
            Vector vector = automatedInstallData.xmlData.getChildrenNamed(string);
            int n = 0;
            if (this.panelInstanceCount.containsKey(string)) {
                n = (Integer)this.panelInstanceCount.get(string);
            }
            XMLElement xMLElement = (XMLElement)vector.elementAt(n);
            this.panelInstanceCount.put(string, new Integer(n + 1));
            if (panelAutomation == null) continue;
            try {
                panelAutomation.runAutomated(automatedInstallData, xMLElement);
            }
            catch (Exception exception) {
                System.err.println("ERROR: automated installation failed for panel " + string);
                exception.printStackTrace();
            }
        }
        System.out.println("[ Automated installation done ]");
        Housekeeper.getInstance().shutDown(0);
    }

    public XMLElement getXMLData(File file) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(file);
        StdXMLParser stdXMLParser = new StdXMLParser();
        stdXMLParser.setBuilder(new StdXMLBuilder());
        stdXMLParser.setReader(new StdXMLReader(fileInputStream));
        stdXMLParser.setValidator(new NonValidator());
        XMLElement xMLElement = (XMLElement)stdXMLParser.parse();
        fileInputStream.close();
        return xMLElement;
    }
}

