/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.util.AbstractUIHandler;
import com.izforge.izpack.util.Console;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.OsConstraint;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class FileExecutor {
    private Collection files;

    private boolean stopThread(Thread thread, MonitorInputStream monitorInputStream) {
        monitorInputStream.doStop();
        long l = 1000L;
        try {
            thread.join(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!thread.isAlive()) {
            return true;
        }
        thread.interrupt();
        long l2 = 1000L;
        try {
            thread.join(l2);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return !thread.isAlive();
    }

    public FileExecutor(Collection collection) {
        this.files = collection;
    }

    public FileExecutor() {
        this.files = null;
    }

    public int executeCommand(String[] stringArray, String[] stringArray2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("executeCommand\n");
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append("\tparams: " + stringArray[i]);
                stringBuffer.append("\n");
            }
        }
        Process process = null;
        MonitorInputStream monitorInputStream = null;
        MonitorInputStream monitorInputStream2 = null;
        Thread thread = null;
        Thread thread2 = null;
        int n = -1;
        Debug.trace(stringBuffer);
        try {
            process = Runtime.getRuntime().exec(stringArray);
            boolean bl = false;
            if (bl) {
                Console console = new Console(process);
                stringArray2[0] = console.getOutputData();
                stringArray2[1] = console.getErrorData();
                n = process.exitValue();
            } else {
                StringWriter stringWriter = new StringWriter();
                StringWriter stringWriter2 = new StringWriter();
                InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
                InputStreamReader inputStreamReader2 = new InputStreamReader(process.getErrorStream());
                monitorInputStream = new MonitorInputStream(inputStreamReader, stringWriter);
                monitorInputStream2 = new MonitorInputStream(inputStreamReader2, stringWriter2);
                thread = new Thread(monitorInputStream);
                thread2 = new Thread(monitorInputStream2);
                thread.setDaemon(true);
                thread2.setDaemon(true);
                thread.start();
                thread2.start();
                n = process.waitFor();
                if (thread != null) {
                    thread.join();
                }
                if (thread2 != null) {
                    thread2.join();
                }
                stringArray2[0] = stringWriter.toString();
                Debug.trace("stdout:");
                Debug.trace(stringArray2[0]);
                stringArray2[1] = stringWriter2.toString();
                Debug.trace("stderr:");
                Debug.trace(stringArray2[1]);
            }
            Debug.trace("exit status: " + Integer.toString(n));
        }
        catch (InterruptedException interruptedException) {
            if (Debug.tracing()) {
                interruptedException.printStackTrace(System.err);
            }
            this.stopThread(thread, monitorInputStream);
            this.stopThread(thread2, monitorInputStream2);
            stringArray2[0] = "";
            stringArray2[1] = interruptedException.getMessage() + "\n";
            process.destroy();
        }
        catch (IOException iOException) {
            if (Debug.tracing()) {
                iOException.printStackTrace(System.err);
            }
            stringArray2[0] = "";
            stringArray2[1] = iOException.getMessage() + "\n";
        }
        return n;
    }

    public int executeFiles(int n, AbstractUIHandler abstractUIHandler) {
        int n2 = 0;
        String[] stringArray = new String[2];
        String string = System.getProperty("path.separator");
        String string2 = System.getProperty("os.name").toLowerCase();
        String string3 = "a+x";
        Iterator iterator = this.files.iterator();
        while (n2 == 0 && iterator.hasNext()) {
            String[] stringArray2;
            ExecutableFile executableFile = (ExecutableFile)iterator.next();
            boolean bl = !executableFile.keepFile;
            File file = new File(executableFile.path);
            Debug.trace("handeling executable file " + executableFile);
            if (!OsConstraint.oneMatchesCurrentSystem(executableFile.osList)) continue;
            if (n != 2 && string.equals(":") && (!string2.startsWith("mac") || string2.endsWith("x"))) {
                Debug.trace("making file executable (setting executable flag)");
                stringArray2 = new String[]{"/bin/chmod", string3, file.toString()};
                n2 = this.executeCommand(stringArray2, stringArray);
                if (n2 != 0) {
                    abstractUIHandler.emitError("file execution error", "Error executing \n" + stringArray2[0] + " " + stringArray2[1] + " " + stringArray2[2]);
                    continue;
                }
            }
            if (n2 == 0 && (n == 0 && executableFile.executionStage == 0 || n == 2 && executableFile.executionStage == 2)) {
                stringArray2 = new ArrayList();
                if (0 == executableFile.type) {
                    stringArray2.add(file.toString());
                } else if (1 == executableFile.type && null == executableFile.mainClass) {
                    stringArray2.add(System.getProperty("java.home") + "/bin/java");
                    stringArray2.add("-jar");
                    stringArray2.add(file.toString());
                } else if (1 == executableFile.type && null != executableFile.mainClass) {
                    stringArray2.add(System.getProperty("java.home") + "/bin/java");
                    stringArray2.add("-cp " + file.toString());
                    stringArray2.add(executableFile.mainClass);
                }
                if (null != executableFile.argList && !executableFile.argList.isEmpty()) {
                    stringArray2.addAll(executableFile.argList);
                }
                String[] stringArray3 = new String[stringArray2.size()];
                for (int i = 0; i < stringArray2.size(); ++i) {
                    stringArray3[i] = (String)stringArray2.get(i);
                }
                n2 = this.executeCommand(stringArray3, stringArray);
                if (n2 != 0) {
                    bl = false;
                    String string4 = stringArray[0] + "\n" + stringArray[1];
                    if (string4.length() == 1) {
                        string4 = new String("Failed to execute " + file.toString() + ".");
                    }
                    if (executableFile.onFailure == 0) {
                        abstractUIHandler.emitError("file execution error", string4);
                    } else if (executableFile.onFailure == 1) {
                        abstractUIHandler.emitWarning("file execution error", string4);
                        n2 = 0;
                    } else if (abstractUIHandler.askQuestion(null, "Continue?", 37) == 47) {
                        n2 = 0;
                    }
                }
            }
            if (executableFile.executionStage != 0 || !bl || !file.canWrite()) continue;
            file.delete();
        }
        return n2;
    }

    private class MonitorInputStream
    implements Runnable {
        private BufferedReader reader;
        private BufferedWriter writer;
        private boolean shouldStop = false;

        public MonitorInputStream(Reader reader, Writer writer) {
            this.reader = new BufferedReader(reader);
            this.writer = new BufferedWriter(writer);
        }

        public void doStop() {
            this.shouldStop = true;
        }

        public void run() {
            try {
                String string;
                while ((string = this.reader.readLine()) != null) {
                    this.writer.write(string);
                    this.writer.newLine();
                    this.writer.flush();
                    if (!this.shouldStop) continue;
                    return;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.out);
            }
        }
    }
}

