void __fastcall TDesignForm::DrawCurrentCS() {
  if (!ISelFrame) return;
  D3DRMBOX Box;
  //     :
  FrameGetBox(ISelFrame, &Box);
  D3DVALUE xlen, ylen, zlen;
  xlen = (Box.max.x - Box.min.x) / 2;
  ylen = (Box.max.y - Box.min.y) / 2;
  zlen = (Box.max.z - Box.min.z) / 2;
  //   ,    ,
  //      :
  if ((xlen+ylen+zlen) == 0) {
     D3DVECTOR scene_pos;
     D3DRMVECTOR4D plane_pos;
     ISelFrame->GetPosition(IScene, &scene_pos);
     Vport->IRMVport->Transform(&plane_pos, &scene_pos);
     xlen = ylen = zlen = plane_pos.w;
  }
  //     :
  D3dView->SetCSFrame(ISelFrame);
  Vport->GDI->Pen->Color = clRed;
  Vport->MoveTo3D(0,0,0); Vport->LineTo3D(xlen,0,0);
  Vport->GDI->Pen->Color = clGreen;
  Vport->MoveTo3D(0,0,0); Vport->LineTo3D(0,ylen,0);
  Vport->GDI->Pen->Color = clBlue;
  Vport->MoveTo3D(0,0,0); Vport->LineTo3D(0,0,zlen);
}//---------------------------------------------------------
void __fastcall TDesignForm::DrawSelections() {
  D3dView->SetCSFrame(ISelFrame);
  //   :
  if (ISelBuilder) {
     D3DRMBOX box;
     ISelBuilder->GetBox(&box);
     D3DVECTOR min = box.min, max = box.max;
     D3DVECTOR v1; v1.x = min.x; v1.y = min.y; v1.z = min.z;
     D3DVECTOR v2; v2.x = max.x; v2.y = min.y; v2.z = min.z;
     D3DVECTOR v3; v3.x = max.x; v3.y = min.y; v3.z = max.z;
     D3DVECTOR v4; v4.x = min.x; v4.y = min.y; v4.z = max.z;
     D3DVECTOR v5; v5.x = min.x; v5.y = max.y; v5.z = min.z;
     D3DVECTOR v6; v6.x = max.x; v6.y = max.y; v6.z = min.z;
     D3DVECTOR v7; v7.x = max.x; v7.y = max.y; v7.z = max.z;
     D3DVECTOR v8; v8.x = min.x; v8.y = max.y; v8.z = max.z;
     Vport->GDI->Pen->Color = clYellow;
     //  :
     Vport->Line3D(&v1, &v2);
     Vport->Line3D(&v2, &v3);
     Vport->Line3D(&v3, &v4);
     Vport->Line3D(&v4, &v1);
     //  :
     Vport->Line3D(&v5, &v6);
     Vport->Line3D(&v6, &v7);
     Vport->Line3D(&v7, &v8);
     Vport->Line3D(&v8, &v5);
     //  :
     Vport->Line3D(&v1, &v5);
     Vport->Line3D(&v2, &v6);
     Vport->Line3D(&v3, &v7);
     Vport->Line3D(&v4, &v8);
  }
  //   :
  if (ISelFace && ISelBuilder) {
     DWORD vcount;
     D3DVECTOR *vlist;
     ISelFace->GetVertices(&vcount, NULL, NULL);
     vlist = new D3DVECTOR[vcount];
     ISelFace->GetVertices(&vcount, vlist, NULL);
     Vport->GDI->Pen->Color = clAqua;
     for (DWORD i = 0; i < vcount-1; i++)
        Vport->Line3D(&vlist[i], &vlist[i+1]);
     Vport->Line3D(&vlist[vcount-1], &vlist[0]);

     delete[] vlist;
  }
  //  :
  if (SelVertex && ISelBuilder) {
     DWORD vcount, ncount , flsize;
     ISelBuilder->GetVertices(&vcount, NULL,
                              &ncount, NULL,
                              &flsize, NULL);
     D3DVECTOR *vlist = new D3DVECTOR[vcount];
     ISelBuilder->GetVertices(&vcount, vlist,
                              &ncount, NULL,
                              &flsize, NULL);
     int x, y;
     SelVertexPos = vlist[SelVertex];
     Vport->Vec2xy(&SelVertexPos, x, y);
     Vport->GDI->Pen->Color = clRed;
     Vport->GDI->Ellipse(x-5, y-5, x+5, y+5);
     Vport->TextOut3D(&SelVertexPos,
                               IntToStr(SelVertex).c_str());
     delete[] vlist;
  }
}//---------------------------------------------------------
