/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.JWindow;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import photoorganizer.Controller;
import photoorganizer.PhotoPlugin;
import photoorganizer.Resources;
import photoorganizer.UiUpdater;
import photoorganizer.directory.FileSystemModel;
import photoorganizer.directory.JTreeTable;
import photoorganizer.formats.FileNameFormat;
import photoorganizer.renderer.AlbumPane;
import photoorganizer.renderer.AlbumThumbnailsPanel;
import photoorganizer.renderer.CollectionThumbnailsPanel;
import photoorganizer.renderer.PhotoCollectionPanel;
import photoorganizer.renderer.PhotoImagePanel;
import photoorganizer.renderer.StatusBar;
import photoorganizer.renderer.ThumbnailsPanel;
import photoorganizer.renderer.WebAlbumPane;
import rogatkin.BaseController;
import rogatkin.Program;
import rogatkin.Serializer;

public class PhotoOrganizer
extends JFrame
implements Program {
    public static final String PROGRAMNAME = "R-PhotoOrganizer";
    public static final String VERSION = "version 1.0.1";
    public static final int BUILD = 46;
    public static final String COPYRIGHT = "Copyright \u00a9 1999-2000 Dmitriy Rogatkin";
    static final String SECNAME = "PhotoOrganizer";
    static final String BOUNDS = "Bounds";
    static final String DIVIDERDIR = "DividerBrowsePos";
    static final String DIVIDERCOL = "DividerCollectionPos";
    static final String DIVIDERALBUM = "DividerAlbumPos";
    static final String TB_ORIENT = "ToolBarOrientation";
    private Controller controller;
    static /* synthetic */ Class class$rogatkin$BaseController;

    public static void main(String[] stringArray) {
        new PhotoOrganizer();
    }

    public PhotoOrganizer() {
        try {
            System.setErr(new PrintStream(new FileOutputStream("R-PhotoOrganizer.log"), true));
        }
        catch (IOException iOException) {
            System.err.println("R-PhotoOrganizer: Can't redefine error stream.");
        }
        FlashWindow flashWindow = new FlashWindow();
        this.controller = new Controller(this);
        this.controller.updateCaption(null);
        ((Frame)this).setIconImage(this.controller.getMainIcon());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PhotoOrganizer.this.controller.close();
                super.windowClosing(windowEvent);
            }
        });
        this.controller.add(new StatusBar(), Controller.COMP_STATUSBAR);
        this.controller.add(new PhotoImagePanel(this.controller), Controller.COMP_IMAGEPANEL);
        this.controller.add(new PhotoImagePanel(this.controller), Controller.COMP_IMAGECOLLCTPANEL);
        this.controller.add(new PhotoImagePanel(this.controller), Controller.COMP_IMAGEALBUMPANEL);
        this.controller.add(new CollectionThumbnailsPanel(this.controller), Controller.COMP_THUMBCOLLCTPANEL);
        this.controller.add(new AlbumPane(this.controller), Controller.COMP_ALBUMPANEL);
        this.controller.add(new PhotoCollectionPanel(this.controller), Controller.COMP_COLLECTION);
        this.controller.add(new WebAlbumPane(this.controller), Controller.COMP_WEBALBUMPANEL);
        this.controller.add(new ThumbnailsPanel(this.controller), Controller.COMP_THUMBPANEL);
        this.controller.add(new JTreeTable(new FileSystemModel(), this.controller), Controller.COMP_DIRTREE);
        this.controller.add(new AlbumThumbnailsPanel(this.controller), Controller.COMP_ALBUMTHUMBPANEL);
        Serializer serializer = this.controller.getSerializer();
        boolean bl = Serializer.getInt(serializer.getProperty("PhotoCollectionOptions", "SplitVertically"), 1) == 1;
        final JTabbedPane jTabbedPane = new JTabbedPane(Serializer.getInt(serializer.getProperty("PhotoCollectionOptions", "TabPosition"), 3));
        JScrollPane jScrollPane = new JScrollPane(this.controller.component(Controller.COMP_ALBUMTHUMBPANEL));
        JTabbedPane jTabbedPane2 = new JTabbedPane(2);
        jTabbedPane2.insertTab("Album", null, new JScrollPane(this.controller.component(Controller.COMP_ALBUMPANEL)), "Use it to view content of your photo albums", 0);
        jTabbedPane2.insertTab("Image", null, this.controller.component(Controller.COMP_IMAGEALBUMPANEL), "Use it to see original sized image", 1);
        jTabbedPane.insertTab("Album", null, new JSplitPane(bl ? 0 : 1, true, jTabbedPane2, jScrollPane), "Viewing and creation photo albums", 0);
        jTabbedPane2 = new JTabbedPane(2);
        jTabbedPane2.insertTab("Selection", null, new JScrollPane(this.controller.component(Controller.COMP_COLLECTION)), "Use it to navigate through your selection structure", 0);
        jTabbedPane2.insertTab("Image", null, this.controller.component(Controller.COMP_IMAGECOLLCTPANEL), "Use it to see original sized image", 1);
        jScrollPane = new JScrollPane(this.controller.component(Controller.COMP_THUMBCOLLCTPANEL));
        jTabbedPane.insertTab("Selection", null, new JSplitPane(bl ? 0 : 1, true, jTabbedPane2, jScrollPane), "Use it to place your selection", 1);
        jTabbedPane2 = new JTabbedPane(2);
        jTabbedPane2.insertTab("Directory", null, new JScrollPane(this.controller.component(Controller.COMP_DIRTREE)), "Use it to navigate through your directory structure", 0);
        jTabbedPane2.insertTab("Image", null, this.controller.component(Controller.COMP_IMAGEPANEL), "Use it to see original sized image", 1);
        jScrollPane = new JScrollPane(this.controller.component(Controller.COMP_THUMBPANEL));
        jTabbedPane.insertTab("Browse", null, new JSplitPane(bl ? 0 : 1, true, jTabbedPane2, jScrollPane), "Use it to navigate through your directory structure", 2);
        boolean bl2 = Serializer.getInt(serializer.getProperty("plugins", "allDisabled"), 0) == 0;
        int n = 1;
        while (bl2) {
            String string = (String)serializer.getProperty("plugins", "class" + n);
            if (string == null) break;
            if (Serializer.getInt(serializer.getProperty("plugins", "disabled1"), 0) != 1) {
                try {
                    Class<?> clazz = Class.forName(string);
                    Constructor<?> constructor = clazz.getDeclaredConstructor(class$rogatkin$BaseController == null ? PhotoOrganizer.class$("rogatkin.BaseController") : class$rogatkin$BaseController);
                    Component component = (Component)constructor.newInstance(this.controller);
                    string = (String)serializer.getProperty("plugins", "name" + n);
                    if (string == null) {
                        string = "plug-in" + n;
                    }
                    this.controller.add(component, string);
                    jTabbedPane.insertTab(string, null, this.controller.component(string), (String)serializer.getProperty("plugins", "tooltip" + n), n + 2);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            ++n;
        }
        jTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JComponent jComponent = null;
                try {
                    jComponent = ((PhotoPlugin)((Object)jTabbedPane.getSelectedComponent())).getStatusBar();
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                ((StatusBar)PhotoOrganizer.this.controller.component(Controller.COMP_STATUSBAR)).setCustomStatus(jComponent);
            }
        });
        this.getContentPane().add((Component)jTabbedPane, "Center");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.pack();
        this.load();
        ((Component)this).setVisible(true);
        this.controller.load();
        this.controller.getUiUpdater().reset();
        flashWindow.dispose();
    }

    public void setTitle(String string) {
        super.setTitle(string + " - " + PROGRAMNAME + " " + VERSION);
    }

    public String getName() {
        return PROGRAMNAME;
    }

    public String getVersion() {
        return VERSION;
    }

    public void save() {
        Serializer serializer = this.controller.getSerializer();
        Rectangle rectangle = this.getBounds();
        Integer[] integerArray = new Integer[]{new Integer(rectangle.x), new Integer(rectangle.y), new Integer(rectangle.width), new Integer(rectangle.height)};
        serializer.setProperty(SECNAME, BOUNDS, integerArray);
        JSplitPane jSplitPane = (JSplitPane)((JTabbedPane)this.getContentPane().getComponent(0)).getComponentAt(0);
        serializer.setProperty(SECNAME, DIVIDERDIR, new Integer(jSplitPane.getDividerLocation()));
        jSplitPane = (JSplitPane)((JTabbedPane)this.getContentPane().getComponent(0)).getComponentAt(1);
        serializer.setProperty(SECNAME, DIVIDERCOL, new Integer(jSplitPane.getDividerLocation()));
        jSplitPane = (JSplitPane)((JTabbedPane)this.getContentPane().getComponent(0)).getComponentAt(2);
        serializer.setProperty(SECNAME, DIVIDERALBUM, new Integer(jSplitPane.getDividerLocation()));
        serializer.setProperty("RenameOptions", "Counter", new Integer(FileNameFormat.counter));
        int n = 0;
        while (n < this.getContentPane().getComponentCount()) {
            Component component = this.getContentPane().getComponent(n);
            if (component instanceof JToolBar) {
                serializer.setProperty(SECNAME, TB_ORIENT, new Integer(((JToolBar)component).getOrientation()));
            }
            ++n;
        }
    }

    public void load() {
        Object[] objectArray;
        String string;
        Serializer serializer = this.controller.getSerializer();
        Object[] objectArray2 = (Object[])serializer.getProperty(SECNAME, BOUNDS);
        if (objectArray2 != null && objectArray2.length == 4 && objectArray2[0] instanceof Integer) {
            ((Component)this).setBounds((Integer)objectArray2[0], (Integer)objectArray2[1], (Integer)objectArray2[2], (Integer)objectArray2[3]);
        }
        JSplitPane jSplitPane = (JSplitPane)((JTabbedPane)this.getContentPane().getComponent(0)).getComponentAt(0);
        Integer n = (Integer)serializer.getProperty(SECNAME, DIVIDERDIR);
        if (n != null) {
            jSplitPane = (JSplitPane)((JTabbedPane)this.getContentPane().getComponent(0)).getComponentAt(0);
            jSplitPane.setDividerLocation(n);
        }
        if ((n = (Integer)serializer.getProperty(SECNAME, DIVIDERCOL)) != null) {
            jSplitPane = (JSplitPane)((JTabbedPane)this.getContentPane().getComponent(0)).getComponentAt(1);
            jSplitPane.setDividerLocation(n);
        }
        if ((n = (Integer)serializer.getProperty(SECNAME, DIVIDERALBUM)) != null) {
            jSplitPane = (JSplitPane)((JTabbedPane)this.getContentPane().getComponent(0)).getComponentAt(2);
            jSplitPane.setDividerLocation(n);
        }
        if (Serializer.getInt(serializer.getProperty("PhotoCollectionOptions", "MenuBar"), 1) == 1) {
            this.setJMenuBar(this.createMenu());
        } else {
            this.getContentPane().getComponent(0).addMouseListener(new MouseInputAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if ((mouseEvent.getModifiers() & 4) > 0) {
                        new ROptionsMenu().show(PhotoOrganizer.this, mouseEvent.getX(), PhotoOrganizer.this.controller.adjustMenuY(mouseEvent.getY(), 180));
                    }
                }
            });
        }
        if (Serializer.getInt(serializer.getProperty("PhotoCollectionOptions", "ToolBar"), 0) == 1) {
            int n2 = Serializer.getInt(serializer.getProperty(SECNAME, TB_ORIENT), 0);
            string = "North";
            if (n2 == 1) {
                string = "West";
            }
            this.getContentPane().add((Component)this.createToolBar(n2), string);
        }
        if (Serializer.getInt(serializer.getProperty("PhotoCollectionOptions", "StatusBar"), 1) == 1) {
            this.getContentPane().add(this.controller.component(Controller.COMP_STATUSBAR), "South");
        }
        FileNameFormat.datemask = Serializer.arrayToString(serializer.getProperty("PhotoCollectionOptions", "DateFormat"));
        FileNameFormat.timemask = Serializer.arrayToString(serializer.getProperty("PhotoCollectionOptions", "TimeFormat"));
        FileNameFormat.counter = Serializer.getInt(serializer.getProperty("RenameOptions", "Counter"), 0);
        FileNameFormat.transformCodes = new Object[Resources.ROTATIONS.length];
        System.arraycopy(Resources.ROTATIONS, 0, FileNameFormat.transformCodes, 0, Resources.ROTATIONS.length);
        try {
            objectArray = (Object[])serializer.getProperty("TransformOptions", "TransformCode");
            if (objectArray == null) {
                throw new Exception("A transform option's missed in configuration file");
            }
        }
        catch (Exception exception) {
            objectArray = Resources.ROTATIONS;
        }
        System.arraycopy(objectArray, 0, FileNameFormat.transformCodes, 0, objectArray.length);
        string = (String)serializer.getProperty("PhotoCollectionOptions", "Language");
        String string2 = (String)serializer.getProperty("PhotoCollectionOptions", "Country");
        if (string != null && string2 != null) {
            Locale.setDefault(new Locale(string, string2));
        }
    }

    JMenuBar createMenu() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        jMenu.setActionCommand("File");
        JMenuItem jMenuItem = new JMenuItem("Change drive");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener((JTreeTable)this.controller.component(Controller.COMP_DIRTREE));
        jMenuItem = new JMenuItem("To selection");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener((JTreeTable)this.controller.component(Controller.COMP_DIRTREE));
        this.controller.getUiUpdater().addForNotification(jMenuItem, UiUpdater.DIRECTORY_SELECTED);
        jMenuItem = new JMenuItem("Get CF");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener((PhotoCollectionPanel)this.controller.component(Controller.COMP_COLLECTION));
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Properties...");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener((JTreeTable)this.controller.component(Controller.COMP_DIRTREE));
        this.controller.getUiUpdater().addForNotification(jMenuItem, UiUpdater.FILE_SELECTED);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Export to CSV...");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener((ActionListener)((Object)this.controller.component(Controller.COMP_ALBUMPANEL)));
        jMenu.addSeparator();
        this.addPluginMenus(jMenu);
        jMenuItem = new JMenuItem("Exit");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this.controller);
        jMenu = new JMenu("Tools");
        jMenuBar.add(jMenu);
        jMenu.setActionCommand("Tools");
        JMenu jMenu2 = Controller.createTransformMenu((PhotoCollectionPanel)this.controller.component(Controller.COMP_COLLECTION));
        jMenu.add(jMenu2);
        this.controller.getUiUpdater().addForNotification(jMenu2, UiUpdater.SELECTION_SELECTED);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Extract markers");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener((PhotoCollectionPanel)this.controller.component(Controller.COMP_COLLECTION));
        this.controller.getUiUpdater().addForNotification(jMenuItem, UiUpdater.SELECTION_SELECTED);
        jMenuItem = new JMenuItem("Extract thumbs");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener((PhotoCollectionPanel)this.controller.component(Controller.COMP_COLLECTION));
        this.controller.getUiUpdater().addForNotification(jMenuItem, UiUpdater.SELECTION_SELECTED);
        jMenuItem = new JMenuItem("Web publishing");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener((PhotoCollectionPanel)this.controller.component(Controller.COMP_COLLECTION));
        this.controller.getUiUpdater().addForNotification(jMenuItem, UiUpdater.SELECTION_SELECTED);
        jMenuItem = new JMenuItem("Send by e-mail");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener((PhotoCollectionPanel)this.controller.component(Controller.COMP_COLLECTION));
        this.controller.getUiUpdater().addForNotification(jMenuItem, UiUpdater.SELECTION_SELECTED);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("View HTML");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this.controller);
        jMenuItem = new JMenuItem("Stitch");
        jMenu.add(jMenuItem);
        jMenuItem.setEnabled(false);
        jMenu.addSeparator();
        this.addPluginMenus(jMenu);
        jMenuItem = new JMenuItem("Options...");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this.controller);
        jMenu = new JMenu("Help");
        jMenuBar.add(jMenu);
        jMenuItem = new JMenuItem("Contents...");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this.controller);
        jMenuItem = new JMenuItem("About...");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this.controller);
        try {
            jMenuBar.setHelpMenu(jMenu);
        }
        catch (Error error) {
            // empty catch block
        }
        return jMenuBar;
    }

    void addPluginMenus(JMenu jMenu) {
        Enumeration enumeration = this.controller.components();
        while (enumeration.hasMoreElements()) {
            try {
                if (!((PhotoPlugin)enumeration.nextElement()).addMenuElements(jMenu)) continue;
                jMenu.addSeparator();
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    JToolBar createToolBar(int n) {
        JToolBar jToolBar = new JToolBar(n);
        JButton jButton = new JButton(BaseController.getResourceIcon("readcf.jpg"));
        jToolBar.add(jButton);
        jButton.setToolTipText("Get CF");
        jButton.addActionListener((PhotoCollectionPanel)this.controller.component(Controller.COMP_COLLECTION));
        jButton = new JButton(BaseController.getResourceIcon("photoorganizer.jpg"));
        jToolBar.add(jButton);
        jButton.setToolTipText("To selection");
        jButton.addActionListener((JTreeTable)this.controller.component(Controller.COMP_DIRTREE));
        this.controller.getUiUpdater().addForNotification(jButton, UiUpdater.DIRECTORY_SELECTED);
        jButton = new JButton(BaseController.getResourceIcon("changedrive.jpg"));
        jToolBar.add(jButton);
        jButton.setToolTipText("Change drive");
        jButton.addActionListener((JTreeTable)this.controller.component(Controller.COMP_DIRTREE));
        return jToolBar;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ROptionsMenu
    extends JPopupMenu {
        public ROptionsMenu() {
            JMenuItem jMenuItem = new JMenuItem("Extract thumbs");
            this.add(jMenuItem);
            jMenuItem.addActionListener((PhotoCollectionPanel)PhotoOrganizer.this.controller.component(Controller.COMP_COLLECTION));
            jMenuItem.setEnabled(PhotoOrganizer.this.controller.getUiUpdater().isEnabled(UiUpdater.SELECTION_SELECTED));
            jMenuItem = new JMenuItem("Web publishing");
            this.add(jMenuItem);
            jMenuItem.addActionListener((PhotoCollectionPanel)PhotoOrganizer.this.controller.component(Controller.COMP_COLLECTION));
            jMenuItem.setEnabled(PhotoOrganizer.this.controller.getUiUpdater().isEnabled(UiUpdater.SELECTION_SELECTED));
            jMenuItem = new JMenuItem("Send by e-mail");
            this.add(jMenuItem);
            jMenuItem.addActionListener((PhotoCollectionPanel)PhotoOrganizer.this.controller.component(Controller.COMP_COLLECTION));
            jMenuItem.setEnabled(PhotoOrganizer.this.controller.getUiUpdater().isEnabled(UiUpdater.SELECTION_SELECTED));
            jMenuItem = new JMenuItem("View HTML");
            this.add(jMenuItem);
            jMenuItem.addActionListener(PhotoOrganizer.this.controller);
            this.addSeparator();
            jMenuItem = new JMenuItem("Get CF");
            this.add(jMenuItem);
            jMenuItem.addActionListener((PhotoCollectionPanel)PhotoOrganizer.this.controller.component(Controller.COMP_COLLECTION));
            this.addSeparator();
            jMenuItem = new JMenuItem("Options...");
            this.add(jMenuItem);
            jMenuItem.addActionListener(PhotoOrganizer.this.controller);
        }
    }

    class FlashWindow
    extends JWindow {
        public FlashWindow() {
            this.getContentPane().add(new JLabel(BaseController.getResourceIcon("logo.jpg")));
            this.pack();
            Dimension dimension = this.getToolkit().getScreenSize();
            Dimension dimension2 = this.getPreferredSize();
            ((Component)this).setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
            ((Component)this).setVisible(true);
        }
    }
}

