/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.directory;

import java.io.File;
import java.util.Date;
import java.util.Vector;
import photoorganizer.directory.AbstractTreeTableModel;
import photoorganizer.directory.FileNode;
import photoorganizer.directory.TreeTableModel;
import photoorganizer.formats.AbstractImageInfo;
import photoorganizer.formats.BasicJpeg;

public class FileSystemModel
extends AbstractTreeTableModel
implements TreeTableModel {
    protected static String[] cNames = new String[]{"Name", "Size", "Type", "Modified", "Shutter", "Aperture", "Flash", "Quality", "Zoom"};
    protected static Class[] cTypes = new Class[]{class$photoorganizer$directory$TreeTableModel == null ? (class$photoorganizer$directory$TreeTableModel = FileSystemModel.class$("photoorganizer.directory.TreeTableModel")) : class$photoorganizer$directory$TreeTableModel, class$java$lang$Integer == null ? (class$java$lang$Integer = FileSystemModel.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$String == null ? (class$java$lang$String = FileSystemModel.class$("java.lang.String")) : class$java$lang$String, class$java$util$Date == null ? (class$java$util$Date = FileSystemModel.class$("java.util.Date")) : class$java$util$Date, class$photoorganizer$formats$Rational == null ? (class$photoorganizer$formats$Rational = FileSystemModel.class$("photoorganizer.formats.Rational")) : class$photoorganizer$formats$Rational, class$java$lang$Float == null ? (class$java$lang$Float = FileSystemModel.class$("java.lang.Float")) : class$java$lang$Float, class$java$lang$Boolean == null ? (class$java$lang$Boolean = FileSystemModel.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$String == null ? (class$java$lang$String = FileSystemModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Integer == null ? (class$java$lang$Integer = FileSystemModel.class$("java.lang.Integer")) : class$java$lang$Integer};
    public static final Integer ZERO = new Integer(0);
    public boolean unixfilefystem = File.separatorChar == '/';
    static /* synthetic */ Class class$photoorganizer$directory$TreeTableModel;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$photoorganizer$formats$Rational;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Boolean;

    public FileSystemModel() {
        this.setRoot(new FileNode(this.findFirstDrive()));
    }

    File findFirstDrive() {
        File[] fileArray = this.getRoots();
        if (fileArray.length > 1) {
            return fileArray[1];
        }
        return null;
    }

    public File[] getRoots() {
        Object[] objectArray;
        if (this.unixfilefystem) {
            File[] fileArray = new File[2];
            fileArray[1] = new File(File.separator);
            if (fileArray[1].exists() && fileArray[1].isDirectory()) {
                return fileArray;
            }
            return null;
        }
        Vector<File> vector = new Vector<File>();
        vector.addElement(new WindowsFloppy());
        char c = 'C';
        while (c <= 'Z') {
            objectArray = new char[]{c, ':', File.separatorChar};
            String string = new String((char[])objectArray);
            File file = new File(string);
            if (file != null && file.exists()) {
                vector.addElement(file);
            }
            c = (char)(c + 1);
        }
        objectArray = new File[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected File getFile(Object object) {
        FileNode fileNode = (FileNode)object;
        return fileNode.getFile();
    }

    protected BasicJpeg getFormat(Object object) {
        FileNode fileNode = (FileNode)object;
        return fileNode.getFormat();
    }

    protected Object[] getChildren(Object object) {
        FileNode fileNode = (FileNode)object;
        return fileNode.getChildren();
    }

    public int getChildCount(Object object) {
        Object[] objectArray = this.getChildren(object);
        return objectArray == null ? 0 : objectArray.length;
    }

    public Object getChild(Object object, int n) {
        return this.getChildren(object)[n];
    }

    public boolean isLeaf(Object object) {
        return !this.getFile(object).isDirectory();
    }

    public int getColumnCount() {
        return cNames.length;
    }

    public String getColumnName(int n) {
        return cNames[n];
    }

    public Class getColumnClass(int n) {
        return cTypes[n];
    }

    public Object getValueAt(Object object, int n) {
        File file = this.getFile(object);
        AbstractImageInfo abstractImageInfo = this.getFormat(object).getImageInfo();
        try {
            switch (n) {
                case 0: {
                    return file.getName();
                }
                case 1: {
                    return file.isFile() ? new Integer((int)file.length()) : ZERO;
                }
                case 2: {
                    if (abstractImageInfo != null) {
                        return abstractImageInfo.getMake();
                    }
                    return file.isDirectory() ? "Directory" : "File";
                }
                case 3: {
                    Date date;
                    if (abstractImageInfo != null && (date = abstractImageInfo.getDateTimeOriginal()) != null) {
                        return date;
                    }
                    return new Date(file.lastModified());
                }
                case 4: {
                    if (abstractImageInfo == null) break;
                    return abstractImageInfo.getShutter();
                }
                case 5: {
                    if (abstractImageInfo == null) break;
                    return new Float(abstractImageInfo.getFNumber());
                }
                case 6: {
                    if (abstractImageInfo == null) break;
                    return abstractImageInfo.isFlash() ? Boolean.TRUE : Boolean.FALSE;
                }
                case 7: {
                    if (abstractImageInfo == null) break;
                    return abstractImageInfo.getQuality();
                }
                case 8: {
                    if (abstractImageInfo == null) break;
                    return new Integer((int)abstractImageInfo.getFocalLength());
                }
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class WindowsFloppy
    extends File {
        public WindowsFloppy() {
            super("A:" + File.separator);
        }

        public boolean isDirectory() {
            return true;
        }
    }
}

