/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.renderer;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import photoorganizer.Controller;
import photoorganizer.Resources;
import photoorganizer.directory.JDirectoryChooser;
import photoorganizer.formats.BasicJpeg;
import photoorganizer.formats.FileNameFormat;
import photoorganizer.renderer.PopupCombo;
import rogatkin.GranulatedLayout;
import rogatkin.Persistentable;
import rogatkin.Serializer;

public final class RenameOptionsTab
extends JPanel
implements ActionListener,
DocumentListener,
FocusListener,
Persistentable {
    public static final String SECNAME = "RenameOptions";
    public static final String MASK = "Mask";
    public static final String ASKEDIT = "AskEdit";
    public static final String REMOVEAFTER = "RemoveAfterRename";
    public static final String COUNTER = "Counter";
    static final String DESTFOLDER = "DestinationFolder";
    Controller controller;
    private JTextField textfield;
    private JTextField tf_counter;
    private JTextField tf_destdir;
    private JButton bt_brws_dstdir;
    private JCheckBox cb_editnewname;
    private JCheckBox cb_remafter;

    public RenameOptionsTab(Controller controller) {
        this.controller = controller;
        this.setLayout(new GranulatedLayout(5, 5, 20, 4, 8, 8));
        this.add((Component)new JLabel("Target name generation mask"), "0,0,4,1");
        this.textfield = new JTextField();
        this.add((Component)this.textfield, "0,1,4,1");
        this.textfield.getDocument().addDocumentListener(this);
        this.cb_editnewname = new JCheckBox("Edit name before");
        this.add((Component)this.cb_editnewname, "0,2,2,1,12");
        this.cb_remafter = new JCheckBox("Remove from selection");
        this.add((Component)this.cb_remafter, "2,2,2,1,12");
        this.add((Component)new PopupCombo(Resources.MASKS[1], "<", this, "4,1,1,1", this.textfield), "4,1,2,1");
        this.add((Component)new JLabel("Initial counter"), "0,3,2,1");
        this.tf_counter = new JTextField();
        this.add((Component)this.tf_counter, "2,3,1,1");
        this.tf_counter.setHorizontalAlignment(4);
        this.add((Component)new JLabel("Destination folder for renaming and transformation"), "0,4,4,1");
        this.tf_destdir = new JTextField();
        this.add((Component)this.tf_destdir, "0,5,4,1");
        this.bt_brws_dstdir = new JButton("Browse");
        this.add((Component)this.bt_brws_dstdir, "4,5,1,1");
        this.bt_brws_dstdir.addActionListener(this);
        this.tf_counter.addFocusListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JDirectoryChooser jDirectoryChooser;
        if (actionEvent.getSource() == this.bt_brws_dstdir && (jDirectoryChooser = new JDirectoryChooser(new JFrame(), this.tf_destdir.getText(), null)).getDirectory() != null) {
            this.tf_destdir.setText(jDirectoryChooser.getDirectory());
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.textfield.setToolTipText(FileNameFormat.makeValidPathName(new FileNameFormat(this.textfield.getText()).format(this.controller.sampleJpeg)));
    }

    public void focusGained(FocusEvent focusEvent) {
        this.tf_counter.setText("" + FileNameFormat.counter);
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void load() {
        Serializer serializer = this.controller.getSerializer();
        this.textfield.setText(Serializer.arrayToString(serializer.getProperty(SECNAME, MASK)));
        this.cb_editnewname.setSelected(Serializer.getInt(serializer.getProperty(SECNAME, ASKEDIT), 0) == 1);
        this.cb_remafter.setSelected(Serializer.getInt(serializer.getProperty(SECNAME, REMOVEAFTER), 0) == 1);
        this.tf_counter.setText("" + FileNameFormat.counter);
        String string = (String)serializer.getProperty(SECNAME, DESTFOLDER);
        if (string != null) {
            this.tf_destdir.setText(string);
        }
    }

    public void save() {
        Serializer serializer = this.controller.getSerializer();
        serializer.setProperty(SECNAME, MASK, this.textfield.getText());
        serializer.setProperty(SECNAME, ASKEDIT, this.cb_editnewname.isSelected() ? Resources.I_YES : Resources.I_NO);
        serializer.setProperty(SECNAME, REMOVEAFTER, this.cb_remafter.isSelected() ? Resources.I_YES : Resources.I_NO);
        serializer.setProperty(SECNAME, DESTFOLDER, this.tf_destdir.getText());
        Integer n = Resources.I_NO;
        try {
            n = new Integer(this.tf_counter.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        serializer.setProperty(SECNAME, COUNTER, n);
        FileNameFormat.counter = n;
    }

    public static String getNewName(BasicJpeg basicJpeg, Controller controller) {
        return new FileNameFormat((String)controller.getSerializer().getProperty(SECNAME, MASK), true).format(basicJpeg);
    }
}

