/* UiUpdater 
 * Copyright (C) 1999 Dmitry Rogatkin.  All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 *  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 *  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 *  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 *  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package photoorganizer;

import java.util.*;
import java.awt.Component;

public class UiUpdater {
    public static int FILE_SELECTED = 1;
    public static int SELECTION_SELECTED = 2;
    public static int DIRECTORY_SELECTED = 3;
    public static int ALBUM_SELECTED = 3;
    static int[] EVENTS = {FILE_SELECTED, SELECTION_SELECTED, DIRECTORY_SELECTED, ALBUM_SELECTED};
    public UiUpdater() {
	lines = new Hashtable(2);
	states = new Hashtable(2);
	for (int j = 0; j <EVENTS.length; j++) {
	    Integer i;
	    lines.put(i = new Integer(EVENTS[j]), new Vector());
	    states.put(i, Boolean.FALSE);
	}
    }
    
    public void addForNotification(Component component, int ui_event) {
	Vector v = (Vector)lines.get(new Integer(ui_event));
	if (v == null)
	    return;
	for (int i=0; i<v.size(); i++)
	    if (v.elementAt(i) == component)
    	    return;
	v.addElement(component);
    }
    
    public void notify(boolean newstate, int ui_event) {
	Vector v = (Vector)lines.get(new Integer(ui_event));
	states.put(new Integer(ui_event), newstate?Boolean.TRUE:Boolean.FALSE);
	if (v == null)
	    return;
	for (int i=0; i<v.size(); i++)
	    ((Component)v.elementAt(i)).setEnabled(newstate);
    }

    public boolean isEnabled(int ui_event) {
	Boolean result = (Boolean)states.get(new Integer(ui_event));
	if (result != null)
	    return result.booleanValue();
	return false;
    }
    
    public void reset() {
	Enumeration e = lines.elements();
	while(e.hasMoreElements()) {
	    Vector v = (Vector)e.nextElement();
	    for (int i=0; i<v.size(); i++)
		((Component)v.elementAt(i)).setEnabled(false);
	}
 	for (int j = 0; j <EVENTS.length; j++)
	    states.put(new Integer(EVENTS[j]), Boolean.FALSE);
    }
    private Hashtable lines, states;
}