/* PhotoOrganizer - AlbumPane.java
 * Copyright (C) 1999-2000 Dmitry Rogatkin.  All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 *  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 *  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 *  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 *  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package photoorganizer.renderer;

import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import java.util.*;
import java.io.*;
import java.text.MessageFormat;
//import java.awt.dnd.*;

import javax.swing.*;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeSelectionEvent;

import rogatkin.*;
import photoorganizer.*;
import photoorganizer.formats.*;
import photoorganizer.album.*;
import photoorganizer.courier.*;

public class AlbumPane extends JTree implements ActionListener, TreeSelectionListener
               /*, DragGestureListener, DragSourceListener*/ {
    AlbumThumbnailsPanel thumbnails;
    PhotoCollectionPanel collectionpanel;
    private StatusBar statusbar;
    // drag stuff
    private boolean in_dragging;
    private JLabel draggedLabel;
    private JPanel glassPanel;
    private TreePath srcPath;
    private int srcAlbumId, dstAlbumId, parentAlbumId;


    public AlbumPane(Controller controller) {
        this.controller = controller;
        access = new Access(controller);
        setModel(new AlbumModel(access));
        getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
	statusbar = (StatusBar)controller.component(Controller.COMP_STATUSBAR);
	//"Tree.leafIcon";
        glassPanel = (JPanel)this.controller.getMainGlassPane();
        draggedLabel = new JLabel((Icon)UIManager.get("Tree.closedIcon"));
        draggedLabel.setOpaque(false);
        glassPanel.add(draggedLabel);
        addTreeSelectionListener(this);
        addMouseListener(new MouseInputAdapter() {
            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiers() & InputEvent.BUTTON3_MASK) > 0) {
                    Point p = ((JViewport)getParent()).getViewPosition();
                    new AlbumRightBtnMenu(AlbumPane.this).
                    show(getParent(), e.getX()-p.x, e.getY()-p.y);
                }
            }
	    public void mouseReleased(MouseEvent e) {
		if (!in_dragging)
		    return;
		setCursor(Cursor.getDefaultCursor());
                glassPanel.setVisible(false);
		TreePath tp = getClosestPathForLocation(e.getX(), e.getY());
		if (tp != null && tp != srcPath && srcPath != null) {
		    /*if (JOptionPane.showConfirmDialog(AlbumPane.this,
			// Are sure that you want to move album src under album dst
			MessageFormat.format(Resources.LABEL_MOVE_ALBUM, new String[]
		    {access.getNameOfAlbum(access.getAlbumId(srcPath)), access.getNameOfAlbum(access.getAlbumId(tp))}),
			Resources.TITLE_COFIRMATION,
			JOptionPane.OK_CANCEL_OPTION) == JOptionPane.OK_OPTION)
			;*/
		    JPopupMenu menu = new JPopupMenu();
		    JMenuItem item;
		    // since variable below are class variables, this code won't work
		    // in multithreaded environment
		    srcAlbumId = access.getAlbumId(srcPath);
		    parentAlbumId = access.getAlbumId(srcPath.getParentPath());
		    dstAlbumId = access.getAlbumId(tp);
		    String [] ans = {access.getNameOfAlbum(srcAlbumId), access.getNameOfAlbum(dstAlbumId)};
		    menu.add(item = new JMenuItem(Resources.CMD_CANCEL));
		    item.addActionListener(AlbumPane.this);
		    menu.add(item = new JMenuItem(MessageFormat.format(Resources.MENU_MOVE_ALBUM, ans)));
		    item.addActionListener(AlbumPane.this);
		    menu.add(item = new JMenuItem(MessageFormat.format(Resources.MENU_COPY_ALBUM, ans)));
		    item.addActionListener(AlbumPane.this);
	    	    menu.show(AlbumPane.this, e.getX(), e.getY());
		}
		in_dragging = false;
	    }
        });
	addMouseMotionListener(new MouseMotionAdapter() {
	    public void mouseDragged(MouseEvent e) {
		if (!in_dragging) {
		    srcPath = getSelectionPath();
                    glassPanel.setVisible(true);
		}
                draggedLabel.setLocation(SwingUtilities.convertPoint(AlbumPane.this, e.getX(), e.getY(), glassPanel));
		in_dragging = true;
		setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
	    }
	});
        setEditable(true);
    }

    void setTumbnailsPanel(AlbumThumbnailsPanel thumbnails) {
        this.thumbnails = thumbnails;
    }

    void setCollectionPanel(PhotoCollectionPanel collection) {
        this.collectionpanel = collection;
    }

    public void actionPerformed(ActionEvent a) {
        String cmd = a.getActionCommand();
	boolean albumCopy=false, albumMove=false;
        if (cmd.equals(Resources.MENU_ADDTOCOLLECT)) {
	    collectionpanel.add(access.getAlbumContents(access.getAlbumId(getSelectionPath())));
        } else if (cmd.equals(Resources.MENU_DELETE)) {
	    access.deleteAlbumFrom(
		new int[] {access.getAlbumId(getSelectionPath().getParentPath())},
		access.getAlbumId(getSelectionPath()));
            invalidateTree();
        } else if (cmd.equals(Resources.MENU_DELETE_COMPLETLY)) {
	    access.deleteAlbum(access.getAlbumId(getSelectionPath()));
	    invalidateTree();
        } else if (cmd.equals(Resources.MENU_COPY_MOVE)) {
	    final int album = access.getAlbumId(getSelectionPath());
	    if (album > 0) {
		Serializer s = controller.getSerializer();
		final boolean albummove =
		    Serializer.getInt(s.getProperty(AlbumOptionsTab.SECNAME, AlbumOptionsTab.MOVETOFOLDER), 0) == 1;
		final String root = (String)s.getProperty(AlbumOptionsTab.SECNAME, AlbumOptionsTab.ALBUMROOT);
		new Thread(new Runnable() {
		    public synchronized void run() {
			if(albummove)
			    moveAlbum(album, new File(root!=null?root:"."));
			else
			    copyAlbum(album, new File(root!=null?root:"."));
			statusbar.clearInfo();
			statusbar.clearProgress();
		    }
		}, "Album copier").start();
	    }
        } else if (cmd.equals(Resources.MENU_RENAME)) {
            startEditingAtPath(getSelectionPath());
        } else if (cmd.equals(Resources.MENU_PUBLISH_CURRENT)) {
	    publishAlbum(access.getAlbumId(getSelectionPath()), false);
        } else if (cmd.equals(Resources.MENU_PUBLISH_ALL)) {
	    publishAlbum(access.getAlbumId(getSelectionPath()), true);
        } else if (cmd.equals(Resources.MENU_PROPERTIES)) {
            new AlbumProperties(this, access.getAlbumId(getSelectionPath()), access);
        } else if (cmd.equals(Resources.MENU_EXPORTTOCSV)) {
            JOptionPane.showMessageDialog(this, Resources.LABEL_FOR_NEXT_VER);
	} else if (cmd.equals(Resources.MENU_REFRESH)) {
	    invalidateTree();
	} else if (Resources.MENU_MOVE_ALBUM.regionMatches(0, cmd, 0, Resources.MENU_MOVE_ALBUM.indexOf('{')-1)) {
	    albumCopy = true;
	    albumMove = true;
	} else if (Resources.MENU_COPY_ALBUM.regionMatches(0, cmd, 0, Resources.MENU_COPY_ALBUM.indexOf('{')-1)) {
	    albumCopy = true;
	}
	if (albumCopy) {
	    if (srcAlbumId > 0 && dstAlbumId >= 0) {
		if (access.insertAlbumToAlbum(new int[]{dstAlbumId}, srcAlbumId) < 0) {
		    JOptionPane.showMessageDialog(controller.getMainFrame(), Resources.LABEL_ERR_COPYALBUM,
                    Resources.TITLE_ERROR, JOptionPane.ERROR_MESSAGE);
		    return;
		}
		((AlbumModel)getModel()).
                     fireTreeStructureChanged(this, new Object[]{getModel().getRoot()}, null, null);
	    }
	    if (albumMove) {
		access.deleteAlbumFrom(new int[]{parentAlbumId}, srcAlbumId);
		((AlbumModel)getModel()).
                     fireTreeStructureChanged(this, new Object[]{getModel().getRoot()}, null, null);
	    }
	}
    }

    public AlbumSelectionDialog getSelectionDialog() {
        if (albumselection == null)
            createSelectionDialog();
        return albumselection;
    }

    final synchronized void createSelectionDialog() {
        if (albumselection == null)
            albumselection = new AlbumSelectionDialog(controller);
    }

    void copyAlbum(int album, File parent) {
	File []content = access.getAlbumContents(album);
	File albumdir = new File(parent, access.getNameOfAlbum(album));
	albumdir.mkdir();
        statusbar.displayInfo(Resources.INFO_COPYING+"->"+albumdir);
        statusbar.setProgress(content.length);
	for (int i = 0; i < content.length; i++)
	    try {
		Controller.copyFile(content[i], new File(albumdir, content[i].getName()));
		statusbar.tickProgress();
	    } catch(IOException ioe) {
		System.err.println("Exception "+ioe+" in copying "+content[i]);
	    }
	int [] albums = access.getAlbumsId(album);
	for (int i = 0; i < albums.length; i++)
	    copyAlbum(albums[i], albumdir);
    }

    void moveAlbum(int album, File parent) {
	File []content = access.getAlbumContents(album);
	File albumdir = new File(parent, access.getNameOfAlbum(album));
	albumdir.mkdir();
        statusbar.displayInfo(Resources.INFO_MOVING+"->"+albumdir);
        statusbar.setProgress(content.length);
	for (int i = 0; i < content.length; i++) {
	    File oldname = new File(content[i], "");
	    // below should be atransaction 
	    if(content[i].renameTo(new File(albumdir, content[i].getName()))) {
		access.renamePictureTo(album, oldname.toString(), content[i].toString());
	    } else
		System.err.println("FIle "+content[i]+" hasn't been renamed");
	}
	int [] albums = access.getAlbumsId(album);
	for (int i = 0; i < albums.length; i++)
	    moveAlbum(albums[i], albumdir);
    }
    
    public void publishAlbum(final int albumId, final boolean child_also) {
	new Thread(new Runnable() {
	    public void run() {
		try {
		    Courier courier=null;
		    // TODO: move the code to courier factory
		    Serializer s = controller.getSerializer();
		    switch(Serializer.getInt(s.getProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.PUBMODE), WebPublishOptionsTab.LOCAL)) {
		    case WebPublishOptionsTab.FTP:
			courier = new FTPCourier(controller);
			break;
		    case WebPublishOptionsTab.HTTP: // http
			courier = new HTTPCourier(controller);
			break;
		    case WebPublishOptionsTab.EMAIL:
			// TODO: add send mail like feature
			//courier = new MailCourier(controller);
			new SendEmailFrame(controller, access.getAlbumContents(albumId));
			return;
		    case WebPublishOptionsTab.XML_SVG: // SVG
			break;
		    default:
			courier = new FileCourier(controller);
		    }
		    new HtmlProducer(controller).produce(courier, albumId, child_also);
		} catch(IOException ioe) {
		    statusbar.flashInfo(Resources.INFO_ERR_WEBPUBLISHING);
		    System.err.println("Exception in Web publishing "+ioe);
		    ioe.printStackTrace();
		}
	    }
	}, "Album publishing").start();
    }

    public void valueChanged(TreeSelectionEvent e) {
        controller.setWaitCursor(this, true);
        thumbnails.updateImages(access.getAlbumContents(access.getAlbumId(e.getPath())));
        controller.setWaitCursor(this, false);
    }

    public void addToAlbum(BasicJpeg[] images, final TreePath[] paths) {
        Serializer s = controller.getSerializer();
        final boolean picmove =
            Serializer.getInt(s.getProperty(AlbumOptionsTab.SECNAME, AlbumOptionsTab.MOVETOFOLDER), 0) == 1;
        final boolean maintainfld =
            Serializer.getInt(s.getProperty(AlbumOptionsTab.SECNAME, AlbumOptionsTab.USEALBUMFOLDER), 0) == 1;
        final String root = (String)s.getProperty(AlbumOptionsTab.SECNAME, AlbumOptionsTab.ALBUMROOT);
        for (int i = 0; paths != null && i < paths.length; i++) {
            if(maintainfld) {
                Object[] _ps = paths[i].getPath();
                String target = root == null?("."+File.separatorChar):root;
                for (int k=1; k<_ps.length; k++) // we skip root element
                    target += File.separator+_ps[k];
                new File(target).mkdirs();
                final String value = PhotoCollectionPanel.getRenameMask(this, s, " "+target);
                FileNameFormat fnf = new FileNameFormat(value, true);
                // TODO add work with real model to achieve corresponding update
                // Possible problem, a user in other thread can continue working on the model
                for (int j=0; j<images.length; j++) {
                    File file = new File(target, FileNameFormat.makeValidPathName(
                        fnf.format(images[j])));
                    if (picmove && i == 0 && !access.belongsToAlbum(images[j])) {
                        if (!images[j].renameTo(file))
                            System.err.println("Problem in moving file "+images[j].getLocationName()+" to "+file+" album");
                    } else {
                        try {
                            Controller.copyFile(new File(images[j].getLocationName()), file);
                            images[j] = new BasicJpeg(file);
                        } catch(IOException ioe) {
                            System.err.println("Problem in copying file "+images[j].getLocationName()+" to "+file+" album");
                        }
                    }
                }
            }
            access.insertPicturesToAlbum(access.getAlbumId(paths[i]), images);
        }
    }

    void deletePicture(String name) {
        access.deletePicture(access.getAlbumId(getSelectionPath()), name);
    }

    void setCommentTo(String name, String comment) {
        access.setPictureComment(access.getAlbumId(getSelectionPath()), name, comment);
    }

    public String getCommentOf(String name) {
        return access.getPictureComment(access.getAlbumId(getSelectionPath()), name);
    }

    public void invalidateTree() {
        ((AlbumModel)getModel()).
            fireTreeStructureChanged(this, new Object[]{getModel().getRoot()}, null, null);
    }

    public Access getAccess() {
	return access;
    }

    class AlbumRightBtnMenu extends JPopupMenu {
        AlbumRightBtnMenu(ActionListener listener) {
            controller.getUiUpdater().notify(getSelectionPath() != null, UiUpdater.ALBUM_SELECTED);
            JMenuItem item;
            add(item = new JMenuItem(Resources.MENU_ADDTOCOLLECT));
            item.addActionListener(listener);
            item.setEnabled(controller.getUiUpdater().isEnabled(UiUpdater.ALBUM_SELECTED));
	    addSeparator();
            add(item = new JMenuItem(Resources.MENU_COPY_MOVE));
            item.addActionListener(listener);
            item.setEnabled(controller.getUiUpdater().isEnabled(UiUpdater.ALBUM_SELECTED));
	    addSeparator();
            add(item = new JMenuItem(Resources.MENU_DELETE));
            item.addActionListener(listener);
            item.setEnabled(controller.getUiUpdater().isEnabled(UiUpdater.ALBUM_SELECTED));
            add(item = new JMenuItem(Resources.MENU_DELETE_COMPLETLY));
            item.addActionListener(listener);
            item.setEnabled(controller.getUiUpdater().isEnabled(UiUpdater.ALBUM_SELECTED));
            add(item = new JMenuItem(Resources.MENU_RENAME));
            item.addActionListener(listener);
            item.setEnabled(controller.getUiUpdater().isEnabled(UiUpdater.ALBUM_SELECTED));
            addSeparator();
	    JMenu menu = new JMenu(Resources.MENU_PUBLISH);
            menu.add(item = new JMenuItem(Resources.MENU_PUBLISH_CURRENT));
            item.addActionListener(listener);
	    item.setEnabled(controller.getUiUpdater().isEnabled(UiUpdater.ALBUM_SELECTED));
            menu.add(item = new JMenuItem(Resources.MENU_PUBLISH_ALL));
            item.addActionListener(listener);
	    item.setEnabled(controller.getUiUpdater().isEnabled(UiUpdater.ALBUM_SELECTED));
	    add(menu);
            addSeparator();
            add(item = new JMenuItem(Resources.MENU_PROPERTIES));
            item.addActionListener(listener);
            item.setEnabled(controller.getUiUpdater().isEnabled(UiUpdater.ALBUM_SELECTED));
            addSeparator();
            add(item = new JMenuItem(Resources.MENU_REFRESH));
            item.addActionListener(listener);
        }
    }

    private Controller controller;
    private AlbumSelectionDialog albumselection;

    Access access;
}