/* GranulatedLayout 
 * Copyright (C) 1999 Dmitry Rogatkin.  All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 *  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 *  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 *  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 *  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package rogatkin;

import java.awt.*;
import java.util.*;

public class GranulatedLayout implements LayoutManager {
    static final int DEF_H = 24; // should be in font size
   
    public GranulatedLayout(int grwidth, int grheight,
        int maxheight, int maxvertgap) {
	this(grwidth, grheight, maxheight, maxvertgap, 4, 2, 4);
    }

    public GranulatedLayout(int grwidth, int grheight,
                            int maxheight, int maxvertgap, int horizinset, int horizgap) {
        this(grwidth, grheight, maxheight, maxvertgap, horizinset, horizgap, 4);
    }
    
    public GranulatedLayout(int grwidth, int grheight,
        int maxheight, int maxvertgap, int horizinset, int horizgap, int proportion) {
        layouters = new Hashtable();
        if (grwidth <= 0)
            grwidth = 1;
        widthingranul = grwidth;
        if (grheight <= 0)
            grheight = 1;
        heightingranul = grheight;
        if (maxheight < 0)
            maxheight = DEF_H;
        maxgranulvertsize = maxheight;
        if (maxvertgap <= 0)
            maxvertgap = 4;
        this.maxvertgap = maxvertgap;
        if (proportion < 1 || proportion > 8)
            proportion = 4;
        this.proportion = proportion;
	if (horizgap < 0 || horizgap > proportion*4)
	    this.horizgap = 0;
	else
	    this.horizgap = horizgap;
	if (horizinset < 0 || horizinset > proportion*4)
	    this.horizinset = 0;
	else
	    this.horizinset = horizinset;
    }
    
    public void addLayoutComponent(String name,
        Component comp) {
        layouters.put(comp, name);
    }
    
    public void removeLayoutComponent(Component comp) {
        layouters.remove(comp);
    }
    
    public Dimension preferredLayoutSize(Container parent) {
        return new Dimension(maxgranulvertsize*proportion*(widthingranul+1),
            maxgranulvertsize*(heightingranul+1));
    }
    
    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(1,1);
    }
    
    public void layoutContainer(Container parent) {
        Dimension d = parent.getSize();
        int horzgransize = (d.width-2*horizinset) / widthingranul;
        int vertgransize = d.height / heightingranul;
        if (vertgransize > (maxgranulvertsize+maxvertgap))
            vertgransize = maxgranulvertsize;
        int x, y, w, h, hg, vg;
        Dimension ps;
        Enumeration ce = layouters.keys();
        while (ce.hasMoreElements())
        {
            Component comp = (Component)ce.nextElement();
            try {
                StringTokenizer st = new StringTokenizer((String)layouters.get(comp), ", ");
                if (st.hasMoreTokens()) {
                    x = Integer.parseInt(st.nextToken() );
                    if (st.hasMoreTokens()) {
	                y = Integer.parseInt(st.nextToken() );
			if (st.hasMoreTokens()) {
			    w = Integer.parseInt(st.nextToken() );
			    if (st.hasMoreTokens()) {
				h = Integer.parseInt(st.nextToken() );
				if (st.hasMoreTokens()) {
				    hg = Integer.parseInt(st.nextToken() );
				    if (st.hasMoreTokens())
					vg = Integer.parseInt(st.nextToken() );
				    else
					vg = 0;
				} else {
				    vg = 0;
				    hg = horizgap;
				}
			    } else {
				h = 1;
				hg = horizgap;
				vg = 0;
			    }
			} else {
			    w = 1;
			    h = 1;
			    hg = horizgap;
			    vg = 0;
			}
                    } else {
                        y = 0;
			w = 1;
			h = 1;
			hg = horizgap;
			vg = 0;
		    }
		} else {
                    y = 0;
		    x = 0;
		    w = 1;
		    h = 1;
		    hg = horizgap;
		    vg = 0;
		}
                ps = comp.getPreferredSize();
                comp.setBounds(x*horzgransize+hg/2+horizinset, y*vertgransize+vg/2,
                    w*horzgransize-hg, (h==0)?ps.height:(h*vertgransize-vg));
            } catch(Throwable e) {
            }
        }
    }
    
    private Hashtable layouters;
    private int widthingranul;
    private int heightingranul;
    private int maxgranulvertsize;
    private int maxvertgap;
    private int horizinset, horizgap;
    private int proportion;
}