/* Quat - A 3D fractal generation program */ 
/* Copyright (C) 1997,98 Dirk Meyer */ 
/* (email: dirk.meyer@studbox.uni-stuttgart.de) */ 
/* mail:  Dirk Meyer */ 
/*        Marbacher Weg 29 */ 
/*        D-71334 Waiblingen */ 
/*        Germany */ 
/* */ 
/* This program is free software; you can redistribute it and/or */ 
/* modify it under the terms of the GNU General Public License */ 
/* as published by the Free Software Foundation; either version 2 */ 
/* of the License, or (at your option) any later version. */ 
/* */ 
/* This program is distributed in the hope that it will be useful, */ 
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */ 
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */ 
/* GNU General Public License for more details. */ 
/* */ 
/* You should have received a copy of the GNU General Public License */ 
/* along with this program; if not, write to the Free Software */ 
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */ 
 
#include <string.h>
#include "common.h"
#include "IntersecEditor.moc"

#define Inherited IntersecEditorData
#define prec 10

//#include <stdio.h>

IntersecEditor::IntersecEditor(QWidget* parent, const char* name, bool s_nochange)
   : Inherited( parent, name )
{
   nochange = s_nochange;
   setCaption( "Intersection Editor" );
   connect(this, SIGNAL(normal1Changed(const char*)), edit_normal1, SLOT(setText(const char*)) );
   connect(this, SIGNAL(normal2Changed(const char*)), edit_normal2, SLOT(setText(const char*)) );
   connect(this, SIGNAL(normal3Changed(const char*)), edit_normal3, SLOT(setText(const char*)) );
   connect(this, SIGNAL(plane1Changed(const char*)), edit_plane1, SLOT(setText(const char*)) );
   connect(this, SIGNAL(plane2Changed(const char*)), edit_plane2, SLOT(setText(const char*)) );
   connect(this, SIGNAL(plane3Changed(const char*)), edit_plane3, SLOT(setText(const char*)) );
   numcut = 0; idx = -1;
   label_item->setText("1");
   scroll->setRange(0, 0);
   scroll->setEnabled(FALSE);
   SetAllEnabled(FALSE);
   if (nochange)
   {
      button_add->setEnabled(FALSE);
      button_del->setEnabled(FALSE);
   }
}


IntersecEditor::~IntersecEditor()
{
}

void IntersecEditor::SetAllEnabled(bool b)
{
   if (!nochange || !b)
   {
      edit_normal1->setEnabled(b);
      edit_normal2->setEnabled(b);
      edit_normal3->setEnabled(b);
      edit_plane1->setEnabled(b);
      edit_plane2->setEnabled(b);
      edit_plane3->setEnabled(b);
   }
}

void IntersecEditor::SetData(double *d)
{
   int i;

   memcpy(buf, d, sizeof(double)*140);
   i = 0; numcut = 0;
   while (*(char *)&buf[i]!=CUT_TERMINATOR && numcut<20) { i += 7; numcut++; }
   idx = 0;
   if (numcut==0)
   {
      scroll->setRange(0, 0);
      idx = -1;
      scroll->setEnabled(FALSE);
      SetAllEnabled(FALSE);
   }
   else
   {
      scroll->setRange(0, numcut-1);
      scroll->setEnabled(TRUE);
      SetAllEnabled(TRUE);
      setPosition(idx | 128);
   }
}

void IntersecEditor::GetData(double *d)
{
   memcpy(d, buf, sizeof(double)*140);
}

void IntersecEditor::Add()
{
   if (numcut<20)
   {
      numcut++; idx = numcut-1;
      scroll->setRange(0, numcut-1);
      scroll->setValue(idx);
      scroll->setEnabled(TRUE);
      SetAllEnabled(TRUE);
      setPosition(idx | 128);
      *(char *)(buf+idx*7) = CUT_PLANE;
   }
}

void IntersecEditor::Del()
{
   int i;

   if (numcut>0)
   {
      for (i=idx; i<numcut-1; i++)
      {
         *(buf+i*7) = *(buf+(i+1)*7);
         *(buf+i*7+1) = *(buf+(i+1)*7+1);
         *(buf+i*7+2) = *(buf+(i+1)*7+2);
         *(buf+i*7+3) = *(buf+(i+1)*7+3);
         *(buf+i*7+4) = *(buf+(i+1)*7+4);
         *(buf+i*7+5) = *(buf+(i+1)*7+5);
         *(buf+i*7+6) = *(buf+(i+1)*7+6);
      }
      numcut--;
      *(char *)(buf+numcut*7) = CUT_TERMINATOR;
      if (numcut>0) scroll->setRange(0, numcut-1);
      else scroll->setRange(0, 0);
      if (numcut==0)
      {
         idx = -1;
         scroll->setEnabled(FALSE);
         SetAllEnabled(FALSE);
      }
      else 
      {
         if (idx==numcut)
         {
            idx--;
            scroll->setValue(idx);
            setPosition(idx);
         }
         else setPosition(idx | 128);
      }
   }
}

void IntersecEditor::setPosition(int i)
{
   QString s;
   if (i != idx || (i & 128) != 0)
   {
      idx = i & 63;
      s.setNum(*(buf+idx*7+1), 'g', prec);
      setNormal1((const char*)s);
      s.setNum(*(buf+idx*7+2), 'g', prec);
      setNormal2((const char*)s);
      s.setNum(*(buf+idx*7+3), 'g', prec);
      setNormal3((const char*)s);
      s.setNum(*(buf+idx*7+4), 'g', prec);
      setPlane1((const char*)s);
      s.setNum(*(buf+idx*7+5), 'g', prec);
      setPlane2((const char*)s);
      s.setNum(*(buf+idx*7+6), 'g', prec);
      setPlane3((const char*)s);
      s.setNum(idx+1);
      label_item->setText((const char *)s);
   }
}

void IntersecEditor::setNormal1(const char *c)
{
   QString s;

   s.setStr(c);
   *(buf+idx*7+1) = s.toDouble(NULL);
   if (strcmp(c, edit_normal1->text()) != 0) emit normal1Changed(c);
}

void IntersecEditor::setNormal2(const char *c)
{
   QString s;

   s.setStr(c);
   *(buf+idx*7+2) = s.toDouble(NULL);
   if (strcmp(c, edit_normal2->text()) != 0) emit normal2Changed(c);
}

void IntersecEditor::setNormal3(const char *c)
{
   QString s;

   s.setStr(c);
   *(buf+idx*7+3) = s.toDouble(NULL);
   if (strcmp(c, edit_normal3->text()) != 0) emit normal3Changed(c);
}

void IntersecEditor::setPlane1(const char *c)
{
   QString s;

   s.setStr(c);
   *(buf+idx*7+4) = s.toDouble(NULL);
   if (strcmp(c, edit_plane1->text()) != 0) emit plane1Changed(c);
}

void IntersecEditor::setPlane2(const char *c)
{
   QString s;

   s.setStr(c);
   *(buf+idx*7+5) = s.toDouble(NULL);
   if (strcmp(c, edit_plane2->text()) != 0) emit plane2Changed(c);
}

void IntersecEditor::setPlane3(const char *c)
{
   QString s;

   s.setStr(c);
   *(buf+idx*7+6) = s.toDouble(NULL);
   if (strcmp(c, edit_plane3->text()) != 0) emit plane3Changed(c);
}

