#include <conio.h>
#include "sources.cpp\xmode.cpp"
#include "sources.cpp\gtri.h"

 /* Dreiecksroutine von Terry Sznober (tumblin@mi.net)
     wurde meinen MODE-X-Primitiven angepasst. Thanx, Terry !!!            */

void GTriangle(float x1,float y1,float c1,float x2,float y2,float c2,
						   float x3,float y3,float c3)
{

	float mx;  // slope dy/dx
	float mc;  // slope dc/dx
	float x;   // x screen coordinate
	float c;   // color of pixel to plot
	int count; // looping variable
	int y;     // looping variable
	float cl;  // color of left edge of horizontal scanline
	float cr;  // color of right edge of horizontal scanline
	float el;  // coordinate of left edge of horizontal scanline
	float er;  // coordinate of right edge of horizontal scanline

	// initialize the edge buffers to extreme values
	for(count=0;count<240;count++)
	{
		edge_l[count]=319;
		edge_r[count]=0;
	}

	// scan the edges of the triangle
	ScanEdge(x1,y1,c1, x2,y2,c2);
	ScanEdge(x2,y2,c2, x3,y3,c3);
	ScanEdge(x3,y3,c3, x1,y1,c1);

	// gouraud fill the horizontal scanlines
	for(y=0;y<240;y++)
	{
		// if the scanline is valid (ie left coordinate < right coordinate)
		if(edge_l[y] <= edge_r[y])
		{
			cl=(float)color_l[y];
			cr=(float)color_r[y];
			el=(float)edge_l[y];
			er=(float)edge_r[y];

			// now calculate slope of color (dc/dx)

			if( (er-el) == 0)
			{
				// denominator will be zero so don't do the division so use dc
				mc = (cr-cl);
			}
			else
			{
				// denominator okay, so use dc/dx
				mc = (cr-cl)/(er-el);
			}
			c = cl; // start with color of left edge of scanline
			// loop through every pixel in horizontal scanline
			for(count=(int)edge_l[y]; count < (int)edge_r[y]; count++)
			{
				pix_w80(count,y+log_y_offset,(int)c);
				c+=mc; // increase the color by dc/dx
			}
		}
	}
}




/* Kanntenberechnung fuer die Dreiecksroutine von Terry Sznober.
   X-Clipping wurde nachtraeglich von mir (Tobias Schwinger) hinzugefuegt. */

void ScanEdge(float x1,float y1,float c1,float x2,float y2,float c2)
{


	// scan-convert (x1,y1,c1)-(x2,y2,c2)
	float mx;   // slope dx/dy
	float mc;   // slope dc/dy
	float x;    // x pixel coordinate
	float c;    // pixel's color
	int count;  // looping variable
	int nx;
	float temp; // used for swapping

	// make sure that edge goes from top to bottom
	if( (y2-y1) < 0 )
	{
		// swap y2 with y1
		temp=y1;
		y1=y2;
		y2=temp;
		// swap x2 with x1
		temp=x1;
		x1=x2;
		x2=temp;
		// swap c2 with c1
		temp=c1;
		c1=c2;
		c2=temp;
	}

	// initialize for stepping
	if( (y2-y1) != 0)
	{
		mx = (x2-x1)/(y2-y1); // dx/dy
		mc = (c2-c1)/(y2-y1); // dc/dy
	}
	else
	{
		mx = (x2-x1); // dx
		mc = (c2-c1); // dc
	}
	x = x1; // starting x coordinate
	c = c1; // starting c color

	// step through edge and record color values along the way
	for(count=y1; count < y2; count++)
	{
		nx=(int)x;
		if (nx < min_x) nx=min_x;
		else if (nx > max_x) nx=max_x;

		if (nx < (float)edge_l[count])
		{

			edge_l[count]=nx;
			color_l[count]=(int)c;
		}
		if (nx > (float)edge_r[count])
		{
			edge_r[count]=nx;
			color_r[count]=(int)c;
		}
		x+=mx;  // x = x + dx/dy
		c+=mc;  // c = c + dc/dy
	}
}



