// WinPlot3DZ.cpp : implementation of the WinPlot3DZ class
// Concrete plotting class derived from Plot3DZ abstract class

#include "stdafx.h"
#include "plot3dz.h"
#include "..\common\winplot3d.h"
#include "..\common\PlotCalc.h"

#ifndef	_WINPLOT3DZ_H_
#define	_WINPLOT3DZ_H_	1	// avoid re-including

/////////////////////////////////////////////////////////////////////////////
class WinPlot3DZ : public WinPlot3D, public Plot3DZ
{
public:
	WinPlot3DZ() { m_pPlotCalc = new PlotCalc; }
	~WinPlot3DZ() { delete m_pPlotCalc; }

	// map to WinPlot3D
	virtual void MoveTo(int xv,int yv) { WinMoveTo(xv,yv);    }
	virtual void DrawTo(int xv,int yv) { WinDrawTo(xv,yv);    }
	virtual void ColorTo(long color)   { WinColorTo(color);   }
	virtual void PlotText(AXIS_PLOT_INFO* pAxisInfo,double degrees,
		int xv,int yv,CString text)    { WinPlotText(pAxisInfo,degrees,xv,yv,text);   }

	// call back routines
	virtual void cbBegPlot()           { WinBegPlot();        }
	virtual void cbEndPlot()           { WinEndPlot();        }
	virtual void cbCheckUserAbort()    { if (IsAbortRequested()) DoAbort(); }

	// must defined these
	virtual double Zfunc(double x,double y) { return( m_pPlotCalc->Calc(x,y) ); }
	virtual long   Color(double x,double y,double z);

	PlotCalc* m_pPlotCalc;  // Equation Calculator
};

#endif	// _WINPLOT3DZ_H_

// ------------------------------  end WinPlot3DZ.H  ----------------------------
