unit GLE2000E;
//////////////////////////////////////////////////////////////////////////////
//  This unit handles text processing.                                      //
//////////////////////////////////////////////////////////////////////////////
{ Edit Unit Version GLE2000H2 12th May 2000
  Input and editing of text files and primary program control
  Arc and Narc now operate on both radians & degrees
  subroutines can now be nested
  Zero scale factors now detected. Arto, SaveAs and polar plots added.
  Data ccess and display features updated.}

interface

uses
  SysUtils, Windows, WinTypes, WinProcs, Messages, Classes, Graphics,
  Controls, Forms, Dialogs, Tabs, ExtCtrls,
  StdCtrls, Menus, GLE2000W, GLE2000T, Printers, Spin;

type
  TEditForm = class(TForm)
    SourceMenu: TMainMenu;
    F1: TMenuItem;
    Edit1: TMenuItem;
    About1: TMenuItem;
    Help1: TMenuItem;
    New1: TMenuItem;
    Open1: TMenuItem;
    Save1: TMenuItem;
    Saveas1: TMenuItem;
    Close1: TMenuItem;
    Print1: TMenuItem;
    Exit1: TMenuItem;
    Cut1: TMenuItem;
    Copy1: TMenuItem;
    Paste1: TMenuItem;
    SourceControls: TPanel;
    Label1: TLabel;
    DrawBtn: TButton;
    HideBtn: TButton;
    GraphBtn: TButton;
    EditMemo: TMemo;
    ClearBtn: TButton;
    Delete1: TMenuItem;
    SaveDialog1: TSaveDialog;
    OpenDialog1: TOpenDialog;
    PrintDialog1: TPrintDialog;
    FontDialog1: TFontDialog;
    LinePanel: TPanel;
    Label2: TLabel;
    ColPanel: TPanel;
    LineValLabel: TLabel;
    ColValLabel: TLabel;
    About: TMemo;
    C1: TMenuItem;
    Help2: TMenuItem;
    ErrorMessages1: TMenuItem;
    Conversions1: TMenuItem;
    F2: TMenuItem;
    SetFont: TMenuItem;
    Name1: TMenuItem;
    Colour1: TMenuItem;
    Height1: TMenuItem;
    Line1: TMenuItem;
    Style1: TMenuItem;
    Colour2: TMenuItem;
    Width1: TMenuItem;
    Fill1: TMenuItem;
    N1: TMenuItem;
    ColorDialog1: TColorDialog;
    transparent1: TMenuItem;
    Solid1: TMenuItem;
    Dash1: TMenuItem;
    Dot1: TMenuItem;
    Dashdot1: TMenuItem;
    Dashdotdot1: TMenuItem;
    Insideframe1: TMenuItem;
    procedure Cut1Click(Sender: TObject);
    procedure Copy1Click(Sender: TObject);
    procedure Paste1Click(Sender: TObject);
    procedure DrawBtnClick(Sender: TObject);
    procedure HideBtnClick(Sender: TObject);
    procedure GraphBtnClick(Sender: TObject);
    procedure ClearBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure Saveas1Click(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure Delete1Click(Sender: TObject);
    procedure SetFontClick(Sender: TObject);
    procedure New1Click(Sender: TObject);
    procedure EditMemoEnter(Sender: TObject);
    procedure EditMemoChange(Sender: TObject);
    procedure EditMemoKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure EditMemoKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure EditMemoMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure EditMemoMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure EditMemoClick(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Close1Click(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure About1Click(Sender: TObject);
    procedure AboutClick(Sender: TObject);
    procedure AboutDblClick(Sender: TObject);
    procedure Help2Click(Sender: TObject);
    procedure C1Click(Sender: TObject);
    procedure ErrorMessages1Click(Sender: TObject);
    procedure Conversions1Click(Sender: TObject);
    procedure Print1Click(Sender: TObject);
    procedure Name1Click(Sender: TObject);
    procedure Colour1Click(Sender: TObject);
    procedure Height1Click(Sender: TObject);
    procedure Fill1Click(Sender: TObject);
    procedure transparent1Click(Sender: TObject);
    procedure Solid1Click(Sender: TObject);
    procedure Dash1Click(Sender: TObject);
    procedure Dot1Click(Sender: TObject);
    procedure Dashdot1Click(Sender: TObject);
    procedure Dashdotdot1Click(Sender: TObject);
    procedure Insideframe1Click(Sender: TObject);
    procedure Colour2Click(Sender: TObject);
    procedure Width1Click(Sender: TObject);
  private
    Function GetStrInsertIndex : Word;
    procedure GetCursorCoord;
    { Private declarations }
  public
    Function GetLineIndex : Word;
    { Public declarations }
  end;

var
  EditForm: TEditForm;
  LnColor,Lnstyle,LnWidth,     {These used for saving and restoring }
  BmStyle,                     {pen & brush settings.}
  Fcol1,FCol2,FColbk:integer;  {& Fill colours}
  SubStringNum,CurrentLineColor:Integer;
  FileName1:String;

Procedure DrawDiagram(FirstLine:Integer);
{Draws or redraws the current diagram}

procedure SetLineStyle(i:integer);

implementation

uses GLE2000G,GLE2000D, GLE2000F;

{$R *.DFM}

var xaxis,yaxis,zaxis:integer;

Function TEditForm.GetLineIndex : Word;
{ Extracts current memo line number}
begin
  Result:= SendMessage(EditMemo.handle,EM_LINEFROMCHAR,Editmemo.selstart,0);
end;

Function TEditForm.GetStrInsertIndex : word;
{Extracts Current Memo column number}
begin
GetStrInsertIndex :=
 EditMemo.Selstart-SendMessage(EditMemo.handle,EM_LINEINDEX,GetLineIndex,0)
end;

procedure TEditForm.GetCursorCoord;
{Displays current cursor position in the memo.}
var LineIndex: word;
    LineChar : byte;
    SelSt : word;
begin
SelSt:=EditMemo.selstart;
LineIndex:=GetLineIndex;
Linechar:=GetStrInsertIndex;
{If text is selected curson position is undefined
 so position is replaced by a message.}
if EditMemo.seltext>''
 then begin
   LineValLabel.Caption:=' Selectn';
   ColValLabel.Caption:=' ';
 end else begin
   LineValLabel.Caption:= ' ' + inttostr(Lineindex);
   ColValLabel.Caption:=  ' ' + inttostr(LineChar);
 end;
end;

procedure TEditForm.Cut1Click(Sender: TObject);
{Cuts selected text to the clipboard}
begin
   EditMemo.CutToClipBoard
end;

procedure TEditForm.Copy1Click(Sender: TObject);
{Copies selected text to the clipboard}
begin
  EditMemo.CopyToClipBoard;
end;

procedure TEditForm.Paste1Click(Sender: TObject);
{Inserts contents of the clipboard.}
begin
  EditMemo.PasteFromClipBoard;
end; {Paste1Click}

procedure AddLine(Istart,Iend:integer);
{Adds an analysis of current line to the end
 of the text file}
var ia1,ia2,ia3:integer;
    sa1,sa2,sa3:String;
begin
    for ia1:= Istart to Iend do
    begin
     Str(ia1:2,sa1);Str(StringType[ia1]:6,sa2);Str(StringValue[ia1]:10,sa3);
     EditForm.EditMemo.lines.add('!'+sa1+' '+StringText[ia1]+sa2+' '+sa3);
    end;
end; {AddLine}

procedure BeginBlock(Item:Integer);
{Carries out operations at the start of a block}
var i,i2:integer;
    p1:realpoint;
    bx,by:double;
begin
  with CurrentTransform do
  begin
   if StringType[Item] = 30 then begin
     i2:=Round(StringValue[Item]);  {Code for this type of begin}
     BeginNum:=succ(BeginNum);
     If BeginNum>MaxBegins then begin
         Disaster:=True;
         Messagedlg('K1: Begin Stack overflow.',mtError,[mbabort],0);
         exit;
     end;
     BeginStack[BeginNum]:=i2;
     case i2 of
     0:begin {Begin Origin}
        p1:=TransformPoint(CurrentTransform,Currentpoint);
        Xorigin:=p1.x;
        YOrigin:=p1.y;
        CurrentPoint.x:=0.0;
        Currentpoint.y:=0.0;
       end;
     1:begin {Rotation}
        If StringType[Item+1] in [3.. 6] then
        begin
          bx := StringValue[Item+1]/AngleMeasure;  {Changed 24/10/98}
          Rotation:= Rotation + bx;
          MatMult(cos(bx),-sin(bx),sin(bx),cos(bx),
                  TranC,TranE,TranD,TranF);
        end else begin
          Disaster:=True;
          Messagedlg('S1: Error in rotation setting.',mtError,[mbabort],0);
          exit;
        end;
       end; {Rotation}
     2:begin {ScaleFactor}
        If (StringType[Item+1] in [3..6]) and (StringType[Item+2] in [3..6])
            and (StringValue[Item+1]<>0) and (StringValue[Item+2]<>0)
        then begin
          bx:= StringValue[Item+1];
          Xscale:= Xscale*bx;
          by:= StringValue[Item+2];
          Yscale:= Yscale*by;
          MatMult(bx,0,0,by,TranC,TranE,TranD,TranF);
        end else begin
          Disaster:=True;
          Messagedlg('S2: Error in scale factor setting.',mtError,[mbabort],0);
          exit;
        end;
       end; {scaleFactor}
     3:begin {Translate}
         If (StringType[Item+1] in [3.. 6]) and (StringType[Item+2] in [3 .. 6])
         then begin
          p1.x := CurrentPoint.x+StringValue[Item+1];
          p1.y := CurrentPoint.y+StringValue[Item+2];
          p1 := TransformPoint(CurrentTransform,p1);
          Xorigin := p1.x;
          YOrigin := p1.y;
         end else begin
          Disaster:=True;
          Messagedlg('S3: Error in translation setting.',mtError,[mbabort],0);
          exit;
         end;
       end; {Translation}
     4:begin {graph}
         Setgraph:=true;     {Selects dictionary for basic commands}
         Setpolar:= False;
         DataDefined:= False;
         SetGraphic:=False;
         SetUpGraph;   {Sets initial defaults for a graph}
       end;
     5:begin {polar plot}
         Setpolar:= true;
         Setgraph:=False;
         DataDefined:= False;
         SetGraphic:=False;
         SetUpPolar;   {Sets initial defaults for a polar plot}
       end;
     6:begin {Smith chart}
            {Sets initial defaults for a Smith chart - not set up.}
         SetGraph:= False;
         SetPolar:= False;
       end;
     7:begin {Local variables}
        Locallevel:= Locallevel+26;
        LocalTextlevel:= LocalTextlevel+5;
        if LocalLevel>390 then
        begin
          Disaster:= True;
          Messagedlg('K2: Too many local levels nested',mtError,[mbAbort],0);
          exit;
        end
        else begin
             for i:= 1 to 26 do vw[i+Locallevel]:= 0;
             for i:= 21 to 25 do
             begin  {Because only part of text
                     array reset use a different algorithm.}
               vwt[i+LocalTextLevel]:=vwt[i];
               vwt[i]:= '';
             end;
        end;
       end; {Local variables}
       { Begin Box, Begin Clip, etc. to be inserted here }
    19 .. 26:begin {Set axis  - to be used for drawing scales in graphics
                    mode}
        SetAxisDefaults;
        SetAxis:=True;
       end;
    27,28:begin  {ArcAxis Used in polar plots }
         SetAngleAxis:= True;
       end;
     end; {case i2}
     if (i2 in [0 ..3]) and (not Disaster) then begin
      CurrentInvTransform:=InverseTransForm(CurrentTransform);
      CtransFormNum:=succ(CTransformNum);
      If CtransFormNum>MaxTransforms then begin
         Disaster:=True;
         Messagedlg('K3: Transform Stack overflow.',mtError,[mbabort],0);
         exit;
      end;
      CurrentPoint:=TransFormPoint(CurrentInvTransform,ToRealPoint(DrawStart));
      If CtransformNum<=25 then Ctrans[CtransformNum]:=CurrentTransform
      else begin
       Disaster:=true;
       Messagedlg('S4: Too many coordinate transforms ',mtError,[mbabort],0);
       exit;
      end;
     end; {if i2 in [0 .. 3]}
   end; {if StringType=30}
  end; { with CurrentTransform}
end; {BeginBlock}

procedure EndBlock(Item:integer);
 {Carries out operations at the end of a block}
var i,i2:integer;
begin
   i2:=Round(StringValue[Item]);      {Check against begin block type}
   if BeginStack[BeginNum]<>i2 then begin
     Disaster:=True;
     Messagedlg('S5: Begin and End of block do not match',mtError,[mbabort],0);
   end else if  BeginNum<=0 then begin
     Disaster:=True;
     Messagedlg('S6: UnderFlow in Begin/End stack',mtError,[mbabort],0);
   end else if (i2<4)and (CTransformNum<=0) then begin
     Disaster:=true;
     Messagedlg('S7: Underflow in coordinate transform stack ',
             mtError,[mbabort],0);
     exit;
   end else if StringType[Item] = 30 then begin
     case i2 of
     0 ..3:begin
             CTransformNum:=pred(CtransformNum);
             If CTransformNum>=0 then
             begin
              CurrentTransform:=Ctrans[CtransformNum];
              CurrentInvTransform:=InverseTransForm(CurrentTransform);
              CurrentPoint:=
              TransFormPoint(CurrentInvTransform,ToRealPoint(DrawStart));
              BeginNum:=Pred(BeginNum);
              If BeginNum<0 then begin
              Disaster:=true;
              Messagedlg('S8: Underflow in transform stack',
                  mtError,[mbabort],0);
              exit;
             end;
             end else begin
              Disaster:=true;
              Messagedlg('S9: Underflow in transform stack',
                  mtError,[mbabort],0);
              exit;
             end;
            end; {case 0 ..3}
         4,5,6:begin
             Messagedlg('S10: Illegal end graph/polarplot/smithchart statement',
                         mtError,[mbAbort],0);
             Disaster:=True;
           end;
         7:begin  {End of local variable block}
             Locallevel:= Locallevel-26;
             if Locallevel<0 then
             begin
              Disaster:= True;
              Messagedlg('K4: Underflow in local level stack',mtError,[mbAbort],0);
              exit;
             end;
             for i:= 21 to 25 do
             begin
              vwt[i]:= vwt[i+LocalTextlevel];
              vwt[i+LocalTextlevel]:= '';
             end;
             LocalTextlevel:= LocalTextlevel-5;
           end;
        19:begin
              DrawAxis(x1axis);
              SetAxis:=False;
           end;
        20:begin
              DrawAxis(x2axis);
              SetAxis:=False;
           end;
        21:begin
              DrawAxis(y1axis);
              SetAxis:=False;
           end;
        22:begin
              DrawAxis(y2axis);
              SetAxis:=False;
           end;
        23:begin
              DrawAxis(z1axis);
              SetAxis:=False;
           end;
        24:begin
              DrawAxis(z2axis);
              SetAxis:=False;
           end;
        25:begin
              DrawAxis(r1axis);
              SetAxis:=False;
           end;
        26:begin
              DrawAxis(r2axis);
              SetAxis:=False;
           end;
        27:begin
              DrawAxis(r3axis);
              SetAxis:=False;
           end;
        28:begin
              DrawAxis(r4axis);
              SetAxis:=False;
           end;
        29:begin
      {        DrawAngleAxis(a1axis); }
              SetAxis:=False;
           end;
        30:begin
     {         DrawAngleAxis(a2axis);   }
              SetAxis:=False;
           end;
     end; {case i2}
   end; {if BeginStack}
{  end; { with CurrentTransform}
end; {EndBlock}



procedure MakeSetting(Item:Integer);
{Carries out operations following a Setting Command. Item is
 the index of the first substring following the 'set' instruction.}
var i2,i3,inext:integer;
    BMset:Boolean;
begin
{start location}
inext:=item;
BMset:= False;
{ Fcol1:= black; Fcol2:= white; Fcolbk:= White; These now set in Draw Unit}
repeat  {put in for multiple items}
  if stringType[Item] = 29 then begin
     i2:=trunc(StringValue[inext]);
     inext:=succ(inext);
     case  i2 of
     4:begin {Font colour}
         if (StringType[inext] in [3 .. 6,24]) then
         begin
           CurrentFont.Color:= Round(StringValue[inext]);
           inext:=succ(inext);
         end else begin
            Disaster:=true;
            Messagedlg('S11: Illegal font colour parameter ',
              mtError,[mbabort],0);
            exit;
           end;
        end;  {Font colour}
     6:begin {Fill Style}
         if StringType[inext] in [3 .. 6] then
         begin
            i3 := Round(StringValue[inext]);
            BMStyle:= i3;
            with DisplayForm.Image1.Canvas do begin
             {  Brush.Bitmap.Free;  May clear background }
               Brush.Style:= SetBrushStyle(i3,BrushBitMap);
               If BrushBitMapset then BMSet:= True;
            {   if BrushBitMapSet then Brush.bitmap:= BrushBitMap;   }
            end;
            inext:=succ(inext);
         end else begin
          Messagedlg('S12: Illegal fill style parameter',mtError,[mbAbort],0);
          Disaster:=True;
         end; {if StringType}
         If Disaster then exit; {Covers Disasters in StringType
                                 or in SetBrushStyle}
       end;   {Fill Style}
     7:begin {Fill colour}
          If Stringtype[inext] in[3 ..6,24] then
          begin
            Fcol1:= Round(StringValue[inext]);
         {   if (not BrushBitmapSet) then    }
            DisplayForm.Image1.Canvas.Brush.Color:= FCol1;
            inext:=succ(inext);
          end else begin
            Disaster:=true;
            Messagedlg('S13: Illegal fill colour parameter ',
              mtError,[mbabort],0);
            exit;
           end;
        end;  {Fill Colour}
      8:begin  {Font name}
           If StringType[inext]=12 then
           begin
             CurrentFont.Name:= StringText[inext];
             inext:=succ(inext);
           end else begin
            Disaster:=true;
            Messagedlg('S14: Expecting a font name',
              mtError,[mbabort],0);
            exit;
           end;
        end;  {Font name}
     10:begin {Font height}
           if StringType[inext] in [3 .. 6] then
           begin
             CurrentFont.size:= round(StringValue[inext]*0.56*PixelsPerCm);
             inext:=succ(inext);                       {cm/pt conversion}
          end else begin
            Disaster:=true;
            Messagedlg('S15: Expecting a font height',
              mtError,[mbabort],0);
            exit;
           end;
        end;  {Font height}
     16:begin {Line width}
           If StringType[inext] in [3 .. 6] then
           begin
            Lnwidth:= Round(PixelsPerCm*StringValue[inext]);
            DisplayForm.Image1.Canvas.Pen.Width:= Lnwidth;
            inext:=succ(inext);
           end else begin
            Disaster:=true;
            Messagedlg('S16: Illegal line width parameter ',
              mtError,[mbabort],0);
            exit;
           end; {Line width}
        end;
     17:begin {linestyle}
           If StringType[inext] in [3 .. 6] then begin
            Lnstyle := Round(StringValue[inext]);
            DisplayForm.Image1.Canvas.Pen.style:= SetPenStyle(Lnstyle);
            inext:=succ(inext);
           end else begin
            Disaster:=true;
            Messagedlg('S17: Illegal line style parameter ',
              mtError,[mbabort],0);
           end; {if StringType}
           if Disaster then exit;
        end; {Line style}
     18:begin {Line colour}
          If Stringtype[inext] in [3 ..6,24] then
          begin
            LnColor:= Round(StringValue[inext]);
            DisplayForm.Image1.Canvas.Pen.Color:= Lncolor;
            inext:=succ(inext);
          end else begin
            Disaster:=true;
            Messagedlg('S18: Illegal line colour parameter ',
              mtError,[mbabort],0);
            exit;
           end;
        end; {Line colour}
     19:begin {Arrowstyle}
          if StringType[inext]=29 then begin
           case Round(StringValue[inext]) of
           23: {Roman style arrow}             ArrowStyle:=  3;
           24: {Roman style coloured arrow}    ArrowStyle:=  4;
           25: {Roman style white arrow}       ArrowStyle:=  5;
           26: {Greek style arrow }            ArrowStyle:=  6;
           27: {Greek style coloured arrow}    ArrowStyle:=  7;
           28: {Greek style white arrow}       ArrowStyle:=  8;
           29: {Norman style arrow - default}  ArrowStyle:=  0;
           30: {Norman style coloured arrow}   ArrowStyle:=  1;
           31: {Norman style white arrow}      ArrowStyle:=  2;
           32: {Saxon style arrow }            ArrowStyle:=  9;
           33: {Saxon style coloured arrow}    ArrowStyle:= 10;
           34: {Saxon style white    arrow}    ArrowStyle:= 11;
           end; {Case}
          end else
            Messagedlg('S19: Error in setting arrow style - set as Norman',
                        mtWarning,[mbOK],0); {end if 29}
          inext:= succ(inext);
        end; {arrowstyle}
     20:begin {Arrow line colour}
          if StringType[inext] in [3 ..6,24]
            then ArrowLineColor:= Round(StringValue[inext])
            else  begin
             Messagedlg('S20: Error in setting Arrow line colour - set to black',
                        mtWarning,[mbOK],0);
             ArrowLineColor:= black;
            end;
          inext:= succ(inext);
        end;  {Arrow line colour}
     21:begin {Arrow fill colour}
          if StringType[inext] in [3 ..6,24]
            then Arrowfillcolor:= Round(StringValue[inext])
            else  begin
             Messagedlg('S21: Error in setting Arrow fill colour - set to black',
                        mtWarning,[mbOK],0);
             Arrowfillcolor:= black;
            end;
          inext:= succ(inext);
        end; {Arrow fill colour}
     22:begin {arrow size}
          if StringType[inext] in [3 ..6]
            then ArrowSize:= StringValue[inext]*0.02*PixelsPerCm
            else  begin
             Messagedlg('S22: Error in setting Arrow size - set to 0.25',
                        mtWarning,[mbOK],0);
             ArrowSize:= 0.005*PixelsPerCm;
            end;
          inext:= succ(inext);
        end;
     35:begin {2nd Fill colour}
          If Stringtype[inext] in[3 ..6,24] then
          begin
            Fcol2:= Round(StringValue[inext]);
            inext:=succ(inext);
          end else begin
            Disaster:=true;
            Messagedlg('S23: Illegal 2nd fill colour ',
              mtError,[mbabort],0);
            exit;
           end;
        end; {2nd Fill colour}
     36:begin {Background Fill colour}
          If Stringtype[inext] in[3 ..6,24] then
          begin
            Fcolbk:= Round(StringValue[inext]);
            inext:=succ(inext);
          end else begin
            Disaster:=true;
            Messagedlg('S24: Illegal background fill colour ',
              mtError,[mbabort],0);
            exit;
           end;
        end; {Background Fill colour}
     37:begin {Set all colour parameters}
          If Stringtype[inext] in[3 ..6,24] then
          begin
            i3:= Round(StringValue[inext]);
            CurrentFont.Color:= i3;
            if (not BrushBitmapSet) then
               DisplayForm.Image1.Canvas.Brush.Color:= i3;
            DisplayForm.Image1.Canvas.Pen.Color:= i3;
            ArrowLinecolor:= i3;
            Arrowfillcolor:= i3;
            Fcol1:= i3;
            Fcol2:= i3;
            Fcolbk:= i3;
            inext:=succ(inext);
          end else begin
            Disaster:=true;
            Messagedlg('S25: Illegal arrow colour ',
              mtError,[mbabort],0);
            exit;
           end;
        end;
     end; {case i2}
   end; {if StringType[Item] = 29}
  until inext>=SubStringNum;
  If BMSet then
  begin
    SetBrushBitMap(BMStyle,256,BrushBitMap,Mask1,Mask2,Fcol1,Fcol2,Fcolbk);
    DisplayForm.Image1.Canvas.Brush.Bitmap:= BrushBitMap;
  end;
{Insert Test output here.}
end; {MakeSetting}

procedure SetDataPlot(AtString:integer;PlotNum:integer);
{ Enters data into plotdata[plotnum].
  PlotNum is the number of the plot column. }

var i,ii,j,k:integer;
    MarkSet,LineSet:Boolean;  {Local flags et for each line}

begin
 with plotdata[PlotNum] do
 begin
  if not PlotIsOn[PlotNum] then
  begin  {First mention of this plot - reset for new data}
   PlotIsOn[PlotNum]:= True;
   SetPlotDefaults(PlotNum);
  end;
  i:= AtString;
  MarkSet:= False;  LineSet:= False;
  repeat
   if (StringType[i]=43) and (Round(StringValue[i]) in [0 .. 42]) then
   begin
    case Round(StringValue[i]) of
     1:begin  {Line}
        LineOn:=True; LineSet:= True;
        i:=succ(i);
       end;
     2:begin {marker}
         MarkerOn:=True;  MarkSet:= True;
         i:=succ(i);
         {Test this next position for the marker style }
       end;
     3:begin {error bar}
        Erron:=True;
        i:=succ(i);
       end;
     4:begin {Vertical error width}
        if (StringType[i+1] in [3 .. 6]) and (StringValue[i+1]>0) then
        begin
         errwidth:=StringValue[1+1];
         i:=i+2;
        end else begin
          Messagedlg('S26: Error in setting vertical error bar',mtError,[mbAbort],0);
          Disaster:=True;
          exit;
        end; {if}
       end;
     5:begin {error-up}
        if (StringType[i+1] in [3 .. 6]) then
        begin
         errup:=Abs(StringValue[1+1]);    {Forces +ve value}
         i:= i+2;
        end else begin
          Messagedlg('S27: Error in setting error-up ',mtError,[mbAbort],0);
          Disaster:=true;
          exit;
        end; {if}
       end;
     6:begin {error-down}
        if (StringType[i+1] in [3 .. 6]) then
        begin
         errdown:= -Abs(StringValue[1+1]);   {Forces -ve value}
         i:= i+2;
        end else begin
          Messagedlg('S28: Error in setting error-down ',mtError,[mbAbort],0);
          Disaster:=true;
          exit;
        end; {if}
       end;
     9:begin {horizontal error width}
        if (StringType[i+1] in [3 .. 6]) and (StringValue[i+1]>0) then
        begin
         herrwidth:=StringValue[1+1];
         i:= i+2;
        end else begin
          Messagedlg('S29:Error in setting horizontal error bar ',
                         mtError,[mbAbort],0);
          Disaster:=true;
          exit;
        end; {if}
       end;
    10:begin {Error left}
        if (StringType[i+1] in [3 .. 6]) then
        begin
         herrleft:= Abs(StringValue[1+1]); {forces +ve value}
         i:= i+2;
        end else begin
          Messagedlg('S30: Error in setting error-left ',mtError,[mbAbort],0);
          Disaster:=true;
          exit;
        end; {if}
       end;
    11:begin {error right}
        if (StringType[i+1] in [3 .. 6]) then
        begin
         herrright:= -Abs(StringValue[1+1]);
         i:= i+2;
        end else begin
          Messagedlg('S31:Error in setting error-right ',mtError,[mbAbort],0);
          Disaster:=true;
          exit;
        end; {if}
       end;
    13:begin {linestyle}
        if (StringType[i+1] in [3 .. 6]) and LineSet then
        begin
         pstyle:= Round(StringValue[i+1]);
         i:= i+2;
        end else begin
          Messagedlg('S32: Error in setting data line style',mtError,[mbAbort],0);
          Disaster:=true;
          exit;
        end; {if}
       end;
    14:begin {Line width}
        if (StringType[i+1] in [3 .. 6]) and LineSet then
        begin
         pwidth:= StringValue[i+1];
         i:= i+2;
        end else begin
          Messagedlg('S33: Error in setting data line width',mtError,[mbAbort],0);
          Disaster:=true;
          exit;
        end; {Line width}
       end;
    15:begin {Line colour}
        if (StringType[i+1] in [3 .. 6,24]) and ( MarkSet or LineSet) then
        begin
         if LineSet then pcolor:= Round(StringValue[i+1]){Overrides Marker Color}
         else if MarkSet then mlcolor:= Round(StringValue[i+1]);
         i:= i+2;
        end else begin
          Messagedlg('S334: Error in setting data line color',mtError,[mbAbort],0);
          Disaster:=true;
          exit;
        end; {Line colour}
       end;
    16:begin {marker border}
        If (StringType[i+1]=43) and (Round(StringValue[i+1])=31)
        and MarkSet  then
        begin
           mborder:=1;
           i:= i+2;
        end else if (StringType[i+1]=43) and (Round(StringValue[i+1])=32)
        and MarkSet then
        begin
           mborder:= 0;
           i:= i+2;
         end else begin
           Messagedlg('S35: Error in setting marker border.',mtError,
                       [mbAbort],0);
           Disaster:=True;
           exit;
         end; {if}
       end;
    17:begin {marker size}
        if (StringType[i+1] in [3 .. 6]) and MarkSet then
        begin
         msize:= Round(0.5*PixelsPerCm*StringValue[i+1])+1;
         i:= i+2;
        end else begin
          Messagedlg('S36: Error in setting marker size',mtError,[mbAbort],0);
          Disaster:=true;
          exit;
        end; {if}
       end;
    18:begin {marker line colour  - Not in use }
        if (StringType[i+1] in [3 .. 6,24]) then
        begin
         mlcolor:= Round(StringValue[i+1]);
         i:= i+2;
        end else begin
          Messagedlg('S37: Error in setting marker line colour',
            mtError,[mbAbort],0);
          Disaster:=true;
          exit;
        end; {if}
       end;
    19:begin {marker fill colour}
        if (StringType[i+1] in [3 .. 6,24]) and MarkSet then
        begin
         mfcolor:= Round(StringValue[i+1]);
         i:= i+2;
        end else begin
          Messagedlg('S38: Error in setting marker fill colour',
              mtError,[mbAbort],0);
          Disaster:=true;
          exit;
        end; {if}
       end;
    21:begin
         Smooth:=True;
         if (StringType[i+1] in [3 .. 6]) then
         begin
           SmoothValue:= Round(StringValue[i+1]);
           i:= i+2;
         end else begin
          Messagedlg('S39: Error in setting Smoothing factor',mtError,[mbAbort],0);
          Disaster:=true;
          exit;
        end; {if}
       end;
    27:begin   {these set the axis to use following a 'use' command.}
         xaxis:= 1;
         i:= succ(i);
       end;
    28:begin
         xaxis:= 2;
         i:= succ(i);
       end;
    29:begin
         yaxis:= 1;
         i:= succ(i);
       end;
    30:begin
         yaxis:= 2;
         i:= succ(i);
       end;
    31:begin
         zaxis:= 1;
         i:=succ(i)
       end;
    32:begin
         zaxis:=2;
         i:=succ(i);
       end;
    33:begin
         yaxis:=3;
         i:=succ(i);
       end;
    34:begin
         yaxis:=4;
         i:=succ(i);
       end;
    35:begin
         yaxis:=5;
         i:=succ(i);
       end;
    36:begin
         yaxis:=6;
         i:=succ(i);
       end;
    37:begin
         xaxis:=3;
         i:=succ(i);
       end;
    38:begin
         xaxis:=4;
         i:=succ(i);
       end;
    39:begin {use - check that this is followed by an axis name.}
        if not ((StringType[i+1]=43) and (Round(StringValue[i+1]) in[27 .. 38]))
        then begin
          Messagedlg('S40: Error in use assignment',mtError,[mbAbort],0);
          Disaster:=True;
          Exit;
        end;
        i:=succ(i);
       end;
    40:begin
         if (StringType[i+1] in [3 .. 6]) then
         begin
           xcol:= Round(StringValue[i+1]);
           i:= i+2;
         end else begin
          Messagedlg('S41: Error in resetting x data column',
                      mtError,[mbAbort],0);
          Disaster:=true;
          exit;
         end; {if}
       end;
     41:begin {on}
        end;
     42:begin {off}
        end;
    end; {case}
   end else if (StringType[i]=28) and MarkSet then
   begin
     mstyle:= StringText[i];
     msnumber:= Round(StringValue[i]);
     i:=succ(i);
   end else  begin
     Messagedlg('S42: Invalid data parameter',mtError,[mbAbort],0);
     Disaster:=True;
     exit
   end; {if }
  until i>=SubStringNum;
 end; {with plotdata}
end; {SetDataPlot}

procedure SetUpAxis(Var AxisName:taxis;AxisNumber,Item:integer);
{Sets up a graph axis. AxisType is code for Axis. Item is current
 position in string array}
var i,ii,iclass,ijump,ijump2,inext,k,Defaultcolor:integer;
    x,y:double;
   { AxisName:tAxis;  }
begin
  DefaultColor:= Black;
  ijump:=Round(StringValue[item]);
  if ijump in [29 .. 35,37,45 ..48,53] then
  begin    {First entry is an axis subtype - e.g. ticks, midlabels  }
     iclass:= ijump;
     i:=succ(item);
  end else begin  {First entry is a direct axis command}
     iclass:= 0;
     i:=item;     { i is current position of StringIndex.}
  end;
  with AxisName do
   begin
    repeat   {For axis parameters continue to end of line}
     ijump:= Round(StringValue[i]); {Primary axis Command Number }
     inext:= succ(i);
     If  (ijump in [0,8 .. 27,60 .. 64]) and (iclass = 0) then {a primary axis command }
     begin
      if (StringType[inext] in [3 .. 6,24]) then
      begin       {Primary axis command with one numeric parmeter}
       case ijump of
       { Enter check on StringType[inext]}
         0:begin  {Set default colour for all axis components.}
             DefaultColor:=Round(StringValue[inext]);
             AxisColor:= DefaultColor;
             TickColor:=DefaultColor;
             SubTickColor:=DefaultColor;
             MidTickColor:=DefaultColor;
             GridColor:=DefaultColor;
             SubGridColor:=DefaultColor;
             MidGridColor:=DefaultColor;
             TitleColor:=DefaultColor;
             MidLabelColor:=DefaultColor;
             LabelColor:=DefaultColor;
           end;
         8:dTicks      := StringValue[inext];        {dticks}
         9:dSubTicks   := StringValue[inext];        {dsubticks}
        10:dMidTicks   := StringValue[inext];        {dmidticks}
        11:dGrid       := StringValue[inext];        {dgrid}
        12:dSubGrid    := StringValue[inext];        {dsubgrid}
        13:dMidGrid    := StringValue[inext];        {dmidgrid}
        14:TickStart   := StringValue[inext];        {tickstart}
        15:SubTickStart:= StringValue[inext];        {subtickstart}
        16:MidTickStart:= StringValue[inext];        {midtickstart}
        17:GridStart   := StringValue[inext];        {gridstart}
        18:SubGridStart:= StringValue[inext];        {subgridstart}
        19:MidGridStart:= StringValue[inext];        {midgridstart}
        20:nTicks      := Round(StringValue[inext]); {nticks}
        21:nMidTicks   :=Round(StringValue[inext]);  {nMidTicks}
        22:nSubTicks   := Round(StringValue[inext]); {nsubticks}
        23:nGrids      := Round(StringValue[inext]); {ngrids}
        24:nMidGrids   :=Round(StringValue[inext]);  {nMidGrids}
        25:nSubGrids   := Round(StringValue[inext]); {nsubgrids}
        26:ScaleHi     := StringValue[inext];        {max}
        27:ScaleLo     := StringValue[inext];        {min}
        60:begin  {StartAtAngle}
             If SetPolar then begin
               if (AxisNumber in [1..4])then begin
                  StartAt := StringValue[inext];
                  AxisStartAngle:= StartAt;
               end else if (AxisNumber in [5,6]) then xstart:= StringValue[Inext]
               else begin
                Disaster:=true;
                Messagedlg('A1: Error in axis type', mtError,[mbabort],0);
                exit;
               end;
             end;
           end;
        61:begin  {StepangleBy}
             If SetPolar then begin
               if (AxisNumber in [1..4])then StepBy := StringValue[inext]
               else begin
                Disaster:=true;
                Messagedlg('A2: Error in axis type', mtError,[mbabort],0);
                exit;
               end;
             end;
           end;
        62:begin  {EndAtAngle}
             If SetPolar then begin
               if (AxisNumber in [1..4])then begin
                EndAt := StringValue[inext];
                AxisEndAngle:= EndAt;
               end else if (AxisNumber in [5,6]) then XEnd:= StringValue[Inext]
               else begin
                Disaster:=true;
                Messagedlg('A3: Error in axis type', mtError,[mbabort],0);
                exit;
               end;
             end;
           end;
        63:if Setpolar and (AxisNumber in [1 .. 6])   {InnerRadius}
               then InnerRadius:= StringValue[inext];
        64:if Setpolar and (AxisNumber in [1 .. 6])   {OuterRadius}
               then OuterRadius:= StringValue[inext];
        else begin   {something wrong - an invalid parameter}
             Disaster:=true;
          Messagedlg('A4: Unknown axis parameter', mtError,[mbabort],0);
          exit;
        end;
       end; {case}
      end else begin
          Disaster:=true;
          Messagedlg('A5: Expecting a number after axis parameter',
                  mtError,[mbabort],0);
          exit;
      end; {if StringType[inext]}
      i:= i+2;   {Step to next command/parameter pair}
     end else if (ijump in [0,1,3 ..7,28,36,51,52]) and (iclass>0)
           and (StringType[i] = 42)
     then  begin   {an axis parameter/value pair for an axis subtype}
                   {check it and begin if all O.K.}
        case ijump of     {First deal with command/parameter pairs}
          0:begin  {colour}
             if  (inext<=SubStringNum) and (StringType[inext] in [3 .. 6,24])
             then begin
              ii:= Round(StringValue[inext]);
              case iclass of
               29:AxisColor:= ii;
               30:TickColor:= ii;
               31:MidTickcolor:= ii;
               32:SubTickColor:= ii;
               33:GridColor:= ii;
               34:MidGridColor:= ii;
               35:SubGridColor:= ii;
               37:TitleColor:= ii;
               45:LabelColor:= ii;
               46:midLabelColor:= ii;
               47:NameColor:= ii;
               else begin
                 Disaster:=true;
                 Messagedlg('A6: Illegal colour setting ',mtError,[mbabort],0);
                 exit;
               end;
              end; {case iclass}
             end else begin
               Disaster:=true;
               Messagedlg('A7: Illegal colour parameter '+
               '- expecting an integer or colour variable',mtError,[mbabort],0);
               exit;
             end;
            end; {colours}
          1:begin {Font name}
             if (StringType[inext]=12) and (inext<=SubStringNum)
             then begin    {a string in quotes}
              try
              case iclass of
               37:TitleFontName:= StringText[inext];
               45:LabelFontName:= StringText[inext];
               46:MidLabelFontName:= StringText[inext];
               47:NameFontName:= StringText[inext];
               else begin
                 Disaster:=true;
                 Messagedlg('A8: Illegal font name setting ',
                   mtError,[mbabort],0);
                 exit;
               end;
              end; {case iclass}
              except
                if Messagedlg('A9: Font name assignment failed.',
                    mtWarning,[mbOK,mbAbort],0)= mrAbort then Disaster:=True;
              end; {exception block}
             end else
                if Messagedlg('A10: Expecting a font name' +
                 '- continue using current font?',
                    mtWarning,[mbOK,mbAbort],0)= mrAbort then Disaster:=True;
             {end of if StringType}
            end; {font}
          3:begin {hei}
               if (StringType[inext] in  [3 .. 6]) and (inext<=SubStringNum)
               then try
                 ii:= round(StringValue[inext]*0.56*PixelsPerCm);
                 case iclass of                  {cm/pt conversion}
                  37:TitleHei:= ii;
                  45:LabelHei:= ii;
                  46:MidLabelHei:= ii;
                  47:NameHei:= ii;
                  else begin
                    Disaster:=true;
                    Messagedlg('A11: Illegal font height setting ',mtError,
                    [mbabort],0);
                    exit;
                  end;
                 end; {case iclass}
                 except
                   if Messagedlg('A12: Font height assignment failed.',
                      mtWarning,[mbOK,mbAbort],0)= mrAbort then Disaster:=True;
               end else begin
                    Disaster:=true;
                    Messagedlg('A13: Expecting a font height ',mtError,
                    [mbabort],0);
                    exit;
               end; {if StringType}
            end; {Set hei}
          4:begin  {length}
             if (StringType[inext] in  [3 .. 6]) and (inext<=SubStringNum)
             then begin
              x:= StringValue[inext];
              case iclass of        {Allocate each result to relevant subtype}
               30:TickLength:= x;
               31:MidTickLength:= x;
               32:SubTickLength:= x;
               33:GridLength:= x;
               34:if Setpolar and (AxisNumber in [5,6])
                   then MidGridLength:= x
                   else Gridlength:= x;
               35:if Setpolar and (AxisNumber in [5,6])
                   then SubGridLength:= x
                   else GridLength:= x;
               else begin
                 Disaster:=true;
                 Messagedlg('A14:Illegal length setting ',mtError,[mbabort],0);
                 exit;
               end;
              end; {case iclass}
             end else begin
                    Disaster:=true;
                    Messagedlg('A15: Expecting a length ',mtError,
                    [mbabort],0);
                    exit;
               end; {if StringType}
            end; {length}
          5:begin  {linewidth}
             if (StringType[inext] in  [3 .. 6]) and (inext<=SubStringNum)
             then begin
              x:= StringValue[inext];
              case iclass of
               29:AxisLineWidth:= x;
               30:TickLinewidth:= x;
               31:MidTickLineWidth:= x;
               32:SubTickLineWidth:= x;
               33:GridLineWidth:= x;
               34:MidGridLineWidth:= x;
               35:SubGridLineWidth:= x;
               else begin
                 Disaster:=true;
                 Messagedlg('A16: Illegal line width setting ',
                   mtError,[mbabort],0);
                 exit;
               end;
              end; {case iclass}
             end else begin
                    Disaster:=true;
                    Messagedlg('A17: Expecting a line width ',mtError,
                    [mbabort],0);
                    exit;
             end; {if StringType}
            end;  {linewidth}
          6:begin  {linecolour  this partially duplicates colour setting}
             if  (inext<=SubStringNum) and (StringType[inext] in [3 .. 6,24])
             then begin
              ii:= Round(StringValue[inext]);
              case iclass of     {Only covers line objects}
               29:AxisColor:= ii;
               30:TickColor:= ii;
               31:MidTickColor:= ii;
               32:SubTickColor:= ii;
               33:GridColor:= ii;
               34:MidGridColor:= ii;
               35:SubGridColor:= ii;
               else begin
                 Disaster:=true;
                 Messagedlg('A18: Illegal line colour setting ',
                  mtError,[mbabort],0);
                 exit;
               end;
              end; {case}
             end else begin
                 Disaster:=true;
                 Messagedlg('A19: Expecting a colour ',mtError,
                 [mbabort],0);
                 exit;
             end; {if StringType}
            end; {lcolour}
          7:begin  {linestyle}
             try
              CurrentpenStyle:=SetpenStyle(Round(StringValue[inext]));
              case iclass of
               29:AxisLineStyle:=CurrentPenStyle;
               30:TickStyle:=CurrentPenStyle;
               31:MidTickStyle:=CurrentPenStyle;
               32:SubTickStyle:=CurrentPenStyle;
               33:GridStyle:=CurrentPenStyle;
               34:MidGridStyle:=CurrentPenStyle;
               35:SubGridStyle:=CurrentPenStyle;
               else begin
                 Disaster:=true;
                 Messagedlg('A20: Illegal line style setting ',
                 mtError,[mbabort],0);
                 exit;
               end;
              end; {case}
             except
               if Messagedlg('A21: Error in setting line style '+
                 ' continue using current style?',mtError,
                 [mbabort,mbOK],0)= mrAbort then
                 begin
                   Disaster:=True;
                   Exit;
                 end;
             end; {of except block}
            end; {linestyle}
         28:begin {dist}
             if  (inext<=SubStringNum) and (StringType[inext] in [3 .. 6])
             then begin
               x:=StringValue[inext];
               case iclass of
                37:TitleDist:= x;
                45:LabelDist:= x;
                46:MidLabelDist:= x;
                47:Namedist:= x;
               else begin
                 Disaster:=true;
                 Messagedlg('A22: Illegal distance setting ',mtError,[mbabort],0);
               end;
              end; {case}
             end else begin
               Disaster:=true;
               Messagedlg('A23: Expecting a distance ',mtError,
               [mbabort],0);
               exit;
             end; {if StringType}
            end; {dist}
         36:begin {angle}
             if  (inext<=SubStringNum) and (StringType[inext] in [3 .. 6])
             then begin
               x:= StringValue[inext]/AngleMeasure;
               case iclass of
                30:TickAngle:= x;      {MidTicks etc. take same angle }
                33:GridAngle:= x;      {as ticks.}
                37:TitleAngle:= x;
                45:LabelAngle:= x;
                47:NameAngle:= x;
               else begin
                if Messagedlg
                ('A24: Illegal angle setting - angle left unchanged',
                 mtError,[mbOK,mbAbort],0) = mrAbort then
                 begin
                  Disaster:=True;
                 end;
                end; {if Messagedlg}
               end; {case iclas}
             end else begin
               Disaster:=true;
               Messagedlg('A25: Expecting an angle ',mtError,
               [mbabort],0);
               exit;
             end; {if StringType}
            end; {angle}
      51,52:begin {Shift/Offset}
             if  (inext<=SubStringNum) and (StringType[inext] in [3 .. 6])
             then begin
               x:=StringValue[inext];
               case iclass of
                37:TitleShift:= x;
                45:LabelShift:= x;
                46:MidLabelShift:= x;
                47:NameShift:= x;
               else begin
                 Disaster:=true;
                 Messagedlg('A26: Illegal shift or offset setting ',
                 mtError,[mbabort],0);
               end;
              end; {case}
             end else begin
               Disaster:=true;
               Messagedlg('A27: Expecting an offset or shift ',mtError,
               [mbabort],0);
               exit;
             end; {if StringType}
            end; {shift}
        end;{case ijump}
        i:= i+2;
   { **** Insert Label formatting here ****** }
     end else if (ijump=55) and (iclass in [45,46]) then
     begin  {Float Setting}
       if (StringType[inext] in [ 3 .. 6]) then
       begin
         if (iclass=45) then begin
           LabelSfigs:= Round(StringValue[inext]);
           LabelDFigs:= -1;
         end else begin
           MidLabelSfigs:= Round(StringValue[inext]);
           MidLabelDFigs:= -1;
         end;
         i:= i+2;
       end else begin
         Messagedlg('A28: Error in setting Float parameter',mtError,
                    [mbAbort],0);
         Disaster:= True;
         Exit;
       end;
     end else if (ijump=56) and (iclass in [45,46]) then
     begin  {Fix Setting}
       if  (SubStringNum >= succ(inext)) and (StringType[inext] in [ 3 .. 6])
           and (StringType[inext+1] in [3 .. 6]) then
       begin
         if (iclass=45) then begin
           LabelSfigs:= Round(StringValue[inext]);
           LabelDFigs:= Round(StringValue[inext+1]);
         end else begin
           MidLabelSfigs:= Round(StringValue[inext]);
           MidLabelDFigs:= Round(StringValue[inext+1]);
         end;
         i:= i+3;
       end else begin
         Messagedlg('A29: Error in setting Fix parameters',mtError,
                    [mbAbort],0);
         Disaster:= True;
         Exit;
       end;
     end else if (ijump in [38,39,41,42,43,44,54,57,58]) and (inext<=(SubStringNum+1))
     then begin {a command with no parameter}
        case ijump of
         38:AxisType:=2;  {Log Axis}
         39:AxisType:=1;  {Linear Axis}
         40:Negate:=True;  {Reverse Axis}
         41:NoFirst:=True;  {Do not show first axis label}
         42:NoLast:=True;  {Do not show last axis label}
         43:begin  {on}
             case iclass of
                0:AxisOff:= False;
               29:SideOn:=True;
               30:TicksOn:=True;
               31:MidTicksOn:=True;
               32:SubTicksOn:=True;
               33:GridOn:= True;
               34:MidGridOn:= True;
               35:SubGridOn:= True;
               45:begin
                   LabelsOn:= True;
                   For k:= 0 to 50 do ShowPlace[k]:= True;
                  end;
               46:begin
                   MidLabelsOn:= True;
                   For k:= 0 to 50 do ShowMidPlace[k]:= True;
                  end;
               47:begin
                   NamesOn:= True;
                   For k:= 0 to 50 do ShowName[k]:= True;
                  end;
             else {Only warn - do nothing}
               Messagedlg('A30: Error in turning parameter on',mtWarning,[mbOK],0);
             end; {case}
            end;
         44:begin  {off}
             case iclass of
                0:AxisOff:=True;
               29:SideOn:=False;
               30:TicksOn:=False;
               31:MidTicksOn:=False;
               32:SubTicksOn:=False;
               33:GridOn:= False;
               34:MidGridOn:= False;
               35:SubGridOn:= False;
               45:begin
                   LabelsOn:= False;
                   for k:= 0 to 50 do ShowPlace[k]:=False;
                  end;
               46:begin
                   MidLabelsOn:= False;
                   For k:= 0 to 50 do ShowMidPlace[k]:= False;
                  end;
               47:begin
                   NamesOn:= False;
                   For k:= 0 to 50 do ShowName[k]:= False;
                  end;
             else {Only warn - do nothing}
               Messagedlg('A31: Error in turning parameter off',mtWarning,[mbOK],0);
             end; {Case iclass}
            end;{off}
         54:AxisType:=1;{Currently set to Linear Axis - will become Probability}
         57:begin  {symmetric}
             case iclass of
                0:begin
                   SymmetricTicks:= True;
                   SymmetricMidTicks:= True;
                   SymmetricSubTicks:= True;
                  end;
               30:SymmetricTicks:= True;
               31:SymmetricMidTicks:= True;
               32:SymmetricSubTicks:= True;
             else {Only warn - do nothing}
               Messagedlg('A32: Error in setting symmetric ticks',mtWarning,[mbOK],0);
             end; {Case iclass}
            end;{symmetric}
         58:begin  {normal}
             case iclass of
                0:begin
                   SymmetricTicks:= False;
                   SymmetricMidTicks:= False;
                   SymmetricSubTicks:= False;
                  end;
               30:SymmetricTicks:= False;
               31:SymmetricMidTicks:= False;
               32:SymmetricSubTicks:= False;
             else {Only warn - do nothing}
               Messagedlg('A33: Error in setting normal ticks',mtWarning,[mbOK],0);
             end; {Case iclass}
            end;{normal}
         59:PolarAxis:= True;   {Check if this is needed!}
       end;  {case ijump}
       i:=i+1; {Step over the command}
        {Enter error control here}
     end else if StringType[i]=12 then  {Entry is a quoted string}
     begin
       case iclass of
         37:begin {A title String}
              Title:=StringText[i];
            end;
         47:begin  {A name}
             ANames[NumOfNames]:= StringText[i];
             NumOfNames:= succ(NumOfNames);
             If NumofNames>MaxNames then begin
               Disaster:=True;
               Messagedlg('K5: Name Stack overflow.',mtError,[mbabort],0);
               exit;
             end;
            end;
         else begin
            Disaster:=true;
            Messagedlg('A34 Graph Title or Axis Name expected.',
                 mtError,[mbabort],0);
              end;
       end; {case}
       i:= i+1;
     end else if (StringType[i] in [3 ..6]) and (iclass in [47,48,53])
          and (i<SubStringNum) then
     begin  {A name or place number}
         ii:= Round(StringValue[i]);
         if (ii>=0) and (ii<=50) then
         begin
          case iclass of
           47: {Axis Names}
              if ShowName[ii]=True then ShowName[ii]:=False
               else ShowName[ii]:=True;
           48: {Axis Places}
              if ShowPlace[ii]=True then ShowPlace[ii]:=False
               else ShowPlace[ii]:=True;
           53: {Axis mid-places}
              if ShowMidPlace[ii]=True then ShowMidPlace[ii]:=False
               else ShowMidPlace[ii]:=True;
           else begin
                 Messagedlg('A35: Illegal place setting',mtWarning,[mbOk],0);
                end;
           end; {case iclass}
         end else
          Messagedlg('A36: Error in turning name or label on/off' +
            ' - Setting not changed',mtWarning,[mbOK],0);
         { end of if }
         i:= i+1;
     end else begin
         Disaster:=true;
         Messagedlg('A37: Unidentified error in axis settings',
                 mtError,[mbabort],0);
         exit;
     end;  {End of outer loop}
     inext:=succ(i);
    until inext>SubStringNum; {end of sub-type}
   end; {with AxisName}
 {Axis setup instructions}
end;


procedure SetUpAngleAxis(Var AxisName:tAxis;Item:integer);
{Sets up a curved axis. AxisType is code for Axis. Item is current
 position in string array}
begin
{Sets up a curved graph axis for angular measurement.
 AxisType is code for Axis.
 Item is current position in string array}
end;

procedure DoStart(var icheck:integer;NumOfSubStrings:integer);

var AtString,i,i1,i2,i3,i4:Integer;  {Temp settings - check}

begin
   Disaster:= False;   {Reset flags}
   SetGraphic:= True;
   SetGraph:= False;
   SetPolar:= False;
   AtString:=1;
   i1:= StringType[Atstring]; {A Graphic at start of line}
   if i1=20 then
   begin
         i2:=trunc(StringValue[AtString]);
         case i2 of
            14: begin {PixelsPerCm}
                  icheck:= icheck+1;
                  if (StringType[AtString+1] in [3 ..6])
                  then  PixelsPerCm:= StringValue[Atstring+1]
                  else Disaster:= True;
                end;
            16:begin  {Window Origin}
                  icheck:= icheck+2;
                  if (NumOfsubStrings>= (AtString+2))
                   and (StringType[AtString+1] in [3 ..6])
                   and (StringType[AtString+2] in [3 ..6])
                  then begin
                    XWinOrigin:= StringValue[Atstring+1];
                    YWinOrigin:= StringValue[AtString+2];
                  end else Disaster:= True;
               end;
            47:begin {Window Size}
                  icheck:= icheck+4;
                  if (NumOfsubStrings>= (AtString+2))
                   and (StringType[AtString+1] in [3 ..6])
                   and (StringType[AtString+2] in [3 ..6])
                  then begin
                    WindowWidth:= StringValue[Atstring+1];
                    WindowHeight:= StringValue[AtString+2];
                  end else Disaster:= True;
               end;
             else Disaster:=True;
          end; {case}
   end else Disaster:=True;  {End if i1}
end; {DoStart}

procedure DoLine(var Eposn,Etype,NextLine:integer;NumOfSubStrings:integer;
                  Skip:Boolean);

var AtString,i,i1,i2,it2,i3,it3,i4,i5:Integer;
    stp1,var1,var2:double;
    Vartext,subtxt,out1,out2:string;

begin
 { If StringType[1]=11 then AtString:=2 else} AtString:=1; {Not needed}
  i1:= StringType[AtString]; {A label at start of line}
  Vartext:= '';
  if i1 = 1 then  {First deal with jumps and subroutine definitions.}
    begin { A system command}
        case Round(StringValue[AtString]) of
         16:begin  {while -similar to if procedure}
              if StringType[AtString+1] in [3 .. 6] then
              begin   {check line syntax}
               IfLevel:= succ(IfLevel);
               ForLoopNum:= succ(ForLoopNum);
               If (IfLevel>MaxIfs) or (ForLoopNum>MaxForLoops) then begin
               Disaster:=True;
               Messagedlg('K6: For Loop or If Stack overflow.',
                          mtError,[mbabort],0);
               exit;
               end;
               with IfStatus[Iflevel],ForLoopStack[ForLoopNum] do
               begin
                SkipOn:= SkipLine; {Save current Skip State}
                Startline:= Pred(NextLine);
                ForVariable:= 'while';
                StartValue:= 0.0; EndValue:= 0.0;
                StepValue:= Round(StringValue[Atstring+1]);
                if (not SkipOn) and (StepValue = 0) then
                begin
                  Skipline := True;
                  DoneIf:= True;
                end;
               end; {if StringType}
             end else begin  {Error in line syntax}
               Messagedlg('L1:Error in While Loop ',
                           mtError,[mbabort],0);
               Disaster:= True;
             end; {if StringType}
            end;   {while}
         17:begin  {endwhile}
            With IfStatus[IfLevel],ForLoopStack[ForLoopNum] do
             begin
              If not SkipOn  then
              begin
               if ForVariable= 'while' then
               begin
                if StepValue= 1 then
                begin
                  NextLine:= StartLine;
                end else begin
                 Skipline:= False;
                end;
                ForLoopNum:= pred(ForLoopNum);
                IfLevel:= pred(IfLevel);
                if (IfLevel<0) or (ForLoopNum<0) then begin
                  Disaster:=true;
                  Messagedlg('L2: Underflow in While block',
                   mtError,[mbabort],0);
                  exit;
                end;
               end else begin
                Messagedlg('L3:Error in ending While Loop ',
                           mtError,[mbabort],0);
                Disaster:= True;
               end; {if StringType}
              end;
             end;
            end;   {endwhile}
       20:begin {if}
           IfLevel:= succ(IfLevel); {move down to next if-stack level}
             If IfLevel>MaxIfs then begin
               Disaster:=True;
               Messagedlg('K7: If Stack overflow.',mtError,[mbabort],0);
               exit;
             end;
           with IfStatus[IfLevel] do
           begin
            SkipOn:= SkipLine; {save current skip state}
            if not SkipOn then { Skip remainder of section if Skip in force}
            begin
             if StringType[AtString+1] in [3 .. 6] then
             begin   {check line syntax}
              if (Round(StringValue[Atstring+1])=1) then
              begin
               DoneIf:= True;
               SkipLine:= False;
              end else SkipLine:= True;
             end else begin  {Error in line syntax}
               Messagedlg('D1: Error in If Statement condition',
                           mtError,[mbabort],0);
               Disaster:= True;
             end; {if StringType}
            end; {Not SkipOn}
           end; {With IfStatus}
          end; {if}
       21:begin {elseif}
           With IfStatus[IfLevel] do
           begin
            If not (SkipOn or DoneIf)  then
            begin
             if StringType[AtString+1] in [3 .. 6] then
             begin  {Syntax check O.K.}
              if (Round(StringValue[Atstring+1])=1) then
              begin
               SkipLine:= False;
               DoneIf:= True;
              end else SkipLine:= True;
              {SkipLine will be true at this point if DoneIf already set}
             end else begin
              Messagedlg('D2:Error in ElseIf Statement condition',
                         mtError,[mbabort],0);
              Disaster:= True;
             end;
            end else SkipLine:= True; {not SkipOn}
           end; {IfStatus}
          end;  {elseif}
       22:begin {else}
           with IfStatus[IfLevel] do
           begin
            If  not (SkipOn or DoneIf) then
            begin
             If (NumOfSubStrings>=(AtString+1))
                 and (StringText[AtString+1] = 'if')
                 and (StringType[AtString+2] in [3 .. 6]) then
             begin {case of ELSE followed by IF}
              if (Round(StringValue[Atstring+2])=1) then
              begin
                SkipLine:= False;
                DoneIf:= True;
              end else SkipLine:= True;;
             end else if (NumOfsubStrings> (AtString+1)) then
             begin {case of ELSE followed by something else}
              if Messagedlg('D3: Ignor Statement following ELSE ?',
                        mtWarning,[mbabort,mbOK],0)= mrAbort
              then begin
               Disaster:= True;
               Exit;
              end;
             end else if NumOfSubStrings<=(AtString+1) then
              SkipLine:= False; {Simple ELSE statement}
            end else SkipLine:= True; { Not (SkipOn or DoneIf )  }
          end; {IfStatus}
          end;
       23:begin {endif}
             SkipLine:= IFStatus[IfLevel].SkipOn;
             IfStatus[IfLevel].DoneIf:= False;
             IfLevel:= Pred(IfLevel);
             if IfLevel<0 then
             begin
               Messagedlg('D4 Error in nesting IF statements',mtError,
                  [mbAbort],0);
               Disaster:= True;
               Exit;
             end;
          end;
       24:begin {sub}
           LastSkip:= SkipLine;
           SubSkipOn:= True;
           If not SkipLine then
           begin  {Allow for conditional setting of subroutines}
            if SubNumber>20 then
            begin
             Disaster:= True;
              Messagedlg('B1:Error in defining subroutine ' + StringText[2]
               + ' Too many subroutines defined.',mtError,[mbAbort],0);
              exit;
            end;
            with subroutine[subnumber] do  {Set input parameters}
            begin
             SkipLine:=  True;
             substart:= NextLine;
             subset:=False;
             if StringType[2]=12 then {a quoted string}
               subname:= LowerCase(StringText[2])
             else begin
               Disaster:= True;
               Messagedlg('B2: Error in naming subroutine ' + StringText[2],
               mtError,[mbAbort],0);
               exit;
             end;
             if NumOfSubStrings > 24 then
             begin
              Disaster:= True;
              Messagedlg('B3: Too many parameters in subroutine ' + StringText[2],
              mtError,[mbAbort],0);
              exit;
             end else if NumOfSubstrings>3 then
             begin
              for  i:= 3 to NumOfSubStrings-1 do
              begin
               i4:=i-3;
               Subtxt:= StringText[i];
               if (StringType[i] = 3) and (length(SubTxt)=1)
               and (Subtxt[1] in ['a' .. 'z']) then
               begin
                SubparName[i4]:= Subtxt;
                SubparType[i4]:= 3;
                SubParValue[i4]:= ord(Subtxt[1])-96;
               end else if (StringType[i] = 9) and (length(Subtxt)=2)
               and (SubTxt[1] in ['v' .. 'z']) then
               begin
                SubparName[i4]:= Subtxt;
                SubparType[i4]:= 9;
                SubParValue[i4]:= ord(Subtxt[1])-97;
               end else begin
                Disaster:= True;
                Messagedlg('B4: Error in setting parameters in subroutine '
                + StringText[2] ,mterror,[mbAbort],0);
                exit;
               end; {if StringType[1]}
              end; {for i}
             end else i4:=0; {if NumOfSubStrings}             NumOfsubpars:= succ(i4);
             SkipLine:= True;  {Set to skip rest of subroutine}
            end; {with subroutine subnumber}
           end;  { If NOT SkipLine}
          end; {sub}
       25:begin {endsub}
           If (SubSkipOn) then
           begin
            With SubRoutine[Subnumber] do
            begin
             SubskipOn:= False;
             subSet:= True;
             SubNumber:= succ(SubNumber);
             If SubNumber>MaxSubs then begin
               Disaster:=True;
               Messagedlg('K8: Subroutine Stack overflow.',mtError,[mbabort],0);
               exit;
             end;
             SkipLine:= LastSkip;
            end; {With Subroutine}
           end else begin {Subroutine running - Tidy up at end of operations}
            With SubRoutine[CurrentSubnumber] do
            begin
              NextLine:= SubReturn;
              Locallevel:= Locallevel-26;  {Reset Local levels}
              if Locallevel<0 then
              begin
               Disaster:= True;
               Messagedlg(
                 'K9: Underflow in local level stack when exiting subroutine '
                 + Subname,mtError,[mbAbort],0);
               exit;
              end;
              for i:= 21 to 25 do
              begin  {Clear local text}
               vwt[i]:= vwt[i+LocalTextlevel];
               vwt[i+LocalTextlevel]:= '';
              end;
              LocalTextlevel:= LocalTextlevel-5;
              CurrentSubNumber:= LastSubNumber;
            end;
           end;  {If SubSkipOn}
          end;
       26:begin
            Disaster:= True;
            Halt:= True;
            exit;
          end;
       end;{case StringType}
  end;
 if not Skip then begin {Non-System commands}
    case i1 of
     1: begin
         case Round(StringValue[AtString]) of
          3:{Toggle Diagnostic output}
            if Diagnostics=True then Diagnostics := False
               else Diagnostics := True;
          5:AngleMeasure:= Degree;  {Set Angle measures for degrees}
          6:AngleMeasure:= 1.0;     {Set angle measure for radians}
          7:begin  {Fix}
              If (StringType[AtString+1]in [3 .. 6]) and
                  (StringType[AtString+2] in [3 .. 6]) then
              begin
                SigFigs:=round(StringValue[AtString+1]);
                DecFigs:=round(StringValue[AtString+2]);
              end else begin
                Disaster:=true;
                Messagedlg('D5: Error in setting Fixed Point Format',
                   mtError,[mbOK],0);
              end; {If StringType}
              if (SigFigs<1) or (SigFigs>30) or (DecFigs>SigFigs)
                 or (DecFigs<0) then begin
                  if Messagedlg('D6: Unlikely settings for Fixed Point format!',
                    mtWarning,[mbOK,mbAbort],0)= mrAbort then
                  begin {Set default fixed point format}
                    SigFigs:=6;
                    DecFigs:=3;
                  end; {if Messagedlg}
              end; {if Sigfigs}
           end; {Fix}
          8:begin {Float}
             if (StringType[AtString+1] in [3 .. 6]) then
              begin
               SigFigs:=round(StringValue[AtString+1]);
               DecFigs:=-1;
              end  else
              begin
               Disaster:=true;
               Messagedlg('D7: Error in setting Floating Point Format',
                   mtError,[mbOK],0);
              end; {if StartString}
             if (SigFigs<5) or (SigFigs>30) then begin
               if Messagedlg('D8: Unlikely settings for Floating Point Format!',
                   mtWarning,[mbOK,mbAbort],0)= mrAbort then
               begin  {Set default floating point format}
                SigFigs:=10;
                Decfigs:=-1;
               end; {if Messagedlg}
             end; {if Sigfigs}
            end;{Float}
         10:begin  {for loop}
             If (Stringtype[Atstring+1]=3)  and (StringText[AtString+2] = '=')
               and (Stringtype[Atstring+3] in [3 ..6])
               and (StringText[AtString+4] = 'to')
               and (StringType[AtString+5] in [3 .. 6]) then
             begin
              BeginNum:= succ(BeginNum);  {Enters a code in begin stack}
             If BeginNum>MaxBegins then begin
               Disaster:=True;
               Messagedlg('K10: Begin Stack overflow.',mtError,[mbabort],0);
               exit;
             end;
              BeginStack[BeginNum]:= 25;
              ForLoopNum:= succ(ForLoopNum);
              If ForLoopNum>MaxForLoops then begin
               Disaster:=True;
               Messagedlg('K11: For Loop Stack overflow.',mtError,[mbabort],0);
               exit;
              end;
              with ForLoopStack[ForLoopNum] do
              begin
               Startline:= NextLine;
               ForVariable:= StringText[AtString+1];
               StartValue:= StringValue[Atstring+3];
               SetVariableValue(ForVariable,StartValue,Vartext);
               EndValue:=   StringValue[atstring+5];
               {Set step to unity unless re-specified later }
               If EndValue>StartValue then StepValue:= 1.0
               else if EndValue<StartValue then StepValue:= -1.0;
               If NumOfSubStrings>(Atstring+6) then begin
                if (StringText[AtString+6]='step')
                   and (Stringtype[AtString+7] in [ 3 ..6]) then
                 StepValue:= StringValue[atString+7]
                else begin
                 Messagedlg('D9: Error in setting step in FOR loop',
                 mtError,[mbAbort],0);
                 Disaster:= True;
                end;
                stp1:= abs(StepValue)/abs(EndValue-StartValue);
                If  (StepValue*(EndValue-StartValue)<0) {Signs do not match}
                or (stp1<0.0002) {More than 5000 steps}
                or (stp1>10000)  {Step very much bigger than range}
                then begin
                 Messagedlg('D10: Error in setting FOR loop step value',mtError,
                 [mbAbort],0);
                 Disaster:= True;
                end;
               end; {NumOfSubStrings>AtString+6}
               EndValue:= EndValue-0.5*StepValue; {Sets working end value }
              end; {with ForLoopdata}
             end; {If StringType ...}
            end; {for Loop}
         13:begin {Next}
             if (Beginstack[BeginNum]=25) then  {Check for correct loop ending}
             begin
              with ForLoopStack[ForLoopNum] do
              begin
               If (StartValue<EndValue) and (StepValue>0) then
               begin
                StartValue:= StartValue+StepValue;
                SetVariableValue(ForVariable,StartValue,Vartext);
                NextLine:= StartLine
               end else if (StartValue>EndValue) and (StepValue<0) then
               begin
                StartValue:= StartValue+StepValue;
                SetVariableValue(ForVariable,StartValue,VarText);
                NextLine:= StartLine
               end else begin {Reset Stacks and exit at end of FOR loop }
                BeginNum:= Pred(BeginNum);
                ForLoopNum:= pred(ForLoopNum);
                if (BeginNum<0) or (ForLoopNum<0) then begin
                   Disaster:=true;
                   Messagedlg('K12: Underflow in Begin or For Loop stack',
                            mtError,[mbabort],0);
                   exit;
                end;
               end;
              end; {with ForLoopStack}
             end else begin
              Messagedlg('D11: Error in FOR loop termination',mtError,[mbAbort],0);
              Disaster:= True;
             end; {If}
            end; {Next}
         14:begin  {repeat  - similar to for loop - uses same tack etc.}
              ForLoopNum:= succ(ForLoopNum);
              If ForLoopNum>MaxForLoops then begin
               Disaster:=True;
               Messagedlg('K13: For Loop Stack overflow.',mtError,[mbabort],0);
               exit;
              end;
              with ForLoopStack[ForLoopNum] do
              begin
               Startline:= NextLine;
               ForVariable:= 'repeat';
               StartValue:= 0.0; EndValue:= 0.0; StepValue:= 1.0;
              end;
            end;   {repeat}
         15:begin  {until - similar to next/if}
             if (ForLoopStack[ForloopNum].ForVariable = 'repeat') then
             { check that this is correct ending}
             begin
              if StringType[AtString+1] in [3 .. 6] then
              begin   {check line syntax}
                if (Round(StringValue[Atstring+1])=0) then
                 NextLine:= ForLoopStack[ForLoopNum].StartLine
                else ForLoopNum:= Pred(forloopNum);
                if ForLoopNum<0 then begin
                  Disaster:=true;
                  Messagedlg('K14: Underflow in For loop stack',
                        mtError,[mbabort],0);
                  exit;
               end;
              end else begin  {Error in line syntax}
               Messagedlg('R1: Error in Repeat Loop condition',
                           mtError,[mbabort],0);
               Disaster:= True;
              end;  {if StringType}
             end else begin
               Messagedlg('R2: Error in Repeat Loop structure',
                           mtError,[mbabort],0);
               Disaster:= True;
             end;  {if StringType}
            end;   {until}
         end; { case i2}
       end; {i1 =1}
     3:begin {A variable}
        if ((StringType[AtString+1]=1)  {Test for assignment}
        and (Round(StringValue[AtString+1])=2)) then
        begin
         SetVariableValue(StringText[AtString],StringValue[AtString+2],
                          VarText);
         StringValue[AtString]:=StringValue[AtString+2];
         Str(StringValue[AtString]:SigFigs:DecFigs,Out3);
         if Disaster then exit;
        end;  {if}
       end; {i1 = 3}
     9:begin {A string Variable}
         if ((StringType[AtString+1]=1) {Test for Assignment}
         and (Round(StringValue[AtString+1])=2)) then
         begin
          If (StringType[AtString+2] = 9) then
           VarText:= vwt[Round(StringValue[AtString+2])]
          else if (StringType[AtString+2] in [12,14]) then
           VarText:= StringText[Atstring+2]
          else begin
           Messagedlg('H1:Error in assigning a string variable',mtError,
           [mbAbort],0);
           Disaster:=True;
           exit;
          end;
          SetVariableValue(StringText[AtString],StringValue[AtString+2],
                          VarText);
          StringValue[AtString]:=StringValue[AtString+2];
          if Disaster then exit;
         end;  {if}
       end; {i1 = 9}
 20:begin  {A graphic}
        if SetGraphic then begin
         i2:=trunc(StringValue[AtString]);
         case i2 of
         0:begin {Aline}
             if NumOfSubStrings>(AtString+4) then
             begin
             if (StringType[AtString+3]=21)
              and (Round(StringValue[AtString+3])=0)
              and (StringType[AtString+4]=21)
              and (Round(StringValue[AtString+4]) in [1 .. 4]) then
              begin
               case Round(StringValue[AtString+4]) of
               1:begin
                  Arrowstart:= True;
                  ArrowEnd:= False;
                 end;
               2:begin
                  Arrowstart:= False;
                  ArrowEnd:= True;
                 end;
               3:begin
                  Arrowstart:= True;
                  ArrowEnd:= True;
                 end;
               4:begin
                  Arrowstart:= False;
                  ArrowEnd:= False;
                 end;
               end; {case}
              end else begin
               if Messagedlg('D12: Error in setting up arrows following aline',
                         mtWarning,[mbOK,mbAbort],0)= mrAbort then
                begin {Halt to check on error}
                 Disaster:= True;
                 exit;
                end else begin {Use default values}
                 Arrowstart:= False;
                 ArrowEnd:= False;
                end;
             end; {if StringType[atString=3]}
            end; {if NumOfsubStrings }
            if (StringType[AtString+1] in [3 ..6])
             and (StringType[AtString+2] in [3 .. 6])
             then Aline(StringValue[AtString+1],StringValue[AtString+2]);
           end; {ALine}
         1:begin {Amove}
             if (StringType[AtString+1] in [3 .. 6])
             and (StringType[AtString+2] in [3 ..6])
             then Amove(StringValue[AtString+1],StringValue[AtString+2]);
           end;
         2:begin {Arc}
             if  (StringType[AtString+1] in [3 .. 6])
             and (StringType[AtString+2] in [3 .. 6])
             and (StringType[AtString+3] in [3 .. 6])
             then ArcAt(StringValue[AtString+1],StringValue[AtString+1],
                        StringValue[AtString+2]*degree/AngleMeasure,
                        StringValue[AtString+3]*degree/AngleMeasure);
             {degree/AngleMeasure forces argument to be in degrees}
           end;
         3:begin {ArcTo}
             if  (StringType[AtString+1] in [3 .. 6])
             and (StringType[AtString+2] in [3 .. 6])
             and (StringType[AtString+3] in [3 .. 6])
             and (StringType[AtString+4] in [3 .. 6])
             and (StringType[AtString+5] in [3 .. 6])
             then ArcTo(StringValue[AtString+1],StringValue[AtString+2],
                        StringValue[AtString+3],StringValue[AtString+4],
                        StringValue[AtString+5]);
           end;  {ArcTo}
         4:begin{Begin}
             if ((BeginNum>=0) and (BeginNum<50)) and
               ((AtString+1=NumOfSubstrings) or (StringType[AtString+1]=30))
               then BeginBlock(AtString+1) else
               begin
                 Disaster:=True;
                 Messagedlg('D13: Illegal begin statement', mterror, [mbAbort],0);
               end;
           end;
         5:begin {Bezier}
             if (StringType[AtString+1] in  [3 .. 6])
             and (StringType[AtString+2] in [3 .. 6])
             and (StringType[AtString+3] in [3 .. 6])
             and (StringType[AtString+4] in [3 .. 6])
             and (StringType[AtString+5] in [3 .. 6])
             and (StringType[AtString+6] in [3 .. 6])
             then Bezier(StringValue[AtString+1],StringValue[AtString+2],
                         StringValue[AtString+3],StringValue[AtString+4],
                         StringValue[AtString+5],StringValue[AtString+6]);
           end; {Bezier}
         7:begin  {box}
             if (StringType[AtString+1] in [3 .. 6])
             and (StringType[AtString+2] in [3 .. 6])
             then box(StringValue[AtString+1],StringValue[AtString+2]);
           end;
         8:begin {Circle}
             if (StringType[AtString+1] in [3 .. 6])
             then Circle(StringValue[AtString+1]);
           end;
        13:begin {Ellipse}
             if (StringType[AtString+1] in [3 .. 6])
             and (StringType[AtString+2] in [3 .. 6])
             then EllipseAt(StringValue[AtString+1],StringValue[AtString+2]);
           end;
        15:begin {Block end}
             if (StringType[AtString+1]=1)
               and (Round(StringValue[AtString+1])=20) then
              begin {End If statement}
               SkipLine:= IfStatus[IfLevel].SkipOn;
               IfStatus[IfLevel].DoneIf:= True;
               IfLevel:= Pred(IfLevel);
               if IFLevel<0 then
               begin
                 Messagedlg('D14: Error in nesting IF statements',mtError,
                  [mbAbort],0);
                 Disaster:= True;
                 Exit;
               end;
              end else if (StringType[AtString+1]=1)
               and (Round(StringValue[AtString+1])=16) then
              begin {End While statement}
              end else if ((BeginNum>0) and (BeginNum<=50)) and
               ((AtString+1=NumOfSubstrings) or (StringType[AtString+1]=30))
              then EndBlock(AtString+1) else
              begin
                Disaster:=True;
                Messagedlg('D15: Illegal End statement', mterror, [mbAbort],0);
              end;
           end; {Block end}
        17:begin {apolyline - coordinates relative to current point}
             i3:= 1; i4:= 1; i5:= 2;
             rpt1[0].x:= 0.0; rpt1[0].y:= 0.0;
             while (i5 < NumOfSubstrings) and (i4 > 0) do
              begin
               if (StringType[AtString+i4] = 20) and
                  (Round(StringValue[AtString+i4]) = 15) then
               begin  {'end' found}
                  i4:= -10;
                  for i:=  i3 to  100 do
                  begin {Resets rest of array}
                   rpt1[i].x:=0.0; rpt1[i].y:= 0.0;
                  end;
               end else if (StringType[AtString+i4] in [3 ..6])
                  and (StringType[AtString+i5] in [3 .. 6]) then
               begin
                rpt1[i3].x:= StringValue[AtString+i4];
                i4:=succ(i4);
                rpt1[i3].y:= StringValue[AtString+i4];
                i4:= succ(i4); i3:= succ(i3); i5:= succ(i4);
               end else begin
                disaster:= true;
                Messagedlg('D16: Error in apolyline array settings',
                            mtError,[mbAbort],0);
                i4:= -20; {Exit from While loop}
               end; {if}
              end; {while}
              if (i4 > -20) then  SetPolyLine(i3,rpt1) else exit;
           end; {apolyline }
        18:begin {rpolyline - coordinates relative to the last point }
             i3:= 1; i4:= 1; i5:= 2;
             rpt1[0].x:= 0.0; rpt1[0].y:= 0.0;
             while (i5 < NumOfSubstrings) and (i4 > 0) do
              begin
               if (StringType[AtString+i4] = 20) and
                  (Round(StringValue[AtString+i4]) = 15) then
               begin  {'end' found}
                  i4:= -10;
                  for i:=  i3 to  100 do
                  begin {Resets rest of array}
                   rpt1[i].x:=0.0; rpt1[i].y:= 0.0;
                  end;
               end else if (StringType[AtString+i4] in [3 ..6])
                  and (StringType[AtString+i5] in [3 .. 6]) then
               begin
                rpt1[i3].x:= StringValue[AtString+i4]+rpt1[i3-1].x;
                i4:=succ(i4);
                rpt1[i3].y:= StringValue[AtString+i4]+rpt1[i3-1].y;
                i4:= succ(i4); i3:= succ(i3); i5:= succ(i4);
               end else begin
                disaster:= true;
                Messagedlg('D17: Error in rpolyline array setting',
                            mtError,[mbAbort],0);
                i4:= -20; {Exit from While loop}
               end; {if}
              end; {while}
              if (i4 > -20) then  SetPolyLine(i3,rpt1) else exit;
           end; {rpolyline }
        20:begin;{FillTo}
             If StringType[Atstring+1] in [3 ..6,24] then
              Fill(Round(StringValue[AtString+1]),1)
             else begin
              Messagedlg('D18: Error in Fillto Colour',mtError,[mbAbort],0);
              Disaster:=True;
              Exit;
             end;
           end;
        21:begin{FillOver}
             If StringType[Atstring+1] in [3 ..6,24] then
              Fill(Round(StringValue[AtString+1]),2)
             else begin
              Messagedlg('D19:Error in Fillover Colour',mtError,[mbAbort],0);
              Disaster:=True;
              Exit;
             end;
           end;
///////////////////////////////////////////////////////////////////////////////
//        22:begin {gsave}              //These remove for future study
//             SaveSettings;
//           end;
//        23:begin {grestore}
//             RestoreSettings;
//           end;
//        24:begin {greset}
//             ResetSettings;
//           end;
///////////////////////////////////////////////////////////////////////////////
        30:begin {Marker}
            If (StringType[AtString+1]=28)
             and (StringType[AtString+2] in [3 .. 6]) then
             Marker(StringText[AtString+1],
                   Round(0.5*PixelsPerCm*StringValue[AtString+2])+1);
           end;
        32:begin {Narc}
             if  (StringType[AtString+1] in [3 .. 6])
             and (StringType[AtString+2] in [3 .. 6])
             and (StringType[AtString+3] in [3 .. 6])
             then ArcAt(StringValue[AtString+1],StringValue[AtString+1],
                        StringValue[AtString+3]*degree/AngleMeasure,
                        StringValue[AtString+2]*degree/AngleMeasure);
           end;
        34:begin {Displayat}
             if (StringType[AtString+1] in [3 .. 6])
             and (StringType[AtString+2] in [3 .. 6])
             and (StringType[AtString+3] = 12)
             then begin
               Displayat(StringValue[AtString+1],StringValue[AtString+2],
               StringText[Atstring+3]);
             end;
           end;
        36:begin {apolygon - coordinates relative to current point}
             i3:= 1; i4:= 1; i5:= 2;
             rpt1[0].x:= 0.0; rpt1[0].y:= 0.0;
             while (i5 < NumOfSubstrings) and (i4 > 0) do
              begin
               if (StringType[AtString+i4] = 20) and
                  (Round(StringValue[AtString+i4]) = 15) then
               begin  {'end' found}
                  i4:= -10;
                  for i:=  i3 to  100 do
                  begin {Resets rest of array}
                   rpt1[i].x:=0.0; rpt1[i].y:= 0.0;
                  end;
               end else if (StringType[AtString+i4] in [3 ..6])
                  and (StringType[AtString+i5] in [3 .. 6]) then
               begin
                rpt1[i3].x:= StringValue[AtString+i4];
                i4:=succ(i4);
                rpt1[i3].y:= StringValue[AtString+i4];
                i4:= succ(i4); i3:= succ(i3); i5:= succ(i4);
               end else begin
                disaster:= true;
                Messagedlg('D20: Error in apolygon array settings',
                            mtError,[mbAbort],0);
                i4:= -20; {Exit from While loop}
               end; {if}
              end; {while}
              if (i4 > -20) then  SetPolygon(i3,rpt1) else exit;
           end; {apolygon }
        37:begin {rpolygon - coordinates relative to the last point }
             i3:= 1; i4:= 1; i5:= 2;
             rpt1[0].x:= 0.0; rpt1[0].y:= 0.0;
             while (i5 < NumOfSubstrings) and (i4 > 0) do
              begin
               if (StringType[AtString+i4] = 20) and
                  (Round(StringValue[AtString+i4]) = 15) then
               begin  {'end' found}
                  i4:= -10;
                  for i:=  i3 to  100 do
                  begin {Resets rest of array}
                   rpt1[i].x:=0.0; rpt1[i].y:= 0.0;
                  end;
               end else if (StringType[AtString+i4] in [3 ..6])
                  and (StringType[AtString+i5] in [3 .. 6]) then
               begin
                rpt1[i3].x:= StringValue[AtString+i4]+rpt1[i3-1].x;
                i4:=succ(i4);
                rpt1[i3].y:= StringValue[AtString+i4]+rpt1[i3-1].y;
                i4:= succ(i4); i3:= succ(i3); i5:= succ(i4);
               end else begin
                disaster:= true;
                Messagedlg('D21: Error in rpolygon array setting',
                            mtError,[mbAbort],0);
                i4:= -20; {Exit from While loop}
               end; {if}
              end; {while}
              if (i4 > -20) then  SetPolygon(i3,rpt1) else exit;
           end; {rpolygon }
        38:begin {rbezier}
             if (StringType[AtString+1] in [3 .. 6])
             and (StringType[AtString+2] in [3 .. 6])
             and (StringType[AtString+3] in [3 .. 6])
             and (StringType[AtString+4] in [3 .. 6])
             and (StringType[AtString+5] in [3 .. 6])
             and (StringType[AtString+6] in [3 .. 6])
             then RBezier(StringValue[AtString+1],StringValue[AtString+2],
                         StringValue[AtString+3],StringValue[AtString+4],
                         StringValue[AtString+5],StringValue[AtString+6]);
           end; {RBezier}
        41:begin  {PasteAt}
             if (StringType[AtString+1] in [3 .. 6])
             and (StringType[AtString+2] in [3 .. 6])
             and (StringType[AtString+3] in [3 .. 6])
             and (StringType[AtString+4] in [3 .. 6])
             then begin
               Out1:= StringText[AtString+3];
               i4:= Length(Out1);
               Out1:= Chr(39) + Out1 + Chr(39);
               PasteAt(StringValue[AtString+1],StringValue[AtString+2],
               StringValue[AtString+3],StringValue[AtString+4]);
             end;
           end;
        43:begin {rline}
             if (NumOfSubStrings>(AtString+4)) then
             begin
             if (StringType[AtString+3]=21)
              and (Round(StringValue[AtString+3])=0)
              and (StringType[AtString+4]=21)
              and (Round(StringValue[AtString+4]) in [1 .. 4]) then
             begin
               case Round(StringValue[AtString+4]) of
               1:begin
                  Arrowstart:= True;
                  ArrowEnd:= False;
                 end;
               2:begin
                  Arrowstart:= False;
                  ArrowEnd:= True;
                 end;
               3:begin
                  Arrowstart:= True;
                  ArrowEnd:= True;
                 end;
               4:begin
                  Arrowstart:= False;
                  ArrowEnd:= False;
                 end;
               end; {case}
             end else begin
              Messagedlg('D22 Error in setting up arrows following rline',
                         mtWarning,[mbOK],0);
              Arrowstart:= False;
              ArrowEnd:= False;
             end; {if StringType}
             end; {if NumOfSubstrings }
             if (StringType[AtString+1] in [3 ..6])
             and (StringType[AtString+2] in [3 .. 6])
             then Rline(StringValue[AtString+1],StringValue[AtString+2]);
           end; {rline}
        44:begin {rmove}
             if (StringType[AtString+1] in [3 .. 6])
             and (StringType[AtString+2] in [3 ..6])
             then Rmove(StringValue[AtString+1],StringValue[AtString+2]);
           end;  {Rmove}
        45:begin  {saveas}
             if (StringType[AtString+1]=3) and (StringType[AtString+2]=3) then
             begin
              SetVariableValue(StringText[AtString+1],CurrentPoint.x,VarText);
              SetVariableValue(StringText[AtString+2],CurrentPoint.y,VarText);
             end else begin
              Messagedlg('D23: Error in SAVE operation ',mtError,[mbAbort],0);
              Disaster:= True;
              Exit;
             end;
           end;
        46:begin {Set}
             If  (AtString<NumOfSubStrings) and
                    (StringType[AtString+1]=29)
             then MakeSetting(AtString+1)
             else begin
              Messagedlg('D24: Illegal setting parameter '
               + StringText[AtString+1], mtError,[mbAbort],0);
              Disaster:=true;
              exit;
             end;
           end; {Set}
        48:begin {square}
             if (StringType[AtString+1] in [3 .. 6])
             then Square(StringValue[AtString+1]);
           end;
        49:begin  {DotsPerCm}
            if (StringType[AtString+1] in [3 ..6])
              then  DotsPerCm:= StringValue[Atstring+1]
            else begin
              Disaster:= True;
              Messagedlg('D25: Error in setting printer dots per cm.',
                mtError,[mbAbort],0);
              exit;
            end; {if}
           end;  {DotsPerCm}
        50:begin {text}
             Text(StringText[Atstring+1],TextAngle);
           end;
        51:begin {TextWidth}
             if (StringType[AtString+1] in [3 .. 6])
             then WidthOfText:= StringValue[AtString+1]
             else begin
              Messagedlg('D26: Illegal TextWidth parameter '
               + StringText[AtString+1], mtError,[mbAbort],0);
              Disaster:=true;
              exit;
             end;
           end; {TextWidth}
        52:begin {Use}
            try
             if (StringType[AtString+1] in [3 .. 6])
                and (StringType[AtString+2] in [3 .. 6])
             then begin
              case Round(StringValue[AtString+1]) of
              1:xaxis:= 1;  {default settings}
              2:xaxis:= 2;
              3:xaxis:= 3;  {values for polar angle axes}
              4:xaxis:= 4;
              end; {Case}
              case Round(StringValue[AtString+2]) of
              1:yaxis:= 1;
              2:yaxis:= 2;
              3:yaxis:= 3;  {Values for polar radial axes}
              4:yaxis:= 4;
              5:yaxis:= 5;
              6:yaxis:= 6;
              end; {Case}
              SetGraphTransform(xaxis,yaxis,GraphTransform,gxOffset,gyOffset);
             end else if (StringType[AtString+1]=20)
                and (StringType[AtString+2]=20)
             then begin {In this case order of defining axes does not matter.}
              case Round(StringValue[AtString+1]) of
              55:xaxis:= 1;  {default settings}
              56:xaxis:= 2;
              57:yaxis:= 1;
              58:yaxis:= 2;
              59:zaxis:= 1;
              60:zaxis:= 2;
              67:yaxis:= 3; {Values for polar radial axes}
              68:yaxis:= 4;
              69:yaxis:= 5;
              70:yaxis:= 6;
              71:xaxis:= 3; {Values for polar angle axes}
              72:xaxis:= 4;
             end;
              case Round(StringValue[AtString+2]) of
              55:xaxis:= 1;  {default settings}
              56:xaxis:= 2;
              57:yaxis:= 1;
              58:yaxis:= 2;
              59:zaxis:= 1;
              60:zaxis:= 2;
              67:yaxis:= 3; {Values for polar radial axes}
              68:yaxis:= 4;
              69:yaxis:= 5;
              70:yaxis:= 6;
              71:xaxis:= 3; {Values for polar angle axes}
              72:xaxis:= 4;
          end; {Case}
              SetGraphTransform(xaxis,yaxis,GraphTransform,gxOffset,gyOffset);
              {Note. Only values of xaxis, yaxis etc. set within this unit
               can be used.}
         end else begin
              Messagedlg('D27: Error in USE settings',mtError,[mbAbort],0);
              Disaster:= True;
              Exit;
         end;
         except
              Messagedlg('D28: Error in USE command - graph may not be set',
                 mtError,[mbAbort],0);
                 Disaster:= True;
                 exit;
         end;
        end; {use}
        53:begin {copyfrom}
             if (StringType[AtString+1] in [3 .. 6])
             and (StringType[AtString+2] in [3 .. 6])
             and (StringType[AtString+3] in [3 .. 6])
             and (StringType[AtString+4] in [3 .. 6])
             then begin
               CopyFrom(StringValue[AtString+1],StringValue[AtString+2],
               StringValue[AtString+3],StringValue[AtString+4]);
             end;
           end;
        54:begin {write}
             Out1:='';
             for i3:=AtString+1 to NumOfSubStrings do
             begin
               if  (StringType[i3]=9)
                 then Out1:= Out1 + vwt[Round(StringValue[i3])]
               else if (StringType[i3] in [10,12,14])
                    then Out1:=Out1+StringText[i3]+' '
               else if (StringType[i3] in [3 .. 6])
                    then begin
                      Str(StringValue[i3]:SigFigs:DecFigs,Out2);
                      Out1:=Out1+Out2+' ';
                     end;   {if StringType}
              end;  {for i3}
        {Insert check on write as D23 here }
               Text(Out1,0.0);
           end;
        55:xaxis :=1;
        56:xaxis:= 2;
        57:yaxis:= 1;
        58:yaxis:= 2;
        59:zaxis:= 1;
        60:zaxis:= 2;
        {61,62  fopen, fclose not yet implemented.}
        63:begin {Apline}
             if NumOfSubStrings>(AtString+4) then
             begin
             if (StringType[AtString+3]=21)
              and (Round(StringValue[AtString+3])=0)
              and (StringType[AtString+4]=21)
              and (Round(StringValue[AtString+4]) in [1 .. 4]) then
              begin
               case Round(StringValue[AtString+4]) of
               1:begin
                  Arrowstart:= True;
                  ArrowEnd:= False;
                 end;
               2:begin
                  Arrowstart:= False;
                  ArrowEnd:= True;
                 end;
               3:begin
                  Arrowstart:= True;
                  ArrowEnd:= True;
                 end;
               4:begin
                  Arrowstart:= False;
                  ArrowEnd:= False;
                 end;
               end; {case}
              end else begin
               if Messagedlg('D29: Error in setting up arrows following apline',
                         mtWarning,[mbOK,mbAbort],0)= mrAbort then
                begin {Halt to check on error}
                 Disaster:= True;
                 exit;
                end else begin {Use default values}
                 Arrowstart:= False;
                 ArrowEnd:= False;
                end;
             end; {if StringType[atString=3]}
            end; {if NumOfsubStrings }
            if (StringType[AtString+1] in [3 ..6])
             and (StringType[AtString+2] in [3 .. 6])
             then Aline(StringValue[AtString+1]
                    *cos(StringValue[AtString+2]/anglemeasure),
                    StringValue[AtString+1]*sin(StringValue[AtString+2]
                    /anglemeasure));
           end; {ALine}
        64:begin {Apmove}
             if (StringType[AtString+1] in [3 .. 6])
             and (StringType[AtString+2] in [3 ..6])
             then Amove(StringValue[AtString+1]*cos(StringValue[AtString+2]
                     /anglemeasure),StringValue[AtString+1]
                     *sin(StringValue[AtString+2]/anglemeasure));
           end;
        65:begin {rpline}
             if (NumOfSubStrings>(AtString+4)) then
             begin
             if (StringType[AtString+3]=21)
              and (Round(StringValue[AtString+3])=0)
              and (StringType[AtString+4]=21)
              and (Round(StringValue[AtString+4]) in [1 .. 4]) then
             begin
               case Round(StringValue[AtString+4]) of
               1:begin
                  Arrowstart:= True;
                  ArrowEnd:= False;
                 end;
               2:begin
                  Arrowstart:= False;
                  ArrowEnd:= True;
                 end;
               3:begin
                  Arrowstart:= True;
                  ArrowEnd:= True;
                 end;
               4:begin
                  Arrowstart:= False;
                  ArrowEnd:= False;
                 end;
               end; {case}
             end else begin
              Messagedlg('D30 Error in setting up arrows following rline',
                         mtWarning,[mbOK],0);
              Arrowstart:= False;
              ArrowEnd:= False;
             end; {if StringType}
             end; {if NumOfSubstrings }
             if (StringType[AtString+1] in [3 ..6])
             and (StringType[AtString+2] in [3 .. 6])
             then Rline(StringValue[AtString+1]*cos(StringValue[AtString+2]
             /anglemeasure),StringValue[AtString+1]*sin(StringValue[AtString+2]
             /anglemeasure));
           end; {rline}
        66:begin {rpmove}
             if (StringType[AtString+1] in [3 .. 6])
             and (StringType[AtString+2] in [3 ..6])
             then Rmove(StringValue[AtString+1]*cos(StringValue[AtString+2]
             /anglemeasure),StringValue[AtString+1]*sin(StringValue[AtString+2]
             /anglemeasure));
           end;  {Rmove}
        67:yaxis:= 3;
        68:yaxis:= 4;
        69:yaxis:= 5;
        70:yaxis:= 6;
        71:xaxis:= 3;
        72:xaxis:= 4;
        73:begin {star}
             if (StringType[AtString+1] in [3 .. 6])
             and (StringType[AtString+2] in [3 ..6])
             and (StringType[AtString+3] in [3 ..6])
             and (StringType[AtString+4] in [3 ..6])
             then DrawStar(StringValue[AtString+1],StringValue[AtString+2],
                  StringValue[AtString+3],StringValue[AtString+4])
             else begin
                 Messagedlg('D31: Error in defining a star',
                 mtError,[mbAbort],0);
                 Disaster:= True;
                 exit;
            end;
           end; {Star}
        74:begin {Regular nsided polygon}
             if (StringType[AtString+1] in [3 .. 6])
             and (StringType[AtString+2] in [3 ..6])
             and (StringType[AtString+3] in [3 ..6])
             then DrawRNPolygon(StringValue[AtString+1],StringValue[AtString+2],
                  StringValue[AtString+3])
             else begin
                 Messagedlg('D32: Error in defining a regular polygon',
                 mtError,[mbAbort],0);
                 Disaster:= True;
                 exit;
            end;
           end;
        75:begin  {getdata}
             if (Stringtype[Atstring+1] in [3 ..6])
             and (Stringtype[Atstring+2] in [3 ..6])
             and (Stringtype[Atstring+3] in [3 ..6])
             and (Stringtype[Atstring+4] = 3) and (Stringtype[Atstring+5] = 3)
             then begin
               try
                i3:= Round(StringValue[Atstring+1]);
                i4:= Round(StringValue[AtString+2]);
                i5:= Round(StringValue[Atstring+3]);
                var1:= data[i4][i3].value;
                var2:= data[i5][i3].value;
                SetVariableValue(StringText[Atstring+4],var1,Out1);
                SetVariableValue(StringText[AtString+5],var2,Out1);
              except
                disaster:= True;
              end;
             end else Disaster:=True;
             if Disaster then begin
              Messagedlg('Error is getting data in row ' +
              StringText[AtString+1] + ' at columns '+ StringText[AtString+2]
              + ' or ' + StringText[AtString+3],mtError,[mbAbort],0);
              Exit;
             end;
           end;
        end; { case i2}
       end; {if Graphic}
         if Disaster then exit
         { Insert message for unidentied error in graphic here }
       end; {case 20}
    32:begin {A subroutine call}
        i:= -1;
        repeat
          i:= succ(i);
        until (i>SubNumber) or (SubRoutine[i].Subname=StringText[1]);
        if i<=SubNumber then begin
         With Subroutine[i] do
         begin
          LastSubNumber:= CurrentSubNumber; {Used for nesting subroutines}
          Subreturn:= NextLine;
          Nextline:= SubStart;
          Locallevel:= Locallevel+26;  { Make subroutine parameters local}
          LocalTextlevel:= LocalTextlevel+5;
          if LocalLevel>390 then
          begin
            Disaster:= True;
            Messagedlg('D33: Too many local levels nested in call to subroutine '
            + StringText[1] ,mtError,[mbAbort],0);
            exit;
          end
          else begin
            for i3:= 1 to 26 do vw[i3+Locallevel]:= 0;
            for i3:= 21 to 25 do
            begin  {Because only part of text
                    array reset use a different algorithm.}
              vwt[i3+LocalTextLevel]:=vwt[i3];
              vwt[i3]:= '';
            end;
          end; {If LocalLevel}
          if NumOfSubPars>0 then
          begin
           for i3:= 0 to NumOfSubPars-1 do {Allocate values to local parameters}
           begin
             i4:= round(SubParValue[i3]);
             if SubPartype[i3]in [3] then  { A number}
             begin
              if StringType[i3+2] in [3 .. 6,24] then
               vw[i4+LocalLevel]:= StringValue[i3+2]
              else Disaster:= True;
             end else if SubPartype[i3]=9 then
             begin
              i4:= round(subparvalue[i3]);
              if Stringtype[i3+2]=9 then
                   vwt[i4]:= vwt[Round(StringValue[i3+2])]
              else if StringType[i3+2]=12 then
                   vwt[i4]:= StringText[i3+2]
              else Disaster:= True;
             end;
             if Disaster then
             begin
              NextLine:= subreturn;  {Displays error message at correct point}
              Messagedlg('D34: Error in assigning parameter in subroutine '
              + StringText[1] ,mtError,[mbAbort],0);
              exit;
             end; {If SubParType}
           end; {for i3}
          end; {If NumOfSubPars}
         end; {With Subroutine[i]}
         CurrentSubNumber:= i;
        end; {if i}
       end;
    40,50:begin {Graphs or Polar plots}
        i2:=trunc(StringValue[AtString]);
        i3:=Round(StringValue[AtString+1]);
        if (SetGraph or Setpolar) then begin
         case i2 of
          0:begin; {Bar}
            end;
          1:begin {Input of data}
              if StringType[AtString+1]=12 then {A dataset name found}
              begin
                DataSetName:=StringText[AtString+1];
               {Now in InputData in Graphs}
                if FileExists(DataSetName) then
                begin
                  InputData(CurrentDEnd,DataSetName);
                  DataDefined:= True;
                  If Disaster then exit;
               {   CheckData;  }
                end
                else begin
                  Messagedlg('G1: Specified datafile does not exist!',mtError,
                  [mbAbort],0);
                  Disaster:=True;
                  exit;
                end;
              end else begin
                  Messagedlg('G2: Expecting a DataSet Name',mtError,[mbAbort],0);
                Disaster:=True;
                exit;
              end; { if StringType }
            end;
          2:begin  {end graph}
              if BeginStack[BeginNum]=i3 then
              begin
               BeginNum:=Pred(BeginNum);
               If BeginNum<0 then begin
                 Disaster:=true;
                 Messagedlg('S46: Underflow in Begin stack',
                        mtError,[mbabort],0);
                 exit;
               end;
               if i1=40 then ConstructGraph
               else if i1=50 then ConstructPolarGraph
               else begin
                 disaster:=true;
                 Messagedlg('G3: Unidentified ending to a graph block',
                     mtError,[mbAbort],0);
                 exit
               end;
               SetGraph:=False; SetPolar:= False; {Reset dictionaries}
               SetGraphic:=True;
              end else begin
              disaster:=true;
              Messagedlg('G4: Error in ending a graph block',
                   mtError,[mbAbort],0);
              end; {if BeginStack}
            end;   {A Graph Block}
          3:begin {fill}
            end;
          4:FullSize:=True; {fullsize flag}
          5:begin {hscale}
              If StringType[AtString+1] in [3 ..6] then
              begin
                 hscale:= StringValue[AtString+1];
                 FullSize:= False;
              end else begin
                 Disaster:= True;
                 Messagedlg('G5: Error in setting hscale',mtError,[mbAbort],0);
               end; {if StringType}
            end; {hscale}
          6:begin {key}
            end;
          7:begin {TextWidth}
             if (StringType[AtString+1] in [3 .. 6])
             then WidthOfText:= StringValue[AtString+1]
             else begin
              Messagedlg('G6: Illegal TextWidth parameter '
               + StringText[AtString+1], mtError,[mbAbort],0);
              Disaster:=true;
              exit;
             end;
            end; {TextWidth}
          8:NoBox:=True;
          9:begin {Size}
              If (StringType[atString+1] in [3 ..6])
                 and (StringType[AtString+2] in [3 ..6]) then
               begin
                 gxsize:= StringValue[AtString+1];
                 gysize:= StringValue[AtString+2];
               end else begin
                 Disaster:= True;
                 Messagedlg('G7: Error in graph size',mtError,[mbAbort],0);
               end; {if StringType}
            end; {size}
         10:begin {title}
              AtString:=Atstring+1;   {make this the starting point}
              repeat
               if StringType[atstring]=12 then   {Title Text}
               begin
                 GTitle:= StringText[atstring];
                 AtString:=AtString+1;
               end else if StringType[Atstring]=41 then{A Graph Parameter}
               begin
                 case Round(stringValue[AtString]) of
                  2:begin {colour}
                     if StringType[AtString+1] in [3 ..6,24] then
                     begin
                       GTitleColor:= round(StringValue[AtString+1]);
                       AtString:= AtString +2;
                     end else begin
                       Messagedlg('G8: Expecting a Title colour parameter',
                       mtError,[mbAbort],0);
                       Disaster:=True;
                       exit;
                     end;
                    end;
                  7:begin{hei}
                     if StringType[AtString+1] in [3 ..6] then
                     begin
                       GTitleHei:= round(StringValue[AtString+1]
                                          *0.56*Pixelspercm);
                       AtString:= AtString + 2;
                     end else begin
                       Messagedlg('G9: Expecting a Title height parameter',
                       mtError,[mbAbort],0);
                       Disaster:=True;
                       exit;
                     end;
                    end;
                  8:begin {offset}
                     if StringType[AtString+1] in [3 ..6] then
                     begin
                       GTitleOffset:= StringValue[AtString+1];
                       AtString:= AtString + 2;
                     end else begin
                       Messagedlg('G10: Expecting a Title offset parameter',
                       mtError,[mbAbort],0);
                       Disaster:=True;
                       exit;
                     end;
                    end;
                 12:begin {font}
                     if StringType[AtString+1]=12 then
                     begin
                       GTitleFontName:= StringText[AtString+1];
                       AtString:= AtString + 2;
                     end else begin
                       Messagedlg('G11: Expecting a Title Font name',
                       mtError,[mbAbort],0);
                       Disaster:=True;
                       exit;
                     end;
                    end;
                 13:begin {dist}
                     if StringType[AtString+1] in [3 ..6] then
                     begin
                       GTitleDist:= StringValue[AtString+1];
                       AtString:= AtString + 2;
                     end else begin
                       Messagedlg('G12: Expecting a Title distance parameter',
                       mtError,[mbAbort],0);
                       Disaster:=True;
                       exit;
                     end;
                    end;
                  else begin
                    Messagedlg('G13: Illegal Title Parameter',mtError,[mbAbort],0);
                    Disaster:=True;
                    exit;
                  end;
                 end; {case}
               end else begin
                Messagedlg('G14: Error in setting up Title',mtError,[mbabort],0);
                Disaster:=True;
                Exit;
               end; {if}
              until AtString>=NumOfSubStrings;
            end;
         11:begin {vscale}
              If StringType[AtString+1] in [3 ..6] then
              begin
                 vscale:= StringValue[AtString+1];
                 Fullsize:= False;
              end else begin
                 Disaster:= True;
                 Messagedlg('G15: Error in vscale',mtError,[mbAbort],0);
               end; {if StringType}
            end; {vscale}
         12:if i1=40 then SetUpAxis(x1Axis,1,AtString+1)
            else if i1=50 then SetUpAxis(r1Axis,1,AtString+1)
            else begin
              disaster:= True; {Axis setting commands}
              Messagedlg('G16: Error in setting x1 or r1 axis',
                 mtError,[mbAbort],0);
              exit;
            end;
         13:if i1=40 then SetUpAxis(x2Axis,2,AtString+1)
            else if i1=50 then SetUpAxis(r2Axis,2,AtString+1)
            else begin
              disaster:= True; {Axis setting commands}
              Messagedlg('G17: Error in setting x2 or r2 axis',
                 mtError,[mbAbort],0);
              exit;
            end;
         14:if i1=40 then SetUpAxis(y1Axis,3,AtString+1)
            else if i1=50 then SetUpAxis(r3Axis,3,AtString+1)
            else begin
              disaster:= True; {Axis setting commands}
              Messagedlg('G18: Error in setting y1 or r3 axis',
                 mtError,[mbAbort],0);
              exit;
            end;
         15:if i1=40 then SetUpAxis(y2Axis,4,AtString+1)
            else if i1=50 then SetUpAxis(r4Axis,4,AtString+1)
            else begin
              disaster:= True; {Axis setting commands}
              Messagedlg('G19: Error in setting y2 or r4 axis',
                 mtError,[mbAbort],0);
              exit;
            end;
         16:if i1=40 then SetUpAxis(z1Axis,5,AtString+1)
            else if i1=50 then SetUpAxis(a1Axis,5,AtString+1)
            else begin
              disaster:= True; {Axis setting commands}
              Messagedlg('G20: Error in setting z1 or a1 axis',
                 mtError,[mbAbort],0);
              exit;
            end;
         17:if i1=40 then SetUpAxis(z2Axis,6,AtString+1)
            else if i1=50 then SetUpAxis(a2Axis,6,AtString+1)
            else begin
              disaster:= True; {Axis setting commands}
              Messagedlg('G21: Error in setting z2 or a2 axis',
                 mtError,[mbAbort],0);
              exit;
            end;
     18..25:begin  {ShowDataAt}
             while (NumOfsubstrings >= AtString+1)   do
             begin
             if (StringType[Atstring] = 40)                and
                (Round(StringValue[Atstring]) in [18 ..25]) and
                (StringType[AtString+1] in [3 ..6])        then
             begin
               case Round(StringValue[AtString]) of
                 18:begin
                     If (NumOfSubStrings >= (AtString+2) )  and
                        (StringType[Atstring+2] in [3 ..6]) then
                     begin
                       ShowplotData:= True;
                       DataAtX:= StringValue[AtString+1];
                       DataAtY:= StringValue[AtString+2];
                     end else Disaster:= True;
                     AtString:=AtString+1;
                    end;
                 19:DRowStart:= Round(StringValue[AtString+1]);
                 20:DRowEnd:=   Round(StringValue[AtString+1]);
                 21:DRowStep:=  Round(StringValue[AtString+1]);
                 22:DColStart:= Round(StringValue[AtString+1]);
                 23:DColEnd:=   Round(StringValue[AtString+1]);
                 24:DColStep:=  Round(StringValue[AtString+1]);
                 25:DColwidth:= StringValue[AtString+1];
               end; {case}
              end else Disaster:= True;
              AtString:= AtString+2;
             end; {while}
             if Disaster then
             begin
              if Messagedlg('G22: Error in setting data display' +
                         ' - previous settings used.',mtError,
                         [mbOK,mbAbort],0) = mrAbort then exit;
             end;
            end;
         28:begin {Centreradius}
              if (i1=50) and (Stringtype[Atstring+1] in [3..6])
               and (Stringtype[Atstring+2] in [3..6,24])
               and (Stringtype[Atstring+3] in [3..6,24]) then begin
                centreradius:= StringValue[AtString+1];
                centrelinecolor:= Round(StringValue[AtString+2]);
                centrefillcolor:= Round(StringValue[AtString+3]);
              end else begin
                Disaster:= True;
                Messagedlg('G23: Error in setting central circle' +
                      ' for a polar plot.',mtError,[mbAbort],0);
                exit;
              end;
            end;
         end; {case i2}
        end; {if SetGraph or SetPolar}
       end; {graphs}
    44:begin {A dataset label}
        If (SetGraph or SetPolar) then SetDataPlot(AtString+1,Round(StringValue[AtString]))
        else Messagedlg('G24: Not in graph setup mode -command ignored',
                mtWarning,[mbOK],0);
       end;
    60:begin
        {Keys}
       end;
     end; {case i1}
  end; {If i1 = 1}
  if disaster then
   begin
    exit;
   end; {Disaster}
  end; {DoLine}

procedure SetUpdiagram(Var nextline:integer);
{This is only called during the initial drawing operation.}

var i,i1,i2,i3,i4,LastLine:integer;
    s4,s5:string;

begin
 Nextline:= 1;
 i1:= 1; i4:= 0;
 Disaster:= False;
 Halt:= False;
 for i:= 0 to 20 do
 begin
  with subroutine[i] do
  begin
   subname:= '';
   substart:= 0;
   subreturn:= 0;
   NumOfSubPars:= 0;
   subset:= False;
   for i2:= 0 to 20 do
   begin
     subparName[i2]:= '';
     subParType[i2]:= 0;
     subParValue[i2]:= 0;
   end; {for i2}
  end; {with subroutine}
 end; {for i:= 0 to 20}
 for i:=1 to 3 do
 begin
    SubStringNum:=0;
    i3:=0;
    LastLine:=NextLine;
    s4:= GetLine(Nextline);
    if Disaster then begin
       Str(NextLine:5,s5);
       Messagedlg('I1: Error in reading source line' + s5 + 'during startup',
                    mtError,[mbAbort],0)
    end else  Analyse(s4,SubStringNum);
    if Disaster then begin
       Str(NextLine:5,s5);
       Messagedlg('I2: Unidentified parameter in source line' + s5
       + 'during startup',  mtError,[mbAbort],0)
    end else DoStart(i4,SubStringNum);
 end;
 if i4<>7 then Disaster:= True;  { i4 is an error flag set in DoStart}
 if Disaster then
 begin
   Messagedlg('I3: The set of source lines used during startup is incorrect ',
               mtError,[mbAbort],0);
   EditForm.EditMemo.lines.insert(NextLine,'! *** ----------------- ***');
   EditForm.EditMemo.lines.insert(Nextline+1,
                                  '! Run aborted - error in initiating file');
   i1:=i1+2;
 end else begin
    InitXorg:= XWinOrigin; NewXorg:= XWinOrigin;
    InitYOrg:= YWinOrigin; NewYOrg:= YWinOrigin;
    InitXSize:= WindowWidth; NewXSize:= WindowWidth;
    InitYSize:= WindowHeight; NewYSize:= WindowHeight;
    InitZoom:= 1.0;
    Zoomfactor:= 1.0;
    XOffset:= 0.0;  YOffset:= 0.0;
    DisplayForm.Height:= Round(WindowHeight*PixelsPerCm)+110; {Set to allow
    space for panels}
    DisplayForm.Width:= Round(WindowWidth*PixelsperCm)+10;  {Slight increase
    in width introduced to cover borders}
    SetBitMaps(DisplayForm.Width,DisplayForm.Height);
    with CurrentTransform do
    begin
      Xorigin:= -XWinorigin;
      YOrigin:= -YWinOrigin;
    end;
    CurrentInvTransform:=InverseTransform(CurrentTransform);
    Ctrans[0]:= currentTransform;
 end;
end; {SetUpdiagram}

Procedure DrawDiagram(FirstLine:Integer);
 {Draws or redraws the current diagram}

var i,i1,i3,i4,j,k,LastLine{,SubStringNum}:integer;
    s2,s3a,s3b,s4:String;
begin
 BeginNum:=0;       {Sets start of Begin Stack}
 BeginValue:=100;   {Sets initial count for unnamed Begins}
 ForLoopNum:=0;
 SubNumber:= 0;
 CurrentSubNumber:= -1;
 SubskipOn:=False;
 Disaster:= False;
 Halt:= False;
 SkipLine:=False;
 IfStatus[0].DoneIf:= False;
 IfLevel:= 0;
 IfStatus[0].SkipOn:= False;
 LocalLevel:= 0;
 LocalTextLevel:= 20;
 SetGraphic:=True;
 SetGraph:=False;
 SetPolar:= False;
 Centreradius:= 0.0;
 SetData:=False;
 ArrowStart:=False;
 ArrowEnd:=False;
 Arrowstyle:= 9;
 ArrowSize:= 0.01*PixelsPerCm;
 ArrowLinecolor:= Black;
 MarkerType:=2;
 MarkerSize:=Round(0.04*PixelsPerCm)+1;
 CTransFormNum:=0;  {Sets start of Transform Stack}
     with Ctrans[0] do
    begin;        {Reset Base of Transform stack}
{      XOrigin and Yorigin must not be reset here.
      They control window position relative to the graph }
      Xscale := 1.0;
      Yscale := 1.0;
      TranC:= 1.0; TranD:= 0;
      TranF:= 1.0; TranE:= 0;
      Rotation:= 0;
    end;
 If updatesettings then
  begin
    XOffset:= XWinOrigin-NewXorg;
    YOffset:= Ywinorigin-NewYorg;
    WindowWidth:= NewXSize;
    WindowHeight:= NewYSize;
    DisplayForm.Height:= Round(WindowHeight*PixelsPerCm)+110; {Set to allow for panels}
    DisplayForm.Width:= Round(WindowWidth*PixelsperCm)+10;  {Slight increase to cover borders}
    SetBitMaps(DisplayForm.Width,DisplayForm.Height);
    Updatesettings:= False;
  end;
  {Now set parameters for screen point transforms. Note that
   DisplayHeight is set by procedure SetBitMaps.}
   SpA:= ZoomFactor*PixelsPerCm;
   SpB:= XOffset*SpA ;
   SpC:= DisplayHeight - YOffset*Spa;
   SpE:= 1/Spa;
   SpF:= -XOffset;
   SpG:= DisplayHeight*SpE - YOffset;
 CurrentTransform:=Ctrans[0];
 CurrentInvTransform:=InverseTransform(CurrentTransform);
 CurrentPoint.x:=0.0;Currentpoint.y:=0.0;
 DrawStart := ScreenPoint(TransformPoint(CurrentTransform,CurrentPoint));
 DrawEnd:=DrawStart; LastEnd:=DrawStart;LastStart:=DrawStart;
 CurrentFont:=Tfont.create;
 CurrentFont.name:='Times New Roman';
 CurrentFont.Style:=[ ];
 CurrentFont.Size:=Round(0.2*PixelsPerCm);
 CurrentFont.Color:=clBlack;
 CurrentTransform:= Ctrans[0];
 WidthOfText:= 1.0;          {Sets initial Textwidth scaling}
 BrushBitmapSet:= False;  {Resets brush for next run.}
 Diagnostics := False; {Resets Diagnostics Flag}
 Amove(0,0);
  i1:=Firstline;   {i1 points to next line to be processed}
  i4:=EditForm.EditMemo.lines.count;
 repeat
  SubStringNum:=0;
  i3:=0;
  LastLine:=i1;
  s4:=Getline(i1);  {Note that i1 is updated within Getline by an
                     ammount dependent on number of comment lines
                     and number of continuation lines.}
  If  Disaster then
  begin
   EditForm.EditMemo.lines.insert(i1,'! *** ----------------- ***');
   EditForm.EditMemo.lines.insert(i1+1,'! Run aborted - error in file');
   i1:=i1+2;
   i4:=i4+2

  end;
  if not Disaster then
  begin
   Analyse(s4,SubStringNum);
   if Diagnostics then addline(0,SubStringNum); { Insert diagnostics. }
   if Disaster then
   begin
    EditForm.EditMemo.lines.insert(i1,'! *** ----------------- ***');
    EditForm.EditMemo.lines.insert(i1+1,'! Run aborted - Error in analysing line');
    i1:=i1+2;
    i4:=i4+2;
    exit;
   end;
  end; {if not Disaster}
  if not Disaster then
  begin
   DoLine(j,k,i1,SubStringNum,SkipLine);
      if Halt then
   begin
    EditForm.EditMemo.lines.insert(i1,'! *** ----------------- ***');
    EditForm.EditMemo.lines.insert(i1+1,'! Run halted');
    i1:=i1+2;
    i4:=i4+2;
    exit;
   end;
   if Disaster then
   begin
    EditForm.EditMemo.lines.insert(i1,'! *** ----------------- ***');
    EditForm.EditMemo.lines.insert(i1+1,'! Run aborted - Error in line syntax');
    i1:=i1+2;
    i4:=i4+2;
    exit;
   end;
  end; {if not Disaster}
 until (i1>=i4) or Disaster;
end;  {Draw}

procedure TEditForm.DrawBtnClick(Sender: TObject);
{Compiles listing and displays the resulting graphics}
begin
 try
   Screen.cursor:= crHourGlass;
   DisplayForm.Image1.Cursor:= crHourglass;
   SetGraphic:=True;
   SetGraph:=False;
   Setpolar:= False;
   SetData:=False;
   Setupdiagram(FirstLine);
   If not Disaster then  begin
     ClearBtnClick(Sender);
     DrawDiagram(FirstLine);
   end;
 finally
  Screen.Cursor:= crDefault;
  DisplayForm.Image1.Cursor:= crZoom;
  DisplayForm.ZoomBtnClick(sender);
 end;
end;

procedure TEditForm.HideBtnClick(Sender: TObject);
{Hides Edit form and shows graphics.}
begin
  EditForm.Hide;
  DisplayForm.Show;
end;

procedure TEditForm.GraphBtnClick(Sender: TObject);
{Displays graphics.}
begin
   DisplayForm.Show;
end;

procedure TEditForm.ClearBtnClick(Sender: TObject);
begin
  with DisplayForm.Image1 do
  begin  {Resets defaults prior to redrawing.}
     Picture.graphic:=Bitmap1;
     Canvas.Pen.Style:=psSolid;
     Canvas.Pen.Width :=1;
     Canvas.Pen.Color:=clBlack;
     Canvas.Brush.Style:=bsClear;
     BrushBitmapSet:= False; {May not be needed here.}
  end;
end;

procedure TEditForm.FormCreate(Sender: TObject);
{Initial program settings}
begin
  {Set initial form size - this is set to fit inside a VGA display.}
  Top:=40;
  Left:= 100;
  Height:= 400;
  Width:= 500;
  {set colours}
  GetColor[0] := Black;
  GetColor[1] := White;
  GetColor[2] := DarkRed;
  GetColor[3] := Red;
  GetColor[4] := LightRed;
  GetColor[5] := DarkGreen;
  GetColor[6] := Green;
  GetColor[7] := LightGreen;
  GetColor[8] := DarkBlue;
  GetColor[9] := Blue;
  GetColor[10]:= LightBlue;
  GetColor[11]:= DarkBrown;
  GetColor[12]:= Brown;
  GetColor[13]:= LightBrown;
  GetColor[14]:= Yellow;
  GetColor[15]:= DarkGrey;
  GetColor[16]:= Grey;
  GetColor[17]:= Silver;
  GetColor[18]:= Lightgrey;
  GetColor[19]:= MistGrey;
  GetColor[20]:= Maroon;
  GetColor[21]:= Olive;
  GetColor[22]:= Purple;
  GetColor[23]:= Fuschia;
  GetColor[24]:= Lime;
  GetColor[25]:= Aqua;
  GetColor[26]:= Primrose;
  GetColor[27]:= Parchment;
  GetColor[28]:= Gold;
  GetColor[29]:= OffWhite;
  GetColor[30]:= Lavender;
  GetColor[31]:= BlueTint;
  GetColor[32]:= GreenTint;
  GetColor[33]:= Pink;
  GetColor[34]:= $00FFFFFF; {Used with transparent lines etc.}
  GetColor[35]:= $00000000; {User defined colours - default is black}
  GetColor[36]:= $00000000;
  GetColor[37]:= $00000000;
  GetColor[38]:= $00000000;
  GetColor[39]:= $00000000;
  GetColor[40]:= $00000000;
  GetColor[41]:= $00000000;
  GetColor[42]:= $00000000;
  GetColor[43]:= $00000000;
  GetColor[44]:= $00000000;
  BmStyle:= 0;  {Initial setting of fillstyle}
  FCol1:= red;  {Inital settings of fill colours}
  Fcol2:= white;
  FColbk:= white;
 {set flags}
  SetGraphic:=True;
  SetGraph:=False;
  SetAxis:=False;
  SetAngleAxis:= False;
  SetPlot:=False;
  SetKey:=False;
  EditMemo.Modified:= False;
  SkipLine:= False;
  WidthOfText:=1.0;
  UpdateSettings:= False;
end;

procedure TEditForm.Save1Click(Sender: TObject);
{Saves listing.}
begin
  SaveDialog1.Filename := OpenDialog1.FileName;
  EditMemo.Lines.SavetoFile(SaveDialog1.FileName);
  Caption := 'Save as '+SaveDialog1.FileName;
  EditMemo.Modified:= False;
end;

procedure TEditForm.Saveas1Click(Sender: TObject);
{Saves listing under a new name.}
begin
  SaveDialog1.FileName:= 'Temp.Gle';
  if SaveDialog1.Execute then
  begin
    EditMemo.Lines.SavetoFile(SaveDialog1.FileName);
    Caption := 'Saved as '+SaveDialog1.FileName;
    EditMemo.Modified:= False;
  end;
end;

procedure TEditForm.Open1Click(Sender: TObject);
{Opens a listing.}
begin
 if EditMemo.modified then
  begin
  if Messagedlg(OpenDialog1.FileName + ' has been changed. Save new version?',
        mtConfirmation,[mbYes,mbNo],0)= mrYes then
             EditForm.Save1Click(sender);
  end;
 if OpenDialog1.Execute then
  begin
    EditMemo.Lines.LoadfromFile(OpenDialog1.FileName);
    SaveDialog1.Filename := OpenDialog1.FileName;
    EditForm.Caption := OpenDialog1.FileName;
    EditMemo.Modified:= False;
  end;
end;

procedure TEditForm.Delete1Click(Sender: TObject);
begin
  EditMemo.ClearSelection;
end;

procedure TEditForm.SetFontClick(Sender: TObject);
var  ln:integer;
     x:real;
     s1,s2:string;
begin
  if FontDialog1.execute then
  begin
    ln:= GetlineIndex;
    CurrentFont.Name:= FontDialog1.Font.Name;
    x:= FontDialog1.Font.Size/28;
    CurrentFont.size:= FontDialog1.Font.size;
    CurrentFont.Color:= FontDialog1.Font.Color;
    Str(x:10:6, s1);
    s2:= '$'+IntToHex(CurrentFont.Color,8);
  {Note. The test on ln is used to ensure that calls from GLE2000D, where
   ln may be set to zero when we attempt to add this statement, and that
   calls when the cursor is set at the last line are handled in a sensible
   manner.}
    if (ln>0) and (ln<editForm.EditMemo.Lines.count) then
    EditForm.EditMemo.Lines.insert(ln,' Set Font'+ ' "'+ CurrentFont.Name +'"  Hei '
    + s1 + ' fontcolor ' +  s2 + '  ')
    else
     EditForm.EditMemo.Lines.Add(' Set Font'+ ' "'+ CurrentFont.Name +'"  Hei '
     + s1 + ' fontcolor ' +  s2 + '  ');
  end;
end;

procedure TEditForm.New1Click(Sender: TObject);
{Starts a new listing.}
begin
 if EditMemo.modified then
 begin
  if Messagedlg(OpenDialog1.FileName + ' has been changed. Save new version?',
        mtConfirmation,[mbYes,mbNo],0)= mrYes then
             EditForm.Save1Click(sender);
 end;
 OpenDialog1.FileName:= 'New.GLE';
 EditMemo.Lines.Clear;
 SaveDialog1.Filename := OpenDialog1.FileName;
 EditForm.Caption := OpenDialog1.FileName;
 EditMemo.Lines.Add('! New GLE2000 Listing');
 EditMemo.Lines.Add('  Size         15 12');
 EditMemo.Lines.Add('  WindowOrigin 0  0');
 EditMemo.Lines.Add('  PixelsPerCm  50');
 EditMemo.Modified:= False;
end;

{Following define the conditions for update of cursor co-ordinate display.}
procedure TEditForm.EditMemoEnter(Sender: TObject);
begin
  GetCursorCoord;
end;
procedure TEditForm.EditMemoChange(Sender: TObject);
begin
  GetCursorCoord;
end;
procedure TEditForm.EditMemoKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  GetCursorCoord;
end;
procedure TEditForm.EditMemoKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  GetCursorCoord;
end;
procedure TEditForm.EditMemoMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  GetCursorCoord;
end;
procedure TEditForm.EditMemoMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  GetCursorCoord;
end;
procedure TEditForm.EditMemoClick(Sender: TObject);
begin
  GetCursorCoord;
end;

procedure TEditForm.Exit1Click(Sender: TObject);
begin
 if EditMemo.modified then
 begin
  if Messagedlg(OpenDialog1.FileName + ' has been changed. Save new version?',
        mtConfirmation,[mbYes,mbNo],0)= mrYes then
             EditForm.Save1Click(sender);
  end;
  Close;
end;

procedure TEditForm.Close1Click(Sender: TObject);
begin
  Close;
end;

procedure TEditForm.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  if EditMemo.modified then
    begin
     if Messagedlg(OpenDialog1.FileName + ' has been changed. Save new version?',
         mtConfirmation,[mbYes,mbNo],0)= mrYes then
             EditForm.Save1Click(sender);
    end;
  if MessageDlg('Close GLE2000 ?', mtConfirmation,
    [mbOk, mbCancel], 0) = mrCancel then
     CanClose := False;
end; {formCloseQuery  }

procedure TEditForm.About1Click(Sender: TObject);
begin
   if not About.Visible then About.Show
    else About.Hide;
end;

procedure TEditForm.AboutClick(Sender: TObject);
begin
  About.hide;
end;

procedure TEditForm.AboutDblClick(Sender: TObject);
begin
  About.hide;
end;

procedure TEditForm.Help2Click(Sender: TObject);
begin
  Application.HelpFile := 'GLE2000';
  Application.HelpCommand(HELP_CONTENTS, 0);
end;

procedure TEditForm.C1Click(Sender: TObject);
begin
  Application.HelpFile := 'GLE2000Coms';
  Application.HelpCommand(HELP_CONTENTS, 0);
end;

procedure TEditForm.ErrorMessages1Click(Sender: TObject);
begin
  Application.HelpFile := 'GLE2000Err';
  Application.HelpCommand(HELP_CONTENTS, 0);
end;

procedure TEditForm.Conversions1Click(Sender: TObject);
begin
  Application.HelpFile := 'GLE2000Cnvrt';
  Application.HelpCommand(HELP_CONTENTS, 0);
end;

procedure TEditForm.Print1Click(Sender: TObject);

  var
  Line: Integer;
  PrintText: TextFile;   {declares a file variable}
begin
  if PrintDialog1.Execute then
  begin
    AssignPrn(PrintText);   {assigns PrintText to the printer}
    Rewrite(PrintText);     {creates and opens the output file}
    Printer.Canvas.Font := EditMemo.Font;  {assigns Font settings to the canvas}
    for Line := 0 to EditMemo.Lines.Count - 1 do
    Writeln(PrintText, EditMemo.Lines[Line]); {Writes the contents of
                                               the Memo1 to the printer object}
    CloseFile(PrintText); {Closes the printer variable}
  end;
end;

procedure TEditForm.Name1Click(Sender: TObject);

var
  ln:integer;
  NewString: string;
  ClickedOK: Boolean;
begin
  ln:= GetLineIndex;
  NewString := '';
  ClickedOK := InputQuery('Set Font', 'Enter Font Name', NewString);
  if ClickedOK then
  begin
   CurrentFont.Name:= NewString;
  { See comment in  TEditForm.setFontClick}
   if (ln>0) and (ln<EditForm.EditMemo.Lines.count) then
    EditForm.EditMemo.Lines.insert(ln,' Set Font'+ ' "'+ CurrentFont.Name +'" ')
   else
    EditForm.EditMemo.Lines.add(' Set Font'+ ' "'+ CurrentFont.Name +'" ');
  end;
end;

procedure TEditForm.Colour1Click(Sender: TObject);
var
  ln:integer;
  s1:string;
begin
  If ColorDialog1.Execute then
  begin
    ln:= GetLineIndex;
    CurrentFont.Color:= ColorDialog1.Color;
    s1:= '$'+IntToHex(ColorDialog1.Color,8);
    { See comment in TEDitForm.SetFontClick}
    if (ln>0) and (ln<EditForm.EditMemo.lines.count) then
    EditForm.EditMemo.Lines.insert(ln,' Set FontColor ' + s1)
    else EditForm.EditMemo.Lines.add(' Set FontColor ' + s1);
  end;
end;

procedure TEditForm.Height1Click(Sender: TObject);

var
  h:double;
  ln,Ecode:integer;
  NewString: string;
  ClickedOK: Boolean;
begin
  NewString := '';
  ClickedOK := InputQuery('Set Font Height', 'Enter height 9cms)', NewString);
  if ClickedOK then
  begin
   ln:=GetLineIndex;
   Val(NewString,h,Ecode);
   if Ecode=0 then
   begin
    CurrentFont.size:= round(h*0.56*PixelsPerCm);
    {See comment in TEditForm.SetFontClick}
    if (ln>0) and (ln<=EditForm.EditMemo.Lines.count) then
    EditForm.EditMemo.Lines.insert(GetLineIndex,' Set hei  ' + NewString)
    else
    EditForm.EditMemo.Lines.add(' Set hei  ' + NewString);
   end;
  end;

end;

procedure TEditForm.Fill1Click(Sender: TObject);
begin
  FillsForm.show;
end;

procedure SetLineStyle(i:integer);
var ln:integer;
    s1:string;
begin
   ln:= EditForm.GetLineIndex;
   Str(i:2,s1);
   SetPenStyle(i);
   if (ln>0) and (ln<=EditForm.EditMemo.Lines.count) then
    EditForm.EditMemo.Lines.insert(EditForm.GetLineIndex,
                                   ' Set Linestyle ' + s1)
   else
    EditForm.EditMemo.Lines.add(' Set linestyle ' + s1);
end; {SetLineStyle}

procedure TEditForm.transparent1Click(Sender: TObject);
begin
   setLineStyle(0);
end;

procedure TEditForm.Solid1Click(Sender: TObject);
begin
   setLineStyle(1);
end;

procedure TEditForm.Dash1Click(Sender: TObject);
begin
   setLineStyle(2);
end;

procedure TEditForm.Dot1Click(Sender: TObject);
begin
   setLineStyle(3);
end;

procedure TEditForm.Dashdot1Click(Sender: TObject);
begin
  setLinestyle(4);
end;

procedure TEditForm.Dashdotdot1Click(Sender: TObject);
begin
   setLineStyle(5);
end;

procedure TEditForm.Insideframe1Click(Sender: TObject);
begin
   setLineStyle(6);
end;

procedure TEditForm.Colour2Click(Sender: TObject);

var
  ln:integer;
  s1:string;
begin
  If ColorDialog1.Execute then
  begin
    ln:= GetLineIndex;
    DisplayForm.Image1.Canvas.Pen.Color:= ColorDialog1.Color;
    s1:= '$'+IntToHex(ColorDialog1.Color,8);
    { See comment in TEDitForm.SetFontClick}
    if (ln>0) and (ln<EditForm.EditMemo.lines.count) then
    EditForm.EditMemo.Lines.insert(ln,' Set LineColor ' + s1)
    else EditForm.EditMemo.Lines.add(' Set LineColor ' + s1);
  end;

end;

procedure TEditForm.Width1Click(Sender: TObject);

var  ln,code:integer;
     w:double;
    s1:string;

begin
  ln:= GetLineIndex;
  s1:= InputBox('Line width', 'Width in cm', '0.01');
  Val(s1, w, Code);
  { Error during conversion to integer? }
  if code <> 0 then
  begin
    MessageDlg('U1: Error in entering line width', mtError, [mbAbort], 0);
    Disaster:=True;
    Exit;
  end else begin
    DisplayForm.Image1.Canvas.Pen.Width:= Round(PixelsPerCm*w);
    if (ln>0) and (ln<EditForm.EditMemo.lines.count) then
    EditForm.EditMemo.Lines.insert(ln,' Set LineWidth ' + s1)
    else EditForm.EditMemo.Lines.add(' Set LineWidth ' + s1);
  end;
end;

end.
