unit GLE2000T;
{Utilities for GLE2000
 Version GLE2000H2 D. Ingram 12th May 2000
  Includes string expessions. Function codes now numeric.
  Log, log10 and ^ now protected against overflow.}
interface

uses
   SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics,
   Controls,Forms, Dialogs, Tabs, ExtCtrls, {Style1, MrkStyle,}
   StdCtrls, Menus,{Symbols,} Spin, Buttons;

const
    Degree=57.2957795130823208767;
    DegToRad=1.0/Degree;  {only used in Graph - circa line 357}
    Exp1=  2.7182818284590452353;
    Gamma=  0.5772156649015328606;
    LogE=   0.4342944819032518277;
    MaxBegins= 100;                     //Size of Begin Stack
    MaxForLoops= 25;
    MaxRepeats=  25;
    MaxWhiles=   25;
    MaxIfs=      20;
    Maxsubs=     20;
    NumOfMarkers=42;
    NumOfcolors= 44;
    NumOfFills = 40;
    NumOfStrings=100;                  {Number of substrings in a line }
    CurveDef=100;                      {Number of point defining a curve}
    Pi =     3.1415926535897932384;
    TwoPi = 2.0*Pi;
    AngleMeasure:double=Degree;          { Set to Degree if in degrees or }
    SigFigs:integer=6;                { to 1.0 if in Radians }
    DecFigs:integer=3;
  {colour constants}
    Black      = $00000000;
    White      = $00FFFFFF;
    DarkRed    = $000000CE;
    Red        = $000000FF;
    LightRed   = $00A0A0FF;
    DarkGreen  = $00077000;
    Green      = $00009900;
    LightGreen = $0000CE00;
    DarkBlue   = $00800000;
    Blue       = $00FF0000;
    LightBlue  = $00FEFAA8;
    DarkBrown  = $000060A8;
    Brown      = $000090E0;
    LightBrown = $0070C0FF;
    Yellow     = $0000FFFF;
    DarkGrey   = $00505050;
    Grey       = $00808080;
    Silver     = $00C0C0C0;
    LightGrey  = $00E0E0E0;
    MistGrey   = $00F0F0F0;
    Maroon     = $00000080;
    Olive      = $00008080;
    Purple     = $00A000A0;
    Fuschia    = $00FF00FF;
    Lime       = $0000FF00;
    Aqua       = $00FFFF00;
    Primrose   = $00CAFFFF;
    Parchment  = $00E0FFFF;
    Gold       = $0017BAFF;
    OffWhite   = $00F8F8F8;
    Lavender   = $00FFF0F8;
    BlueTint   = $00FFFFF0;
    GreenTint  = $00E6FFE6;
    Pink       = $00CDCDFF;

type Mrkrs= Array[0 .. NumOfMarkers] of String;
     clrs = Array[0 .. NumOfColors]  of String;
     fls= Array[0 .. NumOfFills] of String;

     RealPoint = Record
       x:double;
       y:double;
     end;

     ForLoopData = Record
       ForVariable:String;
       StartLine:integer;
       StartValue,EndValue,StepValue:double;
     end;

     IfRecord = Record
       SkipOn,DoneIf:Boolean;
     end;

     sub = Record    {Used to set array Subroutine[] - see below}
      subName:String;
      substart,subreturn,LastSubNumber,NumOfSubPars:integer;
      subValue:double;
      subSet:Boolean;
      subParname: array[0 .. 25] of string;
      subPartype: array[0 .. 25] of integer;
      subParvalue: array[0 .. 25] of double;
     end;

const
   Markers:mrkrs=('circle','triangle','square','diamond','pentagon',
                  'hexagon','octagon','star','fcircle','ftriangle',
                  'fsquare','fdiamond','fpentagon','fhexagon','foctagon',
                  'fstar','club','spade','heart','dot',
                  'cross','snake','dag','ddag','asterisk',
                  'oplus','ominus','otimes','odot','trianglez',
                  'squarez','diamondz','wcircle','wtriangle','wsquare',
                  'wdiamond','wpentagon','whexagon','woctagon','wstar',
                  'sqdot','dmddot','plus');
   colors:clrs = ('black','white','darkred','red','lightred',
                 'darkgreen','green','lightgreen','darkblue','blue',
                 'lightblue','darkbrown','brown','lightbrown','yellow',
                 'darkgrey','grey','silver','lightgrey','mistgrey',
                 'maroon','olive','purple','fuschia','lime',
                 'aqua','primrose','parchment','gold','offwhite',
                 'lavender','bluetint','greentint','pink','clear',
                 'colr0','colr1','colr2','colr3','colr4',
                 'colr5','colr6','colr7','colr8','clr9');
 ColorTitles:clrs = ('Black','White','Darkred','Red','Lightred',
                 'Darkgreen','Green','Lightgreen','Darkblue','Blue',
                 'Lightblue','Darkbrown','Brown','Lightbrown','Yellow',
                 'Darkgrey','Midgrey','Grey','Silver','Lightgrey',
                 'Maroon','Olive','Purple','Fuschia','Lime',
                 'Aqua','Primrose','Parchment','Gold','Offwhite',
                 'Lavender','Bluetint','Greentint','Pink','Clear',
                 'colr0','colr1','colr2','colr3','colr4',
                 'colr5','colr6','colr7','colr8','clr9');
   fills:fls   = ('clear','solid','rightdiagonal','leftdiagonal','squares',
                  'diamonds','horizontals','verticals','fineverticals',
                  'verticalbars',
                  'thickverticalbars','finehorizontals','horizontalbars',
                  'thickhorizontalbars','finesquares',
                  'thicksquares','largesquares','hollowsquares',
                  'thickhollowsquares','finesquaremesh',
                  'squaremesh','solidcircles','hollowcircles',
                  'fineleftdiagonals','leftdiagonalbars',
                  'thickleftdiagonalbars','finerightdiagonals',
                  'rightdiagonalbars','thickrightdiagonalbars',
                  'finediamondmesh',
                  'thickdiamondmesh','smalldiamonds','bigdiamonds',
                  'diagonalweave','verticalweave',
                  'horizontalzigzag','thickhorizontalzigzag','verticalzigzag',
                  'thickverticalzigzag','horizontaltriangles',
                  'verticaltriangles');
 FillTitle:fls = ('Clear','Solid','Right diagonal','Left diagonal','Squares',
                  'Diamonds','Horizontals','Verticals','Fine verticals',
                  'Vertical Bars',
                  'Thick Vertical Bars','Fine Horizontals','Horizontal Bars',
                  'Thick Horizontal Bars','Fine Squares',
                  'Thick Squares','Large Squares','Hollow Squares',
                  'Thick Hollow Squares','Fine Square Mesh',
                  'Square Mesh','Solid Circles','Hollow Circles',
                  'Fine Left Diagonals','Left Diagonal Bars',
                  'Thick Left Diagonal Bars','Fine Right Diagonals',
                  'Right Diagonal Bars','Thick Right Diagonal Bars',
                  'Fine Diamond Mesh',
                  'Thick Diamond Mesh','Small Diamonds','Big Diamonds',
                  'Diagonal Weave','Vertical Weave',
                  'Horizontal Zigzag','Thick Horizontal Zigzag',
                  'Vertical Zigzag','Thick Vertical Zigzag',
                  'Horizontal Triangles',
                  'Vertical Triangles');


 var
  out1,out2,out3:string;
  SetAxis,SetAngleAxis,SetGraph,SetPolar,SetGraphic,SetKey,{Used in line parsing}
  SetData,SkipLine,LastSkip,SubSkipOn,
  SetLineStyle,   {could be in implimentation}
  SetPlot,SetPlotStyle,{Set plot flags data input, SetPlotStyle flags plot style}
  AxisSet,KeySet,Diagnostics,Disaster,Halt,Inaccurate,
  ExpressionIsString,UpdateSettings:Boolean;
  {Used in line parsing}
  BeginNum,BeginValue,      {Level & Value in Begin stack }
  ForLoopNum,ForLoopValue,  {ditto for   ForLoop}
  FirstLine,  {Start of actual diagram}
  CurrentSubNumber, {Global variable used in Unit GLE2000E}
  IfLevel:Integer;          {Level in IF Stack}
  StringIndex,LastIndex,LocalLevel,LocalTextlevel,subnumber:integer;
  NewXorg,NewYorg,NewXsize,NewYsize,zoomfactor,
  SpA,SpB,SpC,SpE,SpF,SpG,  {Parameters for Screen point conversions}
  InitZoom, InitXOrg, InitYOrg, InitXsize, InitYsize:double; {Window settings}
  WidthOfText:double;
  StringType,LastType:Array[0 .. NumOfStrings] of integer;
  StringText,LastText:Array[0 .. NumOfStrings] of string;
  StringValue,LastValue:Array[0 .. NumOfStrings] of double;
  Getcolor: array[0 .. 50] of integer;
  ForLoopStack:array[0 .. MaxForLoops] of ForLoopData;
  RepeatStack:array[0 ..MaxRepeats] of integer; {Only need to record start line}
  WhileStack:array[0 .. MaxWhiles] of integer; { ditto }
  IfStatus:array[0 .. MaxIfs] of IfRecord;
  {Stack used to check begin/end matchings}
  BeginStack: array[ 0 .. MaxBegins] of integer;
  subroutine: array[0 .. MaxSubs] of sub;
  vv:array[0 .. 275] of double;  {used for global variables }
  vw:array[0 .. 390] of double;  {used for local variables }
  vwt:array[0 .. 101] of string;

   Function Atan2(x,y:double):double;
   {Returns arctangent for full range 0 to 2Pi}

   Function Sign(x:double):integer;
   {Sign of a real number}

   Function Isign(x:integer):integer;
   {Sign of an integer number}

   Function RPoint(x,y:double):RealPoint;
   {Sets value of a real point to x,y}

   Procedure MatMult (a,b,c,d:double;var Ta,Tb,Tc,Td:double);
   {Premultiplies 2x2 matrix Ta,tb,tc<td by matrix a,b,c d
    and returns result as in place of original matrix}

   Procedure SetVariableValue(Vs:String; var vl:double; var Vtext:String);
   {Sets the variable Vs to Value vl
    This version modified for use in GLE95.}

   function  Expression(SExp:String;Var ReturnedString:String;
     Var StringReturned:Boolean;Var Ecode,Ecode1,Ecode2:Integer):double;
   {Attempts to evalate the value of a string repesentation of an expression }

   Procedure ResetPars(Rst:integer);
  {Resets parameters
     Rst = 2 Resets Angle and Output number Format
     Rst = 1 Resets Other parameters
     Rst = 3 Resets everything.}

   procedure RemoveQuotes(Var ss:string);
   {Removes Quotes from a simpleString}

   Procedure Analyse(s1:string;var StringNum:integer);
  {Analyses a string into its constituent components and attempts to
   express each component as a command, variable, function, etc.}

   Function GetLine(Var LineNum:Integer):String;
  { This starts at line number LineNum and attempts to construct
   a compound line by adding continuation lines and skipping
   comment lines. If successful the result is returned as the
   function. Non catastrophic failures allow optional continuation.
   Catastrophic failures also set the Global Flag 'Disaster'.
   Various error messages may be returned.}

  implementation
   uses GLE2000E,GLE2000G,GLE2000D;   { Watch this!}

  const
    DrawLine=
    '!-----------------------------------------------------------------------';
    MaxLineCount  =  10;
    NumOfAxisPars = 64;
    NumOfCmds     = 26;
    NumOfConst    = 12;
    NumOfFns      = 64;
    NumOfGraphics = 75;
    NumOfGraphs   = 25;
    NumOfpolars   = 28;
    NumOfGPars    = 22;
    NumOfPlotpars = 42;
    NumOfKeys     = 10;
    NumOfBgns     = 30;
    NumOfBoxes    =  3;
    NumOfJusts    = 11;
    NumOfLines    =  4;
    NumOfSetngs   = 37;
    Quit          =  3;
    Radian        =  1.0;    { Only used once - circa line 2866}
  type
    cmds     = Array[0 .. NumOfCmds]     of String;
    constnts = Array[0 .. NumOfConst]    of String;
    fns      = Array[0 .. NumOfFns]      of String;
    grphcs   = Array[0 .. NumofGraphics] of String;
    grphs    = Array[0 .. NumOfGraphs]   of String;
    plrs     = Array[0 .. NumOfPolars]   of string;
    grphprs  = Array[0 .. NumOfGPars]    of String;
    kys      = Array[0 .. NumOfKeys]     of String;
    bgn      = Array[0 .. NumOfBgns]     of String;
    bxs      = Array[0 .. NumOfBoxes]    of String;
    jst      = Array[0 .. NumOfJusts]    of String;
    lns      = Array[0 .. NumOfLines]    of String;
    pltpars  = Array[0 .. NumOfPlotpars] of String;
    stngs    = Array[0 .. NumOfSetngs]   of String;
    Symbols  = Set of Char;
    Stops    = Set of char;
    xpars    = array[0 .. NumOfAxisPars] of String;
  const
   Graphics:grphcs=('aline','amove','arc','arcto','begin',
               'bezier','bigfile','box','circle','closepath',
               'curve','define','dfont','ellipse','pixelspercm',
               'end','windoworigin','apolyline','rpolyline','fill',
               'fillto','fillover','xgsave','xgrestore','xgreset', //gsave etc.
               'x4x','include','input','join','let',              //deactivated
               'marker','move','narc','newpath','displayat',
               'piechart','apolygon','rpolygon','rbezier','print',
               'region','pasteat','reverse','rline','rmove',
               'saveas','set','size','square','dotspercm',
               'text','textwidth','use','copyfrom','write',
               'xaxis','x2axis','yaxis','y2axis','zaxis',
               'z2axis','fopen','fclose','apline','apmove',
               'rpline','rpmove','raxis','r2axis','r3axis',
               'r4axis','aaxis','a2axis','star','rnpolygon',
               'getdata');

    Graphs:grphs=('bar','data','end','fill','fullsize',
               'hscale','setkey','textwidth','nobox','size',
               'title','vscale','xaxis','x2axis','yaxis',
               'y2axis','zaxis','z2axis','showdataat','fromrow',
               'torow','steprowby','fromcol','tocol','stepcolby',
               'colwidth');

    Polars:plrs=('xxxxxx','data','end','fill','fullsize',
                 'hscale','setkey','textwidth','nobox','size',
                 'title','vscale','raxis','r2axis','r3axis',
                 'r4axis','aaxis','a2axis','showdataat','fromrow',
                 'torow','steprowby','fromcol','tocol','stepcolby',
                 'xinnerradiusx','xouterradiusx','xendatangle',
                 'centrecircle');

    {There should be no common graph (or polar) and axis parameters}
    AxisPars:xpars=('color','font','format','hei','length',
               'linewidth','linecolor','linestyle','dticks','dsubticks',
               'dmidticks','dgrid','dsubgrid','dmidgrid','tickstart',
               'subtickstart','midtickstart','gridstart','subgridstart',
                        'midgridstart',
               'nticks','nmidticks','nsubticks','ngrids','nmidgrids',
               'nsubgrids','max','min','dist','side',
               'ticks','midticks','subticks','grid','midgrid',
               'subgrid','angle','title','log','linear',
               'negate','nofirst','nolast','on','off',
               'labels','midlabels','names','places','start',
               'end','shift','offset','midplaces','prob',
               'float','fix','symmetric','normal','polar',
               'startatangle','stepangleby','endatangle',
                       'innerradius','outerradius');
    {There should be no common graph and plot parameters}
    PlotPars:pltpars=('autoscale','line','marker','err','errwidth',
                      'errup','errdown','from','herr','herrwidth',
                      'herrleft','herrright','key','linestyle','linewidth',
                      'linecolor','border','size','XmkrlinecolorX','fillcolor',
                      'nomiss','smooth','smoothm','xmin','xmax',
                      'ymin','ymax','xaxis','x2axis','yaxis',
                      'y2axis','zaxis','z2axis','r1axis','r2axis',
                      'r3axis','r4axis','a1axis','a2axis','use',
                      'xiscol','on','off');
    {these parameters may be same as axis and plot parameters   }
    GraphPars:grphprs=('linestyle','linewidth','color','xxxx','xxxx',
                        'xxxx','pos','hei','offset','from',
                        'xtox','xstepx','font','dist','on',
                        'grid','log','min','max','dpoints',
                        'length','xxxxx','xxxxx');

      DataOps:symbols=['*','+','-','/','<','>','^','_','|'];

   keys:kys=('offset','position','text','linestyle','marker',
             'msize','mscale','color','hei','fill',
             'nobox');

   Beginnings:bgn=('origin','rotate','scale','translate','graph',
                   'polarplot','smithchart','local','box','clip',
                   'key','path','table','text','fill',
                   'add','name','stroke','width','xaxis',
                   'x2axis','yaxis','y2axis','zaxis','z2axis',
                   'raxis','r2axis','r3axis','r4axis','aaxis','a2axis');
   { use codes  25 on for FOr loop, REPEAT, WHILE, and IF structures}
   Boxes:bxs=('fill','justify','nobox','name');

   JustTo:jst=('left','centre','right','tl','tc','tr',
        'lc','cc','rc','bl','bc','rc');

   Lines:lns=('arrow','start','end','both','none');

   Settings:stngs=('cap','but','round','square','fontcolor',
      'dashlen','fillstyle','fillcolor','font','fontlinewidth',
      'hei','join','mitre','round','bevel',
      'just','linewidth','linestyle','linecolor','arrowstyle',
      'arrowlinecolor','arrowfillcolor','arrowsize','roman','froman',
      'wroman','greek','fgreek','wgreek','norman',
      'fnorman','wnorman','saxon','fsaxon','wsaxon',
      'fill2color','fillbcolor','color');
  {MathPad commands used for evaluating expressions }
   MPComs:cmds=('now','settings','=','diagnostics','clear',
                'degrees','radians','fix','float','x1x',
                'for','to','step','next','repeat',
                'until','while','endwhile','goto','return',
                'if','elseif','else','endif','sub',
                'endsub','halt');
  {MP functions}
    MPfns:fns=('now$(','abdate(','date$(','left$(',
      'right$(','seg$(','num$(','cut$(','chr$(',       { '1' to '9'}
      'abs(','atn(','cos(','exp(','floor(','int(','len(',
      'log(','log10(','not(','pos(','rnd(','sgn(','sin(',
      'sqr(','sqrt(','tan(','val(','acos(','asin(','atn2(',
      'cosh(','sinh(','tanh(','acosh(','asinh(',        {'A' to 'Z'}
      'atanh(','erf(','erfc(','si(','ci(','gamma(',
      'lgamma(','fact(','bjn(','bkn(','bin(','byn(',
      'bico(','frc(','frs(','round(','setcol(','xxx','time$(','cdate$(',
      'insert$(','twidth(','theight(','xg(','yg(','xxx',   {'a' to 'z'}
      'rg(','ag(','xxxx','xxxx');
  {MP variables}
    Letters:Symbols=['a','b','c','d','e','f','g','h','i','j','k',
    'l','m','n','o','p','q','r','s','t','u','v','w','x','y','z','$'];
  {Standard terminators}
    Stop1:Symbols=[' ',';'];
  {Extended terminators}
    Stop2:Symbols=[' ',',',';','('];
    Stop3:Symbols=[',',';',')'];
  {Maths operators}
    MathOps:Symbols=['+','-','~','*','/','^'];
    LogOps:Symbols=['>','<','=','|','&'{,'','',''}];
    Digits:Symbols=['0','1','2','3','4','5','6','7','8','9'];
    HexDigits:Symbols=['0','1','2','3','4','5','6','7','8','9',
                       'a','b','c','d','e','f'];
    AddOps:Symbols=['+','-'];
    Constants:constnts=('pie','rad','deg','exp','loge',
                        'ln10','ntodb','xx1','xx2','yx1',
                        'yx2','zx1','zx2');
    var
      i,j,k,l,m,n,ii,LastCommandNumber,kommand,VariableEnd,
      StartStringAt,EndStringAt,Laststart,Linepos,StringLength,
      code,code1,code2,codea,codeb,codec,Fval,SetVariable,
      ErrorNumber:integer;
      a,b,c,d,e,f,g,h,o,p,q,r,s,t,u,v,w,x,y,z,vb,VarValue:double;
      s2,s3,s4,LastVariable:string;
      ValueSet,AssignVariable,CommaFound,ShStrings,lstructure,
      emessage,enumber:Boolean;
      MPad:TextFile;
    {Used in Maths Fns}
      glntop: longint;
      gla: ARRAY [1..33] OF double;
      glna: ARRAY [1..100] OF double;


function atan2(x,y:double):double;
{Returns arctangent for range 0 to 2Pi}

var z:double;

begin
    try
      if x=0 then
        if (y>0)  then z:=Pi/2 else z:=-Pi/2
      else z:=arctan(y/x);
      if x<0 then z:=Pi+z;
      atan2:=z;
    except
      atan2:=0;
      Messagedlg('M1: Invalid arguments in atan2',                       //M1
      mtError,[mbOK],0);
    end;
end;  {atan2}

function FindNextChar(Position,SLength:integer;SLine:String;
           EndChars:Symbols):integer;
{ Scans Sline staring at position StartAt and returns
  the position of the next non-space character.
  The space characters are defined by the set EndChars }

begin
  if (Position = 0) then Position:= succ(Position);
  while ( (Position<SLength) and (SLine[Position] in EndChars))
    do Position := succ(Position);
  if Position >= Slength then Position := 0;
  FindNextChar := Position;
 end; {FindNextChar}

function FindNextSpace(Position,SLength:integer;SLine:String;
           EndChars:Symbols):integer;
{ Scans Sline staring at position StartAt and returns
  the position of the next space character.
  The space characters are defined by the set Endchars }

begin
  while (Position<SLength) and not( SLine[Position] in EndChars )
    do Position := succ(Position);
  if Position >= SLength then Position := SLength;
  FindNextSpace := Position;
 end; {FindNextSpace}

 Function Sign(x:double):integer;
 {Sign of a real number}
 begin
   if x>0.0 then Sign:=1 else if x<0.0 then Sign:=-1 else Sign:=0;
 end; {Sign(x)}

 Function Isign(x:integer):integer;
 {Sign of an integer number}
 begin
   if x>0 then Isign:=1 else if x<0 then Isign:=-1 else Isign:=0;
 end; {Sign(x)}

 Function RPoint(x,y:double):RealPoint;
 {Sets value of a real point to x,y}
 begin
    RPoint.x:=x;
    RPoint.y:=y;
 end; {RPoint}

 Procedure MatMult (a,b,c,d:double;var Ta,Tb,Tc,Td:double);
 {Premultiplies 2x2 matrix Ta,tb,tc<td by matrix a,b,c d
  and returns result as in place of original matrix}
 var Ta1,Tb1:double;

 begin
   Ta1:= a*Ta + b*Tc;  Tb1:= a*Tb + b*Td;
    Tc:= c*Ta + d*Tc;   Td:= c*Tb + d*Td;
    Ta:= Ta1;  Tb:= Tb1;
 end;

 Function GetVariableName(StartAt:integer;Var EndAt,ReturnCode,
            Ecode,Ecode1:integer;Vs:OpenString;EndChars:symbols):string;
{Checks one or two locations from Startat for a variable name .
 If found returns the name as a string. Otherwise returns
 Ecode =1 Stop codes are defined by EndChars
 Return code is -1 for a numeric variable, -2 for string variable
 below -10 for a constant name and positive for a function}

 var sf:string;
      Linepos:integer;

 begin
   Ecode1:=0;ReturnCode:=-1;
   if  Vs[StartAt] in Letters then
   begin
     if (length(Vs)=1) or (Vs[StartAt+1] in EndChars) then begin
       GetVariableName := Vs[StartAt];
       EndAt:= StartAt+1;
     end else if ((length(Vs)=2) or (Vs[StartAt+2] in EndChars )) and
                 (Vs[StartAt+1] in Digits)  then begin
       GetVariableName:=Vs[StartAt]+Vs[StartAt+1];
       EndAt:= StartAt+2;
     end else if ((length(Vs)=2) or (Vs[StartAt+2] in EndChars )) and
                 (Vs[StartAt+1] = '$')
     then begin { A Simple String Variable }
       GetVariableName:=Vs[StartAt]+Vs[StartAt+1];
       EndAt:= StartAt+2; ReturnCode:= -2;
     end else begin {Variable name not found - test for function}
       Ecode1 := 1;
       GetVariableName:='';
       EndAt:=StartAt+1;
       while  (Vs[EndAt]<>'(') and (Vs[EndAt]<>#13)
             and ( (EndAt-StartAt)<11) and not (Vs[EndAt] in
             MathOps+Stop1+Stop3+LogOps) do EndAt:=Succ(EndAt);
       If Vs[EndAt]='(' then begin  {A function detected}
         Ecode1:=0;
         sf:=Copy(Vs,StartAt,EndAt-StartAt+1);
         LinePos:=-1;{Returncode:=-1;}
         repeat
           linePos:=succ(LinePos);
           if MPfns[Linepos]=sf then ReturnCode:=LinePos;
         until (LinePos=NumOfFns) or (ReturnCode>=0);
       end else if Vs[EndAt]<>'(' then begin  {Check for a constant name}
         sf:=Copy(Vs,StartAt,EndAt-StartAt);
         LinePos:=-1;{Returncode:=-1;}
         Ecode1:=0;
         repeat
           linePos:=succ(LinePos);
           if Constants[Linepos]=sf then
           begin
             ReturnCode:= (LinePos+10); {Return code above 10 for a constant}
             GetVariableName:=sf;
           end;
         until (LinePos=NumOfConst) or (ReturnCode>=0);
        if (ReturnCode=-1) then begin  {Check for a colour constant}
         LinePos:=-1;{Returncode:=-1;}
         repeat
           linePos:=succ(LinePos);
           if Colors[Linepos]=sf then
           begin
             ReturnCode:=(LinePos+10); {Return code above 10 for a constant}
             GetVariableName:=sf;
           end;
         until (LinePos=NumOfColors) or (ReturnCode>=0);
        end;
          If ReturnCode>=10 then ReturnCode:= -ReturnCode;
        { ReturnCode must be less than 0 for a constant }
       end else begin             {variable name, or colour}
         Ecode1:=2;
         Disaster:=True;
         messagedlg('M2: Unrecognised variable, constant or function',   //M2
          mtError,[mbAbort],0);
          Exit;
       end;
    end;
   end;
   if Ecode=0 then Ecode:=Ecode1;
  end; {GetVariableName}

Procedure GetVariableValue(Vs:openString;Var Vvalue:double;
                           Var Vtext:String;Var Ecode,Ecode1:integer);
{Evaluates the variable defined by Vs}
var i1,i2,ReturnCode:integer;
xx:double;
ch:char;
Vstring:String;

begin
 Ecode1:=0;
 xx:=0;
 i1:=length(Vs);
  If ((i1=0) {or (i1>2)}) then
  begin
    Ecode1:=3;
  end else if (i1=1) then
  begin
    i2:=Ord(Vs[1])-96;
    if i2 in [1 .. 26] then
    begin
      xx:= vw[i2+LocalLevel]; VString:= '';
    end else Ecode:=4;
  end else if (i1=2) then
  begin
   if Vs[2]='$' then
   begin
     i2:= Ord(Vs[1])-97;
     if (i2<0) or (i2>25) then Ecode:=5
     else
     begin
       xx:=i2;
       VString:= vwt[i2];
     end;
   end else
   begin
      i2:=(Ord(Vs[1])-97)*10+Ord(Vs[2])-48;
      if (i2<0) or (i2>270) then Ecode:= 5
      else
      begin
       xx:=vv[i2];
       VString:= '';
      end;
   end; {if Vs[2]='$'}
  end else if i1>2 then {A constant}
  begin
      LinePos:=-1;Returncode:=-1; Vstring:= '';
      repeat
        linePos:=succ(LinePos);
        if Constants[Linepos]=Vs then
        begin
          ReturnCode:=LinePos;
          case ReturnCode of
            0:xx:=Pi;
            1:xx:=1.0/Degree;
            2:xx:=Degree;
            3:xx:=Exp1;
            4:xx:=LogE;
            5:xx:=2.30258509299405;
            6:xx:=20*LogE;
          end; {case}
        end;
      until (LinePos=NumOfConst) or (ReturnCode>=0);
      if Returncode<0 then {Check for a color constant}
      LinePos:=-1;Returncode:=-1;
      repeat
        linePos:=succ(LinePos);
        if Colors[Linepos]=Vs then
        begin
          ReturnCode:=LinePos;
          case ReturnCode of
  {          0:xx:=Pi;
            1:xx:=1.0/Degree;
            2:xx:=Degree;
            3:xx:=Exp1;
            4:xx:=LogE;
            5:xx:=2.30258509299405;
            6:xx:=20*LogE; }
            0:xx:= $00000000;
            1:xx:= $00FFFFFF;
            2:xx:= $000000CE;
            3:xx:= $000000FF;
            4:xx:= $00A0A0FF;
            5:xx:= $00077000;
            6:xx:= $00009900;
            7:xx:= $0000CE00;
            8:xx:= $00800000;
            9:xx:= $00FF0000;
           10:xx:= $00FEFAA8;
           11:xx:= $000060A8;
           12:xx:= $000090E0;
           13:xx:= $0070C0FF;
           14:xx:= $0000FFFF;
           15:xx:= $00505050;
           16:xx:= $00808080;
           17:xx:= $00C0C0C0;
           18:xx:= $00E0E0E0;
           19:xx:= $00F0F0F0;
           20:xx:= $00000080;
           21:xx:= $00008080;
           22:xx:= $00A000A0;
           23:xx:= $00FF00FF;
           24:xx:= $0000FF00;
           25:xx:= $00FFFF00;
           26:xx:= $00CAFFFF;
           27:xx:= $00E0FFFF;
           28:xx:= $0017BAFF;
           29:xx:= $00F8F8F8;
           30:xx:= $00FFF0F8;
           31:xx:= $00FFFFF0;
           32:xx:= $00E6FFE6;
           33:xx:= $00CDCDFF;
          end; {case}
        end;
      until (LinePos=NumOfColors) or (ReturnCode>=0);

  end else begin
     Disaster:=True;
     Messagedlg('M3: Unknown variable or constant',mterror,[mbAbort],0);  //M3
     Exit;
  end; {if i1}
    Vvalue:=xx;
    Vtext:= Vstring;
    if Ecode=0 then Ecode:=Ecode1;
 end; {GetVariableValue}

 Procedure SetVariableValue(Vs:String; var vl:double; var Vtext:String);
{Sets the variable Vs to Value vl
 This version has been modified for use in GLE95 by
 removing references to output strings and using a message box
 to report errors. }
var i1,i2,iv:integer;
ch:char;
 sg:double;
begin
 sg:=Sign(vl);
 i1:=length(Vs);
  If ((i1=0) or (i1>2)) then
  begin
    Disaster:=True;  {String is wrong length for a variable}
    MessageDlg('M4: Error in setting variable.',mtError,[mbAbort],0);     //M4
  end else if (i1=1) then
  begin
    i2:=Ord(Vs[1])-96;
    if i2 in [ 9 .. 14] then     {Check for integer overflow}
    begin
     if abs(vl)> 2.1e9 then
     begin
      if MessageDlg('M5: Integer Overflow. Set result to +/-2.1e9',       //M5
            mtError,[mbOK,mbAbort],0)= mrAbort then
              begin
                Disaster:=True;
                iv:=0;
              end else  begin
                iv:=2100000000*sign(vl);
                Inaccurate:=True;
              end;
     end else iv := round(vl); {End of overflow check}
      vl:=iv; { reset to integer value}
    end;
    if i2 in [1 ..26] then vw[i2+LocalLevel]:= vl
      else Disaster:=True;
  end else if (i1=2) then
  begin
   if Vs[2]='$' then
   begin
    i2:= Ord(Vs[1])-97;
    if (i2<0) or (i2>25) then
    begin
       Disaster:=True;
       MessageDlg('M6: Error in string variable name.',                 //M6
         mtError,[mbAbort],0);
    end else begin
        vl:= i2;
       vwt[i2]:= vtext;
    end;
   end else begin
     i2:=(Ord(Vs[1])-97)*10+Ord(Vs[2])-48;
     if (i2<0) or (i2>270) then
     begin
        Disaster:=True;
        MessageDlg('M7: Error in double character variable name.',      //M7
          mtError,[mbAbort],0);
     end else begin
        vv[i2]:=vl;
      {  vtw[i2]:= '';  }
     end;
   end; { if Vs[2]='$'}
  end; {if i1}
  if Disaster then exit;
 end; {SetVariableValue}

Procedure GetNumber(NStart:Integer;Var NEnd, Ecode,Errcode:Integer;S:string;
                    EndChars:Symbols;var V:double);
{ Takes a string which has a digit or '-' sign at location Nstart and
  extracts a number from it. Returns the next location following the
  number in the string. The number is terminated by a right bracket
  or arithmetic operator. If O.K. Ecode = 0.0
  If an error returns Ecode as non-zero:
      Ecode = 10 if start character was not a digit.
      Ecode = 11 if a number was not identified.
      Ecode >= 12 if evaluation of the number failed.
                 Value then gives error location }
var Vtemp:double;
    s1:string;
begin
   Nend:=Nstart;
   if (s[Nstart] in  digits ) then
   begin
    Errcode := 0;
     while (Errcode=0) and (s[Nend] in digits) do
       begin
        Nend:= succ(Nend);
        if (s[Nend]='.') then begin
          if (s[Nend+1] in digits) then Nend:=succ(Nend)
          else Errcode:=11;
        end;
        if (s[Nend]='E') or (s[Nend]='e') then begin
           if (s[Nend+1] in Digits) then Nend:=succ(Nend) else
           if ((s[Nend+1]='+') or (s[Nend+1]='-')) and (s[Nend+2] in digits)
             then
               Nend:=Nend+2
           else Errcode:=12;
        end;
       end; {while}
       If Errcode=0 then {String identified}
          try
             Val(copy(s,Nstart,Nend-Nstart),Vtemp,Errcode);
             V:=Vtemp;
          except
            on  Eoverflow do
            begin
              if MessageDlg
                 ('M8: Overflow in evaluating number - set to 5.5E275', //M8
                 mtError,[mbOK,mbAbort],0)= 3 then
              begin
                Disaster:=True;
                V:=0.0;
              end else  begin
                V:=5.5E275;
                Inaccurate:=True;
              end;
            end else begin
                if MessageDlg( 'M9: Error in evaluating number - set to 1.0',
                   mtError,[mbOK,mbAbort],0)= 3 then                     //M9
                begin
                  Disaster:=True;
                  V:=0.0;
                end else  begin
                  V:=1.0;
                  Inaccurate:=True;
                end;
            end; {except and Errcode=0}
       end;
       if Errcode<>0 then
       begin
        V:=0.0;
        ErrCode:=ErrCode+40;
      end;
   end else if (s[Nstart]='$') and (s[Nstart+1] in hexdigits) then
   begin
    Nend:= succ(Nend);
    while (s[Nend] in hexdigits)do Nend:= succ(Nend);
   {Should have identified hexadecimal number - now evaluate it.}
    try
     s1:= copy(s,Nstart,Nend-Nstart);
     v:= StrToInt(s1);
    except
      if MessageDlg( 'M10: Error in evaluating hexadecimal string ' + s1  //M10
                + ' set to 1.0 ?',mtError,[mbOK,mbAbort],0)= 3 then
      begin
        Disaster:=True;
        V:=0.0;
      end else  begin
        V:=1.0;
        Inaccurate:=True;
      end;
    end; {except}
   end else Errcode:= 10; {end of if s{Nstart]}
  end; {GetNumber}

{Special Maths Functions}

FUNCTION gammln(xx: double): double;
CONST
   stp = 2.50662827465;
   half = 0.5;
   one = 1.0;
   fpf = 5.5;
VAR
   x,tmp,ser: double;
   j: integer;
   cof: ARRAY [1..6] OF double;
BEGIN
   cof[1] := 76.18009173;
   cof[2] := -86.50532033;
   cof[3] := 24.01409822;
   cof[4] := -1.231739516;
   cof[5] := 0.120858003e-2;
   cof[6] := -0.536382e-5;
   x := xx-one;
   tmp := x+fpf;
   tmp := (x+half)*ln(tmp)-tmp;
   ser := one;
   FOR j := 1 TO 6 DO BEGIN
      x := x+one;
      ser := ser+cof[j]/x
   END;
   gammln := (tmp+ln(stp*ser))
END;

FUNCTION factrl(n: integer): double;
(* Programs using routing FACTRL must declare the variables
VAR
   glntop: integer;
   gla: ARRAY [1..33] OF double;
and initialize the values
   glntop := 0;
   gla[1] := 1.0;
in the main routine. *)
VAR
   j: longint;
BEGIN
   IF  (n < 0)  THEN BEGIN
       ErrorNumber:=1;
       MessageDlg('M11: Argument of Factorial cannot be negative.',       //M11
       mterror,[mbOK],0);
   END
   ELSE IF (n <= glntop) THEN BEGIN
      factrl := gla[n+1] END
   ELSE IF (n <= 32) THEN BEGIN
      FOR j := glntop+1 TO n DO BEGIN
         gla[j+1] := j*gla[j]
      END;
      glntop := n;
      factrl := gla[n+1]
   END ELSE BEGIN
      factrl := exp(gammln(n+1.0))
   END
END;

FUNCTION factln(n: integer): double;
(* Programs using routine FACTLN must declare the array
VAR
   glna: ARRAY [1..100] OF double;
and must initialize the array to the values
   FOR i := 1 TO 100 DO glna[i] := -1.0;
in the main routine. *)
BEGIN
   IF  (n < 0) THEN BEGIN
     { writeln(#7);
      writeln (' pause in FACTLN - negative factorial'); readln} END
   ELSE IF (n <= 99) THEN BEGIN
      IF  (glna[n+1] <= 0.0) THEN  glna[n+1] := gammln(n+1.0);
      factln := glna[n+1] END
   ELSE BEGIN
      factln := gammln(n+1.0)
   END
END;

FUNCTION bico(n,k: integer): double;
BEGIN
   bico := round(exp(factln(n)-factln(k)-factln(n-k)));
END;

FUNCTION erfcc(x: double): double;
VAR
   t,z,ans: double;
BEGIN
   z := abs(x);
   t := 1.0/(1.0+0.5*z);
   ans := t*exp(-z*z-1.26551223+t*(1.00002368+
      t*(0.37409196+t*(0.09678418+t*(-0.18628806+
      t*(0.27886807+t*(-1.13520398+t*(1.48851587+
      t*(-0.82215223+t*0.17087277)))))))));
   IF (x >= 0.0) THEN erfcc := ans
   ELSE erfcc := 2.0-ans
END;

FUNCTION bessi0(x: double): double;
VAR
   ax: double;  y,ans: double;
BEGIN
   IF (abs(x) < 3.75) THEN BEGIN
      y := sqr(x/3.75);
      ans := 1.0+y*(3.5156229+y*(3.0899424+y*(1.2067492+y*
         (0.2659732+y*(0.360768e-1+y*0.45813e-2)))))  END
   ELSE BEGIN
      ax := abs(x);  y := 3.75/ax;
      ans := (exp(ax)/sqrt(ax))*(0.39894228+y*(0.1328592e-1
         +y*(0.225319e-2+y*(-0.157565e-2+y*(0.916281e-2
         +y*(-0.2057706e-1+y*(0.2635537e-1+y*(-0.1647633e-1
         +y*0.392377e-2))))))))  END;
   bessi0 := ans
END;

FUNCTION bessi1(x: double): double;
VAR
   ax: double;  y,ans: double;
BEGIN
   IF (abs(x) < 3.75) THEN BEGIN
      y := sqr(x/3.75);
      ans := x*(0.5+y*(0.87890594+y*(0.51498869+y*(0.15084934
         +y*(0.2658733e-1+y*(0.301532e-2+y*0.32411e-3)))))) END
   ELSE BEGIN
      ax := abs(x); y := 3.75/ax;
      ans := 0.2282967e-1+y*(-0.2895312e-1+y*(0.1787654e-1-y*0.420059e-2));
      ans := 0.39894228+y*(-0.3988024e-1+y*(-0.362018e-2
         +y*(0.163801e-2+y*(-0.1031555e-1+y*ans))));
      ans := (exp(ax)/sqrt(ax))*ans;
      IF (x<0.0) THEN ans := -ans  END;
   bessi1 := ans;
END;

FUNCTION bessi(n: integer; x: double): double;
CONST
   iacc=40;
   bigno=1.0e10;
   bigni=1.0e-10;
VAR
   bi,bim,bip,tox,ans: double;
   j,m: integer;
BEGIN
   IF  (n < 2) THEN BEGIN
     { writeln(#7);
      writeln(' pause in routine BESSI');
      writeln(' index n is less than 2'); readln }
   END;
   IF (x=0.0) THEN bessi := 0.0
   ELSE BEGIN
      ans := 0.0;
      tox := 2.0/abs(x);
      bip := 0.0;
      bi := 1.0;
      m := 2*(n+trunc(sqrt(iacc*n)));
      FOR j := m DOWNTO 1 DO BEGIN
         bim := bip+j*tox*bi;
         bip := bi;
         bi := bim;
         IF (abs(bi) > bigno) THEN BEGIN
            ans := ans*bigni;
            bi := bi*bigni;
            bip := bip*bigni
         END;
         IF (j=n) THEN ans := bip
      END;
      IF (x<0.0) AND ((n MOD 2)=1) THEN ans := -ans;
      bessi := ans*bessi0(x)/bi
   END;
END;

FUNCTION bessj0(x: double): double;
VAR
   ax,xx,z: double;  y,ans,ans1,ans2: double;
BEGIN
   IF (abs(x) < 8.0) THEN BEGIN
      y := sqr(x);
      ans1 := 57568490574.0+y*(-13362590354.0+y*(651619640.7
         +y*(-11214424.18+y*(77392.33017+y*(-184.9052456)))));
      ans2 := 57568490411.0+y*(1029532985.0+y*(9494680.718
         +y*(59272.64853+y*(267.8532712+y*1.0))));
      bessj0 := (ans1/ans2)  END
   ELSE BEGIN
      ax := abs(x); z := 8.0/ax; y := sqr(z); xx := ax-0.785398164;
      ans1 := 1.0+y*(-0.1098628627e-2+y*(0.2734510407e-4
         +y*(-0.2073370639e-5+y*0.2093887211e-6)));
      ans2 := -0.1562499995e-1+y*(0.1430488765e-3
         +y*(-0.6911147651e-5+y*(0.7621095161e-6
         -y*0.934945152e-7)));
      ans := sqrt(0.636619772/ax)*(cos(xx)*ans1-z*sin(xx)*ans2);
      bessj0 := ans  END;
END;

FUNCTION bessj1(x: double): double;
VAR
   ax,xx,z: double;  y,ans,ans1,ans2: double;
FUNCTION sign(x: double): double;
   BEGIN
      IF x >= 0.0 THEN sign := 1.0
      ELSE sign := -1.0;
   END;
BEGIN
   IF (abs(x) < 8.0) THEN BEGIN
      y := sqr(x);
      ans1 := x*(72362614232.0+y*(-7895059235.0+y*(242396853.1
         +y*(-2972611.439+y*(15704.48260+y*(-30.16036606))))));
      ans2 := 144725228442.0+y*(2300535178.0+y*(18583304.74
         +y*(99447.43394+y*(376.9991397+y*1.0))));
      bessj1 := (ans1/ans2)  END
   ELSE BEGIN
      ax := abs(x); z := 8.0/ax; y := sqr(z); xx := ax-2.356194491;
      ans1 := 1.0+y*(0.183105e-2+y*(-0.3516396496e-4
         +y*(0.2457520174e-5+y*(-0.240337019e-6))));
      ans2 := 0.04687499995+y*(-0.2002690873e-3
         +y*(0.8449199096e-5+y*(-0.88228987e-6+y*0.105787412e-6)));
      ans := sqrt(0.636619772/ax)*(cos(xx)*ans1
         -z*sin(xx)*ans2)*sign(x);
      bessj1 := ans  END
END;

FUNCTION bessj(n: integer; x: double): double;
CONST
   iacc=40;
   bigno=1.0e10;
   bigni=1.0e-10;
VAR
   bj,bjm,bjp,sum,tox,ans: double;
   j,jsum,m: integer;
BEGIN
   IF (n < 2) THEN BEGIN
  {    writeln(#7);
      writeln(' pause in BESSJ'); readln  }
   END;
   IF (x=0.0) THEN ans := 0.0
   ELSE IF (abs(x) > 1.0*n) THEN BEGIN
      tox := 2.0/abs(x);
      bjm := bessj0(abs(x));
      bj := bessj1(abs(x));
      FOR j := 1 TO n-1 DO BEGIN
         bjp := j*tox*bj-bjm;
         bjm := bj;
         bj := bjp
      END;
      ans := bj
   END ELSE BEGIN
      tox := 2.0/abs(x);
      m := 2*((n+trunc(sqrt(1.0*(iacc*n)))) DIV 2);
      ans := 0.0;
      jsum := 0;
      sum := 0.0;
      bjp := 0.0;
      bj := 1.0;
      FOR j := m DOWNTO 1 DO BEGIN
         bjm := j*tox*bj-bjp;
         bjp := bj;
         bj := bjm;
         IF (abs(bj) > bigno) THEN BEGIN
            bj := bj*bigni;
            bjp := bjp*bigni;
            ans := ans*bigni;
            sum := sum*bigni
         END;
         IF (jsum <> 0) THEN sum := sum+bj;
         jsum := 1-jsum;
         IF (j = n) THEN ans := bjp
      END;
      sum := 2.0*sum-bj;
      ans := ans/sum
   END;
   IF (x<0.0) AND ((n MOD 2)=1) THEN ans := -ans;
   bessj := ans;
END;

FUNCTION bessk0(x: double): double;
VAR
   y,ans: double;
BEGIN
   IF (x <= 2.0) THEN BEGIN
      y := x*x/4.0;
      ans := (-ln(x/2.0)*bessi0(x))+(-0.57721566+y*(0.42278420
         +y*(0.23069756+y*(0.3488590e-1+y*(0.262698e-2
         +y*(0.10750e-3+y*0.74e-5))))))  END
   ELSE BEGIN
      y := (2.0/x);
      ans := (exp(-x)/sqrt(x))*(1.25331414+y*(-0.7832358e-1
         +y*(0.2189568e-1+y*(-0.1062446e-1+y*(0.587872e-2
         +y*(-0.251540e-2+y*0.53208e-3))))))  END;
   bessk0 := ans;
END;

FUNCTION bessk1(x: double): double;
VAR
   y,ans: double;
BEGIN
   IF  (x <= 2.0)  THEN BEGIN
      y := x*x/4.0;
      ans := (ln(x/2.0)*bessi1(x))+(1.0/x)*(1.0+y*(0.15443144
         +y*(-0.67278579+y*(-0.18156897+y*(-0.1919402e-1
         +y*(-0.110404e-2+y*(-0.4686e-4)))))))  END
   ELSE BEGIN
      y := 2.0/x;
      ans := (exp(-x)/sqrt(x))*(1.25331414+y*(0.23498619
         +y*(-0.3655620e-1+y*(0.1504268e-1+y*(-0.780353e-2
         +y*(0.325614e-2+y*(-0.68245e-3)))))))  END;
   bessk1 := ans
END;

FUNCTION bessk(n: integer; x: double): double;
VAR
   tox,bkp,bkm,bk: double;
   j: integer;
BEGIN
   IF (n < 2) THEN BEGIN
  {    writeln(#7);
      writeln(' pause in routine BESSK');
      writeln(' index n less than 2'); readln }
   END;
   tox := 2.0/x;
   bkm := bessk0(x);
   bk := bessk1(x);
   FOR j := 1 TO n-1 DO BEGIN
      bkp := bkm+j*tox*bk;
      bkm := bk;
      bk := bkp
   END;
   bessk := bk
END;

FUNCTION bessy0(x: double): double;
VAR
   xx,z: double;  y,ans,ans1,ans2: double;
BEGIN
   IF (x < 8.0) THEN BEGIN
      y := sqr(x);
      ans1 := -2957821389.0+y*(7062834065.0+y*(-512359803.6
         +y*(10879881.29+y*(-86327.92757+y*228.4622733))));
      ans2 := 40076544269.0+y*(745249964.8+y*(7189466.438
         +y*(47447.26470+y*(226.1030244+y*1.0))));
      ans := (ans1/ans2)+0.636619772*bessj0(x)*ln(x);
      bessy0 := ans  END
   ELSE BEGIN
      z := 8.0/x; y := sqr(z); xx := x-0.785398164;
      ans1 := 1.0+y*(-0.1098628627e-2+y*(0.2734510407e-4
         +y*(-0.2073370639e-5+y*0.2093887211e-6)));
      ans2 := -0.1562499995e-1+y*(0.1430488765e-3
         +y*(-0.6911147651e-5+y*(0.7621095161e-6+y*(-0.934945152e-7))));
      ans := sin(xx)*ans1+z*cos(xx)*ans2;
      ans := sqrt(0.636619772/x)*ans;
      bessy0 := ans  END
END;

FUNCTION bessy1(x: double): double;
VAR
   xx,z: double;  y,ans,ans1,ans2: double;
BEGIN
   IF (x < 8.0) THEN BEGIN
      y := sqr(x);
      ans1 := x*(-0.4900604943e13+y*(0.1275274390e13
         +y*(-0.5153438139e11+y*(0.7349264551e9
         +y*(-0.4237922726e7+y*0.8511937935e4)))));
      ans2 := 0.2499580570e14+y*(0.4244419664e12
         +y*(0.3733650367e10+y*(0.2245904002e8
         +y*(0.1020426050e6+y*(0.3549632885e3+y*1.0)))));
      ans := (ans1/ans2)+0.636619772*(bessj1(x)*ln(x)-1.0/x);
      bessy1 := ans END
   ELSE BEGIN
      z := 8.0/x; y := sqr(z); xx := x-2.356194491;
      ans1 := 1.0+y*(0.183105e-2+y*(-0.3516396496e-4
         +y*(0.2457520174e-5+y*(-0.240337019e-6))));
      ans2 := 0.04687499995+y*(-0.2002690873e-3
         +y*(0.8449199096e-5+y*(-0.88228987e-6+y*0.105787412e-6)));
      ans := sqrt(0.636619772/x)*(sin(xx)*ans1+z*cos(xx)*ans2);
      bessy1 := ans END
END;

FUNCTION bessy(n: integer; x: double): double;
VAR
   by,bym,byp,tox: double;
   j: integer;
BEGIN
   IF (n < 2) THEN BEGIN
  {    writeln(#7);
      writeln(' pause in BESSY - index n less than 2'); readln   }
   END;
   tox := 2.0/x;
   by := bessy1(x);
   bym := bessy0(x);
   FOR j := 1 TO n-1 DO BEGIN
      byp := j*tox*by-bym;
      bym := by;
      by := byp
   END;
   bessy := by
END;

FUNCTION Si(x: double):double;
VAR
   t,z,z1,z2,z3,ans: double;
   y1:array[0 .. 7] of double;
   i,j:integer;

BEGIN
   z := abs(x);
   z2:=sqr(x);
   if z<1.5 then
   begin
     ans:=0;
     z1:=x;
     j:=1;
     z3:=1;
     for i:= 1 to 7 do
      begin
       z1:=-z1*z2;
       j:=j+2;
       z3:=z3*j*(j-1);
       y1[i]:=z1/(j*z3);
      end;
     for i:=7 downto 1 do
              ans:=ans+y1[i];
     Si:=ans+x;
   end else
   begin
     z1:= 38.102495+z2*(335.67732+z2*(265.187033+z2*(38.027264+z2)));
     z1:=z1/(z*(157.105423+z2*(570.23628+z2*(322.624911+z2*(40.021433+z2)))));
     z3:=21.821899+z2*(352.018498+z2*(302.757865+z2*(42.242855+z2)));
     z3:=z3/(z2*(449.690326+z2*(1114.978885+z2*(482.485984+z2*(48.196927+z2)))));
     z3:=Pi/2-z1*cos(z)-z3*sin(z);
     if x<0.0 then z3:=-z3;
     Si:=z3;
   end;
 END;  {Si(x) }

FUNCTION Ci(x: double):double;
VAR
   t,z,z1,z2,z3,ans: double;
   y1:array[0 .. 7] of double;
   i,j:integer;

BEGIN
   z := abs(x);
   z2:=sqr(x);
   if (z<1.5) and (z>1e-51) then
   begin
     ans:=0;
     z1:=1;
     j:=0;
     z3:=1;
     for i:= 1 to 7 do
      begin
       z1:=-z1*z2;
       j:=j+2;
       z3:=z3*(j-1)*j;
       y1[i]:=z1/(j*z3);
      end;
      ans:=0;
     for i:=7 downto 1 do ans:=ans+y1[i];
     Ci:=ans+gamma+ln(z);
   end else
   begin
     z1:= 38.102495+z2*(335.67732+z2*(265.187033+z2*(38.027264+z2)));
     z1:=z1/(z*(157.105423+z2*(570.23628+z2*(322.624911+z2*(40.021433+z2)))));
     z3:=21.821899+z2*(352.018498+z2*(302.757865+z2*(42.242855+z2)));
     z3:=z3/(z2*(449.690326+z2*(1114.978885+z2*(482.485984+z2*(48.196927+z2)))));
     z3:=z1*sin(z)-z3*cos(z);
     Ci:=z3;
   end;
 END;  {Ci(x) }

 procedure Fresnel(x:double;var f,g:double);
 {Calculates auxilliary functions for Fresnel integrals. See Boersma.
  Mathematical Computation Vol 14 p 380 }

 var y,y2,y3,y4,y5:double;

 begin
   If x<4.0 then
   begin
     y:= x/4;y2:=sqr(y);y3:=y*y2;
     y4:=sqr(y2);y5:=y*y4;
     f:=sqrt(y)*(1.59576914-1.702e-6*y-6.808568854*y2-5.76361e-4*y3
       +6.920691902*y4 +y5*(-0.016898657-3.05048566*y-0.075752419*y2
       +0.850663781*y3-0.025639041*y4-y5*(0.15023096-0.034404779*y)));
     g:= (-3.3e-8+4.255387524*y-9.281e-5*y2-7.7800204*y3-9.520895e-3*y4
         +y5*(5.075161298-0.138341947*y-1.363729124*y2-0.403349276*y3
         +0.702222016*y4-y5*(0.216195929-0.019547031*y)))*sqrt(y);
   end else begin
     y:= 4/x;y2:=sqr(y);y3:=y*y2;
     y4:=sqr(y2);y5:=y*y4;
     f:=sqrt(y)*(-0.024933975*y+3.936e-6*y2+5.770956e-3*y3+6.89892e-4*y4
        +y5*(-9.497136e-3+0.011948809*y-6.748873e-3*y2+2.4642e-4*y3
        + 2.102967e-3*y4-y5*(1.21793e-3-2.33939e-4*y)));
     g:=sqrt(y)*(0.19947114+2.3e-8*y-9.351341e-3*y2+2.3006e-5*y3
        +4.851466e-3*y4+y5*(1.903218e-3-0.017122914*y+0.029064067*y2
        -0.027928955*y3+0.016497308*y4-y5*(0.005598515-8.38386e-4*y)));
   end;
  end; {Fresnel}

 function FrC(x:double):double;
 {Fresnel Cosine integral. See Boersma. Mathematical Computation Vol 14 p 380}

 var f1,g1:double;

 begin
     x:=0.5*sqr(x)*Pi;
     Fresnel(x,f1,g1);
     if x<4.0 then Frc:=  f1*cos(x) + g1*sin(x)
     else FrC:= 0.5 + f1*cos(x) + g1*sin(x);
 end; {FrC(x)}

 function  FrS(x:double):double;
 {Fresnel Sine integral. See Boersma. Mathematical Computation Vol 14
  p 380}

 var f1,g1:double;

 begin
   x:=0.5*sqr(x)*Pi;
   Fresnel(x,f1,g1);
   If x<4.0 then Frs:= f1*sin(x) - g1*cos(x)
   else FrS := 0.5 +f1*sin(x) -g1*cos(x);
 end; {FrS(x)}

 function SetColor(i,j:integer;x:real):integer;
 {Sets an interpolated colour}
 var a1,a2,a3,b1,b2,b3,c1,c2,c3,d:integer;
 begin
     a1:= i mod 256;
     i:= i div 256;
     a2:= i mod 256;
     a3:= i div 256;
     b1:= j mod 256;
     j:= j div 256;
     b2:= j mod 256;
     b3:= j div 256;
     c1:= trunc(a1+(b1-a1)*x);
     c2:= trunc(a2+(b2-a2)*x);
     c3:= trunc(a3+(b3-a3)*x);
     setcolor:=c1+256*(c2+256*C3);
 end; {SetColor}

function  Expression(SExp:String;Var ReturnedString:string;
    Var StringReturned:Boolean;Var Ecode,Ecode1,Ecode2:Integer):double;
{Attempts to evalate the value of a string repesentation of an expression }

Var SLength,Spos,NPos,NextPos,TopOp,Maxop,TopNum,MaxNum,Fnum,ie,
    CurrentPrecedence,Kount,MaxKount,FnLevel:integer;
    Vn:double;
    Ch,Ch1,LastCh:Char;
    CurrentOp,OptoDo,ssf:word;
    ss,Vs2:string;
    OpFound,NumFound,FnFound,EndFound:Boolean;
    FnClass,NumOfArgs: array[0 .. 20] of integer;
    Number:Array[0 .. 20] of double;
    TextVariable:Array[0 .. 20] of string;
    IsString:Array[0 ..20] of Boolean;
    Operation:Array[0 .. 25] of word;
    Precedence:Array[0 .. 25] of integer;

Procedure CheckTopOp;
{Checks operation stack }
begin
  Ecode1:=0;
  If TopOp>MaxOp then
  begin
    Ecode1:=15;
    Messagedlg                                                           //M12
      ('M12: Operation stack overflow - expression is probably too complex',
                 mtError,[mbOK],0);
  end else if Topop<0 then begin
    Ecode1:=16;
    Messagedlg
      ('M13:Operation stack underflow - check the expression',          //M13
                 mtError,[mbOK],0);
  end;
  if Ecode=0 then Ecode:=Ecode1;
end; {CheckHTopOp}

Procedure CheckTopNum;
{Checks number stack }
begin
  Ecode1:=0;
  If TopNum>MaxNum then
  begin
    Ecode1:=17;
    Messagedlg                                                          //M14
      ('M14: Number stack overflow - expression is probably too complex',
                 mtError,[mbOK],0);
   end else if TopNum<0 then begin
    Ecode1:=18;
    Messagedlg                                                         //M15
      ('M15: Number stack underflow - check the expression',
                 mtError,[mbOK],0);
  end;
  if Ecode=0 then Ecode:=Ecode1;
end; {CheckTopNum}

Procedure RemoveSpace(i:integer);
{Removes a space or unwanted character from ss}
begin
   while (i<Slength) do
   begin
     Sexp[i]:=Sexp[i+1];
     i:=succ(i);
   end;
   Sexp[Slength]:=' ';   {Pad out string with spaces}
   SLength:= Pred(Slength)
 end; {RemoveSpace}

Procedure Stophere(c:string);
{ Diagnostic Tool  - Not normally used
  Must be altered for Win95 systems. }
begin
{  repeat until keypressed;     }
{  writeln(#7);
  writeln(' Stopped at ',c);
  writeln('       ****************'); }
{  readkey;     }
end; {Stophere}

{ Procedure ShowStacks;
{ Diagnostic outputs - not normally used }
{var i:integer;
    s1,s2,s3:string;
begin
       DgForm.show;

       DgForm.Diagnostics1.lines.add(' String: '+Sexp);
      DgForm.Diagnostics1.lines.add(' Current position: ' + IntToStr(Spos)
         +  '  Character: '+ char(Ch));
   {    i:=Topop;
       writeln(' Operation Stack');
       While i>=0 do
       begin
         writeln('   ', i,':  ',Operation[i],'  (',Precedence[i],')');
         i:=Pred(i);
       end;
       i:=TopNum;
       Writeln(' Number Stack');
       While i>=0 do
       begin
         writeln('    ',i,':   ',Number[i]);
         i:=pred(i);
       end;       }
{ end; {ShowStacks}

Procedure PerformOp;
{ Performs a mathematical operation }
var x,y,z,x1,y1:double;
    i,j:integer;
    ss1,ss2:string;
    Present: TDateTime;
    Year, Month, Day, Hour, Min, Sec, MSec: Word;

begin
  try
    if OptoDo in [49 .. 57, 65 .. 90,97 .. 122,131,132] then
    begin
       if FnClass[FnLevel]<>NumOfArgs[FnLevel] then
        Ecode1:=20 else begin
         FnClass[FnLevel]:=0;
         NumOfArgs[FnLevel]:=0;
         FnLevel:=Pred(FnLevel);
         If FnLevel<0 then Ecode1:=21 else Ecode1:=0;
        end;
    end;
    if Ecode1=0 then
    begin
    Case OptoDo of
     38:begin {Boolean AND  '&' }
          try
           if (Number[TopNum]>0) And (Number[TopNum-1]>0) then
               Number[TopNum-1]:=1.0 else Number[TopNum-1]:= 0;
           TopNum:=Pred(TopNum);
          except
           Messagedlg('M16: Error in AND Boolean Operation',             //M16
           mtError,[mbOK],0);
           Disaster:=True;
          end
         end;
     43:begin   {'+'}
          if  (Not IsString[TopNum]) and ( Not IsString[TopNum-1])
          then begin
           try
            Number[TopNum-1]:=Number[TopNum-1]+Number[TopNum];
           except
             On EOverflow do
             begin                                                     //M17
              if MessageDlg('M17: Addition Overflow. Result set as 5.5E305',
              mtError, [mbOK,mbAbort],0)= 3 then
              begin
                Disaster:=True;
                Number[Topnum-1]:=2.0;
              end else  begin
                Number[TopNum-1]:=5.3E305;
                Inaccurate:=True;
              end;
             end;
           end;
           TopNum:=Pred(TopNum);
          end else if (IsString[TopNum]) and (IsString[TopNum-1] )
          then begin
           TextVariable[TopNum-1]:= TextVariable[topNum-1]+TextVariable[TopNum];
           Isstring[TopNum]:= False;
           TextVariable[TopNum]:='';
           TopNum:= Pred(TopNum)
          end else begin                                               //M18
           MessageDlg('M18: Attempt to concatenate a string and a number',
              mtError,[mbAbort],0);
           Disaster:=True;
          end; {if}
        end;
     45:begin  {'-'}
          try
           Number[TopNum-1]:= Number[TopNum-1]-Number[TopNum];
          except
           ErrorNumber:=1;
           Messagedlg('M19: Error in subtraction operation',             //M19
           mtError,[mbOK],0);
           Disaster:=True;
           Number[TopNum-1]:=0.0;
          end;
          TopNum:=Pred(TopNum);
        end;
     42:begin   {'*'}
         try
          Number[TopNum-1]:=Number[TopNum-1]*Number[TopNum];
          TopNum:=Pred(TopNum);
         except
          Messagedlg('M20:Error in a multiplication operation',          //M20
                mtError,[mbOK],0);
          ErrorNumber:=1;
          Disaster:=True;
         end;
        end;
     47:begin    {'/'}
         try
          Number[TopNum-1]:=Number[TopNum-1]/Number[TopNum];
          TopNum:=Pred(TopNum);
         except
          on EZeroDivide do
          begin
           Messagedlg('M21: Division by zero',                          //M21
           mtError,[mbOK],0);
           Disaster:= True;
          end;
          on EOverflow do
          begin
           Messagedlg('M22: Overflow during a division operation',      //M22
           mtError,[mbOK],0);
           Disaster:=True;
          end
          else
           Messagedlg                                                   //M23
             ('M23: Unidentified error while performing a division operation',
               mtError,[mbOK],0);
          ErrorNumber:=1;
          Disaster:=True;
         end;
        end;
     49:begin  {current date}
          TextVariable[TopNum]:= FormatDatetime('" " hh:nn ddd d mmm yyyy ',
                                  Now + Int(Number[TopNum]));
          IsString[TopNum]:= True;
        end;
     50:begin  {Evaluate days since 30th Dec. 1899}
         try
          x:=encodedate(Round(Number[TopNum]),Round(Number[TopNum-1]),
           Round(Number[TopNum-2]));
          TopNum:=TopNum-2;
          Number[TopNum]:=x;
         except
          Messagedlg('M25: Invalid date',mtError,[mbOK],0);              //M25
          ErrorNumber:=1;
          Disaster:=True;
         end;
        end;
     51:begin  {Evalate date for given days relative to 30th Dec. 1899}
         If Number[TopNum]<-693593 then
         begin
          Messagedlg('M26: Date earlier thsn 1st Jan. 1 A.D.',           //M26
          mtError,[mbOK],0);
          ErrorNumber:=1;
          Disaster:=True;
         end else begin
          TextVariable[TopNum]:= FormatDateTime('dddd, d mmmm yyy',
           Number[topNum]);
          IsString[TopNum]:= True;
         end;
        end;
     52:begin   {left$}
         If (Not IsString[TopNum]) and (IsString[TopNum-1]) then
         begin
          TextVariable[TopNum-1]:= Copy(TextVariable[TopNum-1],1,
                        Round(Number[TopNum]));
          TopNum:= Pred(TopNum);
         end else begin
          Messagedlg('M28: Error in arguments for Left$ function',       //M28
             mtError,[mbAbort],0);
          Disaster:=True;
         end;
        end;
     53:begin   {rightt$}
         If (Not IsString[TopNum]) and (IsString[TopNum-1]) then
         begin
          TextVariable[TopNum-1]:= Copy(TextVariable[TopNum-1],
              Round(Number[TopNum]),
              Length(TextVariable[TopNum-1])-Round(Number[TopNum])+1);
          TopNum:= Pred(TopNum);
         end else begin
          Messagedlg('M29: Error in arguments for Right$ function',      //M29
            mtError,[mbAbort],0);
          Disaster:=True;
         end;
        end;
     54:begin   {seg$}
         If (Not IsString[TopNum]) and (Not IsString[TopNum-1])
          and (IsString[TopNum-2]) then
         begin
          TextVariable[TopNum-2]:= Copy(TextVariable[TopNum-2],
           Round(Number[TopNum-1]),Round(Number[TopNum]));
          TopNum:= TopNum-2;
         end else begin
          Messagedlg('M30: Error in arguments for Seg$ function',        //M30
             mtError,[mbAbort],0);
          Disaster:=True;
         end;
        end;
     55:begin   {num$}
         If Not IsString[TopNum] then
         begin
          Str(Number[TopNum]:Sigfigs:DecFigs,TextVariable[TopNum]);
          IsString[TopNum]:= True;
         end else begin
          Messagedlg('M31: Error in argument of Num$ function',         //M31
           mtError,[mbAbort],0);
          Disaster:=True;
         end; {if}
        end;
     56:begin  {cut$}
         If (Not IsString[TopNum]) and (Not IsString[TopNum-1])
            and (IsString[TopNum-2]) then
         begin
          Delete(TextVariable[TopNum-2],Round(Number[TopNum-1]),
            Round(Number[TopNum]));
          TopNum:= TopNum-2;
         end else begin
          Messagedlg('M32: Error in arguments for Cut$ function',      //M32
           mtError,[mbAbort],0);
          Disaster:=True;
         end;
        end;
     57:begin  {chr$}
         TextVariable[TopNum]:= chr(Round(Number[TopNum]));
         IsString[TopNum]:= True;
        end;
     60:begin {Boolean <}
         try
          if Number[TopNum]>Number[TopNum-1]then Number[TopNum-1]:=1.0
               else Number[TopNum-1]:= 0;
          TopNum:=Pred(TopNum);
         except                                                         //M35
          Messagedlg('M35: Error in < Boolean Comparison',mtError,[mbOK],0);
          Disaster:=True;
         end
        end;
     61:begin {Boolean = }
         try
          if Number[TopNum]=Number[TopNum-1]then Number[TopNum-1]:=1.0
          else Number[TopNum-1]:= 0;
          TopNum:=Pred(TopNum);
         except
          Messagedlg('M36: Error in = Boolean Comparison',              //M36
            mtError,[mbOK],0);
          Disaster:=True;
         end
        end;
     62:begin {Boolean >}
         try
          if Number[TopNum]<Number[TopNum-1]then Number[TopNum-1]:=1.0
          else Number[TopNum-1]:= 0;
          TopNum:=Pred(TopNum);
         except                                                          //M37
          Messagedlg('M37: Error in > Boolean Comparison',mtError,[mbOK],0);
          Disaster:=True;
         end
        end;
     65:{Abs}     Number[TopNum]:= Abs(Number[Topnum]);
     66:{Arctan}  Number[TopNum]:= Arctan(Number[Topnum])*AngleMeasure;
     67:begin {cos}
         x:=Number[TopNum]/AngleMeasure;
         if abs(x)>5E16 then
         begin                                                           //M40
          MessageDlg('M40: Angle exceeds 5e16 radians Cosine value invalid',
             mtError,[mbOK],0);
          Disaster:=True;
          Number[Topnum]:=1.0;
         end else if (abs(x)>5.0e7) then
         begin
          if MessageDlg(                                                //M41
                'M41: Angle exceeds 5e7 radians - cos will be inaccurate',
                 mtError,[mbOK,mbAbort],0)= 3 then
          begin
           Disaster:=True;
           Number[Topnum]:=1.0;
          end  else  begin
           Number[TopNum]:=cos(x);
           Inaccurate:=True;
          end;
         end else Number[TopNum]:= cos(x);
        end;
     68:begin  {exp}
         if Number[TopNum]<704
         then Number[TopNum]:= Exp(Number[Topnum])
         else begin                                                     //M42
          MessageDlg('M42: Exponential overflow - set to exp(704)',mtError,
               [mbOK],0);
          Number[Topnum]:=Exp(704);
          Inaccurate:= True;
         end;
        end;
     69:{floor}   Number[TopNum]:= Round(Number[Topnum]-0.5);
     70:{int}     Number[TopNum]:= Int(Number[Topnum]);
     71:begin  {len}
         Number[topNum]:=  Length(TextVariable[TopNum]);
         Isstring[topNum]:= False;
         TextVariable[TopNum]:='';
        end;
     72:{log} If Number[TopNum]>1.0e-300 then
                Number[TopNum]:= Ln(Number[Topnum])
        else begin                                                      //M43
            Messagedlg('M43: Argument of log function is zero or negative',
            mtError,[mbAbort],0);
           Disaster:= True;
        end;
     73:{log10}
        If Number[TopNum]>1.0e-300 then
           Number[TopNum]:= LogE*Ln(Number[Topnum])
        else begin                                                      //M44
           Messagedlg('M44: Argument of log10 function is zero or negative',
            mtError,[mbAbort],0);
           Disaster:= True;
        end;
     75:begin  {pos}
         if (IsString[TopNum]) and (IsString[TopNum-1]) then
         begin
          Number[TopNum-1]:= pos(TextVariable[TopNum-1],TextVariable[TopNum]);
          IsString[TopNum]:= False;
          TextVariable[TopNum]:= '';
          TopNum:= Pred(TopNum);
          IsString[TopNum]:= False;
          TextVariable[TopNum]:='';
         end else begin                                                 //M45
          MessageDlg('M45: Arguments of pos must both be string variables',
                 mtError,[mbAbort],0);
          Disaster:=True;
         end; {if}
        end;
     76:{rnd}
        if Number[TopNum]=0 then Number[TopNum]:= Random
        else Number[Topnum]:=Random(Round(Number[TopNum]));
     77:begin  {sgn}
         If Number[TopNum]>0 then Number[TopNum]:=1
         else if Number[TopNum]<0 then Number[TopNum]:=-1
         else Number[TopNum]:=0;
        end;
     78:begin  {sine}
         x:=Number[TopNum]/AngleMeasure;
         if abs(x)>5E16 then
         begin                                                          //M46
          MessageDlg('M46: Angle exceeds 5e16 radians, sine value invalid',
                mtError,[mbOK],0);
          Disaster:=True;
          Number[Topnum]:=1.0;
         end else if abs(x)>5.0e7 then
         begin
          if MessageDlg(                                                //M47
                'M47: Angle exceeds 5e7 radians - sine will be inaccurate',
                 mtError,[mbOK,mbAbort],0)= 3 then
          begin
           Disaster:=True;
           Number[Topnum]:=1.0;
          end else  begin
           Number[TopNum]:=sin(x);
           Inaccurate:=True;
          end;
         end else Number[TopNum]:= sin(x);
        end;
     79:{sqr}  Number[TopNum]:= Sqr(Number[Topnum]);
     80:{sqrt} Number[TopNum]:= Sqrt(Number[Topnum]);
     81:begin  {tan}
         x:=Number[TopNum]/AngleMeasure;
         if abs(x)>5E16 then
         begin
          MessageDlg
            ('M50: Angle exceeds 5e16 radians tangent value invalid',   //M50
              mtError,[mbOK],0);
          Disaster:=True;
          Number[Topnum]:=1.0;
         end else if abs(x)>5.0e7 then
         begin
          if MessageDlg(                                                //M51
              'M51: Angle exceeds 5e7 radians - tangent will be inaccurate',
                 mtError,[mbOK,mbAbort],0)= 3 then
          begin
           Disaster:=True;
           Number[Topnum]:=1.0;
          end else  begin
           try
            Number[TopNum]:=sin(x)/cos(x);
            Inaccurate:=True;
           except on EZeroDivide do
            begin                                                       //M52
             Messagedlg('M52: Overflow in evaluating tangent',mtError,[mbOK],0);
             Disaster:=True;
            end;{on EzeroDivide}
           end; {try except}
          end; {if Messgdlg}
         end else begin
          try
           Number[TopNum]:=sin(x)/cos(x);
          except
           on EZeroDivide do
           begin
            Messagedlg('M53: Overflow in evaluating tangent',           //M53
            mtError,[mbOK],0);
            Disaster:=True;
           end; {on EZeroDivide}
          end; {try except}
         end; { if abs(x))}
        end; {tan}
     83:begin {acos}
         x:=Number[TopNum];
         if (x>-1) and (x<1) then
         begin
          x:=sqrt(1-sqr(x))/x;
          Number[TopNum]:=arctan(x)*AngleMeasure;
         end else if (x=1) then Number[TopNum]:= 0
         else if x=-1 then Number[TopNum]:= Pi
         else begin
          Ecode1:=13;
          ErrorNumber:=1;                                               //M54
          MessageDlg('M54: Argument of acos is invalid',mtError,[mbOK],0);
          Disaster:=True;
         end;
        end;
     84:begin {asin}
         x:=Number[TopNum];
         if (x>-1) and (x<1) then
         begin
          x:=x/sqrt(1-sqr(x));
          Number[TopNum]:=arctan(x)*AngleMeasure;
         end else if x=1 then Number[TopNum]:= Pi/2
         else if x=-1 then Number[TopNum] := -Pi/2
         else begin
          Ecode1:=13;
          ErrorNumber:=1;
          Messagedlg('M55: Argument of asin is invalid',                //M55
                 mtError,[mbOK],0);
          Disaster:=True;
         end;
        end;
     85:begin  {atn2 - Evaluates for full 360 degrees}
         try
          x:= Number[TopNum-1];y:=Number[TopNum];
          if x=0 then
           if (y>0)  then z:=Pi/2 else z:=-Pi/2 else z:=arctan(y/x);
          if x<0 then z:=Pi+z;
          Number[TopNum-1]:=z*AngleMeasure;
          TopNum:=Pred(TopNum);
         except
          Ecode1:=14;
          ErrorNumber:=1;                                               //M56
          Messagedlg('M56: Invalid arguments in atan2',mtError,[mbOK],0);
          Disaster:=true;
         end;
        end;
     86:begin  {cosh}
         x:=Number[TopNum];
         if abs(x)>700 then
         begin                                                          //M57
           Messagedlg('M57: Overflow in argument of cosh - set to 700',
              mtError,[mbOK],0);
           x:=sign(x)*700;
           Inaccurate:=True;
         end;
         Number[TopNum]:=(exp(x)+exp(-x))*0.5;
        end;
     87:begin  {sinh}
         x:=Number[TopNum];
         if abs(x)>700 then
         begin
           Messagedlg('M58: Overflow argument of sinh - set to 700',    //M58
              mtError,[mbOK],0);
           x:=sign(x)*700;
           Inaccurate:=True;
         end;
         Number[TopNum]:=(exp(x)-exp(-x))*0.5;
        end;
     88:begin  {tanh}
         x:=Number[TopNum];
         if abs(x)>700 then
         begin
          Messagedlg('M59: Overflow argument of tanh - set to 700',     //M59
             mtError,[mbOK],0);
          x:=sign(x)*700;
          Inaccurate:=True;
         end;
         Number[TopNum]:=(exp(x)-exp(-x))/(exp(x)+exp(-x));
        end;
     89:begin  {acosh}
         x:=Number[TopNum];
         if x=1 then Number[TopNum]:=0
         else if x<1 then
         begin
          Messagedlg('M60: Invalid argument in acosh',mtError,[mbOK],0); //M60
          Disaster:=True;
         end else Number[TopNum] := ln(x+sqrt(sqr(x)-1));
        end;
     90:begin  {asinh}
         x:=abs(Number[TopNum]);
         y:=sign(Number[TopNum]);
         Number[TopNum]:= y*ln(x + sqrt(sqr(x)+1))
        end;
     94:begin   {'^'}
         try
          x:=Number[TopNum-1];
          if x<0 then i:=-1 else i:=1;
          x:= abs(x);
          if x>1.0e-300 then  {Guards against overflow in ln function}
           Number[TopNum-1]:=i*exp(ln(abs(x))*Number[TopNum])
          else Number[TopNum-1]:= 0.0;
          TopNum:=Pred(TopNum);
         except
          begin
           Messagedlg                                                   //M61
           ('M61: Unidentified error while performing an exponentiation',
               mtError,[mbOK],0);
           ErrorNumber:=1;
           Disaster:=True;
          end;
         end;
        end;
     97:begin  {atanh}
         x:=Number[TopNum];
         if abs(x)=1 then Number[TopNum] := 1e305*sign(x)
         else if abs(x)<1.0 then Number[TopNum]:= 0.5*ln((x+1)/(1-x))
         else begin
          Ecode1:=14;
          ErrorNumber:=1;
          Messagedlg('M62: Invalid argument in atanh',                //M62
                 mtError,[mbOk],0);
          Disaster:=true;
         end;
        end;
     98:begin  {Error function}
         x:=Number[TopNum];
         if x>1e100 then Number[TopNum] := 1.0
         else if x>=0 then Number[Topnum]:= 1-erfcc(x)
         else begin
          Ecode1:=14;
          ErrorNumber:=1;                                             //M65
          Messagedlg('M65: Argument of erf(x) must be > 0',mtError,[mbOK],0);
          Disaster:=True;
         end;
        end;
     99:begin    {Erfc(x)}
          x:=Number[TopNum];
          if x>=0 then Number[TopNum]:= erfcc(x)
          else begin
           Ecode1:=14;
           ErrorNumber:=1;
           Messagedlg('M66: Argument of erfc(x) must be > 0 ',        //M66
                  mtError,[mbOK],0);
           Disaster:=True;
          end;
         end;
     100:begin   {Si(x)}
          x:=Number[TopNum];
          if abs(x)>1.0e20 then x:=sign(x)*1.0e20;
          Number[TopNum]:= Si(x);
         end;
     101:begin   {Ci(x)}
          x:=Number[TopNum];
          if x>1.0e20 then x := 1.0e20;
          if x>1.0e-50 then Number[TopNum]:= Ci(x)
          else begin
           Ecode1:=14;
           ErrorNumber:=1;                                               //M67
           Messagedlg('M67: Argument of Ci(x) must be > 0 ',mtError,[mbOK],0);
           Disaster:=True;
          end;
         end;
     102:begin  {Gamma function}
          x:= Number[TopNum];
          if x>170 then begin
          {   Ecode1:=14;
              ErrorNumber:=1; }                                          //M68
           Messagedlg('M68: Overflow in argument of gamma(x)- set to gamma(170)',
                mtError,[mbOK],0);
           x:=170;
           Inaccurate:=True;
          end;
          if (x>=1) then Number[TopNum]:= exp(gammln(x))
          else if x>0 then begin
           y:=1-x;
           x:=exp(gammln(1+y));
           Number[TopNum]:=Pi*y/(x*sin(Pi*y));
          end else begin
           Ecode1:=14;
           ErrorNumber:=1;
           Messagedlg('M69: Argument of gamma(x) must be > 0 ',         //M69
             mtError,[mbOK],0);
          end;
         end;
     103:begin {Log Gamma function}
          x:=Number[TopNum];
          if x>0 then Number[TopNum]:=Gammln(x)
          else begin;
           Ecode1:=14;
           ErrorNumber:=1;
           Messagedlg('M70: Argument of log-gamma(x) must be > 0 ',     //M70
                    mtError,[mbOK],0);
           Disaster:=True;
          end;
         end;
     104:begin {Factorial}
          x:=Number[TopNum];
          if (x>=0) then begin
           if x>18 then begin
            ErrorNumber:=2;                                              //M71
            MessageDlg('M71: Only the first 16 digits of a factorial are valid',
            mtWarning,[mbOK],0);
            Inaccurate:=True;
           end else if x>170 then
           begin
            MessageDlg('M72: Overflow in Factorial. Set to Fact(170)',  //M72
            mtWarning,[mbOK],0);
            Inaccurate:=True;
            x:=170;
           end;
           i:=trunc(x+0.1);
           Number[TopNum]:=Factrl(i);
          end else begin
           Ecode1:=14;
           ErrorNumber:=1;
           MessageDlg('M73: Argument of factorial must be >= 0',        //M73
                 mtError,[mbOK],0);
           Disaster:=True;
          end;
         end;
     105:begin { Bessel J function }
          i:=trunc(Number[TopNum-1]);
          x:=Number[TopNum];
          if i=0 then Number[TopNum-1]:=bessj0(x)
          else if i=1 then Number[TopNum-1]:=bessj1(x)
          else if i>1 then Number[TopNum-1]:=bessj(i,x)
          else begin
           Ecode1:=14;
           Errornumber:=1;
           Messagedlg('M74; Error in order of Bessel-J function',       //M74
                mtError,[mbOK],0);
           Disaster:=True;
          end;
          TopNum:=Pred(TopNum);
         end;
     106:begin { Bessel K function }
          i:=trunc(Number[TopNum-1]);
          x:=Number[TopNum];
          if i=0 then Number[TopNum-1]:=bessk0(x)
          else if i=1 then Number[TopNum-1]:=bessk1(x)
          else if i>1 then Number[TopNum-1]:=bessk(i,x)
          else begin
           Ecode1:=14;
           ErrorNumber:=1;
           Messagedlg('M75: Error in order of Bessel-K function',       //M75
                   mtError,[mbOK],0);
           Disaster:=True;
          end;
          TopNum:=Pred(TopNum);
         end;
     107:begin { Bessel I function }
          i:=trunc(Number[TopNum-1]);
          x:=Number[TopNum];
          if i=0 then Number[TopNum-1]:=bessi0(x)
          else if i=1 then Number[TopNum-1]:=bessi1(x)
          else if i>1 then Number[TopNum-1]:=bessi(i,x)
          else begin
           Ecode1:=14;
           ErrorNumber:=1;
           Messagedlg('M76: Error in order of Bessel-I function',       //M76
                   mtError,[mbOK],0);
           Disaster:=True;
          end;
          TopNum:=Pred(TopNum);
         end;
     108:begin   { Bessel Y function }
          i:=trunc(Number[TopNum-1]);
          x:=Number[TopNum];
          if i=0 then Number[TopNum-1]:=bessy0(x)
          else if i=1 then Number[TopNum-1]:=bessy1(x)
          else if i>1 then Number[TopNum-1]:=bessy(i,x)
          else begin
           Ecode1:=14;
           ErrorNumber:=1;
           Messagedlg('M77: Error in order of Bessel-Y function',       //M77
                   mtError,[mbOK],0);
           Disaster:=true;
          end;
          TopNum:=Pred(TopNum);
         end;
     109:begin {Binomial Coefficients}
          i:=trunc(Number[TopNum-1]);
          j:=Trunc(Number[TopNum]);
          if (i<1) or (i>32) then
          begin
           Messagedlg                                                   //M78
           ('M78: Range of binomial coefficients must be between 1 and 32',
                  mtError,[mbOK],0);
           Disaster:=True;
          end else begin;
           if (j<0) or (j>i) then
           begin
            if MessageDlg(                                              //M79
               'M79: Binomial coefficient out of range - will set to 1.0',
                 mtWarning,[mbOK,mbAbort],0)= 3 then
            begin
             Disaster:=True;
             Number[Topnum-1]:=1.0;
            end else begin
             Inaccurate:=true;
             j:=0;
            end; {if MessageDLg}
           end; {if j<0}
           Number[TopNum-1]:=bico(i,j);
           TopNum:=Pred(TopNum);
          end; {if i<1}
         end;
     110:begin {Fresnel cosine integral}
          x:=Number[TopNum];
          if x>=0 then Number[TopNum]:= FrC(x)
          else begin
           Ecode1:=14;
           ErrorNumber:=1;                                              //M80
           Messagedlg('M80: Argument of frc(x) must be > 0 ',mtError,[mbOK],0);
           Disaster:=True;
          end;
         end;
     111:begin {Fresnel Sine Integral}
          x:=Number[TopNum];
          if x>=0 then Number[TopNum]:= FrS(x)
          else begin
           Ecode1:=14;
           ErrorNumber:=1;
           Messagedlg('M81: Argument of frs(x) must be > 0 ',           //M81
                    mtError,[mbOK],0);
           Disaster:=True;
          end;
         end;
     112:{Round}  Number[TopNum]:= Round(Number[TopNum]);
     113:begin {SetColor}
           i:= Trunc(Number[TopNum-2]);
           j:= Trunc(Number[TopNum-1]);
           x:= Number[TopNum];
           if (x<0.0) or (i<0) or (i>$FFFFFF) or (j<0) or (j>$FFFFFF)
           then begin
             Messagedlg('M82: Error in setting setcolor parameters',    //M82
                    mtError,[mbOK],0);
             Disaster:=True;
           end else begin
             Number[TopNum-2]:= SetColor(i,j,x);
             TopNum:= TopNum-2;
           end;
         end;
     115:begin {time$ - Current time}
          if Not IsString[TopNum] then
             TextVariable[TopNum]:= TimeToStr(Time+Number[TopNum]/86400)
          else TextVariable[TopNum]:= TimeToStr(Time);
          Isstring[TopNum]:= True;
         end;
     116:begin    {date$ - Current Date}
          if Not IsString[TopNum] then
             TextVariable[TopNum]:= DateToStr(Date+Int(Number[TopNum]))
          else TextVariable[TopNum]:= DateToStr(Date);
          Isstring[TopNum]:= True;
         end;
     117:begin  {insert$}
          If (Not IsString[TopNum]) and (IsString[TopNum-1])
            and (IsString[TopNum-2]) then
          begin
           Vs2:= TextVariable[TopNum-1];
           Insert(TextVariable[TopNum-2],Vs2,Round(Number[TopNum]));
           IsString[TopNum-1]:= False;
           TextVariable[TopNum-1]:= '';
           TopNum:= TopNum-2;
           TextVariable[TopNum]:= Vs2;
          end else begin
           Messagedlg('M83: Error in arguments for Insert$ function',   //M83
             mtError,[mbAbort],0);
           Disaster:=True;
          end; {if}
         end;
     118:begin  {Twidth}
          if IsString[TopNum] then
          begin
           ss1:= TextVariable[TopNum];
           Number[TopNum]:=  DisplayForm.Image1.Canvas.TextWidth(
                                ss1)/PixelsPercm;
           TextVariable[Topnum]:= '';
           IsString[Topnum]:= False;
          end else begin
           Messagedlg('M84: Error in argument of Twidth function',      //M84
             mtError,[mbAbort],0);
           Disaster:=True;
          end;  {if}
         end;
     119:begin  {Theight}
          if IsString[TopNum] then
          begin
           ss1:= TextVariable[TopNum];
           Number[TopNum]:=  DisplayForm.Image1.Canvas.TextHeight(
                              ss1)/PixelsPercm;
           TextVariable[Topnum]:= '';
           IsString[Topnum]:= False;
          end else begin
           Messagedlg('M85: Error in argument of Theight function',     //M85
             mtError,[mbAbort],0);
           Disaster:=True;
          end;  {if}
         end;
     120:begin   {xg}
          try
           x:= Number[TopNum-1];y:=Number[TopNum];
           PlotToPaper(x,y,GraphTransform,x1,y1);
           Number[TopNum-1]:= x1;
           TopNum:=Pred(TopNum);
          except
           Ecode1:=14;
           ErrorNumber:=1;
           Messagedlg('G40: Invalid arguments in xg',mtError,[mbOK],0); //G40
           Disaster:=true;
          end;
         end;
     121:begin   {yg}
          try
           x:= Number[TopNum-1];y:=Number[TopNum];
           PlotToPaper(x,y,GraphTransform,x1,y1);
           Number[TopNum-1]:= y1;
           TopNum:=Pred(TopNum);
          except
           Ecode1:=14;
           ErrorNumber:=1;
           Messagedlg('G41: Invalid arguments in yg',                   //G41
                  mtError,[mbOK],0);
           Disaster:=true;
          end;
         end;
     124:begin {Boolean OR '|'}
          try
           if (Number[TopNum]>0) or (Number[TopNum-1]>0) then
           Number[TopNum-1]:=1.0 else Number[TopNum-1]:= 0;
           TopNum:=Pred(TopNum);
          except
           Messagedlg('M90: Error in OR Boolean Comparison',            //M90
           mtError,[mbOK],0);
           Disaster:=True;
          end
         end;
     126:{~}   Number[TopNum]:= -Number[TopNum];
     128:begin {Boolean <> }
          try
           if Number[TopNum]<>Number[TopNum-1]then Number[TopNum-1]:=1.0
               else Number[TopNum-1]:= 0;
           TopNum:=Pred(TopNum);
          except                                                        //M91
           Messagedlg('M91: Error in <> Boolean Comparison',mtError,[mbOK],0);
           Disaster:=True;
          end
         end;
     129:begin {Boolean >= }
          try
           if Number[TopNum]<=Number[TopNum-1]then Number[TopNum-1]:=1.0
           else Number[TopNum-1]:= 0;
           TopNum:=Pred(TopNum);
          except
           Messagedlg('M92: Error in >= Boolean Comparison',            //M92
           mtError,[mbOK],0);
           Disaster:=True;
          end
         end;
     130:begin {Boolean <= }
          try
           if Number[TopNum]>=Number[TopNum-1]then Number[TopNum-1]:=1.0
           else Number[TopNum-1]:= 0;
           TopNum:=Pred(TopNum);
          except
           Messagedlg('M93: Error in <= Boolean Comparison',            //M93
           mtError,[mbOK],0);
           Disaster:=True;
          end
         end;
     131:begin  {rg()}
          try   { Remember angle axis is x and radial axis is y }
           x:= Number[TopNum-1];y:=Number[TopNum];
           PlotToPaper(y,x,GraphTransform,y1,x1);
           x:= abs(x1)*cos(y1/anglemeasure);
           Number[TopNum-1]:= x;
           TopNum:=Pred(TopNum);
          except
           Ecode1:=14;
           ErrorNumber:=1;
           Messagedlg('G42: Invalid arguments in rg',mtError,[mbOK],0); //G42
           Disaster:=true;
          end;
         end;
     132:begin  {ag}
          try
           x:= Number[TopNum-1];y:=Number[TopNum];
           PlotToPaper(y,x,GraphTransform,y1,x1);
           x:= x1*sin(y1/anglemeasure);
           Number[TopNum-1]:= x;
           TopNum:=Pred(TopNum);
          except
           Ecode1:=14;
           ErrorNumber:=1;
           Messagedlg('G43: Invalid arguments in ag',mtError,[mbOK],0); //G43
           Disaster:=true;
          end;
         end;
    end;{ case }
    CheckTopNum;
    TopOp:=Pred(TopOp);
    CheckTopop;
    OpToDo:=Operation[TopOp];
  end;
  if Ecode=0 then Ecode:=Ecode1;
  if  Disaster then Exit;
 except
   on Eoverflow do
     Messagedlg                                                         //M94
     ('M94: Unidentified Overflow error while performing a maths operation',
        mtError,[mbOK],0);
   on EZeroDivide do
     Messagedlg                                                         //M95
     ('M95: Unidentified division by zero while performing a maths operation',
        mtError,[mbOK],0);
   on EMathError do
     Messagedlg
     ('M96: Unidentified error while performing a maths operation',     //M96
        mtError,[mbOK],0)
   else
   Messagedlg('M97: Unidentified error while processing line',          //M97
        mtError,[mbOK],0);
   ErrorNumber:=1;
   Disaster:=True;
 end;
end;  {PerformOp}

Function FunctionCode(Fnumber:integer;var ErrCode:integer):word;
{Generates a number to represent a Function and sets FnClass and
 NumOfArgs to check for correct number of arguments }

var ch:char;

begin
  ErrCode:=0;
  If (Fnumber<0) or (Fnumber>62) then
  begin
   Messagedlg('M98: Unidentified function. Check FnNumber and limits',  //M98
        mtError,[mbOK],0);
    ErrorNumber:=1;
    Disaster:=True;
    ErrCode:=22;
    Exit;
  end else if (Fnumber<9) then begin  {String Functions}
    FunctionCode:= Fnumber+49; end else
  if (Fnumber<35) then begin   {Maths 1}
    FunctionCode:= Fnumber+56; end else
  if (FNumber<60) then begin { a .. z Maths 2}
    FunctionCode:= Fnumber+62;
  end else begin
    FunctionCode:= FNumber+70;
  end;
  if Errcode=0 then begin
   FnLevel:=succ(FnLevel);
   FnClass[FnLevel]:=1;
   NumOfArgs[FnLevel]:=1;
   case FNumber of
            1:FnClass[FnLevel]:= 3;
          3,4:FnClass[FnLevel]:= 2;
          5,7:FnClass[FnLevel]:= 3;
           19:FnClass[FnLevel]:= 2;
           29:FnClass[FnLevel]:= 2;
     43 .. 47:FnClass[FnLevel]:= 2;
           51:FnClass[FnLevel]:= 3;
           55:FnClass[FnLevel]:= 3;
  58,59,61,62:FnClass[FnLevel]:= 2;
   end; {case}
 end;
end;


begin    {Main block for Expression. Parsing is similar to
          that used in GetLine and Analyse but rather simpler
          and modified to allow for absence of spaces within
          Expressions. Evaluation is based on the Reverse
          Polish algorithm.}
  try
    TopOp:=0; TopNum:=-1;MaxOp:=25;MaxNum:=20;
    Ecode1:=0;Ecode2:=1000;
    for ie:= 0 to 20 do
      begin
       FnClass[ie]:=0;NumOfArgs[ie]:=0;
      end;
    commafound:=false;FnLevel:=0;
    for ie:=0 to MaxNum do
    begin
     Number[ie]:=0.0;
     TextVariable[ie]:= '';
     IsString[ie]:= False;
    end;
    for ie:=0 to MaxOp do Precedence[ie]:= 0;
    SLength:= length(SExp);
    MaxKount:= SLength+2;
    SPos:=0;Kount:=0;
    Operation[0]:= 40;Precedence[0]:=0;  { Sets Sentinel at start}
    Ch:=SExp[1];
    If (Ch in AddOps) then
    { Operations if expression starts with a + or - sign}
      if Ch='-' then begin
         SExp[1]:='~'; end else RemoveSpace(1);
    while (Spos<SLength) do {Sets Unary + or - symbols }
     begin
       Spos:=Succ(Spos);
       If (Sexp[Spos]= '(') or (Sexp[Spos]=',') then begin
          if Sexp[Spos]= '(' then FnLevel:=succ(FnLevel);
          if Sexp[Spos+1]='-' then Sexp[SPos+1]:='~' else
          if Sexp[SPos+1]='+' then RemoveSpace(SPos+1);
       end else if Sexp[Spos]=')' then FnLevel:=Pred(FnLevel);
     end;
     Sexp:=Sexp+')';Slength:=Slength+1;
     if FnLevel<>0 then
     begin
       Ecode:=24;
       ErrorNumber:=1;
       Messagedlg(                                                        //T1
        'T1: Expression error. Mismatch between left and right parentheses',
            mtError,[mbOK],0);
     end;
    SPos:=1;Nextpos:=1; {Set at first position in string}
    LastCh:=' ';
    while ((Spos<SLength) {or (TopOp>0)}) and (Ecode=0) do
    begin
      Spos:=Nextpos;
      ch:=SExp[Spos];
      if (Ch='(') then begin {Check for ( and push it on stack}
       Ecode2:=2000;
       TopOp:=succ(TopOp); {TopOp 0 is taken by Sentinel }
       CheckTopOp;         {Check Topop range here }
       Operation[TopOp]:= 40;
       Precedence[Topop]:= 0;
       Nextpos:=Succ(Spos);
      end else if (Ch=')') or (Ch=',') then begin
       Ecode2:=3000;
       if ch=',' then commafound:=true;
       OpToDo:=Operation[TopOp];
       while (OpToDo<>40) and (Ecode=0)
             and not Disaster do   {Now flush stack}
       PerformOp;
       if Disaster then Exit;
       if Commafound then
       begin
         commafound:=false;
         NumOfArgs[FnLevel]:=succ(NumOfArgs[FnLevel]);
       end else TopOp:=Pred(TopOp);  { Pops '(' off op stack }
       { end of 'if commafound'}
       Nextpos:=Succ(Spos);
      end  else if (ch in digits) or (ch='$') then begin  {Check for a number}
       GetNumber(SPos,NextPos,Ecode,Ecode1,SExp,MathOps+LogOps+Stop3,Vn);
       if (Ecode1=0) then
       begin
         TopNum:=succ(TopNum);
         CheckTopNum;
         Number[TopNum]:=Vn;
         TextVariable[TopNum]:= '';
         IsString[TopNum]:= False;
        end;
        {Note that Nextpos was set by GetNumber}
      end else if (ch in Letters)
      then begin  {Check for a Variable}
        Ecode2:=5000;
        if  (LastCh in MathOps+LogOps+Stop2) then
         SS:=GetVariableName(SPos,NextPos,Fnum,Ecode,ECode1,
                                    Sexp,Stop3+MathOps+logOps)
        else Ecode1:=25;
        if (Ecode1=0)  then begin
          if Fnum<0 then begin
           GetVariableValue(SS,Vn,Vs2,Ecode1,Ecode2);
           if (Ecode1=0) then begin
            TopNum:=Succ(Topnum);
            CheckTopNum;
            if (Fnum = -2) then
            begin
              Number[TopNum]:= 0.0; TextVariable[TopNum]:= Vs2;
              IsString[topnum]:= True;
            end else begin
              Number[TopNum]:=Vn; TextVariable[TopNum]:= '';
              IsString[TopNum]:= False;
            end;
           end;
          end else begin
           ssf:= FunctionCode(Fnum,Ecode1);
           If Ecode1=0 then begin
             TopOp:=succ(Topop);
             CheckTopOp;
           end;
           if Ecode1=0 then
           begin
             Operation[Topop]:=ssf;
             Precedence[TopOp]:=4;
           end;
          end;
        end;
        if Ecode=0 then Ecode:=Ecode1;
      end  {Insert Function check here}
      else if (ch in MathOps + LogOps) then begin  {Check for an operation}
       ch1:= Sexp[Spos+1];
       if (Ch1 in LogOps) then begin
           case ch of {Reduces compound operators >= etc. to single characters }
            '>':begin
                 if Ch1 = '=' then
                 begin
                  Currentop:= 129;
                  Spos:= succ(Spos);
                 end;
                end;
            '<':begin
                 if Ch1 = '=' then
                 begin
                  CurrentOp:= 130;
                  Spos:= succ(spos);
                 end else if Ch1 = '>' then
                 begin
                  CurrentOp:= 128;
                  Spos:=succ(spos);
                 end;
                end;
            end; {case}
       end else currentop:= Ord(ch);
       Ecode2:=6000;
       CurrentPrecedence:=0;
       case CurrentOp of
        43,45,60,61,62,   {'+','-','<','=','>','~', 128,129,130}
            126,128,129,130:CurrentPrecedence:=1;
        38,42,47,124:CurrentPrecedence:=2; {'&','*','/','|'}
                        94:CurrentPrecedence:=3; {'^'}
        65 .. 90,97 .. 122:CurrentPrecedence:=4; {'A'..'Z','a'..'z'
                                                   May move to function section}
       end; {Case}
       OptoDo:=Operation[TopOp];
       while (Precedence[TopOp]>=CurrentPrecedence) and (ECode1=0)
         and (Topop>0)  and (TopNum>=0) and not Disaster
         do PerformOp;
      if Disaster then Exit;
      TopOp:=Topop+1;
      CheckTopOp;
      Operation[Topop]:=CurrentOp;
      Precedence[TopOp]:=CurrentPrecedence;
      Nextpos:=succ(Spos); {Step for a single character maths operation}
     end;  {Else MathOps}
{     if ShStacks then showstacks;  {- insert for diagnostics }
     {Step one position if no action}
     Kount:= succ(Kount);
     if Kount>MaxKount then Ecode1:=30;
     if Ecode1>0 then Ecode1:=Ecode1+Ecode2;
     if Ecode=0 then Ecode:=Ecode1;
     LastCh:=Ch;
    end; {While Spos}
    if FnClass[FnLevel]<>NumOfArgs[FnLevel] then Ecode:=31;
    If (TopOp<0){ and (TopNum=0) }then
    begin
      Expression:=Number[TopNum];
      ReturnedString:= TextVariable[TopNum];
      StringReturned:=  IsString[TopNum];
    end;
   except
     ErrorNumber:=1;
     Messagedlg('T2: Unidentified error while evaluating expression',     //T2
         mtError,[mbOK],0);
  end; {Exception handler}
end; {Evaluate Expression}

Procedure ResetPars(Rst:integer);
{Resets parameters
    Rst = 2 Resets Angle and Output number Format
    Rst = 1 Resets Other parameters
    Rst = 3 Resets everything.}
var ii:integer;
begin
if Rst>1 then {Only resets angle measure and number format}
 begin
   AngleMeasure:=1.0;
   SigFigs:=23;
   DecFigs:=-1;
   If Rst=3 then Rst:=1;
 end;
 if Rst=1 then  { This sets intial conditions and resets all variables }
 begin
{  Diagnostics:= False;  }
  ValueSet:=False;
  Lstructure:=False;
  Inaccurate:=False;
  Disaster:=False;
  s4:='';{out1a:='';out1b:='';out1c:='';  }
 { out2:='';out3:=''; }
  {Initial settings}
{  Randomize;  {Primes random number generator }
  SetVariable:=0;
  LastVariable:=' ';
  {Set up initial values for variables}
    e:=2.73;
    g:=2.0;
    p:=3.14159;;
    q:=2.2;
    for ii:=0 to 260 do vv[ii]:=0; {Reset 2 char variables to 0 }
{  StartStringAt:=0;   }
{Initial settings for factorial functions }
{   glntop := 0;
   gla[1] := 1.0;
   ResetIt := 0;
   for ii := 1 to 100 do glna[ii] := -1.0;}
 end;
end; {ResetPars}

procedure RemoveQuotes(Var ss:string);
{Removes Quotes from a simpleString}
var i1,i2,i3:integer;
    st:string;
    a:char;
begin
  i1:=1;
  i2:=length(ss);
  st:='';
  repeat
    if ss[i1]='"' then
    begin
      if ss[i1+1]='"' then
      begin
        st:=st+ss[i1];
       i1:=i1+2;
      end else i1:=succ(i1);
    end else begin
      st:=st+ss[i1];
     i1:=succ(i1);
    end;
  until i1>=i2;
  ss:=st;
end;

Procedure Analyse(s1:string;var StringNum:integer);
{Analyses a string into its constituent components and attempts to
 express each component as a command, variable, function, etc.}
var
    ia1,is1,is2,is3,iData,DColNum,StringIndex,SLength:integer;
    xx:double;
    s2,s3,s4,Vs3,out1:string;   {out1 is used for testing.}
    IsText:Boolean;
begin
    {First reset the substring arrays}
    for ia1:= 0 to NumOfStrings do
    begin
      If SetData and (ia1<>0) then
      begin  {stores last input row for use during data input }
        LastText[ia1]:= StringText[ia1];
        LastType[ia1]:=  StringType[ia1];
        LastValue[ia1]:= StringValue[ia1];
      end;
      StringText[ia1]:=' ';
      StringType[ia1]:=0;
      StringValue[ia1]:=0.0;
    end;  { N.b. ia1 is used again as a flag for '!' - see below. }
    ia1:=0;
    SetAxis:=False;SetPlot:=False;SetKey:=False;
    SetPlotStyle:=False;  {Set flags for parsing}
    SetLineStyle:=False;
    StartStringAt:=0;
    StringIndex:=1;
    repeat     {  Parse a line  }
     if StartStringAt=0 then   {i.e. Start of a new line}
     begin
       code:=0;code1:=0;code2:=0; IsText:= False;{Check these}
      {out2 is last input and s4 is current input with 'return' removed
       out2:= '  '+s4;  Used for testing.}
      StringLength:= Length(s1);    { Flag for end of s1}
     end;
     StartStringAt:=FindNextChar(StartStringAt,Stringlength,s1,Stop1);
     if StartStringAt>0 then  { A substring found before the end of the line }
     begin {Find end of the substring and extract this substring as s2 }
       EndStringAt:=FindNextSpace(StartStringAt,StringLength,s1,Stop1);
       s2:= Copy(s1,StartStringAt,EndStringAt-StartStringAt);
       s2:= LowerCase(s2);{forces lower case to ease comparisons }
       LastStart:= StartStringAt;
       StartStringAt:=EndStringAt;
       StringText[StringIndex]:=s2;
      { Now carry out first stage parsing. The results of this are entered
       in the arrays StringType and StringValue. A copy of the substring
       is held in StringText.}
       StringType[StringIndex] := 0;
       SLength:=length(s2);
       StringValue[StringIndex] := SLength;
    {Carry out any special processing for first string in the line}
       if (StringIndex=1) and (s2[Slength]=':') then {A label at start of line}
       begin
        StringType[0]:=11;
        StringText[0]:=s2;      { Needed }
        StringValue[0]:=0;
        StringIndex:=0;   {Causes repeat test for StringIndex = 1 }
       end else if (StringIndex=1) and (s2[1]='@') then  {A subroutine call}
       begin
          StringType[1]:= 32;
          StringText[1]:= Copy(s2,2,Length(s2));
          StringValue[1]:=0;
    {Otherwise consider general cases}
       end else if s2[1]='!' then { Start of a comment  }
       begin
         StringType[Stringindex] := 7;
         ia1:=7;
 {      end else if s2[1]='&' then { a continuation line  }
 {        StringType[StringIndex] := 8    { This is not used at present }
       end else if (SetData) and (s2[1] in DataOps) and (Slength=1) then
         begin  {Process a data set input special symbol.}
           case s2[1] of   {N.B. These are arranged in ordinal order}
             '*':begin
                   StringType[StringIndex]:=46;
                   StringValue[StringIndex]:= 2;
                 end;
             '+':begin
                   StringText[StringIndex]:=LastText[StringIndex];
                   StringType[StringIndex]:=LastType[StringIndex];
                   StringValue[StringIndex]:=LastValue[StringIndex]+1.0;
                 end;
             '-':begin
                   StringText[StringIndex]:=LastText[StringIndex];
                   StringType[StringIndex]:=LastType[StringIndex];
                   StringValue[StringIndex]:=LastValue[StringIndex]-1.0;
                 end;
             '/':begin
                  {Do nothing at present!}
                 end;
             '<':begin {Set to first data column}
                   StringType[StringIndex]:=46;
                   StringValue[StringIndex]:=3;
                 end;
             '>':begin  {set to last data column of previous set}
                   StringType[StringIndex]:=46;
                   StringValue[StringIndex]:=4;
                 end;
             '^':begin
                   StringText[StringIndex]:=LastText[StringIndex];
                   StringType[StringIndex]:=LastType[StringIndex];
                   if LastType[StringIndex]=6 then
                   begin
                    s2:= LastText[StringIndex];
                    codea:=0;codeb:=0;codec:=0;out1:='';
                    VarValue:=Expression(s2,s4,IsText,codea,codeb,codec);
                    if (codea=0) and (Not IsText) then
                    { No errors - so it is an expression }
                      StringValue[StringIndex] := VarValue
                    else if ((code<>0) and (codea=0)) then code:=0;
                    { error code processing }
                   end else StringValue[StringIndex]:=LastValue[StringIndex];
                 end; {^}
             '_':begin {end of data symbol}
                   StringType[StringIndex]:=46;
                   StringValue[StringIndex]:= LastValue[StringIndex]{6};
                 end;
             '|':begin  {Set to corresponding column in previous data set.}
                   StringType[StringIndex]:=46;
                   StringValue[StringIndex]:=5;
                 end;
            end; {case s2[1]}
       end else if (s2[1] in digits) or ((s2[1]='-') and (s2[2] in digits))
        or ((s2[1]='$') and (s2[2] in hexdigits))
       then      { s2 is probably a number }
       begin
        try
         Val(s2,VarValue,code);
         if code=0 then { No error - so it is a number }
         begin
            StringType[StringIndex]:=5;
            StringValue[StringIndex]:=VarValue;
         end else if (code=1) and (s2[1]='$') then
         begin
           StringType[StringIndex]:=5;
           StringValue[StringIndex]:= StrToInt(s2);
           code:= 0;
         end else begin  {Reset for further tests }
           StringType[StringIndex]:=0;
           StringValue[StringIndex]:=0;
         end;
         except
          On EOverflow do
          begin                                                           //T3
            if MessageDlg('T3: Overflow. Will set value to +5.5E305',mtError,
                [mbOK,mbAbort],0)= mrAbort then
            begin
              Disaster:=True;  { Check this }
              VarValue:=0.0;
            end else  begin
              VarValue:=5.3E305;
              Inaccurate:=True;
            end;
          end;
         end; {except}
       end else if s2[1]='"' then    { A quoted string}
       begin  {First find end of quoted string - this will alter s2}
         is1:=Succ(LastStart); {Starts at 2nd position - this allows }
         is2:=2;               {leading spaces}
         repeat
           if (is1<StringLength) then
           begin
            if (s1[is1]='"') and (s1[is1+1]='"') {allows for quoted quote}
            then begin
              is1:=succ(is1);
              is2:=succ(is2);
            end else if (s1[is1]='"') and (s1[is1+1] in Stop1)
            then is1:=-2; {if s1[is1]='"'}
           end;{ is1<Stringlength}
           is1:=succ(is1);
           is2:=succ(is2);
         until (is1>=Stringlength) or (is1<0);
         s2:= Copy(s1,LastStart,is2);
         StringType[StringIndex]:=12;
         RemoveQuotes(s2);
         StringText[StringIndex]:=s2;{N.B. still includes ALL quotation marks}
         StringValue[StringIndex]:= length(s2); {Final length of string}
         StartStringAt:=LastStart+is2; {Resets starting point for next search.}
       end else if s2[1]= '(' then {Start of an expression}
       begin    {This section removes internal spaces from an expression}
         is1:= Succ(LastStart);  {See previous section for similar operations}
         is2:= 1; {Used as bracketlevel flag}
         repeat
            if s1[is1]='(' then is2:= succ(is2);
            if s1[is1]=')' then is2:= pred(is2);
            is1:= succ(is1);
         until (is2<=0) or (is1>=StringLength);
         s3:= Copy(s1,LastStart,is1-LastStart);
         StartStringAt:= is1; {Resets starting point for next search.}
         is2:= length(s3);  {Now remove any spaces}
         s2:='';
         for is3:= 1 to is2 do
         begin
          if s3[is3]<>' ' then s2:= s2 + s3[is3];
         end;
         StringText[StringIndex]:=s2;   {N.B. Now excludes spaces}
         { Since StringType is still zero this will be checked as an expression
         at the end of this procedure.}
       end else if (s2[1] in letters)  and (S2[Slength]='$')
       and (Slength<3) then { s2 a String variable name }
       begin
       {  If (S2[Slength]='$') and (Slength<3) then s2 must be a
          simple string variable name e.g. a$,b$ }
          StringType[StringIndex]:=9;
          StringValue[StringIndex]:= ord(s2[1])-97;
       end else
       if (s2[1] in letters) and ((length(s2)=1) or
               ((length(s2)=2) and (s2[2] in digits)))   then
       begin  { s2 must be a simple variable name  e.g. a,b7 }
         s3:=GetVariableName(1,VariableEnd,Fval,Code,Code1,S2,Stop1);
         if (code=0) then  { No errors - a valid variable name identified. }
             GetVariableValue(s3,Vb,Vs3,code,code1);
         if code=0 then  {Variable value extracted without errors }
         begin
          StringType[StringIndex] := 3;
          StringValue[StringIndex] := Vb
         end else begin
            Messagedlg('T4: Error in processing a variable name',         //T4
              mtError,[mbAbort],0);
            Disaster:=True;
            exit;
         end;
       end else if (s2[1] in letters) and (s2[2] in digits)
             and (s2[3] in digits) and (length(s2)=3)
       then   {case of a GLE dataset label - e.g d12, c14 etc}
       begin
          case s2[1] of
           'c':StringType[StringIndex] := 45;
           'd':begin
                SetPlotStyle:=True;
                StringType[StringIndex] := 44;
               end;
          end; {case}
          StringValue[StringIndex] := (Ord(s2[2])-48)*10+Ord(s2[3])-48;
       end else if (s2[1] in letters) and (length(s2)>=3) then
       begin {may be a constant}
           is1:=-1;is2:=-1;
          repeat
           is1:=succ(is1);
           if Constants[is1]=s2 then
           begin
            is2:=is1;
            case is2 of
             0:xx:= Pi;
             1:xx:= 1.0/Degree;
             2:xx:= Degree;
             3:xx:= Exp1;
             4:xx:= LogE;
             5:xx:= 2.30258509299405;
             6:xx:= 20*LogE;
             7:xx:=  1; {x1axis}
             8:xx:=  2; {x2axis}
             9:xx:=  3; {y1axis}
             10:xx:= 4;
             11:xx:= 5;{z1axis}
             12:xx:= 6;

            end; {case}
            StringType[StringIndex] := 4;
            StringValue[StringIndex] := xx;
           end; {if Constants}
          until (is1=NumOfConst) or (is2>=0);
     {  end else  begin
          StringType[StringIndex] := -3;  {Denotes an error condition }
       end;  { End of checks on s2}

       {This completes parsing for common types of input. We next check for
        more specialised inputs, starting with the special symbol that may
        be found in a data file.}

        linepos:=-1;kommand:=-1;

       { The only remaining possibilities are that the string represents a
        a command, a parameter or an expression. Since these may not start
        with a letter ( they could start with  + or - or a special symbol)
        these cases must be dealt with in a separate loop. }
       If (StringType[StringIndex]=0) and SetGraph  and (not Setaxis)
             and (not SetPlotStyle)    then {i.e. Nothing yet identified but
             a previous line has setup Graph mode}
       begin  {Compare s2 with graph commands}
        linepos:=-1;kommand:=-1;
        repeat
         linepos:=succ(linepos);
         if Graphs[linepos] =s2 then kommand:=linepos;
         until (linepos=NumOfGraphs) or (kommand>=0);
         if kommand>=0 then { a graph command found }
         begin
           StringType[StringIndex]:=40;
           StringValue[StringIndex]:=kommand;
           if kommand=1 then SetPlot:=True {Set command type for rest of line }
           else if kommand=6 then Setkey:=True
           else if (kommand>11) and (kommand<18) then SetAxis:=True;
         end;
       end;  {graphs}

       If (StringType[StringIndex]=0) and (SetPolar)
             and (not Setaxis) and (not SetPlotStyle)    then
             {i.e. Nothing yet identified but a previous line has
              setup Polar plot mode}
       begin  {Compare s2 with polar plot commands}
        linepos:=-1;kommand:=-1;
        repeat
         linepos:=succ(linepos);
         if Polars[linepos] =s2 then kommand:=linepos;
         until (linepos=NumOfPolars) or (kommand>=0);
         if kommand>=0 then { a polar plot command found }
         begin
           StringType[StringIndex]:=50;
           StringValue[StringIndex]:=kommand;
           if kommand=3 then SetPlot:=True {Set command type for rest of line }
           else if kommand=8 then Setkey:=True
           else if (kommand>11) and (kommand<18) then SetAxis:=True;
         {  else if (kommand>17) and (kommand<20) then SetAngleAxis := True;  }
         end;
       end;  {Polar plots}

       If (StringType[StringIndex]=0) and (SetAxis {or AxisSet Not used so far})
           then {i.e. In graph axis mode so check axis parameters.}
       begin  {Compare s2 with axis parameters}
        linepos:=-1;kommand:=-1;
        repeat
         linepos:=succ(linepos);
         if AxisPars[linepos] =s2 then kommand:=linepos;
         until (linepos=NumOfAxisPars) or (kommand>=0);
         if kommand>=0 then { a graphic command found }
         begin
           StringType[StringIndex]:=42;
           StringValue[StringIndex]:=kommand;
         end;
       end;  {axis parameters}

       If (StringType[StringIndex]=0) and (SetGraph or SetPolar) and SetPlotStyle
          and (not SetAxis) then {In Graph plot mode so check plot parameters.}
       begin  {Compare s2 with plot style commands}
        linepos:=-1;kommand:=-1;
        repeat
         linepos:=succ(linepos);
         if PlotPars[linepos] =s2 then kommand:=linepos;
         until (linepos=NumOfPlotPars) or (kommand>=0);
         if kommand>=0 then { a plot parameter found }
         begin
           StringType[StringIndex]:=43;
           StringValue[StringIndex]:=kommand;
         end;
       end;  {plot parameters}

       If (StringType[StringIndex]=0) and (SetGraph or SetPolar)
           then {i.e. Nothing yet identified so check graph parameters.}
       begin  {Compare s2 with graphics commands}
        linepos:=-1;kommand:=-1;
        repeat
         linepos:=succ(linepos);
         if GraphPars[linepos] =s2 then kommand:=linepos;
         until (linepos=NumOfGPars) or (kommand>=0);
         if kommand>=0 then { a graphic command found }
         begin
           StringType[StringIndex]:=41;
           StringValue[StringIndex]:=kommand;
         end;
       end;  {graph parameters}

       If (StringType[StringIndex]=0) and Setgraphic  and (not SetLineStyle)
              then {i.e. Nothing yet identified.}
       begin  {Compare s2 with graphics commands}
        linepos:=-1;kommand:=-1;
        repeat
         linepos:=succ(linepos);
         if Graphics[linepos] =s2 then kommand:=linepos;
         until (linepos=NumOfGraphics) or (kommand>=0);
         if kommand>=0 then { a graphic command found }
         begin
           StringType[StringIndex]:=20;
           StringValue[StringIndex]:=kommand;
           If (kommand in [0,43,61,63]) then SetLineStyle:=True; {arrow settings}
         end;
       end;  {graphics}

       {Now consider special case of a marker style}
       If (StringIndex>0) and (StringType[StringIndex-1] in [20,43])
       then begin {compare with array of marker styles}
        linepos:=-1;kommand:=-1;
        repeat
          linepos:=succ(linepos);
          if Markers[linepos] =s2 then kommand:=linepos;
        until (linepos=NumOfMarkers) or (kommand>=0);
        if kommand>=0 then { a Marker style found }
        begin
          StringType[StringIndex]:=28;
          StringValue[StringIndex]:=kommand;
        end;
       end; {Marker Style}

       {Special Case of a Text Command}
       If (StringType[StringIndex]=20) and (StringValue[StringIndex]=50) then
       begin
       {Find start of text}
          StartStringAt:=FindNextChar(StartStringAt,Stringlength,s1,Stop1);
          s2:= Copy(s1,StartStringAt,StringLength-StartStringAt);
          StringIndex:=succ(StringIndex);  {Set Text parameters}
          StringText[StringIndex]:=s2;   {Is needed here!}
          StringType[StringIndex]:=10;
          StringValue[StringIndex]:=length(s2);
          StartstringAt:=0; {No more on this line}
       end; {Case of Text Command}

       If (StringType[StringIndex]=0) and (not SetPlotStyle) then
       {i.e. Still nothing identified.}
       begin  {Compare s2 with graphics block parameters}
        linepos:=-1;kommand:=-1;
        repeat
         linepos:=succ(linepos);
         if Beginnings[linepos] =s2 then kommand:=linepos;
         until (linepos=NumOfBgns) or (kommand>=0);
         if kommand>=0 then { a block parameter found }
         begin
           StringType[StringIndex]:=30;
           StringValue[StringIndex]:=kommand;
         end;
       end;  {Blocks}

       If StringType[StringIndex]=0  then {i.e. Still nothing identified.}
       begin  {Compare s2 with colour parameters}
        linepos:=-1;kommand:=-1;
        repeat
         linepos:=succ(linepos);
         if Colors[linepos] =s2 then kommand:=linepos;
         until (linepos=NumOfColors) or (kommand>=0);
         if kommand>=0 then { a colour parameter found }
         begin
           StringType[StringIndex]:=24;
           StringValue[StringIndex]:=GetColor[kommand];
         end;
       end;  {colours}

       If (StringType[StringIndex]=0) and not Setplotstyle  then
       {i.e. Still nothing identified.}
       begin  {Compare s2 with graphics set parameters}
        linepos:=-1;kommand:=-1;
        repeat
         linepos:=succ(linepos);
         if Settings[linepos] =s2 then kommand:=linepos;
         until (linepos=NumOfSetngs) or (kommand>=0);
         if kommand>=0 then { a setting found }
         begin
           StringType[StringIndex]:=29;
           StringValue[StringIndex]:=kommand;
         end;
       end;  {Settings}
       If StringType[StringIndex]=0  then {i.e. Still nothing identified.}
       begin  {Compare s2 with box parameters}
        linepos:=-1;kommand:=-1;
        repeat
         linepos:=succ(linepos);
         if Boxes[linepos] =s2 then kommand:=linepos;
         until (linepos=NumOfBoxes) or (kommand>=0);
         if kommand>=0 then { a box parameter found }
         begin
           StringType[StringIndex]:=22;
           StringValue[StringIndex]:=kommand;
         end;
       end;  {Boxes}
       If StringType[StringIndex]=0  then {i.e. Still nothing identified.}
       begin  {Compare s2 with Line Arrow parameters}
        linepos:=-1;kommand:=-1;
        repeat
         linepos:=succ(linepos);
         if Lines[linepos] =s2 then kommand:=linepos;
         until (linepos=NumOfLines) or (kommand>=0);
         if kommand>=0 then { a Line arrow parameter found }
         begin
           StringType[StringIndex]:=21;
           StringValue[StringIndex]:=kommand;
         end;
       end;
       If StringType[StringIndex]=0  then {i.e. Still nothing identified.}
       begin  {Compare s2 with justification parameters}
        linepos:=-1;kommand:=-1;
        repeat
         linepos:=succ(linepos);
         if JustTo[linepos] =s2 then kommand:=linepos;
         until (linepos=NumOfJusts) or (kommand>=0);
         if kommand>=0 then { a command found }
         begin
           StringType[StringIndex]:=20;
           StringValue[StringIndex]:=kommand;
         end;
       end; {Justifications}

       If ((StringType[StringIndex]=0) and SetGraph and Setkey and
           (not SetplotStyle)) or KeySet
       then {i.e. Still nothing identified but either a graph or graphic key
                  parameter expected.}
       begin  {Compare s2 with key parameters}
        linepos:=-1;kommand:=-1;
        repeat
         linepos:=succ(linepos);
         if JustTo[linepos] =s2 then kommand:=linepos;
         until (linepos=NumOfJusts) or (kommand>=0);
         if kommand>=0 then { a command found }
         begin
           StringType[StringIndex]:=20;
           StringValue[StringIndex]:=kommand;
         end;
       end; {Key parameters}

       If StringType[StringIndex]=0 then  {Still nothing found}
       begin {Compare s2 with the list of commands in MPComs }
        linepos:=-1;kommand:=-1;
        repeat
         linepos:=succ(linepos);
         if MPComs[linepos] =s2 then kommand:=linepos;
        until (linepos=NumOfCmds) or (kommand>=0);
        if kommand>=0 then { a command found }
        begin
         StringType[StringIndex]:=1;
         StringValue[StringIndex]:=kommand;
        end;
       end;  { MpComs }
      { Finally, if no command found test for an expression - this could
        start with an operator, digit or letter. }

       if StringType[StringIndex]=0 then  { i.e. No type yet identified }
       begin
        codea:=0;codeb:=0;codec:=0;
        out1:='';  VarValue:= 1.0E-20; {Dummy near-zero setting}
  {If not in data input mode try to evaluate the string as an expression.
   In data input mode this is defered to  the InputData procedure
   since some of the expression parameters may have been changed after this
   point.}
        if (not SetData) and (not subskipon)
           {Subskipon is included to avoid difficulties in the initial
            setting up of subroutine, when it is posssible to attempt to
            analyse an expression before its variables have been set }
           then VarValue:=Expression(S2,s4,IsText,codea,codeb,codec);
        if codea=0 then { No errors - so it is an expression }
        begin
         if Istext then
         begin
          StringType[StringIndex]:= 14;
          StringValue[StringIndex]:= 0;
          StringText[StringIndex]:= s4;
         end else begin
          StringType[StringIndex] := 6;
          StringValue[StringIndex] := VarValue;
         end;
        end;
        if StringType[stringindex]=0 then begin                           //T5
         Messagedlg('T5: Unrecognised Input ->  ' + s2,mtError,[mbAbort],0);
         Disaster:=true;
         Exit;
        end;
        if ((code<>0) and (codea=0)) then code:=0; { error code processing }
       end; {Completes first parsing cycle. Remainder is carried out by DoLine.}
   end;
   If SetData then  {Processing of DataColumns and data variables}
   begin
    idata:=StringIndex; {Note that StringIndex starts at 1 but data starts at 0}
    vv[idata+29]:=StringValue[StringIndex];  {This may be altered by InputData}
   end;
   StringIndex:=succ(StringIndex);
 until (StartStringAt=0) or (Code>0) or (ia1=7); { End of the line reached}
 StringNum:=Pred(StringIndex);
{ if SetData then NumOfDataCols:=StringNum; Not Needed}
end;  {Analyse}

Function GetLine(Var LineNum:Integer):String;
{ This starts at line number LineNum and attempts to construct
  a compound line by adding continuation lines and skipping
  comment lines. If successful the result is returned as the
  function. Non catastrophic failures allow optional continuation.
  Catastrophic failures also set the Global Flag 'Disaster'.
  Various error messages may be returned.}
var  i,LineCount,StartLine:Integer;
     FirstChar:Char;
     s1,s2,se,snum:String;
     LineValid:boolean;
begin
 Disaster:=False;
 With EditForm.EditMemo do  { Note that this is Specific to GLE95}
 begin
  StartLine:=LineNum;
  {Check that linenum is valid }
  if (LineNum>=Lines.Count) or (LineNum<1) then
  begin
    Disaster:=True;
    Str(LineNum:5,se);
    MessageDlg('T6: Error in a new line starting at line number '        //T6
    + se,Mterror,[mbOK],0);
  end else begin
  {If the starting line is valid then load the assigned line. If it is
   a comment line skip it, if a continuation line add it to the
   end of the current line. Continue until it is not a continuation
   line or else we have reached a maximum of MaxLineCount continuation lines,
   or an error has occurred.}
   s2:='';
   LineCount:=0;
   LineValid:=True;
   repeat
    if (LineNum<Lines.Count) then
    begin
     s1:=Lines[LineNum];
     if (Length(s1)=0) then s1:=' '; {This protects against an error which  }
     for i:= 0 to length(s1) do
       if s1[i] = #9 then s1[i]:= ' '; {Eliminates tab characters}
     FirstChar:=s1[1];  {can arise when a zero-length string is encountered.}
     if (FirstChar='!') then {Comment line}
     begin
      LineNum:=Succ(LineNum);
      If (LineNum<Lines.Count) then LineValid:=True;
     end else if (FirstChar='&') then
     begin
      if LineCount<1 then begin
       {This situation cannot arise in a legal listing!}
       Str(LineNum:5,se);
       if Messagedlg('T7: Found a continuation line at line ' + se +      //T7
        ' - expecting the start of a new statement'
        ,Mterror,[mbAbort],0)= mrAbort then Disaster:=True;
       lines.insert(linenum,'! **** ----- Error Here ----- ***');
       LineNum:=succ(LineNum);
      end else if (LineCount>MaxLineCount) then
      begin { Exceeded maximum  no of continuation lines.}
       Str(LineNum:5,se);
       Str(LineCount-1:3,snum);
       Messagedlg('T8: More than ' + snum + ' continuation lines at line ' //T8
       + se,Mterror,[mbAbort],0);
       Disaster:=True;
       lines.insert(linenum,'! **** ----- Error Here ----- ***');
       LineNum:=succ(LineNum);
       LineValid:=False;
      end else begin
       s1:=Copy(s1,2,Length(s1)); { Removes '&' from start of line}
       s2:=s2+s1;
       LineNum:=succ(LineNum);
       LineCount:=Succ(LineCount);
       If (LineNum<Lines.Count) then LineValid:=True;
      end;
     end else if (LineCount=0) then
     begin  {None of previous have occurred and this is the 1st line.}
      s2:= s1;
      Linecount:= Succ(LineCount);
      LineNum:=Succ(LineNum);
      If (LineNum>=Lines.Count) then LineValid:=False else LineValid:=True;
      { A single line statement at the end of the file is assumed to be OK}
     end else LineValid:=False; {It is start of next input.}
    end else LineNum:=succ(LineNum);  { Ensures program does not lock if
                                       last line is a comment.}
   until (LineCount>(MaxLineCount+2)) or  (LineValid=False)
          or (LineNum>=Lines.Count) or Disaster;
  end; {Initial line test was valid}
  If (NOT Disaster) or  LineValid then GetLine := s2+'  ';
  { Note - added spaces needed to ensure correct parsing.}
 end;  { With Form1.EditMemo}
end; {GetLine}

end.




