#if !defined(AFX_DLGEDITPLOTP_H__A277A2A4_92BD_11D3_8D3C_00105AE81499__INCLUDED_)
#define AFX_DLGEDITPLOTP_H__A277A2A4_92BD_11D3_8D3C_00105AE81499__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000
// DlgEditPlotP.h : header file
//

#include "Plot3DP.h"

#include "..\common\PlotCalc.h"

#define	DEFAULT_SURFACE		"Torus"
#define	SURFACE_HIVE_SUBDIR	"Surfaces"

/////////////////////////////////////////////////////////////////////////////
// DlgEditPlotP dialog

class DlgEditPlotP : public CDialog
{
// Construction
public:
	DlgEditPlotP(CWnd* pParent = NULL);   // standard constructor
	void SetDefaults(void);
	void SaveToRegistry(void);
	int  GetFromRegistry(void);
	void UpdateDialogState(void);
	void AttachCalculator(PlotCalc* pXPlotCalc,PlotCalc* pYPlotCalc,PlotCalc* pZPlotCalc,
						  PlotCalc* pRPlotCalc,PlotCalc* pGPlotCalc,PlotCalc* pBPlotCalc);
	int  SetSurfaceName(CString name="");
	CString GetSurfaceName(void);
	CString GetPlotRegPath(void);
	CString GetSurfaceRegPath(void);

	// data
	int  m_is_equation_ok;
	COLORREF	m_line_color;
	COLORREF	m_background_color;
	CString		m_surface_name;
	int			m_use_sphere_range; // 0=use cube range, else use spherical range

// Dialog Data
	//{{AFX_DATA(DlgEditPlotP)
	enum { IDD = IDD_EDIT_PLOT_PARMS };
	CComboBox	m_list_surfaces;
	double	m_zrotate;
	double	m_xytilt;
	BOOL	m_remove_hidden_lines;
	double	m_scale;
	CString	m_sC1;
	CString	m_sC2;
	CString	m_sC3;
	CString	m_sC4;
	CString	m_sC5;
	CString	m_sC6;
	CString	m_sC7;
	CString	m_sC8;
	CString	m_sEquationStatus;
	BOOL	m_show_axis;
	UINT	m_uLines;
	double	m_umax;
	double	m_umin;
	UINT	m_vLines;
	double	m_vmax;
	double	m_vmin;
	CString	m_xPlotEquation;
	CString	m_yPlotEquation;
	CString	m_zPlotEquation;
	CString	m_rPlotEquation;
	CString	m_gPlotEquation;
	CString	m_bPlotEquation;
	BOOL	m_draw_ulines;
	BOOL	m_draw_vlines;
	BOOL	m_is_color;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(DlgEditPlotP)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	PlotCalc* m_pXPlotCalc;	// equation calculator (we don't own this memory)
	PlotCalc* m_pYPlotCalc;	// equation calculator (we don't own this memory)
	PlotCalc* m_pZPlotCalc;	// equation calculator (we don't own this memory)
	PlotCalc* m_pRPlotCalc;	// equation calculator (we don't own this memory)
	PlotCalc* m_pGPlotCalc;	// equation calculator (we don't own this memory)
	PlotCalc* m_pBPlotCalc;	// equation calculator (we don't own this memory)

	// Generated message map functions
	//{{AFX_MSG(DlgEditPlotP)
	virtual BOOL OnInitDialog();
	afx_msg void OnRadioCrossSections();
	afx_msg void OnButtonLineColor();
	afx_msg void OnButtonBackgroundColor();
	afx_msg void OnPaint();
	afx_msg void OnParmHelp();
	afx_msg void OnButtonTest();
	virtual void OnOK();
	afx_msg void OnButtonNew();
	afx_msg void OnButtonDelete();
	afx_msg void OnSelchangeComboListSurface();
	afx_msg void OnCancel();
	afx_msg void OnButtonSyntax();
	afx_msg void OnButtonSave();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_DLGEDITPLOTP_H__A277A2A4_92BD_11D3_8D3C_00105AE81499__INCLUDED_)
