// Win3DPView.h : interface of the CWin3DPView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_WIN3DPVIEW_H__A488E708_5D96_11D4_8705_00B0D02C8560__INCLUDED_)
#define AFX_WIN3DPVIEW_H__A488E708_5D96_11D4_8705_00B0D02C8560__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "WinPlot3DP.h"

class CWin3DPView : public CView
{
protected: // create from serialization only
	CWin3DPView();
	DECLARE_DYNCREATE(CWin3DPView)

// Attributes
public:
	CWin3DPDoc* GetDocument();

	// plot variables
	BOOL	m_is_drawn;	// 0=no, 1=plot has been drawn (used for redraw via plot file)
	CRect	m_plot_rect;// plot rectangle
	WinPlot3DP	 m_plot3D;	// the 3D plotting object

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CWin3DPView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual void OnInitialUpdate();
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CWin3DPView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CWin3DPView)
	afx_msg void OnDrawPlot();
	afx_msg void OnResizeWindow();
	afx_msg void OnEditCopy();
	afx_msg void OnHelpGettingstarted();
	afx_msg void OnHelpHiddenlineremoval();
	afx_msg void OnHelpIntroduction();
	afx_msg void OnHelpPlotparameters();
	afx_msg void OnHelpTips();
	afx_msg void OnHelpCprogramming();
	afx_msg void OnUpdateEditCopy(CCmdUI* pCmdUI);
	afx_msg void OnHelpExport();
	afx_msg void OnExportPov();
	afx_msg void OnUpdateExportPov(CCmdUI* pCmdUI);
	afx_msg void OnUpdateDrawPlot(CCmdUI* pCmdUI);
	afx_msg void OnUpdateCloseView(CCmdUI* pCmdUI);
	afx_msg void OnUpdateNewView(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in Win3DPView.cpp
inline CWin3DPDoc* CWin3DPView::GetDocument()
   { return (CWin3DPDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_WIN3DPVIEW_H__A488E708_5D96_11D4_8705_00B0D02C8560__INCLUDED_)
