/* Quat - A 3D fractal generation program */ 
/* Copyright (C) 1997,98 Dirk Meyer */ 
/* (email: dirk.meyer@studbox.uni-stuttgart.de) */ 
/* mail:  Dirk Meyer */ 
/*        Marbacher Weg 29 */ 
/*        D-71334 Waiblingen */ 
/*        Germany */ 
/* */ 
/* This program is free software; you can redistribute it and/or */ 
/* modify it under the terms of the GNU General Public License */ 
/* as published by the Free Software Foundation; either version 2 */ 
/* of the License, or (at your option) any later version. */ 
/* */ 
/* This program is distributed in the hope that it will be useful, */ 
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */ 
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */ 
/* GNU General Public License for more details. */ 
/* */ 
/* You should have received a copy of the GNU General Public License */ 
/* along with this program; if not, write to the Free Software */ 
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */ 
 
#include <stdlib.h>
#include <string.h>
#include "ObjectEditor.moc"

#define Inherited ObjectEditorData
//#include <stdio.h>

ObjectEditor::ObjectEditor(QWidget* parent, const char* name, bool nochange)
   : Inherited( parent, name )
{
   connect(this, SIGNAL(cxChanged(QString)), MP, SLOT(setCx(QString)) );
   connect(this, SIGNAL(cyChanged(QString)), MP, SLOT(setCy(QString)) );
   connect(this, SIGNAL(ckChanged(QString)), MP, SLOT(setCk(QString)) );
   connect(this, SIGNAL(clChanged(QString)), MP, SLOT(setCl(QString)) );
   connect(this, SIGNAL(maxiterChanged(QString)), MP, SLOT(setMaxiter(QString)) );
   connect(this, SIGNAL(bailoutChanged(QString)), MP, SLOT(setBailout(QString)) );
   connect(this, SIGNAL(formulaChanged(int)), MP, SLOT(setFormula(int)) );    
   connect(this, SIGNAL(Move_Up()), MP, SLOT(MoveUp()) );
   connect(this, SIGNAL(Move_Down()), MP, SLOT(MoveDown()) );
   connect(this, SIGNAL(Move_Left()), MP, SLOT(MoveLeft()) );
   connect(this, SIGNAL(Move_Right()), MP, SLOT(MoveRight()) );
   connect(this, SIGNAL(Zoom_In()), MP, SLOT(ZoomIn()) );
   connect(this, SIGNAL(Zoom_Out()), MP, SLOT(ZoomOut()) );
   connect(MP, SIGNAL(cxChanged(const char *)), this, SLOT(setCx(const char *)) );
   connect(MP, SIGNAL(cyChanged(const char *)), this, SLOT(setCy(const char *)) );
   connect(this, SIGNAL(cxChanged(QString)), JP, SLOT(setCx(QString)) );
   connect(this, SIGNAL(cyChanged(QString)), JP, SLOT(setCy(QString)) );
   connect(this, SIGNAL(ckChanged(QString)), JP, SLOT(setCk(QString)) );
   connect(this, SIGNAL(clChanged(QString)), JP, SLOT(setCl(QString)) );
   connect(this, SIGNAL(maxiterChanged(QString)), JP, SLOT(setMaxiter(QString)) );
   connect(this, SIGNAL(bailoutChanged(QString)), JP, SLOT(setBailout(QString)) );
   connect(this, SIGNAL(formulaChanged(int)), JP, SLOT(setFormula(int)) );    
   connect(this, SIGNAL(lvalueChanged(QString)), JP, SLOT(setLvalue(QString)) );
   connect(this, SIGNAL(kvalueChanged(int)), JP, SLOT(setKvalue(int)) );
   connect(this, SIGNAL(sig2DPreview()), JP, SLOT(CalcImage2D()) );
   connect(this, SIGNAL(sig3DPreview()), JP, SLOT(CalcImage3D()) );
   connect(this, SIGNAL(ownViewChanged(bool)), JP, SLOT(setOwnView(bool)) );
   connect(this, SIGNAL(cxChanged(const char *)), edit_cx, SLOT(setText(const char *)) );
   connect(this, SIGNAL(cyChanged(const char *)), edit_cy, SLOT(setText(const char *)) );
   connect(this, SIGNAL(ckChanged(const char *)), edit_ck, SLOT(setText(const char *)) );
   connect(this, SIGNAL(clChanged(const char *)), edit_cl, SLOT(setText(const char *)) );
   connect(this, SIGNAL(maxiterChanged(const char*)), edit_maxiter, SLOT(setText(const char *)) );
   connect(this, SIGNAL(lvalueChanged(const char*)), edit_lvalue, SLOT(setText(const char *)) );
   connect(this, SIGNAL(bailoutChanged(const char*)), edit_bailout, SLOT(setText(const char *)) );
   emit cxChanged("0"); emit cyChanged("0"); emit ckChanged("0"); emit clChanged("0");
   emit maxiterChanged("0"); emit lvalueChanged("0"); emit bailoutChanged("0"); 
   emit formulaChanged(0); emit kvalueChanged(0);
   list_formula->setCurrentItem(0); label_kvalue->setText("0");
   emit ownViewChanged(FALSE);
   setCaption("Object Editor");
   if (nochange)
   {
      edit_maxiter->setEnabled(FALSE);
      edit_lvalue->setEnabled(FALSE);
      edit_bailout->setEnabled(FALSE);
      list_formula->setEnabled(FALSE);
      edit_cx->setEnabled(FALSE);
      edit_cy->setEnabled(FALSE);
      edit_ck->setEnabled(FALSE);
      edit_cl->setEnabled(FALSE);
      MP->setEnabled(FALSE);
   }
}

ObjectEditor::~ObjectEditor()
{
}

void ObjectEditor::SetData(int s_Maxiter, double s_Lvalue, double s_Bailout,  int s_Formula,
   double s_cx, double s_cy, double s_ck, double s_cl)
{
   if (Maxiter.toInt(NULL) != s_Maxiter)
   {
      Maxiter.setNum(s_Maxiter); 
      emit maxiterChanged(Maxiter);
      emit maxiterChanged((const char *)Maxiter);
   }
   if (LValue.toDouble(NULL) != s_Lvalue)
   {
      LValue.setNum(s_Lvalue, 'g', 12); 
      emit lvalueChanged(LValue);
      emit lvalueChanged((const char *)LValue);
   }
   if (Bailout.toDouble(NULL) != s_Bailout)
   {
      Bailout.setNum(s_Bailout, 'g', 12);
      emit bailoutChanged(Bailout);
      emit bailoutChanged((const char *)Bailout);
   }
   if (s_Formula != Formula)
   {
      Formula = s_Formula;
      list_formula->setCurrentItem(Formula);
      emit formulaChanged(Formula);
   }
   if (cx.toDouble(NULL) != s_cx)
   {
      cx.setNum(s_cx, 'g', 12);
      emit cxChanged(cx);
      emit cxChanged((const char *)cx);
   }
   if (cy.toDouble(NULL) != s_cy)
   {
      cy.setNum(s_cy, 'g', 12);
      emit cyChanged(cy);
      emit cyChanged((const char *)cy);
   }
   if (ck.toDouble(NULL) != s_ck)
   {
      ck.setNum(s_ck, 'g', 12); 
      emit ckChanged(ck);
      emit ckChanged((const char*)ck);
   }
   if (cl.toDouble(NULL) != s_cl)
   {
      cl.setNum(s_cl, 'g', 12);
      emit clChanged(cl);
      emit clChanged((const char *)cl);
   }
   MP->CalcImage();
}

void ObjectEditor::GetData(int* g_Maxiter, double* g_Lvalue, double* g_Bailout, int* g_Formula,
   double* g_cx, double* g_cy, double* g_ck, double* g_cl)
{
   *g_Maxiter = Maxiter.toInt(NULL); 
   *g_Lvalue = LValue.toDouble(NULL); 
   *g_Bailout = Bailout.toDouble(NULL);
   *g_Formula = Formula;
   *g_cx = cx.toDouble(NULL);
   *g_cy = cy.toDouble(NULL); 
   *g_ck = ck.toDouble(NULL); 
   *g_cl = cl.toDouble(NULL);
}

void ObjectEditor::setMaxiter(const char *c)
{
   Maxiter.setStr(c);
   emit maxiterChanged(Maxiter);
}

void ObjectEditor::setBailout(const char *c)
{
   Bailout.setStr(c);
   emit bailoutChanged(Bailout);
}

void ObjectEditor::setLvalue(const char *c)
{
   LValue.setStr(c);
   emit lvalueChanged(LValue);
}

void ObjectEditor::setFormula(const int i)
{
   Formula = i;
   list_formula->setCurrentItem(Formula);
   emit formulaChanged(Formula);
}

void ObjectEditor::setCx(const char *c)
{
   if (cx.isNull() || strcmp((const char *)cx, c)!=0)
   {
      cx.setStr(c);
      emit cxChanged(cx);
      if (strcmp(c, edit_cx->text()) != 0) emit cxChanged((const char *)cx);
   }
}

void ObjectEditor::setCy(const char *c)
{
   if (cy.isNull() || strcmp((const char *)cy, c)!=0)
   {
      cy.setStr(c);
      emit cyChanged(cy);
      if (strcmp(c, edit_cx->text()) != 0) emit cyChanged((const char *)cy);
   }
}

void ObjectEditor::setCk(const char *c)
{
   ck.setStr(c);
   emit ckChanged(ck);
}

void ObjectEditor::setCl(const char *c)
{
   cl.setStr(c);
   emit clChanged(cl);
}

void ObjectEditor::setKvalue(int i)
{
   QString s;
   double d;

   KValue = i;
   d = (double)i/100;
   s.setNum(d);
   label_kvalue->setText((const char *)s);
   emit kvalueChanged(i);
}

void ObjectEditor::up()
{
   emit Move_Up();
}

void ObjectEditor::down()
{
   emit Move_Down();
}

void ObjectEditor::left()
{
   emit Move_Left();
}

void ObjectEditor::ZoomIn()
{
   emit Zoom_In();
}

void ObjectEditor::ZoomOut()
{
   emit Zoom_Out();
}

void ObjectEditor::right()
{
   emit Move_Right();
}

void ObjectEditor::do2DPreview()
{
   emit sig2DPreview();
}

void ObjectEditor::do3DPreview()
{
   emit sig3DPreview();
}

void ObjectEditor::setOwnView(bool b)
{
   emit ownViewChanged(b);
}

