/* Quat - A 3D fractal generation program */ 
/* Copyright (C) 1997,98 Dirk Meyer */ 
/* (email: dirk.meyer@studbox.uni-stuttgart.de) */ 
/* mail:  Dirk Meyer */ 
/*        Marbacher Weg 29 */ 
/*        D-71334 Waiblingen */ 
/*        Germany */ 
/* */ 
/* This program is free software; you can redistribute it and/or */ 
/* modify it under the terms of the GNU General Public License */ 
/* as published by the Free Software Foundation; either version 2 */ 
/* of the License, or (at your option) any later version. */ 
/* */ 
/* This program is distributed in the hope that it will be useful, */ 
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */ 
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */ 
/* GNU General Public License for more details. */ 
/* */ 
/* You should have received a copy of the GNU General Public License */ 
/* along with this program; if not, write to the Free Software */ 
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */ 
 
#include <math.h>
#include "ViewEditor.moc"
//#include <stdio.h>

#define Inherited ViewEditorData

ViewEditor::ViewEditor(QWidget* parent, const char* name, bool img, bool zbuf)
   :Inherited( parent, name )
{
   setCaption( "View Editor" );
   connect(this, SIGNAL(view_e_Changed2(const char *)), edit_view_e, SLOT(setText(const char *)) );
   connect(this, SIGNAL(view_j_Changed2(const char *)), edit_view_j, SLOT(setText(const char *)) );
   connect(this, SIGNAL(view_k_Changed2(const char *)), edit_view_k, SLOT(setText(const char *)) );
   connect(this, SIGNAL(up_e_Changed2(const char *)), edit_up_e, SLOT(setText(const char *)) );
   connect(this, SIGNAL(up_j_Changed2(const char *)), edit_up_j, SLOT(setText(const char *)) );
   connect(this, SIGNAL(up_k_Changed2(const char *)), edit_up_k, SLOT(setText(const char *)) );
   connect(this, SIGNAL(light_e_Changed(const char *)), edit_light_e, SLOT(setText(const char *)) );
   connect(this, SIGNAL(light_j_Changed(const char *)), edit_light_j, SLOT(setText(const char *)) );
   connect(this, SIGNAL(light_k_Changed(const char *)), edit_light_k, SLOT(setText(const char *)) );
   connect(this, SIGNAL(move_x_Changed2(const char *)), edit_move_x, SLOT(setText(const char *)) );
   connect(this, SIGNAL(move_y_Changed2(const char *)), edit_move_y, SLOT(setText(const char *)) );
   connect(this, SIGNAL(lxr_Changed2(const char *)), edit_lxr, SLOT(setText(const char *)) );
   connect(this, SIGNAL(interocular_Changed2(const char *)), edit_interocular, SLOT(setText(const char *)) );

   /* Signals for ViewSelector 1 */
   connect(this, SIGNAL(view_e_Changed(const char *)), ViewSelector_1, SLOT(setView_e(const char *)) );
   connect(this, SIGNAL(view_j_Changed(const char *)), ViewSelector_1, SLOT(setView_j(const char *)) );
   connect(this, SIGNAL(view_k_Changed(const char *)), ViewSelector_1, SLOT(setView_k(const char *)) );
   connect(this, SIGNAL(up_e_Changed(const char *)), ViewSelector_1, SLOT(setUp_e(const char *)) );
   connect(this, SIGNAL(up_j_Changed(const char *)), ViewSelector_1, SLOT(setUp_j(const char *)) );
   connect(this, SIGNAL(up_k_Changed(const char *)), ViewSelector_1, SLOT(setUp_k(const char *)) );
   connect(this, SIGNAL(move_x_Changed(const char *)), ViewSelector_1, SLOT(setMove_x(const char *)) );
   connect(this, SIGNAL(move_y_Changed(const char *)), ViewSelector_1, SLOT(setMove_y(const char *)) );
   connect(this, SIGNAL(lxr_Changed(const char *)), ViewSelector_1, SLOT(setLxr(const char *)) );
   connect(ViewSelector_1, SIGNAL(view_e_Changed(const char *)), this, SLOT(setView_e(const char *)) );
   connect(ViewSelector_1, SIGNAL(view_j_Changed(const char *)), this, SLOT(setView_j(const char *)) );
   connect(ViewSelector_1, SIGNAL(view_k_Changed(const char *)), this, SLOT(setView_k(const char *)) );
   ViewSelector_1->SetData(0, 2, 1, -1);

   /* Signals for ViewSelector 2 */
   connect(this, SIGNAL(view_e_Changed(const char *)), ViewSelector_2, SLOT(setView_e(const char *)) );
   connect(this, SIGNAL(view_j_Changed(const char *)), ViewSelector_2, SLOT(setView_j(const char *)) );
   connect(this, SIGNAL(view_k_Changed(const char *)), ViewSelector_2, SLOT(setView_k(const char *)) );
   connect(this, SIGNAL(up_e_Changed(const char *)), ViewSelector_2, SLOT(setUp_e(const char *)) );
   connect(this, SIGNAL(up_j_Changed(const char *)), ViewSelector_2, SLOT(setUp_j(const char *)) );
   connect(this, SIGNAL(up_k_Changed(const char *)), ViewSelector_2, SLOT(setUp_k(const char *)) );
   connect(this, SIGNAL(move_x_Changed(const char *)), ViewSelector_2, SLOT(setMove_x(const char *)) );
   connect(this, SIGNAL(move_y_Changed(const char *)), ViewSelector_2, SLOT(setMove_y(const char *)) );
   connect(this, SIGNAL(lxr_Changed(const char *)), ViewSelector_2, SLOT(setLxr(const char *)) );
   connect(ViewSelector_2, SIGNAL(view_e_Changed(const char *)), this, SLOT(setView_e(const char *)) );
   connect(ViewSelector_2, SIGNAL(view_j_Changed(const char *)), this, SLOT(setView_j(const char *)) );
   connect(ViewSelector_2, SIGNAL(view_k_Changed(const char *)), this, SLOT(setView_k(const char *)) );
   ViewSelector_2->SetData(2, 1, -1, 1);

   /* Signals for ViewSelector 3 */
   connect(this, SIGNAL(view_e_Changed(const char *)), ViewSelector_3, SLOT(setView_e(const char *)) );
   connect(this, SIGNAL(view_j_Changed(const char *)), ViewSelector_3, SLOT(setView_j(const char *)) );
   connect(this, SIGNAL(view_k_Changed(const char *)), ViewSelector_3, SLOT(setView_k(const char *)) );
   connect(this, SIGNAL(up_e_Changed(const char *)), ViewSelector_3, SLOT(setUp_e(const char *)) );
   connect(this, SIGNAL(up_j_Changed(const char *)), ViewSelector_3, SLOT(setUp_j(const char *)) );
   connect(this, SIGNAL(up_k_Changed(const char *)), ViewSelector_3, SLOT(setUp_k(const char *)) );
   connect(this, SIGNAL(move_x_Changed(const char *)), ViewSelector_3, SLOT(setMove_x(const char *)) );
   connect(this, SIGNAL(move_y_Changed(const char *)), ViewSelector_3, SLOT(setMove_y(const char *)) );
   connect(this, SIGNAL(lxr_Changed(const char *)), ViewSelector_3, SLOT(setLxr(const char *)) );
   connect(ViewSelector_3, SIGNAL(view_e_Changed(const char *)), this, SLOT(setView_e(const char *)) );
   connect(ViewSelector_3, SIGNAL(view_j_Changed(const char *)), this, SLOT(setView_j(const char *)) );
   connect(ViewSelector_3, SIGNAL(view_k_Changed(const char *)), this, SLOT(setView_k(const char *)) );
   ViewSelector_3->SetData(0, 1, 1, 1);

   setView_e("0"); setView_j("0"); setView_k("0");
   setUp_e("0"); setUp_j("0"); setUp_k("0");
   setLight_e("0"); setLight_j("0"); setLight_k("0");
   setMove_x("0"); setMove_y("0"); setLxr("0"); setInterocular("0");
 /*  emit (view_e_Changed("0")); emit (view_j_Changed("0")); emit (view_k_Changed("0"));
   emit (up_e_Changed("0")); emit (up_j_Changed("0")); emit (up_k_Changed("0"));
   emit (light_e_Changed("0")); emit (light_j_Changed("0")); emit (light_k_Changed("0"));
   emit (move_x_Changed("0")); emit (move_y_Changed("0"));
   emit (lxr_Changed("0")); emit (interocular_Changed("0"));*/

   /* Now: set update of angle */
   connect(this, SIGNAL(view_e_Changed(const char *)), this, SLOT(UpdateAngle(const char *)) );
   connect(this, SIGNAL(view_j_Changed(const char *)), this, SLOT(UpdateAngle(const char *)) );
   connect(this, SIGNAL(view_k_Changed(const char *)), this, SLOT(UpdateAngle(const char *)) );
   connect(this, SIGNAL(interocular_Changed(const char *)), this, SLOT(UpdateAngle(const char *)) );
   SaveClicked();

   if (zbuf || img)
   {
      edit_view_e->setEnabled(FALSE);
      edit_view_j->setEnabled(FALSE);
      edit_view_k->setEnabled(FALSE);
      edit_up_e->setEnabled(FALSE);
      edit_up_j->setEnabled(FALSE);
      edit_up_k->setEnabled(FALSE);
      edit_move_x->setEnabled(FALSE);
      edit_move_y->setEnabled(FALSE);
      edit_lxr->setEnabled(FALSE);
      edit_interocular->setEnabled(FALSE);
      button_save->setEnabled(FALSE);
      button_restore->setEnabled(FALSE);
      ViewSelector_1->setEnabled(FALSE);
      ViewSelector_2->setEnabled(FALSE);
      ViewSelector_3->setEnabled(FALSE);
   }
   if (img)
   {
      edit_light_e->setEnabled(FALSE);
      edit_light_j->setEnabled(FALSE);
      edit_light_k->setEnabled(FALSE);
   }
}

ViewEditor::~ViewEditor()
{
}

void ViewEditor::SetData(double *s_view, double *s_up, double *s_light, double *s_move, 
   double s_lxr, double s_interocular)
{
   if (view_e.toDouble(NULL) != s_view[0])
   {
      view_e.setNum(s_view[0], 'g', 12);
//      emit view_e_Changed((const char *)view_e);
      setView_e((const char*)view_e);
   }
   if (view_j.toDouble(NULL) != s_view[1])
   {
      view_j.setNum(s_view[1], 'g', 12);
      setView_j((const char *)view_j);
   }
   if (view_k.toDouble(NULL) != s_view[2])
   {
      view_k.setNum(s_view[2], 'g', 12);
      setView_k((const char *)view_k);
   }

   if (up_e.toDouble(NULL) != s_up[0])
   {
      up_e.setNum(s_up[0], 'g', 12);
      setUp_e((const char *)up_e);
   }
   if (up_j.toDouble(NULL) != s_up[1])
   {
      up_j.setNum(s_up[1], 'g', 12);
      setUp_j((const char *)up_j);
   }
   if (up_k.toDouble(NULL) != s_up[2])
   {
      up_k.setNum(s_up[2], 'g', 12);
      setUp_k((const char *)up_k);
   }

   if (light_e.toDouble(NULL) != s_light[0])
   {
      light_e.setNum(s_light[0], 'g', 12);
      setLight_e((const char *)light_e);
   }
   if (light_j.toDouble(NULL) != s_light[1])
   {
      light_j.setNum(s_light[1], 'g', 12);
      setLight_j((const char *)light_j);
   }
   if (light_k.toDouble(NULL) != s_light[2])
   {
      light_k.setNum(s_light[2], 'g', 12);
      setLight_k((const char *)light_k);
   }

   if (move_x.toDouble(NULL) != s_move[0])
   {
      move_x.setNum(s_move[0], 'g', 12);
      setMove_x((const char *)move_x);
   }
   if (move_y.toDouble(NULL) != s_move[1])
   {
      move_y.setNum(s_move[1], 'g', 12);
      setMove_y((const char *)move_y);
   }

   if (lxr.toDouble(NULL) != s_lxr)
   {
      lxr.setNum(s_lxr, 'g', 12);
      setLxr(lxr);
   }
   if (interocular.toDouble(NULL) != s_interocular)
   {
      interocular.setNum(s_interocular, 'g', 12);
      setInterocular(interocular);
   }
}

void ViewEditor::GetData(double *g_view, double *g_up, double *g_light, double *g_move, 
   double *g_lxr, double *g_interocular)
{
   g_view[0] = view_e.toDouble(NULL);
   g_view[1] = view_j.toDouble(NULL);
   g_view[2] = view_k.toDouble(NULL);
   g_up[0] = up_e.toDouble(NULL);
   g_up[1] = up_j.toDouble(NULL);
   g_up[2] = up_k.toDouble(NULL);
   g_light[0] = light_e.toDouble(NULL);
   g_light[1] = light_j.toDouble(NULL);
   g_light[2] = light_k.toDouble(NULL);
   g_move[0] = move_x.toDouble(NULL);
   g_move[1] = move_y.toDouble(NULL);
   *g_interocular = interocular.toDouble(NULL);
   *g_lxr = lxr.toDouble(NULL);
}

void ViewEditor::setView_e(const char *c)
{
   view_e.setStr(c);
   emit view_e_Changed(c);
//   if (!edit_view_e->text()) return;
   if (strcmp(c, edit_view_e->text()) != 0) emit view_e_Changed2(c);
}

void ViewEditor::setView_j(const char *c)
{
   view_j.setStr(c);
   emit view_j_Changed(c);
   if (strcmp(c, edit_view_j->text()) != 0) emit view_j_Changed2(c);
}

void ViewEditor::setView_k(const char *c)
{
   view_k.setStr(c);
   emit view_k_Changed(c);
   if (strcmp(c, edit_view_k->text()) != 0) emit view_k_Changed2(c);
}

void ViewEditor::setUp_e(const char *c)
{
   up_e.setStr(c);
   emit up_e_Changed(c);
   if (strcmp(c, edit_up_e->text()) != 0) emit up_e_Changed2(c);
}

void ViewEditor::setUp_j(const char *c)
{
   up_j.setStr(c);
   emit up_j_Changed(c);
   if (strcmp(c, edit_up_j->text()) != 0) emit up_j_Changed2(c);
}

void ViewEditor::setUp_k(const char *c)
{
   up_k.setStr(c);
   emit up_k_Changed(c);
   if (strcmp(c, edit_up_k->text()) != 0) emit up_k_Changed2(c);
}

void ViewEditor::setLight_e(const char *c)
{
   light_e.setStr(c);
   emit light_e_Changed(c);
}

void ViewEditor::setLight_j(const char *c)
{
   light_j.setStr(c);
   emit light_j_Changed(c);
}

void ViewEditor::setLight_k(const char *c)
{
   light_k.setStr(c);
   emit light_k_Changed(c);
}

void ViewEditor::setMove_x(const char *c)
{
   move_x.setStr(c);
   emit move_x_Changed(c);
   if (strcmp(c, edit_move_x->text()) != 0) emit move_x_Changed2(c);
}

void ViewEditor::setMove_y(const char *c)
{
   move_y.setStr(c);
   emit move_y_Changed(c);
   if (strcmp(c, edit_move_y->text()) != 0) emit move_y_Changed2(c);
}

void ViewEditor::setLxr(const char *c)
{
   lxr.setStr(c);
   emit lxr_Changed(c);
   if (strcmp(c, edit_lxr->text()) != 0) emit lxr_Changed2(c);
}

void ViewEditor::setInterocular(const char *c)
{
   interocular.setStr(c);
   emit interocular_Changed(c);
   if (strcmp(c, edit_interocular->text()) != 0) emit interocular_Changed2(c);
}

void ViewEditor::UpdateAngle(const char *c)
{
   double angle;
   QString s;
 
   angle = view_e.toDouble(NULL)*view_e.toDouble(NULL);
   angle += view_j.toDouble(NULL)*view_j.toDouble(NULL);
   angle += view_k.toDouble(NULL)*view_k.toDouble(NULL);
   if (angle<0) return;    /* theoretically not possible ... */
   angle = sqrt(angle);
   if (angle==0) return;
   angle = 2*atan(0.5*interocular.toDouble(NULL)/angle);
   angle *= 360/6.28318;
   s.setNum(angle, 'g', 4);
   s.append("");
   label_angle->setText((const char*) s);
}

void ViewEditor::SaveClicked()
{
   b_view_e.setStr((const char*)view_e); 
   b_view_j.setStr((const char*)view_j); 
   b_view_k.setStr((const char*)view_k);
}

void ViewEditor::RestoreClicked()
{
   setView_e((const char*)b_view_e);
   setView_j((const char*)b_view_j);
   setView_k((const char*)b_view_k);
}

