/* AddressBook - Contact
 * Copyright (C) 1999 Dmitry Rogatkin.  All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 *  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 *  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 *  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 *  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package addressbook;

import java.util.*;
import javax.swing.table.*;

public class Contact /*implements*/ {
    Vector addresses, emails, links;
    TelephoneTableModel telephones;

    public void addAddress(Address address) {
    }

    public void addTelephone(Telephone telephone) {
    }

    public void addEMail(EMail email) {
    }

    public void addLink(Link link) {
    }

    public void add(Object o) {
	if (o instanceof Address)
	    addAddress((Address)o);
    }

    public TableModel telephones() {
	return telephones;
    }

    class TelephoneTableModel extends AbstractTableModel {
	Vector values;
	public int getRowCount() {
	    return values.size();
	}

	public int getColumnCount() {
	    return 2;
	}

	public Object getValueAt(int row, int column) {
	    switch(column) {
	    case 0: return ((Telephone)values.elementAt(row)).getShortDescription();
	    default: return ((Telephone)values.elementAt(row)).getCanonical();
	    }
	}

	public Telephone getValueAt(int row) {
	    return (Telephone)values.elementAt(row);
	}

	public void removeValue(Telephone telephone) {
	}

	public void removeValue(int row) {
	}

	public void setValueAt(int row, Telephone telephone) {
	}

	public void addValue(Telephone telephone) {
	}

    }
}