/* AddressBook - OptionsFrame
 * Copyright (C) 1999 Dmitry Rogatkin.  All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 *  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 *  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 *  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 *  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package addressbook;

import java.awt.event.*;
import java.awt.Container;

import javax.swing.*;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
//import java.awt.BorderLayout;

import rogatkin.*;

public class OptionsFrame extends JFrame implements ActionListener, Persistentable {
    BaseController controller;
    OptionsFrame(BaseController controller) {
	this.controller = controller;
	Container c = getContentPane();
	JTabbedPane tabbedpane = new JTabbedPane(SwingConstants.TOP);
	tabbedpane.insertTab(AddressBookResources.TAB_STORAGE, (Icon)null,
            new StorageTab(),
            AddressBookResources.TTIP_STORAGE,
            0);
	c.add(tabbedpane, "Center");
        c.add(AddressBookFrame.createButtonPanel(this), "South");
        pack();
        setVisible(true);
	load();
    }
     
    public void actionPerformed(ActionEvent a) {
        String cmd = a.getActionCommand();
	// TODO: migrate resources
        if (cmd.equals(AddressBookResources.CMD_OK)) {
            save();
	    dispose();
            //setVisible(false);
        } else if (cmd.equals(AddressBookResources.CMD_APPLY)) {
            save();
        } else if (cmd.equals(AddressBookResources.CMD_CANCEL)) {
	    dispose();
            //setVisible(false);
        }
    }

    public void save() {
    }

    public void load() {
    }

    class StorageTab extends JPanel implements ChangeListener {
	ButtonGroup group;
	StorageTab() {
	    setLayout(new GranulatedLayout(5, 6, AddressBookResources.CTRL_VERT_SIZE, AddressBookResources.CTRL_VERT_GAP,
		AddressBookResources.CTRL_HORIS_INSET, AddressBookResources.CTRL_HORIZ_GAP));
	    group = new ButtonGroup();
	    add(rb_global = new JRadioButton(AddressBookResources.LABEL_GLOBAL), "0,0,2");
	    group.add(rb_global);
	    rb_global.addChangeListener(this);
	    add(new JLabel(AddressBookResources.LABEL_HOST), "1,1,1");
	    add(tf_addr_host = new JTextField(), "2,1,3");
	    add(rb_local = new JRadioButton(AddressBookResources.LABEL_LOCAL), "0,2,2");
	    group.add(rb_local);
	    rb_local.addChangeListener(this);
	    add(new JLabel(AddressBookResources.LABEL_DB_URL), "1,3,1");
	    add(tf_db_url = new JTextField(), "2,3,3");
	    add(cb_share_adr = new JCheckBox(AddressBookResources.LABEL_SHAREADDR), "0,4,2");
	    add(cb_synchro = new JCheckBox(AddressBookResources.LABEL_SYNCHRONIZE), "0,5,2");
	    
	    add(new JLabel(AddressBookResources.LABEL_LOGIN), "2,4,1");
	    add(tf_login = new JTextField(), "3,4,2");
	    add(new JLabel(AddressBookResources.LABEL_PASSWORD), "2,5,1");
	    add(tf_password = new JTextField(), "3,5,2");
	}
	
	public void stateChanged(ChangeEvent e) {
	    boolean global_enabled = rb_global.isSelected();
	    tf_addr_host.setEnabled(global_enabled);
	    tf_db_url.setEnabled(!global_enabled);
	}
	
	JRadioButton rb_global, rb_local;
	JTextField tf_addr_host, tf_db_url, tf_login, tf_password;
	JCheckBox cb_share_adr, cb_synchro;
    }
}