/* PhotoOrganizer 
 * Copyright (C) 1999 Dmitry Rogatkin.  All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 *  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 *  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 *  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 *  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package photoorganizer.renderer;

import javax.swing.*;
import javax.swing.table.*;
import java.util.*;
import java.awt.*;
import photoorganizer.formats.*;
import photoorganizer.Resources;
import photoorganizer.Controller;

public class PropertiesPanel extends JTabbedPane {

    public PropertiesPanel(BasicJpeg format) {
	AbstractImageInfo ii = format.getImageInfo();
        if (ii instanceof Exif) {
            insertTab(Resources.TAB_MAIN_IFD,
                (Icon)null,
                new JScrollPane(new JTable(new PropertiesTableModel((Exif)ii))),
                Resources.TTIP_MAIN_IFD,
                0);
            insertTab(Resources.TAB_THUMBNAIL,
                (Icon)null,
                new JScrollPane(new JTable(new PropertiesTableModel((Exif)ii, false))),
                Resources.TTIP_THUMB_IFD,
                1);
        } else if (ii instanceof JFXX) {
            insertTab(Resources.TAB_PICTURE_INFO,
                (Icon)null,
                new JScrollPane(new JTable(new HashPropTableModel(((JFXX)ii).getPictureInfo()))),
                Resources.TTIP_PICTURE_INFO,
                0);
            insertTab(Resources.TAB_CAMERA,
                (Icon)null,
                new JScrollPane(new JTable(new HashPropTableModel(((JFXX)ii).getCameraInfo()))),
                Resources.TTIP_CAMERA_INFO,
                1);
            insertTab(Resources.TAB_DIAGNOSTIC,
                (Icon)null,
                new JScrollPane(new JTable(new HashPropTableModel(((JFXX)ii).getDiagInfo()))),
                Resources.TTIP_DIAG_INFO,
                2);
        } else if (ii instanceof CIFF) {
            insertTab(Resources.TAB_HEAP,
                (Icon)null,
                new JScrollPane(new JTable(new HashPropTableModel(((CIFF)ii).getProperties()))),
                Resources.TTIP_HEAP,
                0);
        }
    }

    public void setProperties(BasicJpeg format) {
    }

    public static void showProperties(BasicJpeg format, Controller controller) {
	JFrame frame = new JFrame(Resources.TITLE_PROPS_OF+format.getLocationName());
	frame.getContentPane().add(new PropertiesPanel(format));
	frame.pack();
	frame.setVisible(true);
	frame.setIconImage(controller.getMainIcon());
    }
}

class PropertiesTableModel extends AbstractTableModel {
    
    final String [] columnnames = {Resources.HDR_TAG, Resources.HDR_TYPE, Resources.HDR_VALUE};
    private Vector tags;
    private Exif exif;
    private boolean flag_main_image;
    
    public PropertiesTableModel(Exif exif) {
        this(exif, true);
    }

    public PropertiesTableModel(Exif exif, boolean main) {
        tags = new Vector();
        setExif(exif, main);
    }

    public void setExif(Exif exif) {
        setExif(exif, true);
    }

    public void setExif(Exif exif, boolean main) {
        this.exif = exif;
        flag_main_image = main;
        if (exif == null)
            return;
        Enumeration tags = exif.tags(flag_main_image);
        while(tags.hasMoreElements())
            this.tags.addElement(tags.nextElement());
    }

    public int getRowCount() {
        return tags.size();
    }
    
    public int getColumnCount() {
        return columnnames.length;
    }

    public Object getValueAt(int row, int column) {
        if (column == 0)
            return Naming.getTagName((Integer)tags.elementAt(row));
        Entry entry = exif.getTagValue((Integer)tags.elementAt(row), flag_main_image);
        switch (column) {
            case 1:
                return Naming.getTypeName(entry.getType());
            case 2:
                return entry;
        }
        return null;
    }

    public String getColumnName(int column) {
        return columnnames[column];
    }
}

class HashPropTableModel extends AbstractTableModel {
    final String [] columnnames = {Resources.HDR_TAG, Resources.HDR_VALUE};
    Object []tags;
    Hashtable table;

    public HashPropTableModel(Hashtable table) {
        this.table = table;
        tags = new Object[table.size()];
        Enumeration e = table.keys();
        for (int i = 0; e.hasMoreElements(); i++) {
            tags[i] = e.nextElement();
        }
    }

    public int getRowCount() {
        return tags.length;
    }
    
    public int getColumnCount() {
        return columnnames.length;
    }

    public String getColumnName(int column) {
        return columnnames[column];
    }

    public Object getValueAt(int row, int column) {
        switch(column) {
        case 0:
            if (tags[row] instanceof String)
		return tags[row];
	    else if (tags[row] instanceof Integer)
		return Naming.getPropName((Integer)tags[row]);
	    break;
        case 1:
            return table.get(tags[row]);
        }
        return null;
    }
}

