/* PhotoOrganizer - SendEmailFrame 
 * Copyright (C) 1999-2000 Dmitry Rogatkin.  All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 *  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 *  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 *  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 *  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package photoorganizer.renderer;

import java.awt.event.*;
import java.awt.FlowLayout;
import java.io.*;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Date;

import javax.swing.*;
import javax.swing.border.EtchedBorder;
import javax.swing.border.BevelBorder;

import javax.mail.*;
import javax.mail.internet.*;

import rogatkin.*;
import photoorganizer.*;
import photoorganizer.courier.*;
import addressbook.*;

// Java mail implementation
public class SendEmailFrame extends JFrame implements ActionListener {
	static final int MAX_SUBJECT_LENGTH = 100;
	Controller controller;
	File[] files_to_send;
	public SendEmailFrame(Controller controller, File[] files) {
		super(Resources.TITLE_SENDTO);
		this.controller = controller;
		setIconImage(controller.getMainIcon());
		files_to_send = files;
		//getContentPane().setLayout(new BorderLayout());
		getContentPane().add(new SendEmail(), "Center");
		getContentPane().add(new AcionButtons(), "South");
		pack();
		setVisible(true);
	}
	
	public void actionPerformed(ActionEvent a) {
		String cmd = a.getActionCommand();
		if (cmd.equals(Resources.CMD_ADDRESSBOOK)) {
			new AddressBookFrame(controller);
			return;
		} else if (cmd.equals(Resources.CMD_OK)) {
			new Thread(new Runnable() {
				public void run() {
				send();
				}
				}, "E-Mail sender").start();
		}
		dispose();
	}

	void send() {
		Properties props = System.getProperties();
		Serializer s = controller.getSerializer();
		String sb = (String)s.getProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.SMTPSERVER);
		if (sb != null && sb.length() > 0)
			props.put("mail.smtp.host", sb);
		try {
			// Get a Session object
			Session session = Session.getDefaultInstance(props, null);
			session.setDebug(true); // 
			
			// construct the message
			Message msg = new MimeMessage(session);
			sb = (String)s.getProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.EMAILADDR);
			String person = Serializer.arrayToString(s.getProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.SMTPUSER));
			if (sb != null)
				msg.setFrom(person != null?new InternetAddress(sb, person):new InternetAddress(sb));
			else
				msg.setFrom();
			
			sb = tf_to.getText();
			msg.setRecipients(Message.RecipientType.TO,
							  InternetAddress.parse(sb, false));
			MimeBodyPart bp;
			Multipart mp = new MimeMultipart("related");
			Multipart mp2 = new MimeMultipart("alternative");
			bp = new MimeBodyPart();
			bp.setContent(mp2);
			mp.addBodyPart(bp);
			sb = ta.getText();
			if (sb.length() > 0) {
				String subject = new StringTokenizer(sb, "\n\r").nextToken();
				if (subject.length() > MAX_SUBJECT_LENGTH)
					subject = subject.substring(0,MAX_SUBJECT_LENGTH-1);
				msg.setSubject(subject);
				bp = new MimeBodyPart();
				bp.setContent(sb, "text/plain");
				mp.addBodyPart(bp);
			} else
				msg.setSubject(Resources.TITLE_DEF_EMAILSUBJECT);
			
			new HtmlProducer(controller).produce(new MailCourier(controller, mp, mp2), files_to_send);

			msg.setHeader("X-Mailer", PhotoOrganizer.PROGRAMNAME);
			msg.setHeader("Comments", Serializer.arrayToString(s.getProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.ORGANIZATION)));
			msg.setSentDate(new Date());
			msg.setContent(mp);
			
			// send the thing off
			Transport.send(msg);
		} catch(IOException ioex) {
			JOptionPane.showMessageDialog(controller.getMainFrame(), Resources.LABEL_ERR_MAIL_SEND+'\n'+ioex,
										  Resources.TITLE_ERROR, JOptionPane.ERROR_MESSAGE);
			ioex.printStackTrace();
		} catch(MessagingException mex) {
			  JOptionPane.showMessageDialog(controller.getMainFrame(), Resources.LABEL_ERR_MAIL_SEND+'\n'+mex,
											Resources.TITLE_ERROR, JOptionPane.ERROR_MESSAGE);
			  mex.printStackTrace();
		}
	}

	class SendEmail extends JPanel {
		SendEmail () {
			setLayout(new GranulatedLayout(5, 6, Resources.CTRL_VERT_SIZE, Resources.CTRL_VERT_GAP, Resources.CTRL_HORIS_INSET, Resources.CTRL_HORIZ_GAP));
			setBorder(new BevelBorder(EtchedBorder.RAISED));
			add(new JLabel(Resources.LABEL_SENDTO), "0,0,2");
			add(tf_to = new JTextField(), "0,1,3");
			JButton b;
			add(b = new JButton(Resources.CMD_ADDRESSBOOK), "3,1,2");
			b.addActionListener(SendEmailFrame.this);
			add(ta = new JTextArea(3, 1), "0,2,5,3");
			ta.setBorder(new BevelBorder(BevelBorder.LOWERED));
		}
	}

	class AcionButtons extends JPanel {
		AcionButtons() {
			setLayout(new FlowLayout(FlowLayout.RIGHT));
			JButton btn;
			add(btn = new JButton(Resources.CMD_OK));
			btn.addActionListener(SendEmailFrame.this);
			add(btn = new JButton(Resources.CMD_CANCEL));
			btn.addActionListener(SendEmailFrame.this);
		}
	}

	JTextField tf_to;
	JTextArea ta;
}
