//----------------------------------------------------------
#ifndef D3dMoveH
#define D3dMoveH
#include <dstring.h>

#include "D3dVCs.h"
//----------------------------------------------------------
//      
//----------------------------------------------------------
//    :
void Cruise  (PCtrl ctrl);
void HSlide  (PCtrl ctrl);
void VSlide  (PCtrl ctrl);
//    :
void Pitch   (PCtrl ctrl);
void Turn    (PCtrl ctrl);
void Bank    (PCtrl ctrl);
//----------------------------------------------------------
//    :
void SetCruise (PCtrl ctrl);
void SetHSlide (PCtrl ctrl);
void SetVSlide (PCtrl ctrl);
void StopMov   (PCtrl ctrl);
//    :
void SetPitch  (PCtrl ctrl);
void SetTurn   (PCtrl ctrl);
void SetBank   (PCtrl ctrl);
void StopRot   (PCtrl ctrl);
//----------------------------------------------------------
// TSampleCtrl
//----------------------------------------------------------
struct TSampleCtrl {
  TStrings *CtrLst;
  LPDIRECT3DRMFRAME IFrame;
  TSampleCtrl();
  ~TSampleCtrl();
  virtual void SetFrame   (LPDIRECT3DRMFRAME Iframe);
  virtual void SetView    (TD3dView* view);
  virtual void SetArg     (AnsiString& Name, D3DVALUE arg);
  virtual void SetLim     (AnsiString& Name, D3DVALUE lim);
  virtual void AddCtrl    (AnsiString& Name, D3DVALUE arg,
     PCTRLRFUN func, Cardinal  msg, Word CharCode,
     TShiftState shift);
};//--------------------------------------------------------
// TSampleStepCtrl
//----------------------------------------------------------
struct TSampleStepCtrl : public TSampleCtrl {
  TSampleStepCtrl();
  virtual void SetLinearArgs(D3DVALUE arg);
};//--------------------------------------------------------
// TSampleFlyCtrl
//----------------------------------------------------------
struct TSampleFlyCtrl : public TSampleCtrl {
  TSampleFlyCtrl();
  virtual void SetFrame(LPDIRECT3DRMFRAME Iframe);
};//--------------------------------------------------------
void Stay(LPDIRECT3DRMFRAME Iframe, LPVOID arg,
     D3DVALUE delta);
//----------------------------------------------------------
void Shake(LPDIRECT3DRMFRAME Iframe, LPVOID arg,
     D3DVALUE delta);
//----------------------------------------------------------
#endif
