/*
 * Decompiled with CFR 0.152.
 */
package org.hsql;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import org.hsql.Column;
import org.hsql.Record;
import org.hsql.Trace;

class Result {
    private Record rTail;
    private int iSize;
    private int iColumnCount;
    static final int UPDATECOUNT = 0;
    static final int ERROR = 1;
    static final int DATA = 2;
    int iMode;
    String sError;
    int iUpdateCount;
    Record rRoot;
    String[] sLabel;
    String[] sTable;
    String[] sName;
    int[] iType;

    Result() {
        this.iMode = 0;
        this.iUpdateCount = 0;
    }

    Result(byte[] byArray) throws SQLException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            this.iMode = dataInputStream.readInt();
            if (this.iMode == 1) {
                throw Trace.getError(dataInputStream.readUTF());
            }
            if (this.iMode == 0) {
                this.iUpdateCount = dataInputStream.readInt();
            } else if (this.iMode == 2) {
                int n = dataInputStream.readInt();
                this.prepareData(n);
                this.iColumnCount = n;
                int n2 = 0;
                while (n2 < n) {
                    this.iType[n2] = dataInputStream.readInt();
                    this.sLabel[n2] = dataInputStream.readUTF();
                    this.sTable[n2] = dataInputStream.readUTF();
                    this.sName[n2] = dataInputStream.readUTF();
                    ++n2;
                }
                while (dataInputStream.available() != 0) {
                    this.add(Column.readData(dataInputStream, n));
                }
            }
        }
        catch (IOException iOException) {
            Trace.error(18);
        }
    }

    Result(int n) {
        this.prepareData(n);
        this.iColumnCount = n;
    }

    Result(String string) {
        this.iMode = 1;
        this.sError = string;
    }

    void add(Object[] objectArray) {
        Record record = new Record();
        record.data = objectArray;
        if (this.rRoot == null) {
            this.rRoot = record;
        } else {
            this.rTail.next = record;
        }
        this.rTail = record;
        ++this.iSize;
    }

    void append(Result result) {
        if (this.rRoot == null) {
            this.rRoot = result.rRoot;
        } else {
            this.rTail.next = result.rRoot;
        }
        this.rTail = result.rTail;
        this.iSize += result.iSize;
    }

    byte[] getBytes() throws SQLException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(this.iMode);
            if (this.iMode == 0) {
                dataOutputStream.writeInt(this.iUpdateCount);
            } else if (this.iMode == 1) {
                dataOutputStream.writeUTF(this.sError);
            } else {
                int n = this.iColumnCount;
                dataOutputStream.writeInt(n);
                Record record = this.rRoot;
                int n2 = 0;
                while (n2 < n) {
                    dataOutputStream.writeInt(this.iType[n2]);
                    dataOutputStream.writeUTF(this.sLabel[n2]);
                    dataOutputStream.writeUTF(this.sTable[n2]);
                    dataOutputStream.writeUTF(this.sName[n2]);
                    ++n2;
                }
                while (record != null) {
                    Column.writeData(dataOutputStream, n, this.iType, record.data);
                    record = record.next;
                }
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw Trace.error(18);
        }
    }

    int getColumnCount() {
        return this.iColumnCount;
    }

    int getSize() {
        return this.iSize;
    }

    private void prepareData(int n) {
        this.iMode = 2;
        this.sLabel = new String[n];
        this.sTable = new String[n];
        this.sName = new String[n];
        this.iType = new int[n];
    }

    void setColumnCount(int n) {
        this.iColumnCount = n;
    }
}

