package com.gotdns.jimula.EatHealthy;

/**
 * <em>Activity</em> is an object which calculate activity by giving
 * it activity level, IBW(Ideal Body Weight), and sleeping hours.
 * <p>EatHealthy </p>
 * <p>A simple personal nutrient need and food serving calculator </p>
 * <p>Copyright (c) 2003</p>
 * @author Jimmy Ding
 * @version 1.01, 05/01/03
 */
public class Activity {

  //Calculated activity
  private float activity;

  /**
   * Constructs a new activity.
   * @param level  this activity level is given by user.
   * @param IBW    Ideal Body Weight
   */
  public Activity(float level,float IBW,int sleepingTime){

    this.activity=level*IBW*(24-sleepingTime);//formula
    this.activity=(float)(Math.round(this.activity*10))/10;

  }

  /**
   * Get the calculated activity of this object.
   * @return a float with activity
   */
  public float getActivity(){
    return this.activity;
  }
} // end Activity





