/* hpglcom.c */

#include "hplib.c"
#include "defn.h"
void hpglcom(char op1)
{
	 char    op2;

	 switch (toupper(op1))
	 {
	 case 'A':
	op2 = getc(stream);
	switch (op2)
	{
	case 'A':               /* Arc Absolute */
		 dumpit(1);
		 break;

	case 'F':               /* Advance Full Page */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	case 'H':               /* Advance Half Page */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	case 'P':               /* Automatic Pen Lift (HP-GL only) */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	case 'R':               /* Arc Relative */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	case 'S':               /* Acceleration Select */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	default:
		 notimp((stderr, "%c%c: Warning: Unknown HP-GL Command\n\n", op1,op2));
		 dumpit(2);
	}
	break;

	 case 'B':
	op2 = getc(stream);
	switch (op2)
	{
	case 'L':               /* Buffered Label String */
		 while (((ch = getc(stream)) != EOF) && ch != EOL);
		 notimp((stderr, "Not Implemented: %c%c",op1,op2));
		 break;

	default:
		 notimp((stderr, "%c%c: Warning: Unknown HP-GL Command\n\n", op1,op2));
		 dumpit(2);
	}
	break;

case 'C':
	op2 = getc(stream);
	switch (op2)
	{
	case 'A':               /* Alternate Character Set (Not Used) */
		 notimp((stderr, "Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	case 'C':               /* Character Chord Angle */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	case 'I':               /* Circle */
		 break;

	case 'M':               /* Character Selection Mode */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	case 'P':               /* Character Plot */
		 {
		float   xspace, yspace;

		xspace = getval() * XSCALE * SCALE * (char_width + char_space);
		yspace = getval() * YSCALE * SCALE * (char_width + char_space);

		DRAW_FLAG = 0;//end_draw();
		//printf("    %g mm %g mm \n", xspace, yspace/* RMOVE*/);
		 }
		 break;

	case 'S':               /* Standard Character Set */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	case 'T':               /* Chord Tolerance */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	default:
		 notimp((stderr, "Warning: %c%c Unknown HP-GL Command\n", op1, op2));
		 dumpit(2);
	}
	break;

case 'D':
	op2 = getc(stream);
	switch (op2)
	{
	case 'C':               /* Digitize Clear (Not Used) */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	case 'F':               /* Default */
		 //debugp((stderr,"%c%c",op1,op2));
		 dumpit(1);
		 break;

	case 'I':               /* Absolute Direction */
		 //debugp((stderr,"%c%c",op1,op2));
		 break;

	case 'L':               /* Downloadable Character */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	case 'P':               /* Digitize Point (Not Used) */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	case 'R':               /* Relative Direction */
		 //debugp((stderr,"%c%c",op1,op2));
		 break;

	case 'S':               /* Designate Character Set into Slot*/
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	case 'T':               /* Define Terminator */
		 debugp((stderr,"%c%c",op1,op2));
		 dumpit(1);
		 break;

	default:
		 notimp((stderr, "Warning: %c%c Unknown HP-GL Command\n", op1, op2));
		 dumpit(2);
	}
	break;

case 'E':
	op2 = getc(stream);
	switch (op2)
	{
	case 'A':               /* Edge Rectangle Absolute */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	case 'C':               /* Enable Cut Line */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	case 'P':               /* Edge Polygon */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	case 'R':               /* Edge Rectangle Relative */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	case 'S':               /* Extra Space */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	case 'W':               /* Edge Wedge */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	default:
		 notimp((stderr, "Warning: %c%c Unknown RD-GL Command\n", op1, op2));
		 dumpit(2);
	}
	break;

case 'F':
	op2 = getc(stream);
	switch (op2)
	{
	case 'P':               /* Fill Polygon */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	case 'R':               /* Advance Frame */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	case 'S':               /* Force Select */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	case 'T':               /* Fill Type */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	default:
		 notimp((stderr, "Warning: %c%c Unknown HP-GL Command\n", op1, op2));
		 dumpit(2);
	}
	break;

case 'G':
	op2 = getc(stream);
	switch (op2)
	{
	case 'P':               /* Group Pen */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	default:
		 notimp((stderr, "Warning: %c%c Unknown HP-GL Command\n", op1, op2));
		 dumpit(2);
	}
	break;

case 'I':
	op2 = getc(stream);
	switch (op2)
	{
	case 'M':               /* Input Mask (Not Used) */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	case 'N':               /* Initialize */
		 debugp((stderr,"%c%c",op1,op2));
		 dumpit(1);
		 break;

	case 'P':               /* Input P1 and P2 (Not Used) */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	case 'V':               /* Invoke Character Slot */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	case 'W':               /* Input Window */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	default:
		 notimp((stderr, "Warning: %c%c Unknown HP-GL Command\n", op1, op2));
		 dumpit(2);
	}
	break;

case 'L':
	op2 = getc(stream);
	switch (op2)
	{
	case 'B':
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	case 'O':               /* Label Origin */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	case 'T':               /* Line Type */
		 //debugp((stderr,"%c%c",op1,op2));
		 dumpit(1);
		 break;

	default:
		 notimp((stderr, "Warning: %c%c Unknown HP-GL Command\n", op1, op2));
		 dumpit(2);
	}
	break;

case 'N':
	op2 = getc(stream);
	switch (op2)
	{
	case 'R':               /* Not Ready */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	default:
		 notimp((stderr, "Warning: %c%c Unknown HP-GL Command\n", op1, op2));
		 dumpit(2);
	}
	break;

case 'O':                   /* NOT USED */
	op2 = getc(stream);
	switch (op2)
	{
	case 'A':               /* Output Actual Position */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	case 'C':               /* Output Commanded Position */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	case 'D':               /* Output Digitise */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	case 'E':               /* Output Error */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	case 'F':               /* Output Factors */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	case 'H':               /* Output Hard-Clip Limits */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	case 'I':               /* Output Indentification */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	case 'L':               /* Output Label Length */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	case 'O':               /* Output Options */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	case 'P':               /* Output P1 and P2 */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	case 'S':               /* Output Status */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	case 'T':               /* Output Carousel Type */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	case 'W':               /* Output Window */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	default:
		 notimp((stderr, "Warning: %c%c Unknown HP-GL Command\n", op1, op2));
		 dumpit(2);
	}
	break;

case 'P':
	op2 = getc(stream);
	switch (op2)
	{
	case 'A':               /* Plot Absolute */
		 dumpcomma();
		 PLOTABS = 1;
		 if (SIGNED_NUMERIC)plot();
		 dumpit(1);
		 break;

	case 'B':               /* Print Buffered Label */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	case 'D':               /* Pen Down */
		 //debugp((stderr,"%c%c",op1,op2));
		 dumpcomma();
		 PENDOWN = 1;
		 if (SIGNED_NUMERIC)plot();
		 dumpit(1);
		 break;

	case 'G':               /* Advance Full Page */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	case 'M':               /* Polygon Mode */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	case 'R':               /* Plot Relative */
		 //debugp((stderr,"%c%c",op1,op2));
		 dumpcomma();    ///insert luberth
		 PLOTABS = 0;
		 if (SIGNED_NUMERIC)plot();
		 dumpit(1);
		 break;

	case 'T':               /* Pen Thickness */

		 dumpit(1);
		 break;

	case 'U':               /* Pen Up */
		 //debugp((stderr,"%c%c",op1,op2));
		 PENDOWN = 0;
		 if (SIGNED_NUMERIC)plot();

		 dumpit(1);
		 break;

	default:
		 notimp((stderr, "Warning: %c%c Unknown HP-GL Command\n", op1, op2));
		 dumpit(2);
	}
	break;

case 'R':
	op2 = getc(stream);
	switch (op2)
	{
	case 'A':               /* Fill Rectange Absolute */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	case 'O':               /* Rotate Coordinate System */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	case 'R':               /* Fill Rectangle Relative */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	default:
		 notimp((stderr, "Warning: %c%c Unknown RD-GL Command\n", op1, op2));
	    dumpit(2);
	}
	break;

case 'S':
	op2 = getc(stream);
	switch (op2)
	{
	case 'A':               /* Select Alternate Set */
	    notimp((stderr,"Not Implemented: %c%c",op1,op2));
	    dumpit(2);
	    break;

	case 'C':               /* Scale */
		       /* Scaling added by Gordon Jacobs */
	    //debugp((stderr,"%c%c",op1,op2));
		 if (SIGNED_NUMERIC)xmin = getval();
		 else {
				dumpit(1);
				break;
		 }

		 if (SIGNED_NUMERIC)xmax = getval();
		 if (SIGNED_NUMERIC)ymin = getval();
		 if (SIGNED_NUMERIC)ymax = getval();
		 //modify_viewport();  /* new function for scaling */
		 DRAW_FLAG = 0;
		 dumpit(1);
		 break;

	case 'G':               /* Select Pen Group */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	case 'I':               /* Absolute Character Size (SI) */
		 //debugp((stderr,"%c%c",op1,op2));
		 dumpit(1);
		 break;

	case 'L':               /* Character Slant */
		 //debugp((stderr,"%c%c",op1,op2));
		 dumpit(1);
		 break;

	case 'M':               /* Symbol Mode */
		 dumpit(1);
		 break;

	case 'P':               /* Pen Select */
		 //debugp((stderr,"%c%c",op1,op2));
		 //linesize();
		 dumpit(1);
		 break;

	case 'R':               /* Relative Character Size */
		 //debugp((stderr,"%c%c",op1,op2));
		 //printf("/%s %g %g %g DefFont\n",
		 dumpit(1);
		 break;

	case 'S':               /* Select Standard Set */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	default:
		 notimp((stderr, "Warning: %c%c Unknown HP-GL Command\n", op1, op2));
		 dumpit(2);
	}
	break;

case 'T':
	op2 = getc(stream);
	switch (op2)
	{
	case 'L':
		 //debugp((stderr,"%c%c",op1,op2));
		 dumpit(1);
		 break;

	default:
		 notimp((stderr, "Warning: %c%c Unknown HP-GL Command\n", op1, op2));
		 dumpit(2);
	}
	break;

case 'U':
	op2 = getc(stream);
	switch (op2)
	{
	case 'C':               /* User Defined Character */
		 //debugp((stderr,"%c%c",op1,op2));
		 dumpit(1);
		 break;

	case 'F':               /* User-defined Fill Type */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	default:
		 notimp((stderr, "Warning: %c%c Unknown HP-GL Command\n", op1, op2));
		 dumpit(2);
	}
	break;

case 'V':
	op2 = getc(stream);
	switch (op2)
	{
	case 'S':               /* Velocity Select */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	default:
		 notimp((stderr, "Warning: %c%c Unknown HP-GL Command\n", op1, op2));
		 dumpit(2);
	}
	break;

case 'W':                   /* Not HP-GL */
	op2 = getc(stream);
	switch (op2)
	{
	case 'G':               /* Fill Wedge */
		 notimp((stderr,"Not Implemented: %c%c",op1,op2));
		 dumpit(2);
		 break;

	default:
		 notimp((stderr, "Warning: %c%c Unknown RD-GL Command\n", op1, op2));
		 dumpit(2);
	}
	break;

case 'X':
	op2 = getc(stream);
	switch (op2)
	{
	case 'T':               /* X Tick */
		 //debugp((stderr,"%c%c",op1,op2));
		 dumpit(1);
		 break;

	default:
		 notimp((stderr, "Warning: %c%c Unknown HP-GL Command  ", op1, op2));
		 dumpit(2);
	}
	break;

case 'Y':
	op2 = getc(stream);
	switch (op2)
	{
	case 'T':               /* Y Tick */
		 dumpit(1);
		 break;

	default:
		 notimp((stderr, "Warning: %c%c Unknown HP-GL Command\n", op1, op2));
		 dumpit(2);
	}
	break;

	 default:
	op2 = getc(stream);
	notimp((stderr, "Warning: %c%c Unknown HP-GL Command\n", op1,op2));
	dumpit(2);
	break;
	 }
}


/************************************/
void dumpit(long x)
{
	 /* Dump all characters until we get to another command letter.
	  * This is to make sure that we have a clean start for the next command
	  */
	 while (((ch = getc(stream)) != EOF) && ch < 'A')
	 {
	//if (x == 1 ) { debugp((stderr,"%c",ch)); }
	//if (x == 2 ) { notimp((stderr,"%c",ch)); }
	 }
	 //if (x == 1 ) { debugp((stderr,"\n")); }
	 //if (x == 2 ) { notimp((stderr,"\n")); }
	 ungetc(ch,stream);
}

void dumpcomma(void)
{
	 /* Dump the possible comma after a plot command. */
	 while (((ch = getc(stream)) != EOF) && ch == ',');
	//debugp((stderr,"%c",ch));
	 ungetc(ch,stream);
}
