<%@ page language="java" import="java.sql.*, java.util.*, com.kplab.webeasy.Util,
    com.kplab.webeasy.OrderBean.*, com.kplab.webeasy.OrderInfo,
    com.kplab.webeasy.OrderItem" contentType="text/html" %>

<jsp:useBean id="OrderBean" scope="session" class="com.kplab.webeasy.OrderBean" />

<%
//    response.setHeader("Pragma", "no-cache");
//    response.setHeader("Cache-Control", "no-cache");
//    response.setHeader("Expires", "0");
%>
          
<html>
<head>
<title>123-WebEasy Order Management</title>
<meta http-equiv="Content-Type" content="text/html">
</head>

<STYLE><!-- P.classPageBreak { page-break-after: always } --></STYLE>


<%! int MAX_PER_PAGE = 20; %>
<%! int DISPLAY_LANG = 1;  %>
<% 
    /****************************************/
    /******* Variables Initialization *******/
    /****************************************/

    int from_day=1, from_month=1, from_year=2000;
    int to_day=31, to_month=12, to_year=2005;
    try {
      from_day = Integer.parseInt(request.getParameter("FromDay"));
      from_month = Integer.parseInt(request.getParameter("FromMonth"));
      from_year = Integer.parseInt(request.getParameter("FromYear"));
      to_day = Integer.parseInt(request.getParameter("ToDay"));
      to_month = Integer.parseInt(request.getParameter("ToMonth"));
      to_year = Integer.parseInt(request.getParameter("ToYear"));
    }
    catch (Exception e) {
      %>Sorry, the page you selected does not exist.<%
      return;
    }
    Timestamp from_time = new Timestamp(from_year-1900, from_month-1, from_day, 0, 0, 0, 0);
    Timestamp to_time = new Timestamp(to_year-1900, to_month-1, to_day, 23, 59, 59, 999900000);

    int num_of_match=0, display_index=0, from_id=0, to_id=0;
    if (request.getParameter("num_of_match") == null  ||
        request.getParameter("display_index") == null ||
        request.getParameter("from_id") == null       ||
        request.getParameter("to_id") == null)
    {
      /* First Call */
      from_id = OrderBean.getMinOrderID(from_time);
      to_id = OrderBean.getMaxOrderID(to_time);
      num_of_match = OrderBean.getCount(from_id, to_id);
      display_index = 0;
    }
    else
    {
      /* Subsequent Calls */
      try {
        num_of_match = Integer.parseInt(request.getParameter("num_of_match"));
        display_index = Integer.parseInt(request.getParameter("display_index"));
        from_id = Integer.parseInt(request.getParameter("from_id"));
        to_id = Integer.parseInt(request.getParameter("to_id"));
      }
      catch (Exception e) {
        %>Sorry, the page you selected does not exist.<%
        return;
      }
    }

    /*** Retrieve list of orders ***/
    OrderBean.refreshInfoList(from_id, to_id, MAX_PER_PAGE);
    int infolist_size = OrderBean.getInfoListSize();
%>


<body background="../images/bg.gif" bgcolor="white" marginheight="0" marginwidth="0"
      topmargin="5" leftmargin="5">

<font color="#800080" size="5" face="Arial"><strong>List Order Details</strong></font>

<%
    if (infolist_size == 0)
    {
%>
  <p>Sorry, no records meet your selection criteria.</p>
<%
    }
    else
    {

    /******************************************/
    /******* Number of records retrieved ******/
    /******************************************/
%>
  <p>Total <%= Integer.toString(num_of_match) %> records are found from
           <%= Integer.toString(from_day) %>/<%= Integer.toString(from_month) %>/<%=
               Integer.toString(from_year) %> to
           <%= Integer.toString(to_day) %>/<%= Integer.toString(to_month) %>/<%=
               Integer.toString(to_year) %>.</p>



<%
    /******************************************/
    /************* List of orders *************/
    /******************************************/

      int last_order_id=0;
      for (int i=0; i<infolist_size; i++)
      {
        display_index++;
        OrderInfo order_info = OrderBean.getOrderInfoAt(i);
        int order_id = order_info.getOrderID();
        Vector order_detail = OrderBean.getOrderDetail(order_id);
        int num_of_item = order_detail.size();

        Timestamp order_time = order_info.getOrderTime();
        int expiry_month = order_info.getExpiryMonth();
        int expiry_year = order_info.getExpiryYear();
        String customer_id = order_info.getCustomerID();
        String customer_last_name = order_info.getCustomerLastName();
        String customer_first_name = order_info.getCustomerFirstName();
        String payment_method = order_info.getPaymentMethod();
        String cardholder_name = order_info.getCardholderName();
        String card_number = order_info.getCardNumber();
        String recipient_last_name = order_info.getRecipientLastName();
        String recipient_first_name = order_info.getRecipientFirstName();
        String recipient_phone = order_info.getRecipientPhone();
        String recipient_address = order_info.getRecipientAddress();
%>

    <!----- Page Break ------>
    <br><hr><P CLASS="classPageBreak"><BR><P>
    <font face="Arial" size="5"><strong>WebEasy Order</strong></font>
    <hr><br>


    <table border="0" width="100%" cellspacing="5" cellpadding="0">

      <tr>
        <td valign="top" align="left" nowrap><b>Order number:&nbsp;</b></td>
        <td valign="top" align="left"><b><%= Util.padInteger(order_id, 10) %></b></td>
      </tr>

      <tr>
        <td valign="top" align="left" nowrap><b>Order date and time:&nbsp;</b></td>
        <td valign="top" align="left"><b><%= order_time.toString() %></b><br>&nbsp;</td>
      </tr>

<%
    /******************************************/
    /********** Customer Information **********/
    /******************************************/
%>

      <tr>
        <td valign="top" align="left" colspan="2"><font size="4" face="Arial">
        <strong>Customer Information</strong></font></td>
      </tr>

      <tr>
        <td valign="top" align="left" nowrap>Customer surname:&nbsp;</td>
        <td valign="top" align="left"><%= customer_last_name %></td>
      </tr>

      <tr>
        <td valign="top" align="left" nowrap>Customer first name:&nbsp;</td>
        <td valign="top" align="left"><%= customer_first_name %></td>
      </tr>

      <tr>
        <td valign="top" align="left" nowrap>Payment method:&nbsp;</td>
        <td valign="top" align="left"><%= payment_method %></td>
      </tr>

      <tr>
        <td valign="top" align="left" nowrap>Cardholder's name:&nbsp;</td>
        <td valign="top" align="left"><%= cardholder_name %></td>
      </tr>

      <tr>
        <td valign="top" align="left" nowrap>Credit card number:&nbsp;</td>
        <td valign="top" align="left"><%= card_number %></td>
      </tr>

      <tr>
        <td valign="top" align="left" nowrap>Expiration date:&nbsp;</td>
        <td valign="top" align="left"><%= Integer.toString(expiry_month) %>/<%= Integer.toString(expiry_year) %></td>
      </tr>

      <tr>
        <td valign="top" align="left">&nbsp;</td>
        <td valign="top" align="left">&nbsp;</td>
      </tr>


<%
    /******************************************/
    /********** Delivery Information **********/
    /******************************************/
%>

      <tr>
        <td valign="top" align="left" colspan="2"><font size="4" face="Arial">
        <strong>Delivery Information</strong></font></td>
      </tr>

      <tr>
        <td valign="top" align="left" nowrap>Recipient's surname:&nbsp;</td>
        <td valign="top" align="left"><%= recipient_last_name %></td>
      </tr>

      <tr>
        <td valign="top" align="left" nowrap>Recipient's first name:&nbsp;</td>
        <td valign="top" align="left"><%= recipient_first_name %></td>
      </tr>

      <tr>
        <td valign="top" align="left" nowrap>Contact phone number:&nbsp;</td>
        <td valign="top" align="left"><%= recipient_phone %></td>
      </tr>

      <tr>
        <td valign="top" align="left" nowrap>Delivery address:&nbsp;</td>
        <td valign="top" align="left"><%= recipient_address %></td>
      </tr>

      <tr>
        <td valign="top" align="left">&nbsp;</td>
        <td valign="top" align="left">&nbsp;</td>
      </tr>


<%
    /******************************************/
    /************* Order Details **************/
    /******************************************/
%>
      <tr>
        <td valign="top" align="left" colspan="2"><font size="4" face="Arial">
        <strong>Order Details</strong></font></td>
      </tr>

      <tr>
        <td valign="top" align="left" colspan="2">
          <table border="1" width="100%" cellspacing="2" cellpadding="2">
            <tr>
              <td valign="top" align="left"  width="50%"><b>Item name&nbsp;</b></td>
              <td valign="top" align="right" width="15%"><b>&nbsp;Quantity</b></td>
              <td valign="top" align="right" width="15%"><b>&nbsp;Price</b><br>(US$)</td>
              <td valign="top" align="right" width="20%"><b>&nbsp;Sub-total</b><br>(US$)</td>
            </tr>

<%
        double total=0;
        for (int j=0; j<num_of_item; j++)
        {
          OrderItem order_item = (OrderItem) order_detail.elementAt(j);
          int item_id = order_item.getItemID();
          String item_name = order_item.getItemName();
          int qty = order_item.getQty();
          double item_price = order_item.getItemPrice();
          double sub_total = ((double) Math.round(item_price * qty * 100)) / 100;
          total += sub_total;
%>
            <tr>
              <td valign="top" align="left"><%= item_name %>&nbsp;</td>
              <td valign="top" align="right">&nbsp;<%= qty %></td>
              <td valign="top" align="right">&nbsp;<%= item_price %></td>
              <td valign="top" align="right">&nbsp;<%= sub_total %></td>
            </tr>
<%
        }   /*** Order Item ****/
        total = ((double) Math.round(total * 100)) / 100;
%>
            <tr>
              <td valign="top" align="left"><b>Grand total</b></td>
              <td valign="top" align="right">&nbsp;</td>
              <td valign="top" align="right">&nbsp;</td>
              <td valign="top" align="right"><b><%= total %></b></td>
            </tr>
          </table>
        </td>
      </tr>

      <tr>
        <td valign="top" align="left">&nbsp;</td>
        <td valign="top" align="left">&nbsp;</td>
      </tr>

    </table>


<%
        last_order_id = order_id;
      }   /*** Order Info ***/
%>



<%
      /*******************************/
      /********** Next Page **********/
      /*******************************/

      if (last_order_id < to_id)
      {
        from_id = last_order_id + 1;
%>
    <!----- Page Break ------>
    <br><hr><P CLASS="classPageBreak"><BR><P>

  <form action="ListOrderDetail.jsp" method="POST">
    <input type="hidden" name="FromDay" value="<%= Integer.toString(from_day) %>">
    <input type="hidden" name="FromMonth" value="<%= Integer.toString(from_month) %>">
    <input type="hidden" name="FromYear" value="<%= Integer.toString(from_year) %>">

    <input type="hidden" name="ToDay" value="<%= Integer.toString(to_day) %>">
    <input type="hidden" name="ToMonth" value="<%= Integer.toString(to_month) %>">
    <input type="hidden" name="ToYear" value="<%= Integer.toString(to_year) %>">

    <input type="hidden" name="num_of_match" value="<%= Integer.toString(num_of_match) %>">
    <input type="hidden" name="display_index" value="<%= Integer.toString(display_index) %>">
    <input type="hidden" name="from_id" value="<%= Integer.toString(from_id) %>">
    <input type="hidden" name="to_id" value="<%= Integer.toString(to_id) %>">

    <input type="submit" value="Next Page">&nbsp;<a href="index.html">Exit</a>
  </form>
<%
      }   /*** Next Page ***/
    }   /*** InfoListSize != 0 ***/
%>
</body>
</html>
