/****** Object:  Table [dbo].[CONTROL]    Script Date: 1/18/2001 3:29:10 PM ******/
if exists (select * from sysobjects where id = object_id(N'[dbo].[CONTROL]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[CONTROL]
GO

/****** Object:  Table [dbo].[DOC_DEPOT]    Script Date: 1/18/2001 3:29:10 PM ******/
if exists (select * from sysobjects where id = object_id(N'[dbo].[DOC_DEPOT]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[DOC_DEPOT]
GO

/****** Object:  Table [dbo].[FOLDERS]    Script Date: 1/18/2001 3:29:10 PM ******/
if exists (select * from sysobjects where id = object_id(N'[dbo].[FOLDERS]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[FOLDERS]
GO

/****** Object:  Table [dbo].[GROUPS]    Script Date: 1/18/2001 3:29:10 PM ******/
if exists (select * from sysobjects where id = object_id(N'[dbo].[GROUPS]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[GROUPS]
GO

/****** Object:  Table [dbo].[GUI]    Script Date: 1/18/2001 3:29:10 PM ******/
if exists (select * from sysobjects where id = object_id(N'[dbo].[GUI]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[GUI]
GO

/****** Object:  Table [dbo].[HISTORY]    Script Date: 1/18/2001 3:29:10 PM ******/
if exists (select * from sysobjects where id = object_id(N'[dbo].[HISTORY]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[HISTORY]
GO

/****** Object:  Table [dbo].[PAGES]    Script Date: 1/18/2001 3:29:10 PM ******/
if exists (select * from sysobjects where id = object_id(N'[dbo].[PAGES]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[PAGES]
GO

/****** Object:  Table [dbo].[ROUTING]    Script Date: 1/18/2001 3:29:10 PM ******/
if exists (select * from sysobjects where id = object_id(N'[dbo].[ROUTING]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[ROUTING]
GO

/****** Object:  Table [dbo].[test]    Script Date: 1/18/2001 3:29:10 PM ******/
if exists (select * from sysobjects where id = object_id(N'[dbo].[test]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[test]
GO

/****** Object:  Table [dbo].[USERS]    Script Date: 1/18/2001 3:29:10 PM ******/
if exists (select * from sysobjects where id = object_id(N'[dbo].[USERS]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[USERS]
GO

/****** Object:  Login SIIS\Administrator    Script Date: 1/18/2001 3:29:06 PM ******/
if not exists (select * from master..syslogins where name = N'SIIS\Administrator')
	exec sp_grantlogin N'SIIS\Administrator'
	exec sp_defaultdb N'SIIS\Administrator', N'master'
	exec sp_defaultlanguage N'SIIS\Administrator', N'us_english'
GO

/****** Object:  Login SiiS    Script Date: 1/18/2001 3:29:06 PM ******/
if not exists (select * from master..syslogins where name = N'SiiS')
BEGIN
	declare @logindb nvarchar(132), @loginlang nvarchar(132) select @logindb = N'SiiS', @loginlang = N'us_english'
	if @logindb is null or not exists (select * from master..sysdatabases where name = @logindb)
		select @logindb = N'master'
	if @loginlang is null or (not exists (select * from master..syslanguages where name = @loginlang) and @loginlang <> N'us_english')
		select @loginlang = @@language
	exec sp_addlogin N'SiiS', null, @logindb, @loginlang
END
GO

/****** Object:  Login SIIS\Administrator    Script Date: 1/18/2001 3:29:06 PM ******/
exec sp_addsrvrolemember N'SIIS\Administrator', sysadmin
GO

/****** Object:  User dbo    Script Date: 1/18/2001 3:29:07 PM ******/
/****** Object:  User SiiS    Script Date: 1/18/2001 3:29:07 PM ******/
if not exists (select * from sysusers where name = N'SiiS' and uid < 16382)
	EXEC sp_grantdbaccess N'SiiS', N'SiiS'
GO

GRANT  CREATE TABLE ,  CREATE VIEW ,  CREATE PROCEDURE ,  DUMP DATABASE ,  CREATE DEFAULT ,  DUMP TRANSACTION ,  CREATE RULE  TO [SiiS]
GO

/****** Object:  Table [dbo].[CONTROL]    Script Date: 1/18/2001 3:29:16 PM ******/
CREATE TABLE [dbo].[CONTROL] (
	[NFOLDERS] [int] NULL ,
	[LASTFOLDER] [int] NULL ,
	[NIMAGES] [int] NULL ,
	[LASTIMAGE] [int] NULL ,
	[LASTFAX] [int] NULL ,
	[TYPE_GRAPHICS] [char] (255) NULL ,
	[TYPE_OLE] [char] (255) NULL ,
	[TYPE_MM] [char] (255) NULL ,
	[TYPE_INTERNET] [char] (255) NULL ,
	[TYPE_TEXT] [char] (255) NULL ,
	[LASTUSER] [int] NULL ,
	[LASTGROUP] [int] NULL ,
	[LASTMSG] [int] NULL ,
	[LASTMSGFOLDER] [int] NULL 
) ON [PRIMARY]
GO

/****** Object:  Table [dbo].[DOC_DEPOT]    Script Date: 1/18/2001 3:29:20 PM ******/
CREATE TABLE [dbo].[DOC_DEPOT] (
	[DD_PAGEID] [int] NOT NULL ,
	[SOURCE] [char] (64) NULL ,
	[USER_ID] [char] (64) NULL ,
	[REF_COUNT] [int] NOT NULL ,
	[DATE_TIME] [datetime] NULL ,
	[FILE_NAME] [char] (64) NULL ,
	[EXT] [char] (4) NULL ,
	[THUMB] [image] NULL ,
	[DOCUMENT] [image] NULL ,
	[SECURITY] [char] (255) NULL ,
	[CHECK_BY] [char] (64) NULL ,
	[CHECK_PATH] [char] (255) NULL 
)
GO

/****** Object:  Table [dbo].[FOLDERS]    Script Date: 1/18/2001 3:29:24 PM ******/
CREATE TABLE [dbo].[FOLDERS] (
	[ID] [int] NOT NULL ,
	[PARENTID] [int] NULL ,
	[SiSNAME] [char] (64) NULL ,
	[DESCRIPTION] [char] (240) NULL ,
	[DATECREATED] [datetime] NULL ,
	[DATELASTAC] [datetime] NULL ,
	[SOURCE] [char] (32) NULL ,
	[DATE1] [datetime] NULL ,
	[USERDATE1] [datetime] NULL ,
	[REMARKS] [char] (240) NULL ,
	[LOCKED] [int] NULL ,
	[NPAGES] [int] NULL ,
	[KEYWORDS] [char] (240) NULL ,
	[SECURITY] [char] (255) NULL 
)
GO

/****** Object:  Table [dbo].[GROUPS]    Script Date: 1/18/2001 3:29:28 PM ******/
CREATE TABLE [dbo].[GROUPS] (
	[SiSNAME] [char] (64) NOT NULL ,
	[ID] [int] NOT NULL ,
	[ACL] [int] NULL ,
	[DESCRIPTION] [char] (255) NULL 
)
GO

/****** Object:  Table [dbo].[GUI]    Script Date: 1/18/2001 3:29:29 PM ******/
CREATE TABLE [dbo].[GUI] (
	[ID] [int] NOT NULL ,
	[CAPTION_E] [char] (128) NULL ,
	[CAPTION_LOCAL] [char] (128) NULL ,
	[HINT_E] [char] (128) NULL ,
	[HINT_LOCAL] [char] (128) NULL 
) ON [PRIMARY]
GO

/****** Object:  Table [dbo].[HISTORY]    Script Date: 1/18/2001 3:29:30 PM ******/
CREATE TABLE [dbo].[HISTORY] (
	[Signature] [char] (48) NOT NULL ,
	[docID] [int] NOT NULL ,
	[Type] [char] (10) NULL ,
	[Subject] [char] (255) NULL ,
	[SiSUser] [char] (64) NULL ,
	[SiSFrom] [char] (64) NULL ,
	[SiSTo] [char] (64) NULL ,
	[SiSDate] [datetime] NULL ,
	[Document] [image] NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

/****** Object:  Table [dbo].[PAGES]    Script Date: 1/18/2001 3:29:30 PM ******/
CREATE TABLE [dbo].[PAGES] (
	[PAGEID] [int] NOT NULL ,
	[FOLDERID] [int] NULL ,
	[LOCKED] [int] NULL ,
	[NLINKS] [int] NULL ,
	[KEYWORDS] [char] (240) NULL ,
	[LINKED] [int] NULL ,
	[LINKPAGEID] [int] NULL ,
	[IMPORTED] [int] NULL ,
	[LINKPATH] [char] (240) NULL ,
	[SiSNAME] [char] (64) NULL ,
	[EXT] [char] (4) NULL ,
	[LINKFOLDERID] [int] NULL ,
	[DELETED] [int] NULL ,
	[DESCRIPTION] [char] (240) NULL ,
	[USERDATE1] [datetime] NULL ,
	[FOLDERNAME] [char] (64) NULL ,
	[SECURITY] [char] (255) NULL ,
	[DATE1] [datetime] NULL 
)
GO

/****** Object:  Table [dbo].[ROUTING]    Script Date: 1/18/2001 3:29:31 PM ******/
CREATE TABLE [dbo].[ROUTING] (
	[ID] [int] NOT NULL ,
	[FOLDERID] [int] NOT NULL ,
	[Subject] [char] (64) NULL ,
	[Message] [char] (512) NULL ,
	[SiSFrom] [char] (64) NOT NULL ,
	[SiSTo] [char] (64) NOT NULL ,
	[SiSDate] [datetime] NOT NULL ,
	[R] [char] (1) NOT NULL ,
	[D1] [char] (1) NOT NULL ,
	[D2] [char] (1) NOT NULL ,
	[CC] [char] (1) NULL ,
	[SiSCC] [char] (255) NULL ,
	[Archived] [char] (1) NULL 
) ON [PRIMARY]
GO

/****** Object:  Table [dbo].[test]    Script Date: 1/18/2001 3:29:31 PM ******/
CREATE TABLE [dbo].[test] (
	[test] [char] (4096) NULL 
) ON [PRIMARY]
GO

/****** Object:  Table [dbo].[USERS]    Script Date: 1/18/2001 3:29:31 PM ******/
CREATE TABLE [dbo].[USERS] (
	[SiSNAME] [char] (64) NOT NULL ,
	[ID] [int] NOT NULL ,
	[PASSWORD] [char] (64) NULL ,
	[GROUPS] [char] (255) NULL ,
	[ADMIN] [char] (1) NULL ,
	[FULLNAME] [char] (64) NULL ,
	[DESCRIPTION] [char] (255) NULL 
)
GO

ALTER TABLE [dbo].[DOC_DEPOT] WITH NOCHECK ADD 
	CONSTRAINT [PK_DOC_DEPOT_1__14] PRIMARY KEY  CLUSTERED 
	(
		[DD_PAGEID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[FOLDERS] WITH NOCHECK ADD 
	CONSTRAINT [PK_FOLDERS_1__13] PRIMARY KEY  CLUSTERED 
	(
		[ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[GROUPS] WITH NOCHECK ADD 
	CONSTRAINT [PK___2__10] PRIMARY KEY  CLUSTERED 
	(
		[SiSNAME]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[PAGES] WITH NOCHECK ADD 
	CONSTRAINT [PK_PAGES_1__13] PRIMARY KEY  CLUSTERED 
	(
		[PAGEID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[USERS] WITH NOCHECK ADD 
	CONSTRAINT [PK___1__10] PRIMARY KEY  CLUSTERED 
	(
		[SiSNAME]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[GUI] WITH NOCHECK ADD 
	CONSTRAINT [PK_GUI] PRIMARY KEY  NONCLUSTERED 
	(
		[ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[HISTORY] WITH NOCHECK ADD 
	CONSTRAINT [PK_HISTORY] PRIMARY KEY  NONCLUSTERED 
	(
		[Signature]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[ROUTING] WITH NOCHECK ADD 
	CONSTRAINT [PK_ROUTING] PRIMARY KEY  NONCLUSTERED 
	(
		[ID]
	)  ON [PRIMARY] 
GO

 CREATE  INDEX [IX_HISTORY] ON [dbo].[HISTORY]([docID]) ON [PRIMARY]
GO

 CREATE  INDEX [FolderID] ON [dbo].[PAGES]([FOLDERID]) ON [PRIMARY]
GO

 CREATE  INDEX [FolderID] ON [dbo].[ROUTING]([FOLDERID]) ON [PRIMARY]
GO

GRANT  REFERENCES ,  SELECT ,  INSERT ,  DELETE ,  UPDATE  ON [dbo].[CONTROL]  TO [SiiS]
GO

GRANT  REFERENCES ,  SELECT ,  INSERT ,  DELETE ,  UPDATE  ON [dbo].[DOC_DEPOT]  TO [SiiS]
GO

GRANT  REFERENCES ,  SELECT ,  INSERT ,  DELETE ,  UPDATE  ON [dbo].[FOLDERS]  TO [SiiS]
GO

GRANT  REFERENCES ,  SELECT ,  INSERT ,  DELETE ,  UPDATE  ON [dbo].[GROUPS]  TO [public]
GO

GRANT  REFERENCES ,  SELECT ,  INSERT ,  DELETE ,  UPDATE  ON [dbo].[GROUPS]  TO [SiiS]
GO

GRANT  REFERENCES ,  SELECT ,  INSERT ,  DELETE ,  UPDATE  ON [dbo].[GUI]  TO [public]
GO

GRANT  REFERENCES ,  SELECT ,  INSERT ,  DELETE ,  UPDATE  ON [dbo].[GUI]  TO [SiiS]
GO

GRANT  REFERENCES ,  SELECT ,  INSERT ,  DELETE ,  UPDATE  ON [dbo].[HISTORY]  TO [public]
GO

GRANT  REFERENCES ,  SELECT ,  INSERT ,  DELETE ,  UPDATE  ON [dbo].[HISTORY]  TO [SiiS]
GO

GRANT  REFERENCES ,  SELECT ,  INSERT ,  DELETE ,  UPDATE  ON [dbo].[PAGES]  TO [SiiS]
GO

GRANT  REFERENCES ,  SELECT ,  INSERT ,  DELETE ,  UPDATE  ON [dbo].[ROUTING]  TO [SiiS]
GO

GRANT  REFERENCES ,  SELECT ,  INSERT ,  DELETE ,  UPDATE  ON [dbo].[test]  TO [SiiS]
GO

GRANT  REFERENCES ,  SELECT ,  INSERT ,  DELETE ,  UPDATE  ON [dbo].[USERS]  TO [public]
GO

GRANT  REFERENCES ,  SELECT ,  INSERT ,  DELETE ,  UPDATE  ON [dbo].[USERS]  TO [SiiS]
GO

