/*
 * Decompiled with CFR 0.152.
 */
package jms.de;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import jms.de.GetFileObserver;
import jms.util.Trace;

public class GetFile
extends Thread {
    private String fileURL;
    private String path;
    private String fileName;
    public boolean shouldStop = false;
    private boolean fileSaved = false;
    private GetFileObserver fileObserver;
    private long fileSize;
    private int loadedSize;
    private int lastLoadedSize;

    public GetFile(String id, String file_url, String output_path, GetFileObserver gio) {
        super(id);
        this.fileURL = file_url;
        this.path = output_path;
        this.fileObserver = gio;
        this.makeFileName();
    }

    public String toString() {
        return "[Thread-" + this.getName() + " {fileName=" + this.fileName + ",shouldStop=" + this.shouldStop + "}";
    }

    public String getSizeLabel() {
        if (this.lastLoadedSize < 1024) {
            return this.lastLoadedSize + " bytes";
        }
        return this.lastLoadedSize / 1024 + " Kb";
    }

    public static final String getFileNameFromPath(String full_file_name) {
        int pos = -1;
        String str = new String(full_file_name);
        while ((pos = str.indexOf(File.separator)) != -1) {
            str = str.substring(pos + 1);
        }
        return str;
    }

    public static final String getAbsolutePath(String abs_path) {
        String path = abs_path;
        if (!path.endsWith(File.separator)) {
            path = String.valueOf(path) + File.separator;
        }
        return path;
    }

    public static final String getFilePath(String full_file_name) {
        String file_name = GetFile.getFileNameFromPath(full_file_name);
        File f = new File(full_file_name);
        if (!f.exists()) {
            return null;
        }
        String s = f.getAbsolutePath();
        int pos = s.indexOf(file_name);
        if (pos == -1) {
            return null;
        }
        return s.substring(0, pos);
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFullFileName() {
        return String.valueOf(this.path) + this.fileName;
    }

    public boolean fileSaved() {
        return this.fileSaved;
    }

    public void run() {
        Object url = null;
        DataInputStream dis = null;
        Object fos = null;
        int b = -1;
        byte[] byte_array = null;
        this.fileSize = 0L;
        this.setPriority(2);
        try {
            Trace.out("de", "--> GetFile::run() : opening new url... : " + this.fileURL);
            URLConnection url_connection = new URL(this.fileURL).openConnection();
            int array_size = url_connection.getContentLength();
            if (array_size == -1 || !this.fileObserver.getFileUpdate(this)) {
                this.fileSaved = false;
                Trace.out("de", "GetFile()::run() size of file is null! => cannot download it OR cannot save any file any more on disk limit of storing size is reached");
                this.fileObserver.getFileDone(this);
                Trace.out("de", "<-- GetFile::run() done. Size of file unknown");
                return;
            }
            this.fileSize = array_size;
            this.fileObserver.getFileUpdate(this);
            this.loadedSize = 0;
            Trace.out("de", "GetFile::run() : array_size=" + array_size + " for file=" + this.path + this.fileName);
            dis = new DataInputStream(new BufferedInputStream(url_connection.getInputStream()));
            int last_loaded_size = 0;
            byte_array = new byte[array_size];
            while (this.loadedSize < array_size && !this.shouldStop) {
                last_loaded_size = dis.read(byte_array, this.loadedSize, array_size - this.loadedSize);
                if (last_loaded_size == -1) {
                    this.shouldStop = true;
                    Trace.out("de", "GetFile::run() : Connection interrupted at =" + this.getLoad() + "%");
                    break;
                }
                this.lastLoadedSize = last_loaded_size;
                this.loadedSize += this.lastLoadedSize;
                if (this.shouldStop) {
                    this.fileSaved = false;
                    break;
                }
                Trace.out("de", "GetFile::run() : connection stopped at =" + this.getLoad() + "%");
                this.fileObserver.getFileUpdate(this);
            }
            if (!this.shouldStop) {
                this.writeFile(byte_array);
                dis.close();
            }
        }
        catch (MalformedURLException malformedURLException) {
            this.fileSaved = false;
        }
        catch (IOException iOException) {
            this.fileSaved = false;
        }
        this.fileObserver.getFileDone(this);
        this.stop();
    }

    public void writeFile(byte[] byte_array) throws IOException {
        FileOutputStream fos = new FileOutputStream(new File(String.valueOf(this.path) + this.fileName));
        fos.write(byte_array);
        fos.close();
        this.fileSaved = true;
    }

    public long getSize() {
        return this.fileSize;
    }

    public int getReadBytes() {
        return this.lastLoadedSize;
    }

    public int getLoad() {
        if (this.fileSize == 0L) {
            return 0;
        }
        return (int)((double)((float)this.loadedSize / (float)this.fileSize) * 100.0);
    }

    private void makeFileName() {
        if (this.fileURL == null) {
            this.fileName = null;
            return;
        }
        this.fileName = GetFile.getFileName(this.fileURL);
    }

    public static String getFileName(String url) {
        int pos = -1;
        String str = new String(url);
        while ((pos = str.indexOf(47)) != -1) {
            str = str.substring(pos + 1);
        }
        return str;
    }
}

