/*
 * Decompiled with CFR 0.152.
 */
package jms.de;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import jms.graphics.ProgressBar;
import jms.graphics.StatusPanel;

public class StatusBarPanel
extends Panel {
    private ProgressBar progressBar;
    private StatusPanel statusPanel;
    private StatusPanel rateStatusPanel;
    private StatusPanel loadStatusPanel;

    public StatusBarPanel() {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(gbl);
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.progressBar = new ProgressBar(0);
        gbl.setConstraints(this.progressBar, gbc);
        this.add(this.progressBar);
        this.statusPanel = new StatusPanel(new Dimension(320, 27));
        gbc.fill = 2;
        gbc.weightx = 0.5;
        gbc.anchor = 10;
        gbl.setConstraints(this.statusPanel, gbc);
        this.add(this.statusPanel);
        this.rateStatusPanel = new StatusPanel(new Dimension(78, 27));
        gbc.anchor = 13;
        gbl.setConstraints(this.rateStatusPanel, gbc);
        this.add(this.rateStatusPanel);
        gbc.anchor = 13;
        this.loadStatusPanel = new StatusPanel(new Dimension(78, 27));
        gbl.setConstraints(this.loadStatusPanel, gbc);
        this.add(this.loadStatusPanel);
        this.setBackground(Color.lightGray);
    }

    public void writeStatus(String status) {
        this.statusPanel.setText(status);
    }

    public void writeLoad(String load) {
        this.loadStatusPanel.setText(load);
    }

    public void writeRate(String rate) {
        this.rateStatusPanel.setText(rate);
    }

    public void reInitProgressBar(int current) {
        if (this.progressBar != null) {
            this.progressBar.reInit(current);
            this.repaint();
        }
    }

    public void setProgressBarValue(int value) {
        this.progressBar.setValue(value);
    }
}

