/*Data Access Library. v. 1.1.
 *Data Access Exception. 
 *AUTHOR:  Alexander Jaremenko <jarem@altavista.net>
 *RELEASE DATE: 
 */

package JProjects.eab.data;

/**This class is for all exceptions thrown by methods that accesses Database.
 *@author Alexander Jaremenko  <address><a href="mailto:jarem@altavista.net">&lt jarem@altavista.net &gt</a></address>
*/
public class DAException extends java.lang.Exception {

    private java.sql.SQLException _iSQLException;
    private String _id;
    private String _property;

    public DAException(String id) {
	_id = id;
    }

    public DAException(String id,java.sql.SQLException sqlEx) {
	_id = id;
	_iSQLException = sqlEx;
    }

    public DAException(String id,String property) {
	this(id,property,null);
    }

    public DAException(String id,String property,java.sql.SQLException sqlEx) {
	_id = id;
	_property = property;
	_iSQLException = sqlEx;
    }

    /**@return - the String message ID for the current DAException object.*/
    public String getId() {
	return _id;
    }

    /**@return - the name of the property (attribute) that caused
     *the DAException to occur.*/
    public String getProperty() {
	return _property;
    }


    /**@return the SQL Exception object that is associated with the
     *current DAException object.*/
    public java.sql.SQLException getSQLException() {
	return _iSQLException;
    }

}
