package JProjects.eab.data.wizzard;

import java.sql.Types;
import java.util.*;

/**Column descriptor. Support class for code generation.
  *@author Alexandr Jaremenko  <address><a href="mailto:jarem@altavista.net">&lt jarem@altavista.net &gt</a></address>
 *@version Data Access Library. v. 1.1
 */
class ColumnDescriptor {
    //    private String _tblName;
    private String _tblAlias;
    private String _attrLabel;
    private String _colName;
    //    private String _colType;
    private String _attrType;
    private String _attrObjType;
    private boolean _isModi;
    private boolean _isDI;
    private boolean _isNull;
    private boolean _isObj;
    private String _sqlType;
    //    private int _dataLen;
    private boolean _isByteArr;
    private int _scale = 0;

    //    private static final int _defAttrLen = 256;

  ColumnDescriptor(String colName,String attrName,int[] sqlT,boolean isNullable,boolean isDI,boolean isModi) {
	String[] types = ((sqlT[0]==Integer.MIN_VALUE)?null:JDBCTypes.getSQLStrings(sqlT[0]));
	if ( types == null ) {
	    throw new RuntimeException("Unknown SQL Type");
	    //	    _attrType = _attrObjType = "";
	    //	    _isObj = false;
	} else {
	    _attrType = types[0];
	    _attrObjType = types[1];
	    _sqlType = types[2];
	    _isByteArr = _attrType.equals("byte[]");
	    _isObj = Character.isUpperCase(_attrType.charAt(0))||_isByteArr;
	}
	if (colName.indexOf((int)'.')>0) {
	    int i = colName.indexOf((int)'.');
	    _colName = colName.substring(i+1);
	    _tblAlias = colName.substring(0,i);
	} else {
	    _colName = colName;
	    _tblAlias = "";
	}
	_scale = sqlT[1];
	_attrLabel = attrName;
	_isNull = isNullable;
	_isModi = isModi;
	_isDI = isDI;
  }

    ColumnDescriptor(String colName,String attrName,String sqlT,boolean isNullable,boolean isDI,boolean isModi) {
	this(colName,attrName,JDBCTypes.parseDT(sqlT),isNullable,isDI,isModi);
    }


    /*    String getTblName() {
	return _tblName;
    }
    */

    void setScale(int s) {
	_scale = s;
    }

    String getTblAlias() {
	return _tblAlias;
    }

    String getPrefixedName() {
	if (_tblAlias.length()>0)
	    return (_tblAlias+"."+_colName);
	return _colName;
    }

    String getDBFieldName() {
	return _colName;
    }

    String getAttrDeclaration() {
	if (_isNull || _isObj)
	    return (getAttrObjType()+" "+getAttrName()+";");
	return (getAttrType()+" "+getAttrName()+";");
    }

    String getAttrParam() {
	if (!_isNull)
	    return (getAttrType()+" "+getAttrParamName());
	return (getAttrObjType()+" "+getAttrParamName());
    }

    String getAttrParamName() {
	return ("a"+_attrLabel);
    }

    String getAttrType() {
	return getFullType(_attrType);
    }

    String getAttrObjType() {
	return getFullType(_attrObjType);
    }

    String getAttrName() {
	return ("i"+_attrLabel);
    }

    boolean isModifiable() {
	return _isModi;
    }

    boolean isDataId() {
	return _isDI;
    }

    boolean isNullable() {
	return _isNull;
    }

    boolean isStream() {
	return _attrType.indexOf("Stream")>0;
    }

    String getPSetterDef() {
	return getPSetterDef(_isDI);
    }

    String getDIPSetterDef() {
	return getPSetterDef(false);
    }

    String getGetterDef() {
	return getGetterDef(_isDI);
    }

    String getDIGetterDef() {
	return getGetterDef(false);
    }

    String getSetterDef(int idx) {
	return getSetterDef(idx,_isDI);
    }

    String getDISetterDef(int idx) {
	return getSetterDef(idx,false);
    }

    String getToString() {
	String res;
	if ( _attrType.equals("String"))
	    res = getGetterName()+"()";
	else
	    res = "String.valueOf("+getGetterName()+"())";
	return res;
    }

    String getSetAttr(String parN,String sfx) {
	String sufx = ((sfx!=null)?sfx:"");
	return (getAttrName()+" = "+parN+sufx);
    }

    String getNullableDef() {
	return "public boolean "+getNullableName()+"() { return "+((_isNull)?"true":"false")+"; }";
    }

    String getPSetterName() {
	return ("_set"+getCLabel());
    }

    String getSetterName() {
	return ("set"+getCLabel());
    }

    String getGetterName() {
	return ("get"+getCLabel());
    }

    String getNullableName() {
	return "is"+getCLabel()+"Nullable";
    }


    String genEquals(String objName,String indt) {
	String atName = getAttrName();
	String oatName = objName+"."+atName;
	String res = indt+"if ("+atName+" != "+oatName+" ) {";
	if (!_isObj && !_isNull) 
	    res+="\n"+indt+"\treturn false;\n"+indt+"}";
	else {
	    res+="\n"+indt+"\tif ( "+atName+" == null || "+oatName+" == null ) return false;";
	    res+="\n"+indt+"\telse if ( !"+atName+".equals( "+oatName+" ) ) return false;\n"+indt+"}";
	}
	return res;
    }

    String getAttributeStrings() {
	if (_attrType.equals("String"))
	    return (getGetterName()+"()");
	return ("String.valueOf("+getGetterName()+"())");
    }

    String genSetFromRsStream(String rsName,int colNum,String objName,String saveVal,String indt) {
	String o = ((objName==null)?"":objName+".");
	String res = indt+"if ("+o+getGetterName()+"() !=null ) {\n";
	res+=indt+"\tDAIOStream dStr = "+o+getGetterName()+"();\n";
	res+=indt+"\tif (dStr.getOutputStreamOrFile() == null ) {\n";
	res+=indt+"\t\tif ("+saveVal+")\n"+indt+"\t\t\tdStr.getFromLob("+rsName+".get"+_attrType+"("+colNum+"),true);\n";
	res+=indt+"\t} else\n";
	res+=indt+"\t\tdStr.getFromLob("+rsName+".get"+_attrType+"("+colNum+"),"+saveVal+");\n";
	res+=indt+"}\n";
	return res;
    }

    String genSetFromRs(String rsName,int colNum,String objName,String indt) {
	//for DAManager.fetchNext
	String o = ((objName==null)?"":objName+".");
	String res = indt+o+getPSetterName()+"(";
	String rsGetter = ".get"+((_attrObjType.equals("Integer"))?"Int":_attrObjType);
	if (_attrType.equals("String")) {
	    res+=rsName+rsGetter+"("+colNum+"));";
	    if (_isNull)
		res+="\n"+indt+"if ("+rsName+".wasNull()) "+o+getPSetterName()+"(null);";
	}
	else if (_attrType.equals("BigDecimal")) {
	    res+=rsName+rsGetter+"("+colNum+","+_scale+"));";
	    if (_isNull)
		res+="\n"+indt+"if ("+rsName+".wasNull()) "+o+getPSetterName()+"(null);";
	}
	else if (_isNull && !_isObj ) {
	    res+="new "+getAttrObjType()+"("+rsName+rsGetter+"("+colNum+")));";
	    res+="\n"+indt+"if ("+rsName+".wasNull()) "+o+getPSetterName()+"(null);";
	} else
	    res+=rsName+rsGetter+"("+colNum+"));";
	return res;
    }

    String genSetParamRs(String stN,String idxName,String objName,String indt) {
	//see retrieve,add,delete,update,update(dataId),updateFetched
	String oTyp = ((_attrObjType.equals("Integer"))?"Int":_attrObjType);
	String o = ((objName==null)?"":objName+".");
	String res ="";
	boolean streamType = _attrType.indexOf("Stream")>0;
	String oGetter = o+getGetterName()+"()";
	if (streamType)
	    oTyp = _attrType;
	if (_isNull) {
	    if (streamType)
		res = indt+"if ("+oGetter+" == null || "+oGetter+".getInputStreamOrFile() == null)\n";
	    else
		res = indt+"if ("+oGetter+" == null)\n";
	    res+=indt+"\t"+stN+".setNull("+idxName+"++,Types."+_sqlType+");";
	    res+="\n"+indt+"else\n"+indt+"\t";
	} else
	    res = indt;
	res+= stN+".set"+oTyp+"("+idxName+"++,";
	if (streamType)
	    res+=oGetter+".getInputStreamOrFile(),"+oGetter+".getReadLength());";
	else
	    res+=getAsSimpleType(o)+");";
	return res;
    }

    String getPSetAttr(String pName,String sfx) {
	String sufx = ((sfx==null)?"":sfx);
	return (getPSetterName()+"("+pName+")"+sufx);
    }

    String getAsCtr(String objName) {
	String o = ((objName==null)?"":objName+".");
	if (_isObj || _isNull )
	    return o+getGetterName()+"()";
	else
	    return " new "+_attrObjType+"("+o+getGetterName()+"())";
    }


    private String getCLabel() {
	char[] l = _attrLabel.toCharArray();
	l[0]=Character.toUpperCase(l[0]);
	return new String(l);
    }

    private String getFullType(String typ) {
	String res = typ;
	if (typ.equals("Date") || typ.equals("Time") || typ.equals("Timestamp"))
	    res="java.sql."+res;
	return res;
    }

    private String getPSetterDef(boolean isDI) {
	String parName = "a"+getCLabel();
	String res ="void "+getPSetterName()+"(";
	if (_isNull || _isObj )
	    res+=getAttrObjType()+" "+parName+") {";
	else
	    res+=getAttrType()+" "+parName+") {";
	if (!isDI)
	    return res+"\n\t"+getAttrName()+" = "+parName+";\n}";
	return res+" theDataId."+getPSetterName()+"("+parName+"); }";
    }

    private String getSetterDef(int idx,boolean isDI) {
	String paramName = "a"+getCLabel();
	String res = "public void "+getSetterName()+"(";
	if (_isNull || _isObj)
	    res+=getAttrObjType()+" "+paramName+") {";
	else
	    res+=getAttrType()+" "+paramName+") {";
	if (isDI) {
	    res+="\n\ttheDataId."+getSetterName()+"("+paramName+");\n}";
	}
	else {
	    res+="\n\tmodified["+idx+"] = true;";
	    res+="\n\t"+getAttrName()+" = "+paramName+";";
	    res+="\n\tsetModified(true);\n}";
	}
	return res;
    }

    private String getAsSimpleType(String o) {
	//	String o = ((oN==null)?"":oN+".");
	String res = o+getGetterName()+"()";
	if ( !_isObj && _isNull ) {
	    if (_attrObjType.equals("Integer"))
		res+=".intValue()";
	    else 
		res+="."+_attrType+"Value()";
	}
	return res;
    }

    private String getGetterDef(boolean isDI) {
	String res= "public ";
	if (_isNull || _isObj )
	    res+=getAttrObjType()+" "+getGetterName()+"() { return ";
	else
	    res+=getAttrType()+" "+getGetterName()+"() { return ";
	if (isDI)
	    res+="theDataId."+getGetterName()+"(); }";
	else
	    res+=getAttrName()+"; }";
	return res;
    }

}
