package com.db4o.lib;

public class Str
{
	private static final char DATESEPARATOR = '-';
	private static final char TIMESEPARATOR = ':';
	private static final char DATETIMESEPARATOR = ' ';
	
	protected String i_String;
	
	private Str(){};
	
	public Str(String a_String){
		i_String = a_String;
	}
	
	public Str(char a_char, int a_count){
		char[] l_array = new char[a_count];
		for (int i = 0; i < a_count;l_array[i++] = a_char);
		i_String = new String(l_array);
	}
	
	public Str(int a_int){
		i_String = new Integer(a_int).toString();
	}
	
	public Str(long a_long){
		i_String = new Long(a_long).toString();
	}
	
	public Str(char a_char){
		i_String = new String(new char[] {a_char});
	}

	public void clear(){
		i_String = "";
	}
	
	public String getString(){
		return i_String;
	}
	
	protected String joinDate(String a_Year, String a_Month, String a_Day ){
		i_String = a_Year + DATESEPARATOR + a_Month + DATESEPARATOR + a_Day;
		return i_String;
	}
	
	protected String joinTime(String a_Hours, String a_Minutes,String a_Seconds){
		i_String = a_Hours + TIMESEPARATOR + a_Minutes + TIMESEPARATOR + a_Seconds;
		return i_String;
	}

	protected String joinDateTime(String a_Date, String a_Time){
		i_String = a_Date + DATETIMESEPARATOR + a_Time;
		return i_String;
	}
	
	public static String _left(String a_String, int a_chars){
		return new Str(a_String).left(a_chars);
	}
	
	public String left(int a_chars){
		if(a_chars > i_String.length()){
			a_chars = i_String.length();
		}else{
			if (a_chars < 0){
				a_chars = 0;
			}
		}
		return i_String.substring(0,a_chars);
	}
	
	public String PadLeft(char a_char, int a_length){
		return new Str(new Str(a_char,a_length).getString() + i_String).right(a_length);
	}
	
	public String PadRight(char a_char, int a_length){
		return (i_String + new Str(a_char,a_length).getString()).substring(0,a_length);
	}
	
	public void replace(String a_Replace, String a_With){
		replace(a_Replace, a_With,0);
	}
	
	public static String _replace(String a_in, String a_replace, String a_with){
		Str s = new Str(a_in);
		s.replace(a_replace, a_with);
		return s.getString();
	}
	
	public void replace(String a_Replace, String a_With, int a_start){
		int l_pos = 0;
		while((l_pos = i_String.indexOf(a_Replace,a_start)) > -1){
			i_String = i_String.substring(0,l_pos) + a_With + i_String.substring(l_pos + a_Replace.length());
		}
	}
	
	public void replace (String a_ReplaceBegin, String a_ReplaceEnd, String a_With){
		replace (a_ReplaceBegin, a_ReplaceEnd, a_With, 0);
	}
	
	public void replace (String a_ReplaceBegin, String a_ReplaceEnd, String a_With, int a_start){
		int l_pos_from = i_String.indexOf(a_ReplaceBegin, a_start);
		if (l_pos_from > -1){
			int l_pos_to = i_String.indexOf(a_ReplaceEnd,l_pos_from + 1);
			if(l_pos_to > - 1){
				i_String = i_String.substring(0,l_pos_from) + a_With + i_String.substring(l_pos_to + a_ReplaceEnd.length());
				replace(a_ReplaceBegin, a_ReplaceEnd, a_With, l_pos_to);
			}
		}
	}
	
	public String right(int a_chars){
		int l_take = i_String.length() - a_chars;
		if(l_take < 0){
			l_take = 0;
		}
		return i_String.substring(l_take);
	}

	
	public static String _splitRight(String a_String, String a_Splitter){
		Str s = new Str(a_String);
		return s.splitRight(a_Splitter);
	}
	
	public String splitRight(String a_Splitter){
		String l_Return = "";
		int l_pos = i_String.lastIndexOf(a_Splitter);
		if(l_pos > 0){
			l_Return = i_String.substring(l_pos + a_Splitter.length());
			i_String = i_String.substring(0,l_pos);
		}
		return l_Return;
	}
	
	private String toYear(){
		switch (i_String.length()){
			case 1:
				i_String = "200" + i_String;
				break;
			case 2:
				i_String = "20" + i_String;		   
				break;
			case 3:
				i_String = "2" + i_String;		   
				break;
		}
		return i_String;
	}
	
	private String toZeroTwoDigit(){
		if (i_String.length() == 1)
			i_String = "0" + i_String;
		return i_String;
	}
	
	
}
