package com.db4o.test;

public class Entry {

	public Object key;
	public Object value;

	public Entry(){
	}

    public Entry(Object key, Object value) {
		this.key = key;
		this.value = value;
    }

	public Entry firstElement(){
		return new Entry("first", "firstvalue");
	}

	public Entry lastElement(){
		return new Entry(new ObjectSimplePublic("lastKey"), new ObjectSimplePublic("lastValue"));
	}

	public Entry noElement(){
		return new Entry("NO", "babe");
	}

	public Entry[] test(int ver){
		if(ver == 1){
			return new Entry[]{
				firstElement(),
				new Entry(new Integer(111), new ObjectSimplePublic("111")),
				new Entry(new Long(9999111), new Double((double)0.4566)),
				lastElement()
			};
		}
		return new Entry[]{
			new Entry(new Integer(222), new ObjectSimplePublic("111")),
			new Entry("222", "TrippleTwo"),
			new Entry(new ObjectSimplePublic("2222"), new ObjectSimplePublic("222")),
		};
	}

	public String compare(Entry[] a_cmp, int oneOrTwo, boolean keysOnly, String errors){
		Entry[] test = test(oneOrTwo);
		Entry[] cmp = new Entry[a_cmp.length];
		System.arraycopy(a_cmp,0, cmp, 0, a_cmp.length);
		if(cmp == null){
			return errors + "Entry:argument is null" + Regression.nl;
		}
		if(cmp.length  != test.length){
			return errors + "Entry:arrays of different length" + Regression.nl;
		}
		for(int i = 0; i < test.length; i ++){
			boolean found = false;
			for(int j=0; j < cmp.length; j++){
				if(cmp[j] != null){
					if(test[i].key.equals(cmp[j].key)){
						if(!keysOnly){
							if(! test[i].value.equals(cmp[j].value)){
								return errors + "Entry:inequality" + Regression.nl;
							}
						}
						cmp[j] = null;
						found = true;
						break;
					}
				}
			}
			if(! found){
				return errors + "element not found" + Regression.nl;
			}
		}
		return errors;
	}

}