/*
Author: Pramod S. Jaiswal
Date: 16 june 01


This programs depicts how to use the DatePickerBean to present a date range selection to the user

PLEASE ADD DatePicker.jar to your classpath and then do Javac

*/


import DatePickerBean.*;
import java.awt.*;
import java.awt.event.*;

public class DatePickerRange extends Frame 
{
	DatePicker startdt=new DatePicker();
	DatePicker enddt=new DatePicker();

	public DatePickerRange()
	{
		
		Panel p=new Panel();
		p.add(new Label("List all Employees who have joined the Company between"));
		p.add(startdt);
		p.add(new Label("  AND "));
		p.add(enddt);

		add(p,BorderLayout.NORTH);
		add(new Label("NOTE: Startdt cannot be > than Enddt and Enddt Cannot be < than Startdt. Just Check how every click affects the Date Range in respective cals" ),BorderLayout.CENTER);	
//DatePicker Settings

		try
		{
			startdt.setDateFormat(DatePicker.mmmm_dd_yyyy);
			enddt.setDateFormat(DatePicker.mmmm_dd_yyyy);

			startdt.setCalendarTitle("Choose Start Date");
			enddt.setCalendarTitle("Choose End Date");

			//setting minimum startdate
			startdt.setMinDate(1950,1,1);
			//setting current start date
			startdt.setDate(2000,1,1);

			//setting maximum end date
			enddt.setMaxDate(2050,12,31);
			//setting current end date
			enddt.setDate(2000,12,31);
			
			//start date- end date validation
			startdt.setMaxDate(enddt.getDate());
			enddt.setMinDate(startdt.getDate());
		}
		catch(DatePickerException dpe)
		{}


		addWindowListener( new WindowAdapter()
		{
			public void windowClosing(WindowEvent e)
			{
				System.exit(0);
			}
		}
		);


		setTitle("DatePicker Range");
		Toolkit tk=Toolkit.getDefaultToolkit();
 		Dimension sd = tk.getScreenSize();	
		setSize((int)sd.getWidth(),(int)sd.getHeight());
		setVisible(true);		
	}

	public static void main(String args[])
	{
		new DatePickerRange();
	}


}