/*
 * Decompiled with CFR 0.152.
 */
package DatePickerBean;

import DatePickerBean.CalWin;
import DatePickerBean.DPLanguage;
import DatePickerBean.DatePickerException;
import DatePickerBean.DatePickerListener;
import DatePickerBean.DatePickerListenerHandler;
import DatePickerBean.GreaterThanMaxDateException;
import DatePickerBean.InvalidDateException;
import DatePickerBean.LessThanMinDateException;
import DatePickerBean.calendarpanel;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.sql.Date;
import java.util.GregorianCalendar;

public class DatePicker
extends Button {
    public static final int dd_mm_yyyy = 1;
    public static final int mm_dd_yyyy = 2;
    public static final int dd_mmm_yyyy = 3;
    public static final int dd_mmmm_yyyy = 4;
    public static final int mmm_dd_yyyy = 5;
    public static final int mmmm_dd_yyyy = 6;
    public static final int ldow_dd_mmm_yyyy = 7;
    public static final int ldow_dd_mmmm_yyyy = 8;
    public static final int ldow_mmm_dd_yyyy = 9;
    public static final int ldow_mmmm_dd_yyyy = 10;
    public static final int sdow_dd_mmm_yyyy = 11;
    public static final int sdow_dd_mmmm_yyyy = 12;
    public static final int sdow_mmm_dd_yyyy = 13;
    public static final int sdow_mmmm_dd_yyyy = 14;
    private int dateformat = 13;
    public static final int LANG_ENGLISH = 101;
    public static final int LANG_FRENCH = 102;
    public static final int LANG_FINNISH = 103;
    int language;
    calendarpanel calpan = new calendarpanel(this);
    boolean CalModal = false;
    CalWin cwin;
    boolean showtoday = true;
    boolean show_date_range = true;
    int alterheight = 0;
    private Color ArrowColor = Color.lightGray;
    private Color CalendarBackground = Color.white;
    private Color CalendarArrowColor = Color.gray;
    private Color CalendarWeekdaysColor = Color.blue;
    private Color CalendarDaysColor = Color.black;
    private Color CalendarMonthColor = Color.black;
    private Color CalendarYearColor = Color.black;
    private Color CalendarMouseOverYearColor = Color.red;
    private Color CalendarSelectionColor = Color.red;
    private boolean EditableYearVisible = true;
    private int CalWinWidth_EditableYearVisible = 290;
    private int CalWinWidth_EditableYearNotVisible = 260;
    private int CalWinWidth = this.CalWinWidth_EditableYearVisible;
    private int CalWinHeightNormal = 290;
    private int CalWinHeightApplet = 310;
    private int CalWinHeight = this.CalWinHeightNormal;
    String calendarTitle;
    private Rectangle parentrect;
    private Rectangle rect;
    private boolean appletstatus = false;
    private boolean browserstatus = false;
    private GregorianCalendar vdt = new GregorianCalendar();
    private boolean AutoCalendarPosition = true;
    DatePickerListenerHandler dphl;
    int calendar_x = 0;
    int calendar_y = 0;
    private boolean autoresize_dpbutton = false;
    boolean dateSelection = true;

    public DatePicker() {
        this.init();
    }

    public DatePicker(int n, int n2, int n3) throws DatePickerException {
        this.setDate(n, n2, n3);
        this.init();
    }

    public DatePicker(Date date) throws DatePickerException {
        this.setDate(date);
        this.init();
    }

    public DatePicker(Date date, Date date2, Date date3) throws DatePickerException {
        this.setDate(date);
        this.setMinDate(date);
        this.setMaxDate(date);
        this.init();
    }

    public DatePicker(GregorianCalendar gregorianCalendar) throws DatePickerException {
        this.setDate(gregorianCalendar);
        this.init();
    }

    public DatePicker(GregorianCalendar gregorianCalendar, GregorianCalendar gregorianCalendar2, GregorianCalendar gregorianCalendar3) throws DatePickerException {
        this.setDate(gregorianCalendar);
        this.setMinDate(gregorianCalendar);
        this.setMaxDate(gregorianCalendar);
        this.init();
    }

    public static int CompareDates(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n < n4) {
            return -1;
        }
        if (n > n4) {
            return 1;
        }
        if (n2 < n5) {
            return -1;
        }
        if (n2 > n5) {
            return 1;
        }
        if (n3 < n6) {
            return -1;
        }
        if (n3 > n6) {
            return 1;
        }
        return 0;
    }

    public static int CompareDates(GregorianCalendar gregorianCalendar, GregorianCalendar gregorianCalendar2) {
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2);
        int n3 = gregorianCalendar.get(5);
        int n4 = gregorianCalendar2.get(1);
        int n5 = gregorianCalendar2.get(2);
        int n6 = gregorianCalendar2.get(5);
        return DatePicker.CompareDates(n, n2, n3, n4, n5, n6);
    }

    void NewDateSelected(String string) {
        this.showDate(string);
        this.dphl.FireNewDateSelected();
    }

    public int addDatePickerListener(DatePickerListener datePickerListener) {
        int n = this.dphl.addDatePickerListener(datePickerListener);
        return n;
    }

    public boolean autoResizeDPButton() {
        return this.autoresize_dpbutton;
    }

    public void autoResizeDPButton(boolean bl) {
        this.autoresize_dpbutton = bl;
    }

    public void enableDateSelection(boolean bl) {
        this.dateSelection = bl;
        this.calpan.enableDateSelection(bl);
    }

    public Color getArrowColor() {
        return this.ArrowColor;
    }

    public boolean getAutoCalendarPosition() {
        return this.AutoCalendarPosition;
    }

    public Color getCalendarArrowColor() {
        return this.CalendarArrowColor;
    }

    public Color getCalendarBackground() {
        return this.CalendarBackground;
    }

    public Color getCalendarDaysColor() {
        return this.CalendarDaysColor;
    }

    public int getCalendarHeight() {
        return this.CalWinHeight - this.alterheight;
    }

    public Color getCalendarMonthColor() {
        return this.CalendarMonthColor;
    }

    public Color getCalendarMouseOverYear_Color() {
        return this.CalendarMouseOverYearColor;
    }

    public Color getCalendarSelectionColor() {
        return this.CalendarSelectionColor;
    }

    public String getCalendarTitle() {
        return this.cwin.getTitle();
    }

    public Color getCalendarWeekdaysColor() {
        return this.CalendarWeekdaysColor;
    }

    public int getCalendarWidth() {
        return this.CalWinWidth;
    }

    public Color getCalendarYearColor() {
        return this.CalendarYearColor;
    }

    public boolean getCalendar_Modal() {
        return this.CalModal;
    }

    public String getDOW(GregorianCalendar gregorianCalendar) {
        int n = gregorianCalendar.get(7);
        return this.calpan.mp.wd[0].getWeekDay(n - 1);
    }

    public GregorianCalendar getDate() {
        GregorianCalendar gregorianCalendar = this.calpan.getDate();
        return new GregorianCalendar(gregorianCalendar.get(1), gregorianCalendar.get(2), gregorianCalendar.get(5));
    }

    public int getDateFormat() {
        return this.dateformat;
    }

    public DatePicker getDateValues() {
        return this;
    }

    public int getDay() {
        return this.getDayFrom(this.getDate());
    }

    public int getDayFrom(GregorianCalendar gregorianCalendar) {
        return gregorianCalendar.get(5);
    }

    public static int getDaysBetween(GregorianCalendar gregorianCalendar, GregorianCalendar gregorianCalendar2) {
        int n = DatePicker.CompareDates(gregorianCalendar, gregorianCalendar2);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (n == -1) {
            n5 = gregorianCalendar.get(1);
            n3 = gregorianCalendar.get(6);
            n4 = gregorianCalendar2.get(1);
            n2 = gregorianCalendar2.get(6);
        } else {
            if (n == 0) {
                return 0;
            }
            if (n == 1) {
                n5 = gregorianCalendar2.get(1);
                n3 = gregorianCalendar2.get(6);
                n4 = gregorianCalendar.get(1);
                n2 = gregorianCalendar.get(6);
            }
        }
        int n6 = 0;
        if (n5 == n4) {
            n6 = n2 - n3;
        } else if (n4 - n5 == 1) {
            n6 = DatePicker.getNumberOfDaysInYear(n5) - n3 + n2;
        } else if (n4 - n5 > 1) {
            n6 = DatePicker.getNumberOfDaysInYear(n5) - n3;
            int n7 = n5 + 1;
            while (n7 < n4) {
                n6 += DatePicker.getNumberOfDaysInYear(n7);
                ++n7;
            }
            n6 += n2;
        }
        return n6;
    }

    public int getDisplayLanguage() {
        return this.language;
    }

    public boolean getEditableYearVisible() {
        return this.EditableYearVisible;
    }

    public String getFormat() {
        String string;
        switch (this.dateformat) {
            case 1: {
                string = "dd_mm_yyyy";
                break;
            }
            case 2: {
                string = "mm_dd_yyyy";
                break;
            }
            case 3: {
                string = "dd_mmm_yyyy";
                break;
            }
            case 4: {
                string = "dd_mmmm_yyyy";
                break;
            }
            case 5: {
                string = "mmm_dd_yyyy";
                break;
            }
            case 6: {
                string = "mmmm_dd_yyyy";
                break;
            }
            case 7: {
                string = "ldow_dd_mmm_yyyy";
                break;
            }
            case 8: {
                string = "ldow_dd_mmmm_yyyy";
                break;
            }
            case 9: {
                string = "ldow_mmm_dd_yyyy";
                break;
            }
            case 10: {
                string = "ldow_mmmm_dd_yyyy";
                break;
            }
            case 11: {
                string = "sdow_dd_mmm_yyyy";
                break;
            }
            case 12: {
                string = "sdow_dd_mmmm_yyyy";
                break;
            }
            case 13: {
                string = "sdow_mmm_dd_yyyy";
                break;
            }
            case 14: {
                string = "sdow_mmmm_dd_yyyy";
                break;
            }
            default: {
                string = "sdow_mmm_dd_yyyy";
            }
        }
        if (this.getDateFormat() <= 9) {
            return "0" + this.getDateFormat() + ". " + string;
        }
        return this.getDateFormat() + ". " + string;
    }

    public String getFormattedDate() {
        return this.calpan.getDateFormat(this.getDate(), this.dateformat);
    }

    public String getFormattedDate(GregorianCalendar gregorianCalendar, int n) {
        return this.calpan.getDateFormat(gregorianCalendar, n);
    }

    public GregorianCalendar getMaxDate() {
        GregorianCalendar gregorianCalendar = this.calpan.getMaxDate();
        return new GregorianCalendar(gregorianCalendar.get(1), gregorianCalendar.get(2), gregorianCalendar.get(5));
    }

    public GregorianCalendar getMinDate() {
        GregorianCalendar gregorianCalendar = this.calpan.getMinDate();
        return new GregorianCalendar(gregorianCalendar.get(1), gregorianCalendar.get(2), gregorianCalendar.get(5));
    }

    public int getMonth() {
        return this.getMonthFrom(this.getDate());
    }

    public int getMonthFrom(GregorianCalendar gregorianCalendar) {
        return gregorianCalendar.get(2) + 1;
    }

    public String getMonthStr(GregorianCalendar gregorianCalendar) {
        int n = gregorianCalendar.get(2);
        return this.calpan.bp.mylrp.myp.getMonth(n, 2);
    }

    public static int getNumberOfDaysInYear(int n) {
        if (n % 4 == 0 && (n % 100 != 0 || n % 400 == 0)) {
            return 366;
        }
        return 365;
    }

    public boolean getShowDateRangeInCalendar() {
        return this.show_date_range;
    }

    public boolean getShowTodayInCalendar() {
        return this.showtoday;
    }

    public int getYear() {
        return this.getYearFrom(this.getDate());
    }

    public int getYearFrom(GregorianCalendar gregorianCalendar) {
        return gregorianCalendar.get(1);
    }

    public boolean inApplet() {
        return this.appletstatus;
    }

    public void inApplet(boolean bl) {
        this.appletstatus = bl;
        this.CalWinHeight = bl ? this.CalWinHeightApplet : this.CalWinHeightNormal;
    }

    public boolean inBrowser() {
        return this.browserstatus;
    }

    public void inBrowser(boolean bl) {
        this.browserstatus = bl;
    }

    private void init() {
        this.cwin = new CalWin(new Frame(), this.CalModal, this.calpan);
        this.setBackground(Color.white);
        this.setForeground(Color.gray);
        this.language = 101;
        String[] stringArray = new String[]{"Sun", "Mon", "Tue", "Wed", " Thu", " Fri", "Sat"};
        String[] stringArray2 = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
        GregorianCalendar gregorianCalendar = this.getDate();
        int n = gregorianCalendar.get(7);
        String string = String.valueOf(stringArray[n - 1]) + ", " + stringArray2[this.getMonth() - 1] + " " + this.getDay() + ", " + this.getYear();
        this.dateformat = 13;
        this.showDate(string);
        this.dphl = new DatePickerListenerHandler(this);
        this.addActionListener(this.dphl);
    }

    private boolean isDateValid(int n, int n2, int n3) {
        this.vdt.set(n, --n2, n3);
        return n == this.vdt.get(1) && n2 == this.vdt.get(2) && n3 == this.vdt.get(5);
    }

    public void paint(Graphics graphics) {
        graphics.setColor(this.ArrowColor);
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        int[] nArray = new int[]{n * 80 / 100, n * 94 / 100, n * 87 / 100};
        int[] nArray2 = new int[]{n2 * 32 / 100, n2 * 32 / 100, n2 * 70 / 100};
        graphics.fillPolygon(nArray, nArray2, 3);
    }

    void refreshCalendar() {
        Point point = this.cwin.getLocationOnScreen();
        this.calendar_x = point.x;
        this.calendar_y = point.y;
        this.dphl.showCalendar(this.calendar_x, this.calendar_y);
    }

    public int removeDatePickerListener(DatePickerListener datePickerListener) {
        int n = this.dphl.removeDatePickerListener(datePickerListener);
        return n;
    }

    public void setArrowColor(Color color) {
        this.ArrowColor = color;
        this.repaint();
    }

    public void setAutoCalendarPosition(boolean bl) {
        this.AutoCalendarPosition = bl;
    }

    public void setCalendarArrowColor(Color color) {
        this.CalendarArrowColor = color;
    }

    public void setCalendarBackground(Color color) {
        this.CalendarBackground = color;
    }

    public void setCalendarDaysColor(Color color) {
        this.CalendarDaysColor = color;
    }

    public void setCalendarMonthColor(Color color) {
        this.CalendarMonthColor = color;
    }

    public void setCalendarMouseOverYear_Color(Color color) {
        this.CalendarMouseOverYearColor = color;
    }

    public void setCalendarOwner(Dialog dialog) {
        if (this.cwin.getOwner() != dialog) {
            this.calendarTitle = this.cwin.getTitle();
            this.cwin.dispose();
            this.cwin = null;
            this.cwin = new CalWin(dialog, this.CalModal, this.calpan);
            ((Component)this.cwin).setSize(this.getCalendarWidth(), this.getCalendarHeight());
            this.cwin.setTitle(this.calendarTitle);
            this.dphl.dp = this;
        }
    }

    public void setCalendarOwner(Frame frame) {
        if (this.cwin.getOwner() != frame) {
            this.calendarTitle = this.cwin.getTitle();
            this.cwin.dispose();
            this.cwin = null;
            this.cwin = new CalWin(frame, this.CalModal, this.calpan);
            ((Component)this.cwin).setSize(this.getCalendarWidth(), this.getCalendarHeight());
            this.cwin.setTitle(this.calendarTitle);
            this.dphl.dp = this;
        }
    }

    public void setCalendarSelectionColor(Color color) {
        this.CalendarSelectionColor = color;
    }

    public void setCalendarTitle(String string) {
        this.cwin.setTitle(string);
    }

    public void setCalendarWeekdaysColor(Color color) {
        this.CalendarWeekdaysColor = color;
    }

    public void setCalendarYearColor(Color color) {
        this.CalendarYearColor = color;
    }

    public void setCalendar_Modal(boolean bl) {
        this.CalModal = bl;
        this.cwin.setModal(this.CalModal);
        this.dphl.dp = this;
    }

    public void setDate(int n, int n2, int n3) throws DatePickerException {
        if (!this.isDateValid(n, n2, n3)) {
            throw new InvalidDateException();
        }
        if (DatePicker.CompareDates(new GregorianCalendar(n, n2 - 1, n3), this.getDate()) == 0) {
            return;
        }
        int n4 = DatePicker.CompareDates(new GregorianCalendar(n, n2 - 1, n3), this.calpan.getMinDate());
        if (n4 == -1) {
            throw new LessThanMinDateException();
        }
        n4 = DatePicker.CompareDates(new GregorianCalendar(n, n2 - 1, n3), this.calpan.getMaxDate());
        if (n4 == 1) {
            throw new GreaterThanMaxDateException();
        }
        this.calpan.setDate(n, n2, n3);
        this.NewDateSelected(this.calpan.dateSelectionOver());
    }

    public void setDate(Date date) throws DatePickerException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        this.setDate(gregorianCalendar);
    }

    public void setDate(GregorianCalendar gregorianCalendar) throws DatePickerException {
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar(gregorianCalendar.get(1), gregorianCalendar.get(2), gregorianCalendar.get(5));
        this.setDate(gregorianCalendar2.get(1), gregorianCalendar2.get(2) + 1, gregorianCalendar2.get(5));
    }

    public void setDateFormat(int n) {
        this.dateformat = n;
        this.showDate(this.calpan.setDateFormat());
    }

    public void setDateValues(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        try {
            this.setDate(n, n2, n3);
            this.setMinDate(n4, n5, n6);
            this.setMaxDate(n7, n8, n9);
        }
        catch (DatePickerException datePickerException) {}
    }

    public void setDateValues(DatePicker datePicker) {
        try {
            this.setDate(datePicker.getDate());
            this.setMinDate(datePicker.getMinDate());
            this.setMaxDate(datePicker.getMaxDate());
        }
        catch (DatePickerException datePickerException) {}
    }

    public boolean setDisplayLanguage(int n) {
        if (this.language == n) {
            return true;
        }
        if (n >= 101 && n <= 103) {
            this.language = n;
            this.setCalendarTitle(DPLanguage.getSelectDateTranslation(this.language));
            String string = this.calpan.changeLanguage(this.language);
            this.showDate(string);
            return true;
        }
        return false;
    }

    public void setEditableYearVisible(boolean bl) {
        if (this.EditableYearVisible != bl) {
            this.EditableYearVisible = bl;
            this.calpan.setEditableYearVisible(bl);
            this.CalWinWidth = bl ? this.CalWinWidth_EditableYearVisible : this.CalWinWidth_EditableYearNotVisible;
        }
    }

    public void setFormat(String string) {
        try {
            int n;
            this.dateformat = n = Integer.parseInt(string.substring(0, 2));
            this.showDate(this.calpan.setDateFormat());
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public void setMaxDate(int n, int n2, int n3) throws DatePickerException {
        if (!this.isDateValid(n, n2, n3)) {
            throw new InvalidDateException();
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(n, n2 - 1, n3);
        this.setMaxDate(gregorianCalendar);
    }

    public void setMaxDate(Date date) throws LessThanMinDateException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        this.setMaxDate(gregorianCalendar);
    }

    public void setMaxDate(GregorianCalendar gregorianCalendar) throws LessThanMinDateException {
        block4: {
            GregorianCalendar gregorianCalendar2 = new GregorianCalendar(gregorianCalendar.get(1), gregorianCalendar.get(2), gregorianCalendar.get(5));
            if (DatePicker.CompareDates(gregorianCalendar2, this.getMaxDate()) == 0) {
                return;
            }
            int n = DatePicker.CompareDates(gregorianCalendar2, this.calpan.getMinDate());
            if (n == -1) {
                throw new LessThanMinDateException();
            }
            this.calpan.setMaxDate(gregorianCalendar2);
            n = 0;
            n = DatePicker.CompareDates(gregorianCalendar2, this.calpan.getDate());
            if (n != -1) break block4;
            try {
                this.setDate(gregorianCalendar2);
            }
            catch (DatePickerException datePickerException) {}
        }
    }

    public void setMinDate(int n, int n2, int n3) throws DatePickerException {
        if (!this.isDateValid(n, n2, n3)) {
            throw new InvalidDateException();
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(n, n2 - 1, n3);
        this.setMinDate(gregorianCalendar);
    }

    public void setMinDate(Date date) throws GreaterThanMaxDateException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        this.setMinDate(gregorianCalendar);
    }

    public void setMinDate(GregorianCalendar gregorianCalendar) throws GreaterThanMaxDateException {
        block4: {
            GregorianCalendar gregorianCalendar2 = new GregorianCalendar(gregorianCalendar.get(1), gregorianCalendar.get(2), gregorianCalendar.get(5));
            if (DatePicker.CompareDates(gregorianCalendar2, this.getMinDate()) == 0) {
                return;
            }
            int n = DatePicker.CompareDates(gregorianCalendar2, this.calpan.getMaxDate());
            if (n == 1) {
                throw new GreaterThanMaxDateException();
            }
            this.calpan.setMinDate(gregorianCalendar2);
            n = 0;
            n = DatePicker.CompareDates(gregorianCalendar2, this.calpan.getDate());
            if (n != 1) break block4;
            try {
                this.setDate(gregorianCalendar2);
            }
            catch (DatePickerException datePickerException) {}
        }
    }

    public void setShowDateRangeInCalendar(boolean bl) {
        this.showDateRangeInCalendar(bl);
    }

    public void setShowTodayInCalendar(boolean bl) {
        this.showTodayInCalendar(bl);
    }

    public void showCalendar() {
        this.dphl.showCalendar();
    }

    public void showCalendar(int n, int n2) {
        this.dphl.showCalendar(n, n2);
    }

    private void showDate(String string) {
        if (this.autoresize_dpbutton) {
            if (this.dateformat == 1 || this.dateformat == 2 || this.dateformat == 3 || this.dateformat == 5) {
                this.setLabel("  " + string + "        ");
            } else if (this.dateformat == 4 || this.dateformat == 6 || this.dateformat == 11 || this.dateformat == 13) {
                this.setLabel("  " + string + "          ");
            } else {
                this.setLabel("  " + string + "                ");
            }
        } else {
            this.setLabel("  " + string + "                ");
        }
        ((Component)this.cwin).setVisible(false);
    }

    public void showDateRangeInCalendar(boolean bl) {
        if (this.show_date_range == bl) {
            return;
        }
        this.show_date_range = bl;
        this.alterheight = 0;
        if (!this.showtoday) {
            this.alterheight = 30;
        }
        if (!this.show_date_range) {
            this.alterheight += 30;
        }
        this.calpan.showInCalendar(this.showtoday, this.show_date_range);
    }

    public void showTodayInCalendar(boolean bl) {
        if (this.showtoday == bl) {
            return;
        }
        this.showtoday = bl;
        this.alterheight = 0;
        if (!this.showtoday) {
            this.alterheight = 30;
        }
        if (!this.show_date_range) {
            this.alterheight += 30;
        }
        this.calpan.showInCalendar(this.showtoday, this.show_date_range);
    }

    public String toString() {
        String string = String.valueOf(DPLanguage.getCurrentDateTranslation(this.language)) + " :" + this.getFormattedDate(this.getDate(), 10) + "\n";
        string = String.valueOf(string) + DPLanguage.getMinDateTranslation(this.language) + " :" + this.getFormattedDate(this.getMinDate(), 10) + "\n";
        string = String.valueOf(string) + DPLanguage.getMaxDateTranslation(this.language) + " :" + this.getFormattedDate(this.getMaxDate(), 10) + "\n";
        return string;
    }
}

