/*

Author : Shailesh K. Ashar

PLEASE ADD DatePicker.jar to your classpath and then do Javac


*/


import DatePickerBean.*;
import java.awt.*;
import java.awt.event.*;

public class DatePickerDemo extends Frame implements DatePickerListener
{
	DatePicker dp=new DatePicker();
	TextArea ta=new TextArea();

	public DatePickerDemo()
	{
		Panel p=new Panel();
		p.add(dp);

		add(p,BorderLayout.NORTH);
		add(ta,BorderLayout.SOUTH);

//DatePicker Settings

		try
		{
			dp.setMinDate(1999,5,12);
			dp.setMaxDate(2010,4,21);
		}
		catch(DatePickerException dpe)
		{}

		dp.setBackground(Color.lightGray);
		dp.setCalendarBackground(Color.lightGray);
		dp.setArrowColor(Color.gray);
		dp.setCalendarArrowColor(Color.white);



// adding a DatePickerListener

		dp.addDatePickerListener(this);
		
		addWindowListener( new WindowAdapter()
		{
			public void windowClosing(WindowEvent e)
			{
				System.exit(0);
			}
		}
		);


		setTitle("DatePicker Demo");
		setBounds(100,100,400,400);
		setVisible(true);		
	}

	public static void main(String args[])
	{
		System.out.println("start");
		new DatePickerDemo();
	}

	public void dateChanged(DatePicker dpobj)
	{
		ta.setText("DateChange Event:\n\n"+dpobj.toString());
	}

}