/****************************************************

	JConfig Source Code Distribution
	version: 2.1.0      written: Mon May 28 10:11:26 PDT 2001

	Unless otherwise noted, all contents
	Copyright (c) 1997,1998,1999,2000 Samizdat Productions.
	All Rights Reserved.
	All contents are subject to the terms of the
	JConfig Source Code License Agreement

****************************************************/

package com.jconfig;

/**
Interface for objects which watch the commands sent to an AppProcess object.

@author Copyright (c) 1997,1998,1999,2000 Samizdat Productions. All Rights Reserved.
*/

public interface AppCommandWatcher {
	static final String copyrightString = "JConfig Copyright (c) 1997,1998,1999,2000 Samizdat Productions. All Rights Reserved.";

/**
Called before the event is acted upon. If this method returns true, the event is not
processed.
@param target the target of this AppCommand
@param command the command
@param flags the flags for the command
*/

	boolean watchPre( Object target, AppCommand command, int flags );

/**
Called after the event has been acted upon.
@param target the target of this AppCommand
@param command the command
@param flags the flags for the command
*/

	boolean watchPost( Object target, AppCommand command, int flags );
}

