/****************************************************

	JConfig Source Code Distribution
	version: 2.1.0      written: Mon May 28 10:11:26 PDT 2001

	Unless otherwise noted, all contents
	Copyright (c) 1997,1998,1999,2000 Samizdat Productions.
	All Rights Reserved.
	All contents are subject to the terms of the
	JConfig Source Code License Agreement

****************************************************/

#include "SIcons.h"
#include "MoreFiles.h"
#include "MoreFilesExtras.h"
#include "FullPath.h"
#include "find_icon.h"
#include "DTGetIconSuite.h"
#include "CUtils.h"
#include "Debugger.h"

ErrCode SIcons::getVolumeIconSuite( long vRef, long selector, Handle *hSuite )
{
	FSSpec		theSpec;
	ErrCode			theErr;

	UNUSED( selector );

	*hSuite = NULL;

	theErr = FSMakeFSSpec( vRef, 0, NULL, &theSpec );
	if ( theErr != kErrNoErr ) {
		Debugger::debug( __LINE__, "getVolumeIconSuite.fsm", NULL, NULL, theErr, vRef );
		return theErr;
	}

	theErr = Find_icon( &theSpec, NULL, kSelectorAllAvailableData, hSuite );
	if ( theErr != kErrNoErr )
		Debugger::debug( __LINE__, "getVolumeIconSuite.fi", NULL, NULL, theErr, vRef );
	
	return theErr;
}

ErrCode SIcons::getFileIconSuite( const CFSpec *theSpec, long selector, Handle *hSuite )
{
	CFSpec		tempSpec( theSpec );
	ErrCode			theErr;

	UNUSED( selector );

	*hSuite = NULL;

	theErr = tempSpec.verify();
	if ( theErr != kErrNoErr ) {
		tempSpec.dumpInfo( theErr, _TXL( "getFileIconSuite.fsm" ) );
		return theErr;
	}

	theErr = Find_icon( tempSpec.getSpecP(), NULL, kSelectorAllAvailableData, hSuite );
	if ( theErr != kErrNoErr )
		tempSpec.dumpInfo( theErr, _TXL( "getFileIconSuite.fi" ) );

	return theErr;
}

ErrCode SIcons::getFTACIconSuite( long vRef, long creator, long type, long selector, Handle *hSuite )
{
	ErrCode			theErr;

	UNUSED( selector );

	*hSuite = NULL;

	theErr = DTGetIconSuite( vRef, kSelectorAllAvailableData, creator, type, hSuite );
	if ( theErr != kErrNoErr )
		Debugger::debug( __LINE__, "getFTACIconSuite.dt", NULL, NULL, theErr, creator, type );

	return theErr;
}

ErrCode SIcons::disposeAnIconSuite( Handle hSuite, long flags )
{
	ErrCode			theErr;

	if ( hSuite == NULL )
		return paramErr;

	theErr = DisposeIconSuite( hSuite, (Boolean) flags );
	if ( theErr != kErrNoErr )	
		Debugger::debug( __LINE__, "disposing of icon suite", NULL, NULL, (long) hSuite, theErr );
	
	return theErr;
}

