/****************************************************

	JConfig Source Code Distribution
	version: 2.1.0      written: Mon May 28 10:11:26 PDT 2001

	Unless otherwise noted, all contents
	Copyright (c) 1997,1998,1999,2000 Samizdat Productions.
	All Rights Reserved.
	All contents are subject to the terms of the
	JConfig Source Code License Agreement

****************************************************/

#include "SAppInfo.h"
#include "XToolkit.h"
#include "CFileUtils.h"
#include "CRegUtils.h"
#include "Debugger.h"

ErrCode SAppInfo::iNativeLaunchApp( const CStr *commandLine, AppDataType *appDataP )
{
	long				theErr;

	if ( !XToolkit::XCreateProcess( commandLine, STARTF_USESHOWWINDOW, SW_SHOW, &appDataP->pi ) ) {
		Debugger::debug( __LINE__, _TXL( "createProcess" ), commandLine, NULL );
		theErr = kErrCreateProcess;
	}
	else {
		scanForMainHWND( appDataP );
		theErr = kErrNoErr;
	}

	return theErr;
}

ErrCode SAppInfo::iNativeMoveApp( AppDataType *appData, eMoveApp selector, long flags )
{
	long		theErr;

	theErr = scanForMainHWND( appData );
	if ( theErr != kErrNoErr )
		goto bail;

	theErr = moveHWND( (HWND) appData->hwnd, selector );

bail:

	return theErr;
}

ErrCode SAppInfo::moveHWND( HWND hWnd, long selector )
{
	long			theErr;

	switch ( selector ) {
		case kMoveAppToFront:
			if ( !SetForegroundWindow( hWnd ) )
				theErr = kErrSetForegroundWindow;
			else
				theErr = kErrNoErr;
		break;

		case kMoveAppToBack:
			if ( !SetWindowPos( hWnd, HWND_BOTTOM, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE ) )
				theErr = kErrSetWindowPos;
			else
				theErr = kErrNoErr;
		break;

		case kMoveAppMinimize:
			if ( !CloseWindow( hWnd ) )
				theErr = kErrCloseWindow;
			else
				theErr = kErrNoErr;
		break;

		case kMoveAppMaximize:
			if ( !ShowWindow( hWnd, SW_SHOWMAXIMIZED ) )
				theErr = kErrShowWindow;
			else
				theErr = kErrNoErr;
		break;

		default:
			theErr = kErrParamErr;
		break;
	}

	return theErr;
}

ErrCode SAppInfo::iNativeQuitApp( AppDataType *appData )
{
	long		theErr;

	theErr = scanForMainHWND( appData );
	if ( theErr != kErrNoErr )
		goto bail;

	PostThreadMessage( appData->pi.dwThreadId, WM_QUIT, (WPARAM) NULL, (LPARAM) NULL );

	theErr = kErrNoErr;

bail:

	return theErr;
}

ErrCode SAppInfo::iNativeVerifyNativeAppData( AppDataType *appData )
{
	return scanForMainHWND( appData );
}

long SAppInfo::moveAppFlagsToSWFlags( eMoveApp flags )
{
	if ( flags == kMoveAppToFront )
		return SW_SHOWNORMAL;
	else if ( flags == kMoveAppToBack )
		return SW_SHOWNOACTIVATE;
	else if ( flags == kMoveAppMinimize )
		return SW_SHOWMINIMIZED;
	else if ( flags == kMoveAppMaximize )
		return SW_SHOWMAXIMIZED;

	return SW_SHOWNORMAL;
}

HWND SAppInfo::getTopWindow( HWND start )
{
	HWND		last;
	
	last = 0;
	while ( start != 0 ) {
		last = start;
		start = GetParent( start );
	}
	
	return last;
}

BOOL CALLBACK SAppInfo::MyEnumThreadWndProc( HWND hwnd, LPARAM lParam )
{
	*( (HWND*) lParam ) = hwnd;

	return FALSE;
}

ErrCode SAppInfo::scanForMainHWND( AppDataType *appData )
{
	DWORD		fred;

	fred = 0;

	EnumThreadWindows( appData->pi.dwThreadId, (WNDENUMPROC) MyEnumThreadWndProc, (LPARAM) &fred );

	if ( fred == 0 )
		Debugger::debug( __LINE__, _TXL( "scanForMainHWND" ), NULL, NULL, fred, 0 );

	appData->hwnd = (HWND) fred;

	if ( fred == 0 )
		return kErrEnumThreadWindows;
	else
		return kErrNoErr;
}

