package com.tolstoy.imagemeister;

import java.awt.*;
import java.awt.image.*;
import java.io.File;
import java.io.PrintStream;
import java.util.Date;
import com.jconfig.*;

/**
A utility class used to hold information on a file. An object of this class holds either a
com.jconfig.DiskObject object, or a java.io.File object which specifies the file.
It also holds a FinderInfo and a FileExtension object on the file.

@author Copyright (c) 1997,1998,1999,2000 Samizdat Productions. All Rights Reserved.
*/

public class FileSpecifier {
	private static final String copyright="ImageMeister Copyright (c) 1998,1999,2000 Samizdat Productions. All Rights Reserved. ImageMeister is a Trademark of Samizdat Productions.";

	private DiskObject			diskObj;
	private File				jFile;
	private FinderInfo			finfo;
	private FileExtension		ext;

/**
Create a new instance. If both the DiskObject and the File are null, an IllegalArgumentException
is thrown. Either or both of the FinderInfo and FileExtension objects can be null.
*/

	public FileSpecifier( DiskObject d, File f, FinderInfo fi, FileExtension fe ) {
		if ( d == null && f == null )
			throw new IllegalArgumentException( "FileSpecifier: both dobj and file are null" );

		diskObj = d;
		jFile = f;
		finfo = fi;
		ext = fe;
	}

	public FileSpecifier( FileSpecifier fs ) {
		this( fs.getDiskObject(), fs.getFile(), fs.getFinderInfo(), fs.getFileExtension() );
	}
	
	public DiskObject getDiskObject() { return diskObj; }
	public File getFile() { return jFile; }
	public FinderInfo getFinderInfo() { return finfo; }
	public FileExtension getFileExtension() { return ext; }
}
