package com.tolstoy.imagemeister;

import java.awt.*;
import java.awt.image.*;

/**
An image button.

@author Copyright (c) 1997,1998,1999,2000 Samizdat Productions. All Rights Reserved.
*/

class ImageButton extends Canvas implements ImageObserver {
	private static final String copyright="ImageMeister Copyright (c) 1998,1999,2000 Samizdat Productions. All Rights Reserved. ImageMeister is a Trademark of Samizdat Productions.";

	Image			uImage, dImage;
	int				w,h;
	boolean			bIsDown, bFirstTime;
	
/**
@param fileNameU path of the file containing the image to be shown when the button is up.
@param fileNameD path of the file containing the image to be shown when the button is down.
*/
	
	public ImageButton( String fileNameU, String fileNameD, int w, int h ) {
		this.w = w;
		this.h = h;
		uImage = Toolkit.getDefaultToolkit().getImage( fileNameU );
		dImage = Toolkit.getDefaultToolkit().getImage( fileNameD );
		bIsDown = false;
		bFirstTime = true;
	}
	
	public boolean mouseDown( Event e, int x, int y ) {
		bIsDown = true;
		repaint();
		return true;
	}

	public boolean mouseUp( Event e, int x, int y ) {
		Event		newE;

		if ( e.target != this )
			return false;

		if ( bIsDown && x >= 0 && y >= 0 && x < w && y < h ) {
			newE = new Event( this, e.when, Event.ACTION_EVENT, x, y, 0, 0 );
			this.postEvent( newE );
		}
		
		bIsDown = false;
		repaint();
		
		return true;
	}

	public boolean mouseExit( Event e, int x, int y ) {
		if ( bIsDown ) {
			bIsDown = false;
			repaint();
		}
		
		return true;
	}

	public void paint( Graphics g ) {
		if ( bFirstTime ) {
			bFirstTime = false;
			if ( bIsDown ) {
				g.drawImage( uImage, 0, 0, this );
				g.drawImage( dImage, 0, 0, this );
			}
			else {
				g.drawImage( dImage, 0, 0, this );
				g.drawImage( uImage, 0, 0, this );
			}
			
			return;
		}

		if ( bIsDown )
			g.drawImage( dImage, 0, 0, this );
		else
			g.drawImage( uImage, 0, 0, this );
	}

	public Dimension minimumSize() {
		return new Dimension( w, h );
	}

	public Dimension preferredSize() {
		return new Dimension( w, h );
	}

	public Dimension size() {
		return new Dimension( w, h );
	}
}
