package com.tolstoy.imagemeister;

import java.awt.*;
import java.awt.image.*;
import java.io.File;
import java.io.PrintStream;
import java.util.Date;
import com.jconfig.*;

/**
Displays information on a volume.

@author Copyright (c) 1997,1998,1999,2000 Samizdat Productions. All Rights Reserved.
*/

class SInfoVVolume extends SInfoViewer {
	private DiskVolume			vol;

	public SInfoVVolume( DiskVolume dv, OwnedFrame oldFrame, InfoViewerOwner onr,
							FileSpecifier spec, Rectangle rect ) {
		super( oldFrame, onr, spec, rect );
		vol = dv;
	}

	void showInformation( Graphics g, int x, int y ) {
		DiskVolume			dv;
		File				jFile;
		String				s1, s2, s3, s4, dateString;
		
		jFile = vol.getFile();
		dateString = getDateString( vol );

		s1 = "VOLUME @" + Integer.toHexString( vol.hashCode() ) + ": " +  vol.getName();

		s2 = "prefix=" + vol.getPrefix() +
				", color coding=" + vol.getColorCoding() +
				", ref num=" + vol.getReferenceNumber() +
				", dates=" + dateString;
	
		if ( jFile == null )
			s3 = "java.io.File is null";
		else
			s3 = "java.io.File=" + jFile.getPath();

		if ( !jFile.exists() )
			s3 += "** java.io.File.exists() == false **"; 

		s4 = "max capacity=" + vol.getMaxCapacity() +
				", free space=" + vol.getFreeSpace();

		g.setColor( Color.red );
		g.drawString( s1, x, y );
		g.drawString( s2, x, y + 15 );
		g.drawString( s3, x, y + 30 );
		g.drawString( s4, x, y + 45 );
	}

	private String getDateString( DiskVolume df ) {
		try {
			return df.getDateBundle().toString();
		}
		catch ( UnimplementedException ue ) {
			return "getDateBundle not implemented";
		}
		catch ( Exception e ) {
			return e.toString();
		}
	}
}
