package com.tolstoy.imagemeister;

import java.awt.*;
import java.awt.image.*;
import java.io.*;
import com.jconfig.*;

/**
A very basic InfoViewerI implementation.

This is an abstract class which extends Panel.

To use this class, supply a subclass and implement the showInformation method to show
information	on a file/folder/volume.

@author Copyright (c) 1997,1998,1999,2000 Samizdat Productions. All Rights Reserved.
*/

abstract class SInfoViewer extends Panel implements InfoViewerI, WindowOwner {
	private InfoViewerOwner		owner;
	private FileSpecifier		theSpec;
	private OwnedFrame			theFrame;

	public SInfoViewer( OwnedFrame oldFrame, InfoViewerOwner onr,
						FileSpecifier spec, Rectangle rect ) {
		DiskObject			diskObj;

		owner = onr;
		theSpec = spec;

		diskObj = theSpec.getDiskObject();
		if ( diskObj == null )
			throw new IllegalArgumentException( "can't get diskObj from " + spec );

		if ( oldFrame == null ) {
			theFrame = new OwnedFrame( this );
			theFrame.reshape( rect.x, rect.y, rect.width, rect.height );
		}
		else {
			theFrame = oldFrame;
			theFrame.setWindowOwner( this );
			theFrame.removeAll();
		}
		
		theFrame.setLayout( new BorderLayout( 0, 0 ) );
		theFrame.add( "Center", this );
		theFrame.setTitle( diskObj.getDisplayName() );
	}

	public FileSpecifier getFileSpecifier() {
		return theSpec;
	}

	public OwnedFrame getFrame() {
		return theFrame;
	}

	public void setVisible( boolean bState ) {
		if ( bState )
			theFrame.show();
		else
			theFrame.hide();
	}

	abstract void showInformation( Graphics g, int x, int y );

	public void paint( Graphics g ) {
		Dimension		dd;
		
		dd = size();
		g.setColor( Color.lightGray );
		g.fillRect( 0, 0, dd.width, dd.height );

		g.setColor( Color.darkGray );
		g.drawRect( 1, 1, dd.width - 2, dd.height - 2 );
		g.drawRect( 2, 2, dd.width - 4, dd.height - 4 );
		g.drawRect( 3, 3, dd.width - 6, dd.height - 6 );

		showInformation( g, 20, 20 );
	}

	public void closeWindow( Window w ) {
		if ( w == theFrame )
			owner.closeInfoViewer( this );
	}
}
