package com.tolstoy.imagemeister;

import java.awt.*;
import java.awt.image.*;
import java.io.File;
import java.io.PrintStream;
import java.util.Date;
import com.jconfig.*;

/**
A stock plugin for showing JPEGs.

Uses a SImageViewer object to actually show the JPEG.

Does not create	InfoViewerI objects, only ImageViewerI objects.

@author Copyright (c) 1997,1998,1999,2000 Samizdat Productions. All Rights Reserved.
*/

class SJPEGViewerPlugin implements PluginI {
	private static final int				k4ccJPEG = JUtils.asciiToInt( "JPEG" );
	private static final FileExtension		kJPGExtension = new FileExtension( ".jpg" );

	public boolean canCreateImageViewer( FileSpecifier spec ) {
		FileExtension		ext;
		FinderInfo			finfo;

		ext = spec.getFileExtension();
		if ( ext != null && ext.isMatch( kJPGExtension ) )
			return true;

		finfo = spec.getFinderInfo();
		if ( finfo != null && finfo.getFileType() == k4ccJPEG )
			return true;

		return false;
	}

	public ImageViewerI createImageViewer( OwnedFrame frame, ImageViewerOwner onr,
											FileSpecifier spec, Rectangle rect ) {
		Rectangle		rr;

		rr = new Rectangle( rect.x, rect.y, rect.width, rect.height );

		if ( frame == null )
			WindowManager.adjustWindowPlacement( rr );

		try {
			return new SImageViewer( frame, onr, spec, rr );
		}
		catch ( Exception e ) {
			return null;
		}
	}

	public boolean canCreateInfoViewer( FileSpecifier spec ) {
		return false;
	}
	
	public InfoViewerI createInfoViewer( OwnedFrame frame, InfoViewerOwner onr,
											FileSpecifier spec, Rectangle rect ) {
		return null;
	}
	
	public FinderInfo[] getFinderInfo() {
		FinderInfo		retArray[];
		
		retArray = new FinderInfo[ 1 ];
		retArray[ 0 ] = new FinderInfo( JUtils.asciiToInt( "????" ), k4ccJPEG );
		
		return retArray;
	}

	public FileExtension[] getFileExtension() {
		FileExtension		retArray[];
		
		retArray = new FileExtension[ 1 ];
		retArray[ 0 ] = kJPGExtension;
		
		return retArray;
	}

	public MIMEType[] getMIMEType() {
		return null;
	}

	public VersionInfo getVersionInfo() {
		return null;
	}

	public String getName( int which ) {
		switch ( which ) {
			case kDisplayName:
				return "JPEG Files";

			case kMacStyleName:
				return "JPEG Files";

			case kWinStyleName:
				return "*.jpg ( JPEG Files )";

			default:
				return null;
		}
	}
	
	public PluginI getParent() {
		return null;
	}

	public PluginI[] getChildren() {
		return null;
	}
	
	public IconPanel getIconPanel() {
		return null;
	}
}


