package com.tolstoy.imagemeister;

import java.awt.*;
import java.awt.image.*;
import java.io.File;
import java.io.PrintStream;
import java.util.Date;
import com.jconfig.*;

/**
A stock plugin for showing information on a disk object.

Uses a subclass of SInfoViewer (SInfoVVolume, etc.) to show the information.

Does not create	ImageViewerI objects, only InfoViewerI objects.

Copyright (c) 1998-2002 Samizdat Productions. All Rights Reserved. ImageMeister is a Trademark of Samizdat Productions.
*/

class SInfoViewerPlugin implements PluginI {
	private static final int				k4ccUnknown = JUtils.asciiToInt( "????" );
	private static final FileExtension		kWildcardExtension = new FileExtension( ".*" );

	public boolean canCreateImageViewer( FileSpecifier spec ) {
		return false;
	}

	public ImageViewerI createImageViewer( OwnedFrame frame, ImageViewerOwner onr,
											FileSpecifier spec, Rectangle rect ) {
		return null;
	}

	public boolean canCreateInfoViewer( FileSpecifier spec ) {
		return true;
	}

	public InfoViewerI createInfoViewer( OwnedFrame frame, InfoViewerOwner onr,
											FileSpecifier spec, Rectangle rect ) {
		DiskObject			dobj;
		Rectangle			rr;
		
		dobj = spec.getDiskObject();
		if ( dobj == null )
			return null;

		rr = new Rectangle( rect.x, rect.y, rect.width, rect.height );

		if ( frame == null )
			WindowManager.adjustWindowPlacement( rr );

		try {
			if ( dobj instanceof DiskAlias )
				return new SInfoVAlias( (DiskAlias) dobj, frame, onr, spec, rect );

			if ( dobj instanceof DiskVolume )
				return new SInfoVVolume( (DiskVolume) dobj, frame, onr, spec, rect );	

			if ( !( dobj instanceof DiskFile ) )
				return null;

			if ( ( dobj.getFlags() & DiskFile.FILE_DIR ) != 0 )
				return new SInfoVFolder( (DiskFile) dobj, frame, onr, spec, rect );
			else
				return new SInfoVFile( (DiskFile) dobj, frame, onr, spec, rect );
		}
		catch ( Exception e ) {
			Trace.println( "got exception creating disk object " + e );
			return null;
		}
	}
	
	public FinderInfo[] getFinderInfo() {
		FinderInfo		retArray[];
		
		retArray = new FinderInfo[ 1 ];
		retArray[ 0 ] = new FinderInfo( k4ccUnknown, k4ccUnknown );
		
		return retArray;
	}

	public FileExtension[] getFileExtension() {
		FileExtension		retArray[];
		
		retArray = new FileExtension[ 1 ];
		retArray[ 0 ] = kWildcardExtension;
		
		return retArray;
	}

	public MIMEType[] getMIMEType() {
		return null;
	}

	public VersionInfo getVersionInfo() {
		return null;
	}

	public String getName( int which ) {
		switch ( which ) {
			case kDisplayName:
				return "All Files";

			case kMacStyleName:
				return "All Files";

			case kWinStyleName:
				return "*.* ( All Files )";

			default:
				return null;
		}
	}
	
	public PluginI getParent() {
		return null;
	}

	public PluginI[] getChildren() {
		return null;
	}
	
	public IconPanel getIconPanel() {
		return null;
	}
}


