/*
 * Decompiled with CFR 0.152.
 */
package jdbees.ftpbatch.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.EtchedBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import jdbees.JBeesConfInfo;
import jdbees.JBeesTreeCellRenderer;
import jdbees.ftpbatch.controller.JBeesFTPBatchController;
import jdbees.ftpbatch.model.JBeesFTPBatchModel;
import jdbees.ftpbatch.model.JBeesFTPBatchTreeNode;

public class JBeesFTPBatchDlg
extends JDialog {
    private boolean debug = false;
    public static final int OPTION_OK = 1;
    public static final int OPTION_CANCEL = 2;
    private JBeesConfInfo jbconf;
    private JBeesFTPBatchModel model;
    private JBeesFTPBatchTreeNode treeNode;
    private DefaultMutableTreeNode chosedNode;
    private String path;
    private String host;
    private String user;
    private String passwd;
    private String begDir;
    private String savedBegDir;
    private int port = 21;
    private JBeesFTPBatchController controller;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel8;
    private JLabel jLabel1;
    private JTextField hostText;
    private JLabel jLabel2;
    private JTextField portText;
    private JLabel jLabel3;
    private JTextField begdirText;
    private JLabel jLabel4;
    private JTextField savetodirText;
    private JPanel jPanel9;
    private JLabel jLabel5;
    private JCheckBox authCkb;
    private JLabel jLabel6;
    private JTextField userText;
    private JLabel jLabel7;
    private JPasswordField passwdText;
    private JPanel jPanel10;
    private JButton searchBtn;
    private JPanel jPanel3;
    private JPanel jPanel12;
    private JButton addBtn;
    private JButton delBtn;
    private JSplitPane jSplitPane3;
    private JScrollPane jScrollPane1;
    private JList choiceList;
    private JScrollPane jScrollPane2;
    private JTree dirTree;
    private JScrollPane jScrollPane3;
    private JList chosedList;
    private JPanel jPanel4;
    private JButton okBtn;
    private JButton cancelBtn;

    public JBeesFTPBatchDlg(JFrame parent, JBeesConfInfo jbconf, JBeesFTPBatchModel model) {
        super((Frame)parent, true);
        this.setTitle("FTP Batch");
        this.jbconf = jbconf;
        this.model = model;
        this.initComponents();
        this.setResizable(false);
        this.addBtn.setEnabled(false);
        this.delBtn.setEnabled(false);
        this.userText.setEditable(false);
        this.passwdText.setEditable(false);
        this.portText.setText("21");
        this.begdirText.setText("/");
        this.savetodirText.setText(System.getProperty("user.dir"));
        this.dirTree.setModel(null);
        this.dirTree.getSelectionModel().setSelectionMode(1);
        this.pack();
        this.dirTree.setCellRenderer(new JBeesTreeCellRenderer());
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension d1 = this.getSize();
        ((Component)this).setLocation((d.width - d1.width) / 2, (d.height - d1.height) / 2);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel8 = new JPanel();
        this.jLabel1 = new JLabel();
        this.hostText = new JTextField();
        this.jLabel2 = new JLabel();
        this.portText = new JTextField();
        this.jLabel3 = new JLabel();
        this.begdirText = new JTextField();
        this.jLabel4 = new JLabel();
        this.savetodirText = new JTextField();
        this.jPanel9 = new JPanel();
        this.jLabel5 = new JLabel();
        this.authCkb = new JCheckBox();
        this.jLabel6 = new JLabel();
        this.userText = new JTextField();
        this.jLabel7 = new JLabel();
        this.passwdText = new JPasswordField();
        this.jPanel10 = new JPanel();
        this.searchBtn = new JButton();
        this.jPanel3 = new JPanel();
        this.jPanel12 = new JPanel();
        this.addBtn = new JButton();
        this.delBtn = new JButton();
        this.jSplitPane3 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.choiceList = new JList();
        this.jScrollPane2 = new JScrollPane();
        this.dirTree = new JTree();
        this.jScrollPane3 = new JScrollPane();
        this.chosedList = new JList();
        this.jPanel4 = new JPanel();
        this.okBtn = new JButton();
        this.cancelBtn = new JButton();
        this.addWindowListener(new 1());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 1));
        this.jPanel2.setPreferredSize(new Dimension(600, 100));
        this.jPanel2.setBorder(new EtchedBorder());
        this.jPanel8.setLayout(new FlowLayout(0, 10, 5));
        this.jPanel8.setPreferredSize(new Dimension(400, 40));
        this.jPanel8.setMinimumSize(new Dimension(100, 20));
        this.jLabel1.setText("HOST");
        this.jPanel8.add(this.jLabel1);
        this.hostText.setPreferredSize(new Dimension(100, 20));
        this.jPanel8.add(this.hostText);
        this.jLabel2.setText("PORT");
        this.jPanel8.add(this.jLabel2);
        this.portText.setPreferredSize(new Dimension(40, 20));
        this.jPanel8.add(this.portText);
        this.jLabel3.setText("BEGDIR");
        this.jPanel8.add(this.jLabel3);
        this.begdirText.setPreferredSize(new Dimension(100, 20));
        this.begdirText.setMinimumSize(new Dimension(20, 20));
        this.jPanel8.add(this.begdirText);
        this.jLabel4.setText("SAVETO");
        this.jPanel8.add(this.jLabel4);
        this.savetodirText.setPreferredSize(new Dimension(100, 20));
        this.savetodirText.setMinimumSize(new Dimension(20, 20));
        this.jPanel8.add(this.savetodirText);
        this.jPanel2.add(this.jPanel8);
        this.jPanel9.setLayout(new FlowLayout(0, 10, 5));
        this.jPanel9.setPreferredSize(new Dimension(400, 40));
        this.jLabel5.setText("AUTHENTICATION");
        this.jPanel9.add(this.jLabel5);
        this.authCkb.setText("ON/OFF");
        this.authCkb.addActionListener(new 2());
        this.jPanel9.add(this.authCkb);
        this.jLabel6.setText("USER");
        this.jPanel9.add(this.jLabel6);
        this.userText.setPreferredSize(new Dimension(80, 20));
        this.jPanel9.add(this.userText);
        this.jLabel7.setText("PASSWORD");
        this.jPanel9.add(this.jLabel7);
        this.passwdText.setPreferredSize(new Dimension(80, 20));
        this.jPanel9.add(this.passwdText);
        this.jPanel2.add(this.jPanel9);
        this.jPanel10.setPreferredSize(new Dimension(400, 26));
        this.searchBtn.setPreferredSize(new Dimension(69, 20));
        this.searchBtn.setText("Search");
        this.searchBtn.setMargin(new Insets(2, 2, 2, 2));
        this.searchBtn.addActionListener(new 3());
        this.jPanel10.add(this.searchBtn);
        this.jPanel2.add(this.jPanel10);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.gridheight = 5;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.anchor = 11;
        gridBagConstraints1.weightx = 100.0;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints1);
        this.jPanel3.setLayout(new GridBagLayout());
        this.jPanel3.setPreferredSize(new Dimension(600, 300));
        this.jPanel12.setPreferredSize(new Dimension(120, 200));
        this.jPanel12.setBorder(new MatteBorder(1, 1, 1, 1, Color.darkGray));
        this.addBtn.setAlignmentX(0.5f);
        this.addBtn.setText("ADD >>");
        this.addBtn.addActionListener(new 4());
        this.jPanel12.add(this.addBtn);
        this.delBtn.setAlignmentX(0.5f);
        this.delBtn.setText("DEL <<");
        this.delBtn.addActionListener(new 5());
        this.jPanel12.add(this.delBtn);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 10;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 4;
        gridBagConstraints2.fill = 3;
        gridBagConstraints2.weighty = 100.0;
        this.jPanel3.add((Component)this.jPanel12, gridBagConstraints2);
        this.jSplitPane3.setPreferredSize(new Dimension(300, 200));
        this.choiceList.addListSelectionListener(new 6());
        this.jScrollPane1.setViewportView(this.choiceList);
        this.jSplitPane3.setRightComponent(this.jScrollPane1);
        this.dirTree.addTreeSelectionListener(new 7());
        this.jScrollPane2.setViewportView(this.dirTree);
        this.jSplitPane3.setLeftComponent(this.jScrollPane2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 10;
        gridBagConstraints2.fill = 3;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.weighty = 100.0;
        this.jPanel3.add((Component)this.jSplitPane3, gridBagConstraints2);
        this.jScrollPane3.setPreferredSize(new Dimension(180, 200));
        this.chosedList.addListSelectionListener(new 8());
        this.jScrollPane3.setViewportView(this.chosedList);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 14;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 6;
        gridBagConstraints2.fill = 3;
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.weighty = 100.0;
        this.jPanel3.add((Component)this.jScrollPane3, gridBagConstraints2);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 5;
        gridBagConstraints1.gridheight = 10;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.weightx = 100.0;
        this.jPanel1.add((Component)this.jPanel3, gridBagConstraints1);
        this.jPanel4.setPreferredSize(new Dimension(600, 50));
        this.jPanel4.setBorder(new EtchedBorder());
        this.okBtn.setText("OK");
        this.okBtn.addActionListener(new 9());
        this.jPanel4.add(this.okBtn);
        this.cancelBtn.setText("CANCEL");
        this.cancelBtn.addActionListener(new 10());
        this.jPanel4.add(this.cancelBtn);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 15;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.weightx = 100.0;
        this.jPanel1.add((Component)this.jPanel4, gridBagConstraints1);
        this.getContentPane().add((Component)this.jPanel1, "Center");
    }

    private void delBtnActionPerformed(ActionEvent evt) {
        this.delBtn.setEnabled(false);
        Object[] files = this.chosedList.getSelectedValues();
        this.model.deleteChosed(files);
        Object[] o = this.model.getFileChosedModel();
        if (o != null) {
            this.chosedList.setListData(this.model.getFileChosedModel());
        } else {
            this.chosedList.removeAll();
        }
    }

    private void addBtnActionPerformed(ActionEvent evt) {
        this.addBtn.setEnabled(false);
        Object[] files = this.choiceList.getSelectedValues();
        this.choiceList.clearSelection();
        this.model.addChosed(files);
        this.chosedList.setListData(this.model.getFileChosedModel());
    }

    private void searchBtnActionPerformed(ActionEvent evt) {
        Vector nodes = null;
        Vector choices = null;
        this.searchBtn.setEnabled(false);
        if (!this.verified()) {
            this.searchBtn.setEnabled(true);
            return;
        }
        try {
            this.controller = new JBeesFTPBatchController(this.host, this.port, this.user, this.passwd, this.jbconf);
            this.controller.getStatus(this.begDir);
            choices = this.controller.getFiles();
            nodes = this.controller.getDirs();
            if (nodes == null && choices == null) {
                throw new Exception("Maybe you don't have priority");
            }
            this.model.setFTPBatchModel(this.host, this.port, this.begDir, this.savedBegDir, this.user, this.passwd);
            this.model.setChoices(choices);
            this.treeNode = new JBeesFTPBatchTreeNode(this.begDir);
            this.treeNode.createNodes(this.treeNode, nodes);
            this.dirTree.setModel(new DefaultTreeModel(this.treeNode));
            this.path = this.begDir.startsWith("/") ? this.begDir : "/" + this.begDir;
            if (choices != null) {
                this.choiceList.setListData(choices);
            }
        }
        catch (Exception e) {
            this.searchBtn.setEnabled(true);
            JOptionPane.showMessageDialog(null, "Exception occurred during searching " + e.getMessage(), "Error", 0);
        }
    }

    private boolean verified() {
        if (this.hostText.getText() == null || this.hostText.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(null, "You must enter a valid host", "Error", 0);
            return false;
        }
        this.host = this.hostText.getText();
        if (this.portText.getText() == null || this.portText.getText().trim().length() == 0) {
            this.port = 21;
        } else {
            try {
                this.port = Integer.parseInt(this.portText.getText().trim());
                if (this.port <= 0) {
                    throw new Exception();
                }
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, "You must enter a valid port", "Error", 0);
                return false;
            }
        }
        this.begDir = this.begdirText.getText().trim();
        this.savedBegDir = this.savetodirText.getText().trim();
        if (this.begDir == null || this.begDir.length() == 0 || this.savedBegDir == null || this.savedBegDir.length() == 0) {
            JOptionPane.showMessageDialog(null, "You must enter valid directories", "Error", 0);
            return false;
        }
        if (this.authCkb.isSelected()) {
            if (this.userText.getText() == null || this.userText.getText().trim().length() == 0 || this.passwdText.getPassword() == null) {
                JOptionPane.showMessageDialog(null, "User name or password must not be null", "Error", 0);
                return false;
            }
            this.user = this.userText.getText();
            this.passwd = new String(this.passwdText.getPassword());
        }
        return true;
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        try {
            if (this.controller != null) {
                this.controller.close();
            }
        }
        catch (Exception exception) {}
        this.model.setRetOption(1);
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private void jTree2ValueChanged(TreeSelectionEvent evt) {
        this.chosedNode = (DefaultMutableTreeNode)this.dirTree.getLastSelectedPathComponent();
        TreePath tp = this.dirTree.getSelectionPath();
        if (tp == null) {
            return;
        }
        Object[] treepath = tp.getPath();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < treepath.length) {
            if (treepath[i].toString().startsWith("/")) {
                sb.append(treepath[i].toString());
            } else if (sb.toString() != null && sb.toString().endsWith("/")) {
                sb.append(treepath[i].toString());
            } else {
                sb.append("/").append(treepath[i].toString());
            }
            ++i;
        }
        if (this.path.equalsIgnoreCase(sb.toString())) {
            return;
        }
        this.path = sb.toString();
        this.model.setCurrentPath(this.path);
        if (this.model.isPopulated()) {
            Vector choiceModel = this.model.getChoices();
            this.choiceList.setListData(choiceModel);
        } else {
            this.getDataFromFtpServer();
        }
    }

    private void getDataFromFtpServer() {
        Vector choices = null;
        Vector nodes = null;
        try {
            this.controller.getStatus(this.path);
            choices = this.controller.getFiles();
            nodes = this.controller.getDirs();
            this.model.setChoices(choices);
            this.treeNode.createNodes(this.chosedNode, nodes);
            this.choiceList.removeAll();
            if (this.debug) {
                System.out.println("enter getDataFromFtpServer");
            }
            this.choiceList.setListData(choices);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Exception occurred during searching " + e.getMessage(), "Error", 0);
        }
    }

    private void chosedListValueChanged(ListSelectionEvent evt) {
        if (this.chosedList.getSelectedIndex() != -1) {
            this.delBtn.setEnabled(true);
        } else {
            this.delBtn.setEnabled(false);
        }
    }

    private void choiceListValueChanged(ListSelectionEvent evt) {
        if (this.choiceList.getSelectedIndex() != -1) {
            this.addBtn.setEnabled(true);
        } else {
            this.addBtn.setEnabled(false);
        }
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        try {
            if (this.controller != null) {
                this.controller.close();
            }
        }
        catch (Exception exception) {}
        this.model.setRetOption(2);
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private void authCkbActionPerformed(ActionEvent evt) {
        if (this.authCkb.isSelected()) {
            this.userText.setEditable(true);
            this.passwdText.setEditable(true);
        } else {
            this.userText.setEditable(false);
            this.passwdText.setEditable(false);
        }
    }

    private void closeDialog(WindowEvent evt) {
        try {
            if (this.controller != null) {
                this.controller.close();
            }
        }
        catch (Exception exception) {}
        this.model.setRetOption(2);
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent evt) {
            JBeesFTPBatchDlg.this.closeDialog(evt);
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            JBeesFTPBatchDlg.this.authCkbActionPerformed(evt);
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            JBeesFTPBatchDlg.this.searchBtnActionPerformed(evt);
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            JBeesFTPBatchDlg.this.addBtnActionPerformed(evt);
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            JBeesFTPBatchDlg.this.delBtnActionPerformed(evt);
        }

        /* synthetic */ 5() {
        }
    }

    private final class 6
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent evt) {
            JBeesFTPBatchDlg.this.choiceListValueChanged(evt);
        }

        /* synthetic */ 6() {
        }
    }

    private final class 7
    implements TreeSelectionListener {
        public void valueChanged(TreeSelectionEvent evt) {
            JBeesFTPBatchDlg.this.jTree2ValueChanged(evt);
        }

        /* synthetic */ 7() {
        }
    }

    private final class 8
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent evt) {
            JBeesFTPBatchDlg.this.chosedListValueChanged(evt);
        }

        /* synthetic */ 8() {
        }
    }

    private final class 9
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            JBeesFTPBatchDlg.this.okBtnActionPerformed(evt);
        }

        /* synthetic */ 9() {
        }
    }

    private final class 10
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            JBeesFTPBatchDlg.this.cancelBtnActionPerformed(evt);
        }

        /* synthetic */ 10() {
        }
    }
}

