/*
 * Decompiled with CFR 0.152.
 */
package jdbees.http;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import jdbees.JBeesConfInfo;
import jdbees.JBeesLocalFile;
import jdbees.JBeesNetworkIO;
import jdbees.http.JBeesHttpException;
import jdbees.http.JBeesHttpTeam;
import jdbees.security.JBeesBase64;

public class JBeesHttpBee
implements Runnable {
    private boolean debug = false;
    private JBeesLocalFile localFile;
    private long remoteBegin;
    private long remoteEnd;
    private DataInputStream dis;
    private PrintWriter pw;
    private URL url;
    private JBeesNetworkIO jbnio;
    private boolean isChunked;
    private volatile boolean interrupted = false;
    private JBeesHttpTeam jbt;
    private int index;
    private String user;
    private String passwd;
    private String proxyUser;
    private String proxyPasswd;
    private boolean viaProxy = false;

    public JBeesHttpBee(URL url, JBeesLocalFile raf, long bg, long ed, boolean isChunked, int timeout, String user, String passwd) throws IOException {
        this.remoteBegin = bg;
        this.remoteEnd = ed;
        this.localFile = raf;
        this.isChunked = isChunked;
        this.url = url;
        this.user = user;
        this.passwd = passwd;
        this.jbnio = new JBeesNetworkIO(url);
        if (timeout > 0) {
            this.jbnio.setTimeout(timeout);
        }
        this.dis = this.jbnio.getDataInputStream();
        this.pw = this.jbnio.getPrintWriter();
    }

    public JBeesHttpBee(URL url, String proxyHost, int proxyPort, JBeesLocalFile raf, long bg, long ed, boolean isChunked, int timeout, String user, String passwd) throws IOException {
        this.remoteBegin = bg;
        this.remoteEnd = ed;
        this.localFile = raf;
        this.isChunked = isChunked;
        this.url = url;
        this.user = user;
        this.passwd = passwd;
        this.jbnio = new JBeesNetworkIO(proxyHost, proxyPort);
        if (timeout > 0) {
            this.jbnio.setTimeout(timeout);
        }
        this.dis = this.jbnio.getDataInputStream();
        this.pw = this.jbnio.getPrintWriter();
    }

    public JBeesHttpBee(URL url, JBeesLocalFile raf, long bg, long ed, boolean isChunked, JBeesHttpTeam jbt, int index, int timeout, String user, String passwd) throws IOException {
        this(url, raf, bg, ed, isChunked, timeout, user, passwd);
        this.jbt = jbt;
        this.index = index;
    }

    public JBeesHttpBee(URL url, String proxyHost, int proxyPort, JBeesLocalFile raf, long bg, long ed, boolean isChunked, JBeesHttpTeam jbt, int index, int timeout, String user, String passwd) throws IOException {
        this(url, proxyHost, proxyPort, raf, bg, ed, isChunked, timeout, user, passwd);
        this.jbt = jbt;
        this.index = index;
    }

    public JBeesHttpBee(URL url, JBeesLocalFile raf, long bg, long ed, boolean isChunked, JBeesHttpTeam jbt, int index, JBeesConfInfo jbconf) throws IOException {
        this(url, raf, bg, ed, isChunked, jbt, index, jbconf, null, null);
    }

    public JBeesHttpBee(URL url, JBeesLocalFile raf, long bg, long ed, boolean isChunked, JBeesHttpTeam jbt, int index, JBeesConfInfo jbconf, String user, String passwd) throws IOException {
        this.remoteBegin = bg;
        this.remoteEnd = ed;
        this.localFile = raf;
        this.isChunked = isChunked;
        this.url = url;
        this.user = user;
        this.passwd = passwd;
        this.jbt = jbt;
        this.index = index;
        this.user = user;
        this.passwd = passwd;
        if (jbconf.getProxyHost() != null) {
            this.viaProxy = true;
            if (jbconf.getHttpAuthUser() != null) {
                this.proxyUser = jbconf.getHttpAuthUser();
                this.proxyPasswd = jbconf.getHttpAuthPasswd();
            }
            this.jbnio = new JBeesNetworkIO(jbconf.getProxyHost(), jbconf.getProxyPort());
        } else {
            this.jbnio = new JBeesNetworkIO(url);
        }
        if (jbconf.getSocketTimeout() > 0) {
            this.jbnio.setTimeout(jbconf.getSocketTimeout());
        }
        this.dis = this.jbnio.getDataInputStream();
        this.pw = this.jbnio.getPrintWriter();
    }

    public void run() {
        try {
            try {
                this.sendRequest();
                this.recvResponseHead();
                if (this.isChunked) {
                    this.recvChunkedContentBody();
                } else {
                    this.recvContentBody();
                }
            }
            catch (JBeesHttpException jbe) {
                System.out.println("jb exception: " + jbe);
            }
            catch (IOException e) {
                System.out.println("IO exception: " + e);
            }
            Object var3_3 = null;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            throw throwable;
        }
    }

    private void sendRequest() throws IOException {
        String authRequest = null;
        if (this.user != null) {
            JBeesBase64 jb64 = new JBeesBase64();
            String enc = new String(jb64.encode((String.valueOf(this.user) + ":" + this.passwd).getBytes()));
            authRequest = "Authorization: Basic " + enc;
        }
        String proxyAuthRequest = null;
        if (this.viaProxy && this.proxyUser != null) {
            JBeesBase64 jb64 = new JBeesBase64();
            String enc = new String(jb64.encode((String.valueOf(this.proxyUser) + ":" + this.proxyPasswd).getBytes()));
            proxyAuthRequest = "Proxy-Authorization: Basic " + enc;
        }
        String urlRequest = "GET " + this.url.toString() + " HTTP/1.1";
        String host = "Host: " + this.url.getHost();
        String rangeRequest = this.remoteEnd > 0L ? "Range: bytes=" + this.remoteBegin + "-" + this.remoteEnd : "Range: bytes=" + this.remoteBegin + "-";
        String connectionRequest = "Connection: close";
        String acceptRequest = "Accept: */*";
        String refererRequest = "Referer: http://" + this.url.getHost() + (this.url.getPort() != -1 ? ":" + this.url.getPort() : "");
        String useragent = "User-Agent: JBees/1.0";
        if (this.debug) {
            System.out.println(urlRequest);
            System.out.println(host);
            System.out.println(rangeRequest);
            System.out.println(refererRequest);
            System.out.println(useragent);
            System.out.println(authRequest);
            System.out.println(proxyAuthRequest);
        }
        this.pw.println(urlRequest);
        this.pw.println(host);
        this.pw.println(rangeRequest);
        this.pw.println(connectionRequest);
        this.pw.println(refererRequest);
        this.pw.println(acceptRequest);
        if (authRequest != null) {
            this.pw.println(authRequest);
        }
        if (proxyAuthRequest != null) {
            this.pw.println(proxyAuthRequest);
        }
        this.pw.println(useragent);
        this.pw.println();
        this.pw.println();
        this.pw.flush();
    }

    private void recvResponseHead() throws IOException, JBeesHttpException {
        String str;
        if (this.debug) {
            System.out.println("recvResponseHead");
        }
        while ((str = this.readLine()) == null || str.length() <= 0) {
        }
        if (this.debug) {
            System.out.println(str);
        }
        if (str.indexOf("20") == -1) {
            throw new JBeesHttpException("http status is not OK");
        }
        while ((str = this.readLine()).length() != 0) {
            if (!this.debug) continue;
            System.out.println(str);
        }
    }

    private String readLine() throws IOException {
        StringBuffer sb = new StringBuffer();
        while (true) {
            byte c;
            if ((c = this.dis.readByte()) == 13 || c == 10) break;
            sb.append((char)c);
        }
        this.dis.readByte();
        return sb.toString();
    }

    private void recvChunkedContentBody() throws IOException {
        long beg = 0L;
        while (!this.interrupted) {
            String str = this.readLine();
            if (str == null) break;
            if (str.trim().length() == 0) continue;
            int length = Integer.parseInt(str.trim(), 16);
            if (length == 0) break;
            long readLn = 0L;
            while (readLn < (long)length) {
                byte[] byteArr = (long)length - readLn > 1024L ? new byte[1024] : new byte[(int)((long)length - readLn)];
                int l = this.dis.read(byteArr);
                if (l == -1) {
                    throw new EOFException("Abnormal end of file.");
                }
                if (this.debug) {
                    System.out.println("read " + l + " bytes from socket");
                }
                if (l > 0) {
                    this.localFile.writeBytes(byteArr, this.remoteBegin + readLn);
                    this.jbt.updateRate(l);
                }
                readLn += (long)l;
                if (this.jbt != null) {
                    this.jbt.updateResumeBegin(this.index, this.remoteBegin + readLn);
                }
                if (!this.debug) continue;
                System.out.println("read length: " + readLn);
            }
            this.remoteBegin += (long)length;
        }
        this.dis.close();
        this.pw.close();
        this.jbnio.close();
    }

    private void recvContentBody() throws IOException, EOFException {
        if (this.debug) {
            System.out.println("recvContentBody");
        }
        long readLn = 0L;
        long length = this.remoteEnd - this.remoteBegin + 1L;
        while (readLn < length && !this.interrupted) {
            byte[] byteArr = length - readLn > 1024L ? new byte[1024] : new byte[(int)(length - readLn)];
            int l = this.dis.read(byteArr);
            if (l == -1) {
                throw new EOFException("Abnormal end of file.");
            }
            if (this.debug) {
                System.out.println("read " + l + " bytes from socket");
            }
            if (l > 0) {
                this.localFile.writeBytes(byteArr, this.remoteBegin + readLn);
                this.jbt.updateRate(l);
            }
            readLn += (long)l;
            if (this.jbt != null) {
                this.jbt.updateResumeBegin(this.index, this.remoteBegin + readLn);
            }
            if (!this.debug) continue;
            System.out.println("read length: " + readLn);
        }
        if (this.debug) {
            System.out.println("OK");
        }
        this.dis.close();
        this.pw.close();
        this.jbnio.close();
    }

    public void setInterrupted(boolean v) {
        this.interrupted = v;
    }
}

