/*
 * Decompiled with CFR 0.152.
 */
package jdbees;

import java.net.URL;
import java.util.Vector;
import javax.swing.JOptionPane;
import jdbees.JBeesConfInfo;
import jdbees.JBeesDownloadedFileInfo;
import jdbees.ftp.JBeesFtpRemoteInfo;
import jdbees.http.JBeesHttpRemoteInfo;

public class JBeesCheckUpdate
implements Runnable {
    private Vector vector;
    private JBeesConfInfo jbconf;

    public JBeesCheckUpdate(Vector v, JBeesConfInfo jbconf) {
        this.vector = v;
        this.jbconf = jbconf;
    }

    public void run() {
        int i = 0;
        while (i < this.vector.size()) {
            JBeesDownloadedFileInfo jbdf = (JBeesDownloadedFileInfo)this.vector.elementAt(i);
            if (jbdf.getURL().toLowerCase().indexOf("http") != -1) {
                this.checkHttpStatus(jbdf);
            } else {
                this.checkFtpStatus(jbdf);
            }
            ++i;
        }
    }

    private void checkHttpStatus(JBeesDownloadedFileInfo jbdf) {
        try {
            JBeesHttpRemoteInfo jbhri = new JBeesHttpRemoteInfo(new URL(jbdf.getURL()), jbdf.getUser(), jbdf.getPasswd(), this.jbconf);
            String dateStr = jbhri.getLastModifiedDate();
            String statusStr = jbdf.isModified(dateStr) ? jbdf.getURL() + " is updated!" : jbdf.getURL() + " isn't updated";
            JOptionPane.showMessageDialog(null, statusStr, "Success", 1);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "can't check the status of " + jbdf.getURL(), "Error", 0);
        }
    }

    private void checkFtpStatus(JBeesDownloadedFileInfo jbdf) {
        try {
            JBeesFtpRemoteInfo jbfri = jbdf.getUser() == null ? new JBeesFtpRemoteInfo(new URL(jbdf.getURL()), this.jbconf) : new JBeesFtpRemoteInfo(new URL(jbdf.getURL()), this.jbconf, jbdf.getUser(), jbdf.getPasswd());
            String dateStr = jbfri.getLastModifiedDate();
            String statusStr = jbdf.isModified(dateStr) ? jbdf.getURL() + " is updated!" : jbdf.getURL() + " isn't updated";
            JOptionPane.showMessageDialog(null, statusStr, "Success", 1);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "can't check the status of " + jbdf.getURL(), "Error", 0);
        }
    }
}

