/*
 * Decompiled with CFR 0.152.
 */
package jdbees.ftp;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class JBeesFtpDataServer {
    ServerSocket ss;
    Socket so;
    DataInputStream dis;

    public JBeesFtpDataServer(int port) throws IOException {
        this.ss = new ServerSocket(port);
    }

    public void accept(int timeout) throws IOException {
        this.so = this.ss.accept();
        if (timeout > 0) {
            this.so.setSoTimeout(timeout);
        }
    }

    public DataInputStream getDataInputStream() throws IOException {
        this.dis = new DataInputStream(this.so.getInputStream());
        return this.dis;
    }

    public void close() throws IOException {
        this.dis.close();
        this.so.close();
        this.ss.close();
    }

    String readLine() throws IOException {
        StringBuffer sb = new StringBuffer();
        try {
            while (true) {
                byte c;
                if ((c = this.dis.readByte()) == 13 || c == 10) {
                    this.dis.readByte();
                    break;
                }
                sb.append((char)c);
            }
        }
        catch (EOFException e) {
            return null;
        }
        return sb.toString();
    }
}

